/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.NodeComparatorByLabel;

public class RootedLinks<E>
implements Iterable<Link<E>> {
    private Node<E> rootNode;
    private HashMap<Node<E>, Link<E>> nodeToLink;

    public RootedLinks(Node<E> rootNode) {
        this.rootNode = rootNode;
        this.nodeToLink = new HashMap();
    }

    public RootedLinks(Node<E> rootNode, int initialCapacity) {
        this.rootNode = rootNode;
        this.nodeToLink = new HashMap(initialCapacity);
    }

    public void add(Link<E> link) {
        if (link == null || link.getSourceNode() == null || link.getTargetNode() == null) {
            throw new NullPointerException("Null parameter detected.");
        }
        if (link.getSourceNode() != this.rootNode && link.getTargetNode() != this.rootNode) {
            throw new UnsupportedOperationException("Link not rooted to the current root node.");
        }
        this.nodeToLink.put(link.getOtherNode(this.rootNode), link);
    }

    public Link<E> addArc(Node<E> sourceNode, Node<E> targetNode) {
        Link<E> result = this.addArc(sourceNode, targetNode, 0.0);
        return result;
    }

    public Link<E> addArc(Node<E> sourceNode, Node<E> targetNode, double weight) {
        if (sourceNode == null || targetNode == null) {
            throw new NullPointerException("Null parameter detected.");
        }
        Link<E> result = this.nodeToLink.get(targetNode);
        if (result == null) {
            result = new Link<E>(sourceNode, targetNode, Link.LinkType.ARC, weight);
            this.nodeToLink.put(targetNode, result);
        }
        return result;
    }

    public Link<E> addEdge(Node<E> sourceNode, Node<E> targetNode) {
        Link<E> result = this.addEdge(sourceNode, targetNode, 0.0);
        return result;
    }

    public Link<E> addEdge(Node<E> sourceNode, Node<E> targetNode, double weight) {
        if (sourceNode == null || targetNode == null) {
            throw new NullPointerException("Null parameter detected.");
        }
        Link<E> result = this.nodeToLink.get(targetNode);
        if (result == null) {
            result = new Link<E>(sourceNode, targetNode, Link.LinkType.EDGE, weight);
            this.nodeToLink.put(targetNode, result);
        }
        return result;
    }

    public double averagePositiveWeight() {
        double sum = 0.0;
        int count = 0;
        for (Link<E> link : this.getLinks()) {
            if (link == null || !(link.getWeight() > 0.0)) continue;
            ++count;
            sum += link.getWeight();
        }
        double result = count == 0 ? 0.0 : sum / (double)count;
        return result;
    }

    public double averageWeight() {
        double result = this.size() == 0 ? 0.0 : this.sumWeight() / (double)this.size();
        return result;
    }

    public List<Link<E>> getLinks() {
        ArrayList<Link<E>> result = new ArrayList<Link<E>>(this.nodeToLink.values());
        return result;
    }

    public Link<E> getLinkWith(Node<E> otherNode) {
        Link<E> result = this.nodeToLink.get(otherNode);
        return result;
    }

    public List<Node<E>> getNodes() {
        ArrayList<Node<E>> result = new ArrayList<Node<E>>(this.nodeToLink.keySet());
        return result;
    }

    public List<Node<E>> getNodesSortedByLabel() {
        List<Node<E>> result = this.getNodes();
        Collections.sort(result, new NodeComparatorByLabel());
        return result;
    }

    public Node<E> getRootNode() {
        return this.rootNode;
    }

    @Override
    public Iterator<Link<E>> iterator() {
        Iterator<Link<E>> result = this.nodeToLink.values().iterator();
        return result;
    }

    public double maxWeight() {
        double result;
        if (this.size() == 0) {
            result = 0.0;
        } else {
            result = Double.MIN_VALUE;
            for (Link<E> link : this.nodeToLink.values()) {
                if (link == null || !(link.getWeight() > result)) continue;
                result = link.getWeight();
            }
        }
        return result;
    }

    public double minWeight() {
        double result;
        if (this.size() == 0) {
            result = 0.0;
        } else {
            result = Double.MAX_VALUE;
            for (Link<E> link : this.nodeToLink.values()) {
                if (link == null || !(link.getWeight() < result)) continue;
                result = link.getWeight();
            }
        }
        return result;
    }

    public int size() {
        int result = this.nodeToLink.size();
        return result;
    }

    public double sumWeight() {
        double result = 0.0;
        for (Link<E> link : this.nodeToLink.values()) {
            if (link == null) continue;
            result += link.getWeight();
        }
        return result;
    }
}

