/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.census.workers;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.census.chains.Chain;
import org.tip.puck.census.chains.ChainCluster;
import org.tip.puck.census.chains.ChainMaker;
import org.tip.puck.census.chains.Couple;
import org.tip.puck.census.chains.Notation;
import org.tip.puck.census.chains.Vector;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CensusDetails;
import org.tip.puck.census.workers.CensusReporter;
import org.tip.puck.census.workers.ChainValuator;
import org.tip.puck.census.workers.CircuitType;
import org.tip.puck.census.workers.RestrictionType;
import org.tip.puck.census.workers.SiblingMode;
import org.tip.puck.census.workers.SymmetryType;
import org.tip.puck.net.Families;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.MultiPartition;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Trafo;
import org.tip.puck.util.Value;

public class CircuitFinder {
    Individuals targetDomain;
    Individuals searchDomain;
    Individuals linkDomain;
    Families familyDomain;
    Partition<Chain> circuits;
    Partition<Chain> couples;
    Partition<Individual> pivots;
    List<Chain>[] couplesByOrder;
    Set<Individual>[] pivotsByOrder;
    CensusDetails censusDetails;
    List<Chain> forbiddenChains;
    List<Chain> chainModels;
    CensusCriteria criteria;
    boolean markIndividuals;
    boolean openChainFrequencies;
    List<Chain> consideredCouples;
    int couplesConsidered;
    String relationType;
    String relationEgoRole;
    String relationAlterRole;
    String requiredAttribute;
    Map<Individual, Map<Individual, Integer>> consanguines;
    protected int[] degrees;
    private int[] maxDeg;
    private String schema;
    private Gender firstGender;
    protected boolean linearOnly;
    protected boolean crossSex;
    protected boolean couplesOnly;
    private SymmetryType symmetry;
    private FiliationType line;
    private String classification;
    protected SiblingMode sib;
    private CircuitType ringType;
    RestrictionType restriction;
    Partition<Individual> mergingPartition;
    Partition<Individual> linkingPartition;
    private int[] nrCircuits;
    private int[] nrCouples;
    private int[] nrIndividuals;
    private Map<Value, Integer> nrCircuitsForKey;
    private Map<Value, Integer> nrCouplesForKey;
    private Map<Value, Integer> nrPivotsForKey;
    private Map<Value, Integer> nrOpenChainsForKey;
    private int[] nrCircuitTypes;
    long time;

    public int getCouplesConsidered() {
        return this.couplesConsidered;
    }

    public String getLabel() {
        String result = "";
        return result;
    }

    private int dim() {
        return this.degrees.length;
    }

    public static Partition<Chain> createFirstCousinMarriages(Segmentation segmentation) throws PuckException {
        CensusCriteria criteria = new CensusCriteria();
        criteria.setPattern("XX(X)XX");
        criteria.setSiblingMode(SiblingMode.ALL);
        criteria.setClosingRelation("SPOUSE");
        criteria.setChainClassification("POSITIONAL");
        criteria.setRestrictionType(RestrictionType.ALL);
        CircuitFinder finder = new CircuitFinder(segmentation, criteria);
        finder.findCircuits();
        Partition<Chain> result = finder.getCircuits();
        result.setLabel("First Cousin Marriages");
        return result;
    }

    public static MultiPartition<Chain> createAncestorChains(Segmentation segmentation, int degree) throws PuckException {
        CensusCriteria criteria = new CensusCriteria();
        String pattern = "";
        int i = 0;
        while (i < degree) {
            pattern = String.valueOf(pattern) + "X";
            ++i;
        }
        pattern = String.valueOf(pattern) + "(X)";
        criteria.setPattern(pattern);
        criteria.setSiblingMode(SiblingMode.NONE);
        criteria.setSymmetryType(SymmetryType.INVARIABLE);
        criteria.setClosingRelation("LINEAR");
        criteria.setChainClassification("POSITIONAL");
        criteria.setRestrictionType(RestrictionType.ALL);
        CircuitFinder finder = new CircuitFinder(segmentation, criteria);
        finder.findCircuits();
        Partition<Chain> chains = finder.getCircuits();
        MultiPartition<Chain> result = new MultiPartition<Chain>();
        for (Cluster<Chain> cluster : chains.getClusters().toListSortedByDescendingValue()) {
            String value = cluster.getValue().stringValue();
            Value value1 = new Value("X" + value.substring(1));
            Value value2 = new Value(value.substring(0, 1));
            Partition<Chain> row = result.getRow(value1);
            if (row == null) {
                row = new Partition();
            }
            row.putAll(cluster.getItems(), value2);
            result.put(row, value1);
        }
        result.setLabel("Ancestor Chains (degree=" + degree + ")");
        return result;
    }

    public CircuitFinder(Individuals searchDomain) {
        this.searchDomain = searchDomain;
    }

    private boolean checkForMarriage(Individual ego, Individual alter) {
        boolean result = false;
        return result;
    }

    public String getPattern() {
        String result = this.criteria.getPattern().replaceAll(" ", "_");
        return result;
    }

    public CircuitFinder(Segmentation segmentation, CensusCriteria criteria) throws PuckException {
        this.criteria = criteria;
        this.censusDetails = criteria.getCensusDetails();
        if (StringUtils.isBlank((CharSequence)criteria.getPattern())) {
            this.degrees = null;
            this.schema = null;
        } else if (Pattern.matches("^[ ,\\t\\d]+$", criteria.getPattern())) {
            this.degrees = ToolBox.stringsToInts(criteria.getPattern());
            this.schema = null;
        } else {
            this.degrees = null;
            this.schema = criteria.getPattern();
        }
        if (this.degrees == null && this.schema == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Pattern not defined [{0}]", criteria.getPattern());
        }
        this.restriction = criteria.getRestrictionType();
        if (this.restriction == RestrictionType.NONE) {
            this.targetDomain = segmentation.getAllIndividuals();
            this.searchDomain = segmentation.getAllIndividuals();
            this.familyDomain = segmentation.getAllFamilies();
        } else if (this.restriction == RestrictionType.ALL) {
            this.targetDomain = segmentation.getCurrentIndividuals();
            this.searchDomain = segmentation.getCurrentIndividuals();
            this.familyDomain = segmentation.getCurrentFamilies();
        } else {
            this.targetDomain = segmentation.getCurrentIndividuals();
            this.familyDomain = segmentation.getCurrentFamilies();
            this.searchDomain = segmentation.getAllIndividuals();
        }
        this.linkDomain = this.symmetry == SymmetryType.PERMUTABLE ? this.searchDomain : segmentation.getAllIndividuals();
        this.relationType = criteria.getClosingRelation();
        this.relationEgoRole = criteria.getClosingRelationEgoRole();
        this.relationAlterRole = criteria.getClosingRelationAlterRole();
        if (StringUtils.isNotBlank((CharSequence)this.relationType) && this.relationType.charAt(0) == '@') {
            this.linkingPartition = PartitionMaker.createRaw(this.relationType.substring(1), this.searchDomain);
            this.symmetry = SymmetryType.INVERTIBLE;
        } else {
            this.symmetry = this.relationType.equals("SPOUSE") || this.relationType.equals("PARTN") ? SymmetryType.PERMUTABLE : (this.relationType.equals("LINEAR") ? SymmetryType.INVARIABLE : (this.relationType.equals("OPEN") || this.relationType.equals("COSPOUSE") ? SymmetryType.INVERTIBLE : (this.relationEgoRole == null && this.relationAlterRole == null || this.relationEgoRole.equals(this.relationAlterRole) ? SymmetryType.INVERTIBLE : SymmetryType.INVARIABLE)));
        }
        this.sib = criteria.getSiblingMode();
        this.line = criteria.getFiliationType();
        this.ringType = criteria.getCircuitType();
        if (this.relationType.equals("SPOUSE") || this.relationType.equals("PARTN")) {
            this.crossSex = true;
            this.couplesOnly = true;
        } else {
            this.crossSex = criteria.isCrossSexChainsOnly();
            this.couplesOnly = criteria.isCouplesOnly();
        }
        if (this.relationType.charAt(0) == '@') {
            this.requiredAttribute = this.relationType.substring(1);
        }
        this.firstGender = criteria.getFirstGender();
        if (!Trafo.isNull(criteria.getClassificatoryLinking()) && !criteria.getClassificatoryLinking().equals("NONE")) {
            this.mergingPartition = PartitionMaker.createRaw(criteria.getClassificatoryLinking(), this.targetDomain);
            this.sib = SiblingMode.NONE;
        }
        this.classification = criteria.getChainClassification();
        this.circuits = new Partition();
        this.couples = new Partition();
        this.pivots = new Partition();
        this.forbiddenChains = this.getChainModels(criteria.getFilter());
        if (this.schema != null) {
            int dim = 1;
            String[] stringArray = this.schema.split("\\s");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                int d = s.split("\\.").length;
                if (d > dim) {
                    dim = d;
                }
                ++n2;
            }
            this.degrees = new int[dim];
            this.chainModels = this.getChainModels(this.schema);
            for (Chain model : this.chainModels) {
                int deg = model.depth();
                if (deg > this.degrees[model.dim() - 1]) {
                    this.degrees[model.dim() - 1] = deg;
                }
                if (this.isForbidden(model)) continue;
                this.circuits.putCluster(ChainValuator.get(model, this.classification));
            }
            this.forbiddenChains = null;
        }
        this.maxDeg = new int[this.dim()];
        int i = 0;
        while (i < this.dim()) {
            this.maxDeg[i] = this.degrees[i];
            int j = i + 1;
            while (j < this.dim()) {
                if (this.degrees[j] > this.maxDeg[i]) {
                    this.maxDeg[i] = this.degrees[j];
                }
                ++j;
            }
            ++i;
        }
        this.couplesByOrder = new List[this.dim() + 1];
        this.pivotsByOrder = new Set[this.dim() + 1];
        i = 0;
        while (i < this.dim() + 1) {
            this.couplesByOrder[i] = new ArrayList<Chain>();
            this.pivotsByOrder[i] = new HashSet<Individual>();
            ++i;
        }
        this.markIndividuals = criteria.isMarkIndividuals();
        if (!this.relationType.equals("OPEN")) {
            this.openChainFrequencies = criteria.isOpenChainFrequencies();
        }
        this.consideredCouples = new ArrayList<Chain>();
    }

    public Partition<Chain> getOpenChains() throws PuckException {
        CircuitFinder openChainFinder = new CircuitFinder(this.searchDomain);
        openChainFinder.targetDomain = this.targetDomain;
        openChainFinder.degrees = this.degrees;
        openChainFinder.maxDeg = this.maxDeg;
        openChainFinder.schema = this.schema;
        openChainFinder.forbiddenChains = this.forbiddenChains;
        openChainFinder.chainModels = this.chainModels;
        openChainFinder.classification = this.classification;
        openChainFinder.mergingPartition = this.mergingPartition;
        openChainFinder.crossSex = this.crossSex;
        openChainFinder.markIndividuals = this.markIndividuals;
        openChainFinder.couplesOnly = this.couplesOnly;
        openChainFinder.markIndividuals = this.markIndividuals;
        openChainFinder.ringType = this.ringType;
        openChainFinder.line = this.line;
        openChainFinder.restriction = this.restriction;
        openChainFinder.sib = this.sib;
        openChainFinder.censusDetails = this.censusDetails;
        openChainFinder.firstGender = this.firstGender;
        openChainFinder.linkingPartition = this.linkingPartition;
        openChainFinder.requiredAttribute = this.requiredAttribute;
        openChainFinder.circuits = new Partition();
        if (this.schema != null) {
            for (Cluster<Chain> cluster : this.circuits.getClusters()) {
                openChainFinder.circuits.putCluster(cluster.getValue());
            }
        }
        openChainFinder.relationType = "OPEN";
        openChainFinder.symmetry = SymmetryType.INVERTIBLE;
        openChainFinder.findCircuits();
        Partition<Chain> result = openChainFinder.getCircuits();
        this.nrOpenChainsForKey = new HashMap<Value, Integer>();
        for (Value value : result.getValues()) {
            this.nrOpenChainsForKey.put(value, result.getValueFrequency(value));
        }
        return result;
    }

    private List<Chain> getChainModels(String schema) {
        ArrayList<Chain> result = new ArrayList<Chain>();
        if (schema != null) {
            String[] stringArray = schema.split("\\s");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String subSchema = stringArray[n2];
                if (subSchema != null && subSchema.length() > 0) {
                    if (subSchema.charAt(0) == '<') {
                        for (String partSchema : CircuitFinder.formulae(subSchema.substring(1))) {
                            this.develop(result, ChainMaker.transform(partSchema), 0);
                        }
                    } else {
                        this.develop(result, ChainMaker.transform(subSchema), 0);
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    private static ArrayList<String> formulae(String str) {
        ArrayList<String> formulae = new ArrayList<String>();
        str = str.replaceAll("\\(\\)", "\\(X\\)");
        String strinv = CircuitFinder.inverse(str);
        String s = "(X)X";
        int i = 0;
        while (!s.equals(str) && !s.equals(strinv)) {
            s = i % 2 == 0 ? "X" + s : String.valueOf(s) + "X";
            ++i;
            formulae.add(s);
        }
        return formulae;
    }

    private static String inverse(String s) {
        String str = "";
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            str = c == '(' ? String.valueOf(')') + str : (c == ')' ? String.valueOf('(') + str : String.valueOf(c) + str);
            ++n2;
        }
        return str;
    }

    private String fill(String str, String x, String y) {
        if (this.line == FiliationType.COGNATIC || x.equals("Y") || this.line == FiliationType.AGNATIC && y.equals("H") || this.line == FiliationType.UTERINE && y.equals("F")) {
            return str.replaceFirst(x, y);
        }
        int i = str.indexOf(x);
        if (i == 0 || i == str.length() - 1 || str.charAt(i + 1) == '.' || str.charAt(i - 1) == '.') {
            return str.replaceFirst(x, y);
        }
        return null;
    }

    private void develop(List<Chain> models, String str, int k) {
        if (ChainMaker.isWellFormed(str)) {
            int i = k;
            while (i < str.length()) {
                if (str.charAt(i) == 'X') {
                    this.develop(models, this.fill(str, "X", "H"), i);
                    this.develop(models, this.fill(str, "X", "F"), i);
                    return;
                }
                if (str.charAt(i) == 'Y') {
                    if (this.sib != SiblingMode.ALL) {
                        this.develop(models, this.fill(str, "Y", "X"), k);
                    }
                    if (this.sib != SiblingMode.NONE) {
                        this.develop(models, this.fill(str, "Y", ""), k);
                    }
                    return;
                }
                ++i;
            }
            if (!ChainMaker.containsHomosexualMarriages(this.crossSex, str)) {
                Chain model = ChainMaker.fromString(str);
                model.setSymmetry(this.symmetry);
                models.add(model.standard());
            }
        }
    }

    public static String replaceCharAt(String s, int i, char c) {
        return String.valueOf(s.substring(0, i)) + c + s.substring(i + 1);
    }

    void begin() {
        this.time = System.currentTimeMillis();
    }

    private void buildCircuits(List<Chain> chains, List<Chain>[] br) {
        if (chains.size() == br.length) {
            Chain circuit = ChainMaker.concatenate(chains, this.degrees[chains.size() - 1]);
            this.put(circuit);
            return;
        }
        for (Chain chain : br[chains.size()]) {
            chains.add(chain);
            this.buildCircuits(chains, br);
            chains.remove(chain);
        }
    }

    public Map<Chain, Set<Cluster<Chain>>> coupleChainClusterMap(Gender firstGender) {
        HashMap<Chain, Set<Cluster<Chain>>> result = new HashMap<Chain, Set<Cluster<Chain>>>();
        for (Cluster<Chain> cluster : this.circuits.getClusters()) {
            for (Chain chain : cluster.getItems()) {
                int i = 0;
                while (i < 2 * chain.dim()) {
                    Chain couple;
                    if ((this.symmetry == SymmetryType.PERMUTABLE || i <= 0) && (couple = chain.getCouple(i)).getFirst().getGender() == firstGender) {
                        HashSet<Cluster<Chain>> clusters = (HashSet<Cluster<Chain>>)result.get(couple);
                        if (clusters == null) {
                            clusters = new HashSet<Cluster<Chain>>();
                            result.put(couple, clusters);
                        }
                        clusters.add(cluster);
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    private int getCouplePosition(Chain couple, Chain circuit) {
        Individual ego = couple.getFirst();
        Individual alter = couple.getLast();
        int result = 0;
        while (result < 2 * circuit.dim()) {
            if (circuit.getPivot(result).equals(ego) && (result % 2 == 0 && circuit.getPivot(result - 1).equals(alter) || result % 2 == 1 && circuit.getPivot(result + 1).equals(alter))) break;
            ++result;
        }
        return result;
    }

    public Map<Chain, Set<Chain>> coupleChainMap(Gender firstGender) {
        HashMap<Chain, Set<Chain>> result = new HashMap<Chain, Set<Chain>>();
        for (Cluster<Chain> cluster : this.circuits.getClusters()) {
            for (Chain circuit : cluster.getItems()) {
                for (Chain couple : circuit.getCouples(this.crossSex, this.symmetry, firstGender)) {
                    HashSet<Chain> clusters = (HashSet<Chain>)result.get(couple);
                    if (clusters == null) {
                        clusters = new HashSet<Chain>();
                        result.put(couple, clusters);
                    }
                    clusters.add(circuit.transform(this.getCouplePosition(couple, circuit)));
                }
            }
        }
        return result;
    }

    public Partition<Cluster<Chain>> clustersByCouples(Gender firstGender) {
        Partition<Cluster<Chain>> result = new Partition<Cluster<Chain>>();
        for (Cluster<Chain> cluster : this.circuits.getClusters()) {
            for (Chain r : cluster.getItems()) {
                int i = 0;
                while (i < 2 * r.dim()) {
                    Chain couple;
                    if ((this.symmetry == SymmetryType.PERMUTABLE || i <= 0) && (couple = r.getCouple(i)).getFirst().getGender() == firstGender) {
                        result.put(cluster, new Value(couple));
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    private boolean isForbidden(Chain chain) {
        boolean result = false;
        if (this.forbiddenChains != null) {
            for (Chain model : this.forbiddenChains) {
                if (!chain.getCharacteristicVector().equals(model.getCharacteristicVector())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean hasCorrectForm(Chain chain) {
        boolean result = false;
        if (this.chainModels != null) {
            for (Chain model : this.chainModels) {
                if (!chain.getCharacteristicVector().equals(model.getCharacteristicVector())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean notInDomain(Individual ego, Individual alter) {
        boolean result = false;
        switch (this.restriction) {
            case NONE: {
                result = false;
                break;
            }
            case ALL: {
                if (this.symmetry == SymmetryType.INVARIABLE) {
                    result = !this.targetDomain.contains(ego);
                    break;
                }
                result = !this.targetDomain.contains(ego) || !this.targetDomain.contains(alter);
                break;
            }
            case LASTMARRIED: {
                result = !this.targetDomain.contains(ego) && !this.targetDomain.contains(alter);
                break;
            }
            case SOME: {
                result = !this.targetDomain.contains(ego) && !this.targetDomain.contains(alter);
            }
        }
        return result;
    }

    private boolean notInDomain(Chain chain) {
        boolean result = false;
        block0 : switch (this.restriction) {
            case NONE: {
                result = false;
                break;
            }
            case LASTMARRIED: {
                result = chain.getLastMarriage(this.familyDomain) == null;
                break;
            }
            case SOME: {
                result = true;
                for (Individual i : chain) {
                    if (!this.targetDomain.contains(i)) continue;
                    result = false;
                    break;
                }
                if (result) break;
                result = chain.hasNoFamiliesInDomain(this.familyDomain, this.relationType);
                break;
            }
            case ALL: {
                switch (this.symmetry) {
                    case PERMUTABLE: {
                        result = chain.hasFamiliesOutOfDomain(this.familyDomain, this.relationType);
                        break block0;
                    }
                    case INVERTIBLE: {
                        result = !this.targetDomain.contains(chain.getFirst()) && !this.targetDomain.contains((Individual)chain.get(1));
                        break block0;
                    }
                    case INVARIABLE: {
                        result = !this.targetDomain.contains(chain.getFirst());
                    }
                }
            }
        }
        return result;
    }

    protected boolean incorrectProperties(Individual individual) {
        boolean result = false;
        if (this.couplesOnly && individual.isSingle(this.relationType)) {
            result = true;
        }
        return result;
    }

    private void completeCircuits(Chain chain) {
        int n = chain.size();
        if (n % 2 == 1) {
            return;
        }
        if (this.symmetry == SymmetryType.INVERTIBLE && chain.getFirst().getId() > chain.getLast().getId()) {
            return;
        }
        if (this.notInDomain(chain)) {
            return;
        }
        if (this.relationType.equals("OPEN") && this.incorrectRelation(chain.getFirst(), chain.getLast())) {
            return;
        }
        if (this.requiredAttribute != null && Trafo.isBlank(chain.getLast().getAttributeValue(this.requiredAttribute))) {
            return;
        }
        int degree = this.degrees[n / 2 - 1];
        List[] br = new List[n / 2];
        int i = 0;
        while (i < n / 2) {
            int a;
            int e;
            if (this.relationType.equals("OPEN")) {
                e = 2 * i;
                a = 2 * i + 1;
            } else {
                e = (n + 1 + 2 * i) % n;
                a = (n + 2 + 2 * i) % n;
            }
            br[i] = new ArrayList<Chain>(this.findBridges((Individual)chain.get(e), (Individual)chain.get(a), degree));
            if (br[i].size() == 0) {
                return;
            }
            ++i;
        }
        this.buildCircuits(new ArrayList<Chain>(), br);
    }

    public void countCircuits() {
        this.nrCircuitsForKey = new HashMap<Value, Integer>();
        for (Value value : this.circuits.getValues()) {
            int circuitClusterSize = this.circuits.getCluster(value).size();
            if (circuitClusterSize == 0) continue;
            this.nrCircuitsForKey.put(value, circuitClusterSize);
        }
    }

    public void count() {
        int n = this.dim() + 1;
        this.nrCircuits = new int[n];
        this.nrCouples = new int[n];
        this.nrIndividuals = new int[n];
        this.nrCircuitTypes = new int[n];
        this.nrCircuitsForKey = new HashMap<Value, Integer>();
        this.nrCouplesForKey = new HashMap<Value, Integer>();
        this.nrPivotsForKey = new HashMap<Value, Integer>();
        for (Value value : this.circuits.getValues()) {
            int circuitClusterSize = this.circuits.getCluster(value).size();
            if (circuitClusterSize == 0) continue;
            int d = this.circuits.getCluster(value).getFirstItem().dim();
            int coupleClusterSize = this.couples.getCluster(value).size();
            int pivotClusterSize = this.pivots.getCluster(value).size();
            this.nrCircuitsForKey.put(value, circuitClusterSize);
            this.nrCouplesForKey.put(value, coupleClusterSize);
            this.nrPivotsForKey.put(value, pivotClusterSize);
            this.nrCircuits[0] = this.nrCircuits[0] + circuitClusterSize;
            int n2 = d;
            this.nrCircuits[n2] = this.nrCircuits[n2] + circuitClusterSize;
            this.nrCircuitTypes[0] = this.nrCircuitTypes[0] + 1;
            int n3 = d;
            this.nrCircuitTypes[n3] = this.nrCircuitTypes[n3] + 1;
        }
        int i = 0;
        while (i < this.dim() + 1) {
            this.nrCouples[i] = this.couplesByOrder[i].size();
            this.nrIndividuals[i] = this.pivotsByOrder[i].size();
            ++i;
        }
    }

    private void createAscendantTies(Map<Individual, Map<Individual, Integer>> asc, Individual ego, Individual alter, int k, int max) {
        CircuitFinder.set(asc, ego, alter, k);
        CircuitFinder.set(asc, alter, ego, -k);
        if (k < max) {
            Individuals parents = alter.getParents();
            if (parents == null) {
                return;
            }
            for (Individual newAlter : parents) {
                if (newAlter == null) continue;
                this.createAscendantTies(asc, ego, newAlter, k + 1, max);
            }
        }
    }

    void end() {
        this.end(null);
    }

    void end(String s) {
        this.time = System.currentTimeMillis() - this.time;
    }

    private boolean potentialAlterPosition(int pos) {
        boolean result = this.symmetry == SymmetryType.PERMUTABLE ? true : (this.symmetry == SymmetryType.INVERTIBLE ? (this.relationType.equals("OPEN") ? pos == 2 * this.dim() - 1 : pos == 1) : false);
        return result;
    }

    private void findBases(Individual ego, Chain chain, Set<Individual> vertices, int rmax, int egoPos) {
        this.completeCircuits(chain);
        if (egoPos == rmax) {
            return;
        }
        vertices.add(ego);
        Individuals alters = this.getAlters(ego, egoPos);
        for (Individual alter : alters) {
            if (!(egoPos != 0 || this.relationType.equals("OPEN") || alter.getId() <= ego.getId() && this.symmetry != SymmetryType.INVARIABLE || this.notInDomain(ego, alter) || (this.relationType.equals("SPOUSE") || this.relationType.equals("PARTN")) && this.familyDomain.getBySpouses(ego, alter) == null)) {
                ++this.couplesConsidered;
                this.consideredCouples.add(Chain.getCouple(ego, alter, this.crossSex, this.symmetry, this.firstGender));
            }
            if (this.potentialAlterPosition(egoPos + 1) && this.incorrectProperties(alter) || this.restriction == RestrictionType.ALL && !this.targetDomain.contains(alter) && (this.symmetry == SymmetryType.PERMUTABLE || this.symmetry == SymmetryType.INVERTIBLE && egoPos == 0) || this.restriction == RestrictionType.ALL && this.isCouplePosition(egoPos) && (this.relationType.equals("SPOUSE") || this.relationType.equals("PARTN")) && this.familyDomain.getBySpouses(ego, alter) == null || alter.getId() < chain.getFirst().getId() && (this.symmetry == SymmetryType.PERMUTABLE && this.potentialAlterPosition(egoPos + 1) || this.symmetry == SymmetryType.INVERTIBLE && egoPos == 0 && alter.getId() < chain.getFirst().getId()) || this.symmetry == SymmetryType.PERMUTABLE && alter.equals(chain.getFirst()) && ego.getId() <= chain.getId(1) || vertices.contains(alter) && alter != ego && alter != chain.getFirst() || !chain.add(alter, 0)) continue;
            this.findBases(alter, chain, vertices, rmax, egoPos + 1);
            chain.removeLast();
        }
        vertices.remove(ego);
    }

    private Set<Chain> findBridges(Individual ego, Individual alter, int r) {
        HashSet<Chain> result = new HashSet<Chain>();
        this.findBridges(ego, alter, result, new Chain(ego), new Chain(alter), new HashSet<Individual>(), r, r);
        return result;
    }

    private void findBridges(Individual ego, Individual alter, Set<Chain> bridges, Chain leftChain, Chain rightChain, Set<Individual> vertices, int rmax, int r) {
        this.findLeftBridges(ego, alter, bridges, leftChain, rightChain, vertices, rmax);
        if (r == 0) {
            return;
        }
        if (this.matches(ego, alter)) {
            return;
        }
        Individuals parents = this.getParents(alter);
        if (parents == null) {
            return;
        }
        vertices.add(alter);
        for (Individual newAlter : parents) {
            if (vertices.contains(newAlter) || !rightChain.add(newAlter, 1)) continue;
            this.findBridges(ego, newAlter, bridges, leftChain, rightChain, vertices, rmax, r - 1);
            rightChain.removeLast();
        }
        vertices.remove(alter);
    }

    public void findCircuits() {
        this.couplesConsidered = 0;
        if (this.relationType.equals("OPEN")) {
            this.getConsanguines(this.maxDeg[0]);
        } else if (this.dim() > 1) {
            this.getConsanguines(this.maxDeg[1]);
        }
        for (Individual ego : this.searchDomain.toSortedList()) {
            if (this.incorrectProperties(ego) || this.requiredAttribute != null && Trafo.isBlank(ego.getAttributeValue(this.requiredAttribute))) continue;
            if (this.relationType.equals("LINEAR")) {
                this.findLinearChains(new Chain(ego));
                continue;
            }
            if (this.relationType.equals("OPEN")) {
                this.findBases(ego, new Chain(ego), new HashSet<Individual>(), 2 * this.dim() - 1, 0);
                continue;
            }
            if (this.dim() == 1) {
                for (Individual alter : this.getAlters(ego, 0)) {
                    if (this.notInDomain(ego, alter) || (this.relationType.equals("SPOUSE") || this.relationType.equals("PARTN")) && this.familyDomain.getBySpouses(ego, alter) == null || this.incorrectProperties(alter) || alter.getId() <= ego.getId() && this.symmetry != SymmetryType.INVARIABLE) continue;
                    ++this.couplesConsidered;
                    this.consideredCouples.add(Chain.getCouple(ego, alter, this.crossSex, this.symmetry, this.firstGender));
                    Set<Chain> bridges = this.findBridges(ego, alter, this.degrees[0]);
                    for (Chain c : bridges) {
                        this.put(c);
                    }
                }
                continue;
            }
            this.findBases(ego, new Chain(ego), new HashSet<Individual>(), 2 * this.dim() - 1, 0);
        }
    }

    private Individuals getParents(Individual ego) {
        Individuals result = this.line == FiliationType.COGNATIC ? ego.getParents() : ego.getParents(this.line);
        return result;
    }

    private void findLeftBridges(Individual ego, Individual alter, Set<Chain> bridges, Chain leftChain, Chain rightChain, Set<Individual> vertices, int r) {
        if (this.matches(ego, alter)) {
            if (this.mergingPartition != null) {
                if (rightChain.size() < 2 || !this.matches(ego, (Individual)rightChain.get(rightChain.size() - 2))) {
                    Couple group = new Couple();
                    group.setName(this.mergingPartition.getCluster(ego).getLabel());
                    Chain leftChain1 = leftChain.clone();
                    Chain rightChain1 = rightChain.clone();
                    leftChain1.add(group, 1);
                    rightChain1.add(group, 1);
                    bridges.add(ChainMaker.concatenateInv(leftChain1, rightChain1));
                }
            } else {
                bridges.add(ChainMaker.concatenateInv(leftChain, rightChain));
            }
            return;
        }
        if (r == 0) {
            return;
        }
        Individuals parents = this.getParents(ego);
        if (parents == null) {
            return;
        }
        vertices.add(ego);
        for (Individual newEgo : parents) {
            if (vertices.contains(newEgo) || !leftChain.add(newEgo, 1)) continue;
            this.findLeftBridges(newEgo, alter, bridges, leftChain, rightChain, vertices, r - 1);
            leftChain.removeLast();
        }
        vertices.remove(ego);
    }

    public Cluster<Chain> get(String str) {
        return this.getCircuits().getCluster(ChainMaker.fromString(str));
    }

    private String getRelationNames(Individual ego, Individual alter) {
        String result = "";
        for (Relation relation : ego.relations().getByModelName(this.relationType)) {
            if (relation == null || !StringUtils.isBlank((CharSequence)this.relationEgoRole) && !relation.hasRole(ego, this.relationEgoRole) || !StringUtils.isBlank((CharSequence)this.relationAlterRole) && !relation.hasRole(alter, this.relationAlterRole)) continue;
            if (result.length() > 0) {
                result = String.valueOf(result) + ",";
            }
            result = String.valueOf(result) + relation.getName();
        }
        return result;
    }

    private boolean isCouplePosition(int pos) {
        boolean result = this.relationType.equals("OPEN") ? pos % 2 != 0 : (this.relationType.equals("SPOUSE") || this.relationType.equals("PARTN") ? pos % 2 == 0 : pos > 0 && pos % 2 == 0);
        return result;
    }

    private Individuals getAlters(Individual ego, int pos) {
        Individuals result;
        if (this.relationType.equals("OPEN")) {
            result = pos % 2 != 0 ? (this.relationType.equals("PARTN") ? ego.getPartners() : ego.getSpouses()) : this.links(ego, this.maxDeg[pos / 2]);
        } else if (pos == 0) {
            if (this.relationType.equals("SPOUSE")) {
                result = ego.getSpouses();
            } else if (this.relationType.equals("PARTN")) {
                result = ego.getPartners();
            } else if (this.relationType.equals("COSPOUSE")) {
                result = ego.coSpouses();
            } else if (this.relationType.charAt(0) == '@') {
                result = new Individuals();
                Cluster<Individual> linkingCluster = this.linkingPartition.getCluster(ego);
                if (linkingCluster.getLabel() != null) {
                    for (Individual alter : linkingCluster.getItems()) {
                        if (this.incorrectRelation(ego, alter)) continue;
                        result.add(alter);
                    }
                }
            } else if (this.relationType.equals("TOTAL")) {
                result = new Individuals();
                for (Individual alter : this.targetDomain) {
                    if (this.incorrectRelation(ego, alter) || this.symmetry != SymmetryType.INVARIABLE && alter.getId() <= ego.getId()) continue;
                    result.add(alter);
                }
            } else {
                result = new Individuals();
                for (Relation relation : ego.relations().getByModelName(this.relationType)) {
                    if (relation == null || !StringUtils.isBlank((CharSequence)this.relationEgoRole) && !relation.hasRole(ego, this.relationEgoRole)) continue;
                    for (Actor actor : relation.actors()) {
                        Individual alter;
                        if (!StringUtils.isBlank((CharSequence)this.relationAlterRole) && !actor.getRole().getName().equals(this.relationAlterRole) || this.incorrectRelation(ego, alter = actor.getIndividual())) continue;
                        result.add(alter);
                    }
                }
            }
        } else {
            result = pos % 2 == 0 ? (this.relationType.equals("PARTN") ? ego.getPartners() : ego.getSpouses()) : this.links(ego, this.maxDeg[(pos + 1) / 2]);
        }
        return result;
    }

    public Individuals links(Individual ego, int d) {
        Individuals result = new Individuals();
        Map<Individual, Integer> cons = this.consanguines.get(ego);
        for (Individual alter : cons.keySet()) {
            if (cons.get(alter) > d) continue;
            result.put(alter);
        }
        return result;
    }

    private boolean matches(Individual ego, Individual alter) {
        boolean result = false;
        if (ego.equals(alter)) {
            result = true;
        } else if (this.mergingPartition != null) {
            Value egoGroup = this.mergingPartition.getValue(ego);
            Value alterGroup = this.mergingPartition.getValue(alter);
            if (egoGroup != null && alterGroup != null && ((Object)egoGroup).equals(alterGroup)) {
                result = true;
            }
        }
        return result;
    }

    void changeCircuitLabelsToClassic() {
        if (this.classification == "SIMPLE") {
            for (Cluster<Chain> cluster : this.circuits.getClusters()) {
                Chain chain = cluster.getFirstItem();
                if (this.crossSex) {
                    cluster.setValue(new Value(chain.signature(Notation.CLASSIC)));
                    continue;
                }
                cluster.setValue(new Value(chain.signature(Notation.CLASSIC_GENDERED)));
            }
        }
    }

    protected void put(Chain c) {
        if (c == null) {
            return;
        }
        c.setSymmetry(this.symmetry);
        Chain cs = this.relationType.equals("LINEAR") ? c : (this.symmetry == SymmetryType.INVARIABLE && this.dim() > 1 ? c.neutralize(this.sib).transform(2 * c.dim() - 1) : c.neutralize(this.sib).standard());
        Value k = ChainValuator.get(cs, this.classification);
        int dim = c.dim();
        if (this.isForbidden(cs)) {
            return;
        }
        if (this.line != FiliationType.COGNATIC && !ChainValuator.hasLineValue(cs, "LINE", new Value(this.line))) {
            return;
        }
        if (this.violatesRingType(cs)) {
            return;
        }
        if (this.schema != null && !this.hasCorrectForm(cs)) {
            return;
        }
        if (this.restriction == RestrictionType.LASTMARRIED && this.circuits.getCluster(k) != null && this.circuits.getCluster(k).getItems().contains(cs)) {
            return;
        }
        if (this.linkingPartition != null) {
            cs.closingRelation = this.linkingPartition.getCluster(cs.getFirst()).getLabel();
        } else if (!(this.relationType.equals("SPOUSE") || this.relationType.equals("PARTN") || this.relationType.equals("OPEN") || this.relationType.equals("COSPOUSE"))) {
            cs.closingRelation = this.getRelationNames(cs.getFirst(), cs.getLast());
        }
        this.circuits.put(cs, k);
        if (this.couples != null) {
            for (Chain couple : cs.getCouples(this.crossSex, this.symmetry, this.firstGender)) {
                this.couples.put(couple, k);
                if (!ChainCluster.contains(this.couplesByOrder[dim], couple)) {
                    this.couplesByOrder[dim].add(couple);
                }
                if (ChainCluster.contains(this.couplesByOrder[0], couple)) continue;
                this.couplesByOrder[0].add(couple);
            }
        }
        if (this.pivots != null) {
            for (Chain subchain : cs.subchains) {
                Individual pivot = subchain.getFirst();
                this.pivots.put(pivot, k);
                this.pivotsByOrder[dim].add(pivot);
                this.pivotsByOrder[0].add(pivot);
                if (!this.markIndividuals) continue;
                pivot.setAttribute("chain_" + k.toString().replaceAll(" ", "_"), "true");
            }
        }
    }

    private String clusterSignature(Cluster<Chain> cluster) {
        String result;
        if (this.classification.equals("SIMPLE")) {
            Chain chain = cluster.getFirstItem();
            result = this.crossSex ? chain.signature(Notation.CLASSIC) : chain.signature(Notation.CLASSIC_GENDERED);
            result = String.valueOf(result) + "\t" + chain.signature(Notation.POSITIONAL) + "\t" + chain.signature(Notation.VECTOR);
        } else {
            result = cluster.getValue().toString();
        }
        return result;
    }

    private String groupSignature(Chain chain) {
        String result = this.mergingPartition == null ? "" : String.valueOf(chain.signature(Notation.GROUPS)) + "\t";
        return result;
    }

    private Double[] getClosureRate(Partition<Chain> openChains, Cluster<Chain> circuit) {
        Double[] result;
        if (openChains == null) {
            result = new Double[]{0.0, 0.0, 0.0};
        } else {
            result = new Double[3];
            int circuitFrequency = circuit.count();
            int openChainFrequency = 0;
            if (!circuit.getValue().isVector()) {
                openChainFrequency = openChains.getCluster(circuit.getValue()).count();
            } else {
                Vector vector = circuit.getValue().vectorValue();
                if (vector.order() == 1) {
                    openChainFrequency = openChains.getCluster(circuit.getValue()).count();
                } else {
                    int i = 0;
                    while (i < 2 * vector.order()) {
                        Cluster<Chain> openCluster = openChains.getCluster(new Value(vector.transform(i)));
                        if (openCluster != null) {
                            openChainFrequency += openCluster.count();
                        }
                        ++i;
                    }
                }
            }
            result[0] = MathUtils.percent(circuitFrequency, this.couplesConsidered);
            result[1] = MathUtils.percent(2 * openChainFrequency, this.targetDomain.size());
            result[2] = MathUtils.percent(circuitFrequency, openChainFrequency);
        }
        return result;
    }

    public Double[] getClosureRatePercentages(Value key) {
        Double[] result = new Double[3];
        Double[] closureRates = this.getClosureRate(key);
        result[0] = MathUtils.percent(closureRates[0], (double)this.couplesConsidered);
        result[1] = MathUtils.percent(2.0 * closureRates[1], (double)(100 * this.targetDomain.size()));
        result[2] = closureRates[2];
        return result;
    }

    public Double[] getClosureRate(Value key) {
        Double[] result;
        if (!this.openChainFrequencies) {
            result = null;
        } else {
            result = new Double[3];
            int circuitFrequency = this.getNrCircuitsForKey(key);
            int openChainFrequency = 0;
            if (!key.isVector()) {
                openChainFrequency = this.getNrOpenChainsForKey(key);
            } else {
                Vector vector = key.vectorValue();
                if (vector.order() == 1) {
                    openChainFrequency = this.getNrOpenChainsForKey(key);
                } else {
                    int i = 0;
                    while (i < 2 * vector.order()) {
                        openChainFrequency += this.getNrOpenChainsForKey(new Value(vector.transform(i)));
                        ++i;
                    }
                }
            }
            result[0] = new Double(circuitFrequency);
            result[1] = new Double(openChainFrequency);
            result[2] = MathUtils.percent(circuitFrequency, openChainFrequency);
        }
        return result;
    }

    private String getOpenChainSequence(Value key) {
        Double[] closure = this.getClosureRate(key);
        String result = closure == null ? "" : String.valueOf(String.format("%d \t%.2f%%", closure[1].intValue(), closure[2])) + "\t";
        return result;
    }

    private static String getOpenChainSequence(Partition<Chain> openChains, Cluster<Chain> circuit) {
        String result;
        if (openChains == null) {
            result = "";
        } else {
            int circuitFrequency = circuit.count();
            int openChainFrequency = 0;
            if (!circuit.getValue().isVector()) {
                openChainFrequency = openChains.getCluster(circuit.getValue()).count();
            } else {
                Vector vector = circuit.getValue().vectorValue();
                if (vector.order() == 1) {
                    openChainFrequency = openChains.getCluster(circuit.getValue()).count();
                } else {
                    int i = 0;
                    while (i < 2 * vector.order()) {
                        Cluster<Chain> openCluster = openChains.getCluster(new Value(vector.transform(i)));
                        if (openCluster != null) {
                            openChainFrequency += openCluster.count();
                        }
                        ++i;
                    }
                }
            }
            result = String.valueOf(String.format("%d \t%.2f%%", openChainFrequency, MathUtils.percent(circuitFrequency, openChainFrequency))) + "\t";
        }
        return result;
    }

    public String listCircuitFrequencies() {
        String result = "";
        for (Cluster<Chain> circuitCluster : this.circuits.getClusters().toListSortedByValue()) {
            Value key = circuitCluster.getValue();
            result = String.valueOf(result) + "\t" + this.getNrCircuitsForKey(key);
        }
        return result;
    }

    public int getNrOpenChainsForKey(Value key) {
        int result = 0;
        if (this.nrOpenChainsForKey.get(key) != null) {
            result = this.nrOpenChainsForKey.get(key);
        }
        return result;
    }

    public int getNrCircuits(int dimension) {
        return this.nrCircuits[dimension];
    }

    public int getNrCircuitsForKey(Value key) {
        int result = 0;
        if (this.nrCircuitsForKey.get(key) != null) {
            result = this.nrCircuitsForKey.get(key);
        }
        return result;
    }

    public int getNrCouplesForKey(Value key) {
        int result = 0;
        if (this.nrCouplesForKey.get(key) != null) {
            result = this.nrCouplesForKey.get(key);
        }
        return result;
    }

    public int getNrPivotsForKey(Value key) {
        int result = 0;
        if (this.nrPivotsForKey.get(key) != null) {
            result = this.nrPivotsForKey.get(key);
        }
        return result;
    }

    public Map<Value, Double[]> getClosureRates() throws PuckException {
        HashMap<Value, Double[]> result = new HashMap<Value, Double[]>();
        for (Cluster<Chain> circuitCluster : this.circuits.getClusters().toListSortedByValue()) {
            Value key = circuitCluster.getValue();
            result.put(key, this.getClosureRatePercentages(key));
        }
        return result;
    }

    public Map<Value, Double> getCircuitFrequencies() throws PuckException {
        HashMap<Value, Double> result = new HashMap<Value, Double>();
        for (Cluster<Chain> circuitCluster : this.circuits.getClusters().toListSortedByValue()) {
            result.put(circuitCluster.getValue(), new Double(circuitCluster.count()));
        }
        return result;
    }

    public static Map<Value, Double[]> getClosureRates(Segmentation segmentation, String chainClassification, FiliationType line, int maxGen) throws PuckException {
        CensusCriteria criteria = new CensusCriteria();
        criteria.setChainClassification(chainClassification);
        criteria.setPattern("XX(X)XX");
        criteria.setFiliationType(line);
        criteria.setOpenChainFrequencies(true);
        criteria.setSiblingMode(SiblingMode.FULL);
        criteria.setRestrictionType(RestrictionType.ALL);
        CircuitFinder finder = new CircuitFinder(segmentation, criteria);
        finder.findCircuits();
        finder.getOpenChains();
        finder.countCircuits();
        Map<Value, Double[]> result = finder.getClosureRates();
        return result;
    }

    public SymmetryType getSymmetry() {
        return this.symmetry;
    }

    public StringList reportSurvey() {
        StringList result = new StringList();
        StringList labels = new StringList();
        if (CensusReporter.isBasicClassification(this.classification)) {
            labels.addAll(this.censusDetails.getReportLabels());
        }
        String signatureSequence = "";
        signatureSequence = this.classification.equals("SIMPLE") ? String.valueOf(this.t("Standard")) + "\t" + this.t("Positional") + "\t" + this.t("Vector") : this.classification;
        String openChainSequence = "";
        if (this.openChainFrequencies) {
            openChainSequence = String.valueOf(this.t("#Open chains")) + "\t" + this.t("Closure Rate") + "\t";
        }
        String totalCouples = "";
        String totalIndividuals = "";
        if (!this.relationType.equals("OPEN") && !this.relationType.equals("LINEAR")) {
            totalCouples = "(" + MathUtils.percent(this.nrCouples[0], this.couplesConsidered) + " % of " + this.couplesConsidered + " couples examined)";
            totalIndividuals = "(" + MathUtils.percent(this.nrIndividuals[0], this.targetDomain.size()) + " % of " + this.targetDomain.size() + " individuals examined)";
        }
        result.appendln();
        result.appendln(String.valueOf(this.nrCircuits[0]) + " " + this.t("circuits") + " (" + this.t("maximal depths = ") + Arrays.toString(this.degrees) + ")");
        result.appendln(String.valueOf(this.nrCircuitTypes[0]) + " " + this.t("circuit types") + " (" + this.t("average frequency = ") + MathUtils.round(new Double(this.nrCircuits[0]) / new Double(this.nrCircuitTypes[0]), 2) + ")");
        result.appendln(String.valueOf(this.nrCouples[0]) + " " + this.t("couples concerned") + " " + totalCouples);
        result.appendln(String.valueOf(this.nrIndividuals[0]) + " " + this.t("individuals concerned") + " " + totalIndividuals);
        result.appendln();
        int d = 0;
        int id = 0;
        for (Cluster<Chain> circuitCluster : this.circuits.getClusters().toListSortedByValue()) {
            Value key = circuitCluster.getValue();
            int nrTheseCircuits = this.getNrCircuitsForKey(key);
            int nrTheseCouples = this.getNrCouplesForKey(key);
            int nrThesePivots = this.getNrPivotsForKey(key);
            if (nrTheseCircuits == 0) continue;
            ++id;
            int valueDim = key.dimension();
            if (valueDim > d) {
                d = valueDim;
                result.appendln();
                result.appendln(String.valueOf(this.nrCircuits[d]) + " " + this.t("circuits of order") + " " + d + " (" + this.t("maximal depth = ") + this.degrees[d - 1] + ")" + " (" + MathUtils.percent(this.nrCircuits[d], this.nrCircuits[0]) + " %)");
                result.appendln(String.valueOf(this.nrCircuitTypes[d]) + " " + this.t("circuit types") + " (" + MathUtils.percent(this.nrCircuitTypes[d], this.nrCircuitTypes[0]) + " %)" + " (" + this.t("average frequency = ") + MathUtils.round(new Double(this.nrCircuits[d]) / new Double(this.nrCircuitTypes[d]), 2) + ")");
                result.appendln(String.valueOf(this.nrCouples[d]) + " " + this.t("couples concerned") + " (" + MathUtils.percent(this.nrCouples[d], this.nrCouples[0]) + " %)" + ", " + MathUtils.percent(this.nrCouples[d], this.couplesConsidered) + "% of all couples");
                result.appendln(String.valueOf(this.nrIndividuals[d]) + " " + this.t("individuals concerned") + " (" + MathUtils.percent(this.nrIndividuals[d], this.nrIndividuals[0]) + " %)" + ", " + MathUtils.percent(this.nrIndividuals[d], this.targetDomain.size()) + "% of all individuals");
                result.appendln();
                result.appendln("Nr\t" + signatureSequence + "\t" + this.t("#Circuits") + "\t" + this.t("% Circuits") + "\t" + openChainSequence + this.t("# Couples") + "\t" + this.t("% Couples") + "\t" + this.t("% All Couples") + "\t" + this.t("# Individuals") + "\t" + this.t("% Individuals") + "\t" + this.t("% All Individuals") + "\t" + labels.toStringSeparatedBy("\t"));
            }
            result.appendln(String.valueOf(id) + "\t" + this.clusterSignature(circuitCluster) + "\t" + nrTheseCircuits + "\t" + MathUtils.percent(nrTheseCircuits, this.nrCircuits[d]) + "\t" + this.getOpenChainSequence(key) + nrTheseCouples + "\t" + MathUtils.percent(nrTheseCouples, this.nrCouples[d]) + "\t" + MathUtils.percent(nrTheseCouples, this.couplesConsidered) + "\t" + nrThesePivots + "\t" + MathUtils.percent(nrThesePivots, this.nrIndividuals[d]) + "\t" + MathUtils.percent(nrThesePivots, this.targetDomain.size()) + "\t" + ChainValuator.getValueString(circuitCluster.getFirstItem(), (List<String>)labels, null));
        }
        result.appendln();
        return result;
    }

    public StringList reportCircuitTypeList() {
        StringList result = new StringList();
        result.appendln("List by circuit types");
        result.appendln();
        int clusterCount = 1;
        for (Cluster<Chain> cluster : this.circuits.getClusters().toListSortedByValue()) {
            if (!cluster.isNotEmpty()) continue;
            List<Chain> list = CircuitFinder.asSortedList(cluster.getItems());
            result.append(clusterCount);
            result.append(". ");
            result.append(this.clusterSignature(cluster));
            result.append(" (");
            result.append(list.size());
            result.appendln(")");
            for (Chain chain : list) {
                result.append("\t");
                result.append(chain.signature(Notation.PIVOTS));
                result.append("\t");
                result.append(chain.signature(Notation.NUMBERS));
                result.append("\t");
                result.append(this.groupSignature(chain));
                result.appendln(chain.signature(Notation.CLOSING_RELATION));
            }
            ++clusterCount;
            result.appendln();
        }
        result.appendln();
        return result;
    }

    public static StringList reportChainListByCluster(MultiPartition<Chain> partitions) {
        StringList result = new StringList();
        result.appendln("List by circuit types");
        result.appendln();
        int partitionCount = 1;
        for (Value rowValue : partitions.sortedRowValues()) {
            result.append(partitionCount);
            result.append(". ");
            result.append(rowValue.toString());
            result.append(" (");
            result.append(partitions.rowSum(rowValue));
            result.appendln(")");
            result.appendln();
            int clusterCount = 1;
            for (Value colValue : partitions.colValues()) {
                Cluster<Chain> cluster = partitions.getCluster(rowValue, colValue);
                if (cluster == null || !cluster.isNotEmpty()) continue;
                List<Chain> list = CircuitFinder.asSortedList(cluster.getItems());
                result.append("\t");
                result.append(clusterCount);
                result.append(". ");
                result.append(cluster.getValue().toString());
                result.append(" (");
                result.append(list.size());
                result.appendln(")");
                for (Chain chain : list) {
                    result.append("\t\t");
                    result.append(chain.signature(Notation.PIVOTS));
                    result.append("\t");
                    result.append(chain.signature(Notation.NUMBERS));
                    result.appendln();
                }
                ++clusterCount;
                result.appendln();
            }
            result.appendln();
        }
        result.appendln();
        return result;
    }

    public List<Chain> getOutOfCircuitCouples() {
        ArrayList<Chain> result = new ArrayList();
        for (Chain couple : this.consideredCouples) {
            if (this.couples.getItems().contains(couple)) continue;
            result.add(couple);
        }
        result = CircuitFinder.asSortedList(result);
        return result;
    }

    public StringList reportCoupleList() {
        StringList result = new StringList();
        result.appendln("List by couples");
        result.appendln();
        Map<Chain, Set<Chain>> couples = this.coupleChainMap(Gender.MALE);
        int clusterCount = 1;
        for (Chain couple : CircuitFinder.asSortedList(couples.keySet())) {
            List<Chain> list = CircuitFinder.asSortedList((Collection)couples.get(couple));
            result.append(clusterCount);
            result.append(". ");
            result.append(couple.signature(Notation.COUPLE));
            result.append(" (");
            result.append(list.size());
            result.append(") ");
            result.append("\t");
            result.appendln(list.get(0).signature(Notation.CLOSING_RELATION));
            for (Chain chain : list) {
                result.append("\t");
                result.append(chain.signature(Notation.CLASSIC));
                result.append("\t");
                result.append(chain.signature(Notation.NUMBERS));
                result.appendln(this.groupSignature(chain));
            }
            ++clusterCount;
            result.appendln();
        }
        result.appendln();
        int outOfCircuitCount = this.getOutOfCircuitCouples().size();
        result.appendln(String.valueOf(outOfCircuitCount) + " Couples out of circuits (" + MathUtils.percent(outOfCircuitCount, this.couplesConsidered) + "% of all couples examined):");
        result.appendln();
        int count = 1;
        for (Chain couple : this.getOutOfCircuitCouples()) {
            result.appendln(String.valueOf(count) + "\t" + couple.getFirst() + "\t" + couple.getLast());
            ++count;
        }
        return result;
    }

    public StringList reportSortableList() {
        StringList result = new StringList();
        result.appendln("Sortable list");
        result.appendln();
        result.append("Nr.").append("\t");
        result.append("Standard\tPositional\tVector").append("\t");
        result.append("Ego").append("\t");
        result.append("Alter").append("\t");
        result.append("Pivots").append("\t");
        result.append("Chain").appendln();
        int clusterCount = 1;
        for (Cluster<Chain> cluster : this.circuits.getClusters().toListSortedByValue()) {
            if (!cluster.isNotEmpty()) continue;
            List<Chain> list = CircuitFinder.asSortedList(cluster.getItems());
            for (Chain chain : list) {
                result.append(clusterCount).append("\t");
                result.append(this.clusterSignature(cluster)).append("\t");
                result.append(chain.getFirst().getId()).append("\t");
                result.append(chain.getLast().getId()).append("\t");
                result.append(chain.signature(Notation.PIVOTS)).append("\t");
                result.append(chain.signature(Notation.NUMBERS)).append("\t");
                result.append(this.groupSignature(chain)).appendln(chain.signature(Notation.CLOSING_RELATION));
            }
            ++clusterCount;
        }
        result.appendln();
        return result;
    }

    private static Chain createLinearChain(Chain chain) {
        Chain result = chain.clone();
        result.subchains = new ArrayList<Chain>();
        result.subchains.add(chain.clone());
        result.subchains.add(new Chain(chain.getLast()));
        return result;
    }

    private void findLinearChains(Chain chain) {
        if (chain.length() <= this.maxDeg[0]) {
            if (chain.length() > 0) {
                this.put(CircuitFinder.createLinearChain(chain));
            }
            for (Individual parent : chain.getLast().getParents()) {
                if (!chain.add(parent, 1)) continue;
                this.findLinearChains(chain);
                chain.removeLast();
            }
        }
    }

    public Map<Individual, Map<Individual, Integer>> getConsanguines(int max) {
        HashMap<Individual, Map<Individual, Integer>> linearRelatives = new HashMap<Individual, Map<Individual, Integer>>();
        for (Individual ego : this.linkDomain) {
            this.createAscendantTies(linearRelatives, ego, ego, 0, max);
        }
        this.consanguines = new HashMap<Individual, Map<Individual, Integer>>();
        for (Individual ego : linearRelatives.keySet()) {
            if (this.incorrectProperties(ego)) continue;
            Map ascendants = (Map)linearRelatives.get(ego);
            for (Individual ascendant : ascendants.keySet()) {
                Cluster<Individual> ascendantsCluster;
                int upDistance = (Integer)ascendants.get(ascendant);
                if (upDistance < 0) continue;
                Individuals intermediates = new Individuals();
                intermediates.put(ascendant);
                if (this.mergingPartition != null && (ascendantsCluster = this.mergingPartition.getCluster(ascendant)).getLabel() != null) {
                    for (Individual ascendantEquivalent : ascendantsCluster.getItems()) {
                        intermediates.put(ascendantEquivalent);
                    }
                }
                for (Individual ancestor : intermediates) {
                    Map ascendantsDescendants = (Map)linearRelatives.get(ancestor);
                    for (Individual alter : ascendantsDescendants.keySet()) {
                        int downDistance;
                        if (this.incorrectProperties(alter) || (downDistance = ((Integer)ascendantsDescendants.get(alter)).intValue()) > 0) continue;
                        CircuitFinder.set(this.consanguines, ego, alter, Math.max(upDistance, -downDistance));
                    }
                }
            }
        }
        return this.consanguines;
    }

    public int sum() {
        return this.circuits.itemsCount();
    }

    public String t(String string) {
        return string;
    }

    public Net toNet() {
        Net net = new Net();
        ArrayList<Individual> pivotals = new ArrayList<Individual>();
        for (Cluster<Chain> cluster : this.circuits.getClusters()) {
            for (Chain t : cluster.getItems()) {
                int n = t.size();
                int i = 0;
                while (i < n) {
                    int j = (i + 1) % n;
                    Individual e = ((Individual)t.get(i)).clone();
                    Individual a = ((Individual)t.get(j)).clone();
                    e.getKin(t.dir(j)).add(a);
                    if (t.pivotal(i)) {
                        pivotals.add(e);
                    }
                    ++i;
                }
            }
        }
        return net;
    }

    private boolean incorrectRelation(Individual ego, Individual alter) {
        boolean result = ego == alter ? true : (this.crossSex ? ego.getGender() == alter.getGender() : false);
        return result;
    }

    private boolean violatesRingType(Chain r) {
        boolean result = false;
        if (this.ringType != CircuitType.CIRCUIT) {
            if (CircuitFinder.isRoundabout(r, this.sib)) {
                result = true;
            }
            if (this.ringType != CircuitType.RING) {
                if (CircuitFinder.hasShortcut(r, false)) {
                    result = true;
                }
                if (this.ringType != CircuitType.MINOR && CircuitFinder.hasShortcut(r, true)) {
                    result = true;
                }
            }
        }
        return result;
    }

    static boolean adjacent(int start, int end, int distance, int size) {
        boolean result = false;
        result = start == end ? true : distance == (size + start - end) % size;
        return result;
    }

    public static <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> c) {
        ArrayList<T> list = new ArrayList<T>(c);
        Collections.sort(list);
        return list;
    }

    public static boolean connects(Chain chain, Individual target, int maxLength, int maxOrder, List<Individual> visited) {
        if (chain.dim() > maxOrder + 1) {
            return false;
        }
        if (chain.getLast() == target && chain.length() > 1) {
            return true;
        }
        if (chain.length() >= maxLength) {
            return false;
        }
        visited.add(chain.getLast());
        int t = -1;
        while (t < 2) {
            if (t == 0) {
                chain.setOrder(chain.getOrder() + 1);
            }
            if (chain.lastDir() != -1 || t != 1) {
                for (Individual v : chain.getLast().getKin(t)) {
                    if (v == null || visited.contains(v)) continue;
                    chain.add(v, t);
                    if (CircuitFinder.connects(chain, target, maxLength, maxOrder, visited)) {
                        chain.removeLast();
                        if (t == 0) {
                            chain.setOrder(chain.getOrder() - 1);
                        }
                        visited.remove(chain.getLast());
                        return true;
                    }
                    chain.removeLast();
                }
                if (t == 0) {
                    chain.setOrder(chain.getOrder() - 1);
                }
            }
            ++t;
        }
        visited.remove(chain.getLast());
        return false;
    }

    static boolean connects(Individual ego, Individual alter, int maxLength, int maxOrder) {
        return CircuitFinder.connects(new Chain(ego), alter, maxLength, maxOrder, new ArrayList<Individual>());
    }

    static boolean hasCouplesInCommon(Cluster<Chain> clu, Chain r) {
        for (Chain s : clu.getItems()) {
            for (Chain c1 : s.getCouples()) {
                for (Chain c2 : r.getCouples()) {
                    if (!c1.equals(c2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean hasShortcut(Chain r, boolean strict) {
        int w = r.dim() - 1;
        if (strict) {
            w = 100;
        }
        int i = 0;
        while (i < 2 * r.dim()) {
            Chain s = r.transform(i);
            if (CircuitFinder.connects(s.getFirst(), s.getLast(), s.length() - 1, w)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean haveApicalLink(Individual ego, Individual alter) {
        boolean result = false;
        if (!(ego instanceof Couple) && !(alter instanceof Couple)) {
            result = CircuitFinder.haveDirectLink(ego, alter);
        } else if (!(alter instanceof Couple)) {
            for (Individual w : ((Couple)ego).individuals()) {
                if (!CircuitFinder.haveDirectLink(w, alter)) continue;
                result = true;
                break;
            }
        } else if (!(ego instanceof Couple)) {
            for (Individual w : ((Couple)alter).individuals()) {
                if (!CircuitFinder.haveDirectLink(ego, w)) continue;
                result = true;
                break;
            }
        } else {
            for (Individual w : ((Couple)ego).individuals()) {
                for (Individual u : ((Couple)alter).individuals()) {
                    if (!CircuitFinder.haveDirectLink(w, u)) continue;
                    return true;
                }
            }
        }
        return result;
    }

    private static boolean haveDirectLink(Individual ego, Individual alter) {
        boolean result = false;
        if (ego.getSpouses().contains(alter) || ego.getParents().contains(alter) || ego.getChildren().contains(alter)) {
            result = true;
        }
        return result;
    }

    private static boolean haveDirectLinearLink(Individual ego, Individual alter) {
        boolean result = false;
        if (ego.getParents().contains(alter) || ego.getChildren().contains(alter)) {
            result = true;
        }
        return result;
    }

    private static int[] intArray(String str) {
        String[] s = Trafo.trim(str).split(" ");
        int[] a = new int[s.length];
        int i = 0;
        while (i < s.length) {
            a[i] = Integer.parseInt(s[i].trim());
            ++i;
        }
        return a;
    }

    public static boolean isRoundabout(Chain chain, SiblingMode sib) {
        boolean result = false;
        if (chain.length() > 1 && (chain.getSymmetry() == SymmetryType.PERMUTABLE ? CircuitFinder.haveDirectLinearLink(chain.getFirst(), chain.getLast()) : CircuitFinder.haveDirectLink(chain.getFirst(), chain.getLast()))) {
            return true;
        }
        int n = chain.size();
        if (n >= 3) {
            int i = 2;
            while (i < n) {
                int s = 0;
                if (i == n - 1) {
                    s = 1;
                }
                int j = s;
                while (j < i - 1) {
                    Individual alter;
                    Individual ego = (Individual)chain.get(i);
                    if (CircuitFinder.haveApicalLink(ego, alter = (Individual)chain.get(j))) {
                        return true;
                    }
                    if (sib == SiblingMode.ALL && !CircuitFinder.adjacent(i, j, 2, n) && CircuitFinder.siblings(ego, alter)) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    public static void reduce(Cluster<Chain> clu1, Cluster<Chain> clu2) {
        if (clu1.equals(clu2)) {
            return;
        }
        Iterator<Chain> it = clu1.getItems().iterator();
        while (it.hasNext()) {
            if (!CircuitFinder.hasCouplesInCommon(clu2, it.next())) continue;
            it.remove();
        }
    }

    private static void set(Map<Individual, Map<Individual, Integer>> distMap, Individual e, Individual a, int d) {
        Map<Individual, Integer> map;
        if (distMap.get(e) == null) {
            distMap.put(e, new HashMap());
        }
        if ((map = distMap.get(e)).get(a) == null || d < map.get(a)) {
            map.put(a, d);
        }
    }

    static boolean siblings(Individual ego, Individual alter) {
        int i = 0;
        while (i < 2) {
            Individual egoParent = ego.getParent(i);
            Individual alterParent = alter.getParent(i);
            if (egoParent != null && alterParent != null && egoParent.equals(alterParent)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Partition<Chain> getCircuits() {
        return this.circuits;
    }

    public void setCircuits(Partition<Chain> circuits) {
        this.circuits = circuits;
    }

    public static MultiPartition<Chain> createDifferentialCensus(Segmentation segmentation, CensusCriteria censusCriteria) throws PuckException {
        MultiPartition<Chain> result = new MultiPartition<Chain>();
        result.setLabel(censusCriteria.getIndividualPartitionLabel());
        Partition<Individual> partition = PartitionMaker.createRaw(censusCriteria.getIndividualPartitionLabel(), segmentation.getCurrentIndividuals(), censusCriteria.getIndividualPartitionLabel());
        for (Cluster<Individual> cluster : partition.getClusters()) {
            if (cluster.isNull()) continue;
            Individuals individuals = new Individuals(cluster.getItems());
            Segmentation domain = new Segmentation(individuals, segmentation.getAllFamilies(), segmentation.getAllRelations());
            CircuitFinder finder = new CircuitFinder(domain, censusCriteria);
            finder.findCircuits();
            result.put(finder.getCircuits(), cluster.getValue());
        }
        return result;
    }

    private static void increment(Map<Value, Integer> sumMap, Map<Value, Integer> incMap, Value key) {
        if (incMap.get(key) != null) {
            if (sumMap.get(key) == null) {
                sumMap.put(key, incMap.get(key));
            } else {
                sumMap.put(key, sumMap.get(key) + incMap.get(key));
            }
        }
    }

    public void initializeCounts() {
        int n = this.dim() + 1;
        this.nrCircuits = new int[n];
        this.nrCouples = new int[n];
        this.nrIndividuals = new int[n];
        this.nrCircuitTypes = new int[n];
        this.nrCircuitsForKey = new HashMap<Value, Integer>();
        this.nrCouplesForKey = new HashMap<Value, Integer>();
        this.nrPivotsForKey = new HashMap<Value, Integer>();
        if (this.openChainFrequencies) {
            this.nrOpenChainsForKey = new HashMap<Value, Integer>();
        }
    }

    public void incrementCounts(CircuitFinder finder) {
        finder.count();
        for (Value value : finder.getCircuits().getValues()) {
            Cluster<Chain> cluster = finder.getCircuits().getCluster(value);
            if (cluster.size() <= 0) continue;
            this.circuits.put(cluster.getFirstItem(), value);
        }
        int i = 0;
        while (i < this.dim() + 1) {
            int n = i;
            this.nrCircuits[n] = this.nrCircuits[n] + finder.nrCircuits[i];
            int n2 = i;
            this.nrCouples[n2] = this.nrCouples[n2] + finder.nrCouples[i];
            int n3 = i;
            this.nrIndividuals[n3] = this.nrIndividuals[n3] + finder.nrIndividuals[i];
            int n4 = i;
            this.nrCircuitTypes[n4] = this.nrCircuitTypes[n4] + finder.nrCircuitTypes[i];
            ++i;
        }
        for (Value key : finder.circuits.getValues()) {
            CircuitFinder.increment(this.nrCircuitsForKey, finder.nrCircuitsForKey, key);
            CircuitFinder.increment(this.nrCouplesForKey, finder.nrCouplesForKey, key);
            CircuitFinder.increment(this.nrPivotsForKey, finder.nrPivotsForKey, key);
            if (!this.openChainFrequencies) continue;
            CircuitFinder.increment(this.nrOpenChainsForKey, finder.nrOpenChainsForKey, key);
        }
    }

    public void normalizeCounts(int runs) {
        int i = 0;
        while (i < this.dim() + 1) {
            this.nrCircuits[i] = this.nrCircuits[i] / runs;
            this.nrCouples[i] = this.nrCouples[i] / runs;
            this.nrIndividuals[i] = this.nrIndividuals[i] / runs;
            this.nrCircuitTypes[i] = this.nrCircuitTypes[i] / runs;
            ++i;
        }
        for (Value key : this.circuits.getValues()) {
            this.nrCircuitsForKey.put(key, this.nrCircuitsForKey.get(key) / runs);
            this.nrCouplesForKey.put(key, this.nrCouplesForKey.get(key) / runs);
            this.nrPivotsForKey.put(key, this.nrPivotsForKey.get(key) / runs);
            if (!this.openChainFrequencies) continue;
            this.nrOpenChainsForKey.put(key, this.nrOpenChainsForKey.get(key) / runs);
        }
    }

    public long getCircuitCoupleCount() {
        long result = this.nrCouples[0];
        return result;
    }

    public double getCircuitCoupleDensity() {
        double result = MathUtils.percent(this.nrCouples[0], this.couplesConsidered);
        return result;
    }
}

