/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.census.chains;

import java.util.ArrayList;
import java.util.List;
import oldcore.calc.partitions.Clusterable;
import org.tip.puck.census.chains.ChainMaker;
import org.tip.puck.census.chains.Couple;
import org.tip.puck.census.chains.Notation;
import org.tip.puck.census.chains.Vector;
import org.tip.puck.census.workers.CircuitFinder;
import org.tip.puck.census.workers.SiblingMode;
import org.tip.puck.census.workers.SymmetryType;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Families;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.Numberable;

public class Chain
extends ArrayList<Individual>
implements Comparable<Chain>,
Clusterable,
Numberable {
    int id;
    List<Integer> directions = new ArrayList<Integer>();
    private int order;
    List<Integer> pivots;
    List<Integer> apices;
    private int[] depths;
    Vector vector;
    private SymmetryType symmetry;
    public String closingRelation;
    public List<Chain> subchains;

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    private static int getSpouseIndex(int i, int n) {
        int result = i % 2 == 0 ? (i + n - 1) % n : (i + 1) % n;
        return result;
    }

    public static Notation notation(String str) {
        Notation result = null;
        if (Character.isDigit(str.charAt(0)) || Character.isDigit(str.charAt(1))) {
            result = Notation.VECTOR;
        } else if (str.charAt(1) == ' ' || Gender.isGenderSymbol(str.charAt(0))) {
            result = Notation.CLASSIC_GENDERED;
        } else if (Character.isLetter(str.charAt(0)) || str.charAt(0) == '(') {
            result = Notation.POSITIONAL;
        }
        return result;
    }

    public Chain() {
    }

    public Chain(Individual ego) {
        if (ego != null) {
            this.add(ego);
        }
    }

    public Chain(Individual ego, int dir) {
        if (ego != null) {
            this.add(ego);
            this.directions.add(dir);
        }
    }

    public Chain(Individual ego, Individual alter) {
        this.add(ego);
        this.add(alter);
    }

    public boolean add(Individual indi, int direction) {
        if (indi == null) {
            return false;
        }
        if (this.size() > 0) {
            this.directions.add(direction);
        }
        return super.add(indi);
    }

    public boolean addAll(Chain c) {
        for (int dir : c.directions) {
            this.directions.add(dir);
        }
        return super.addAll(c);
    }

    public boolean addAllWithMarriage(Chain c) {
        if (this.size() > 0 && !this.getLast().equals(c.getFirst())) {
            this.directions.add(0);
        }
        for (int dir : c.directions) {
            this.directions.add(dir);
        }
        return super.addAll(c);
    }

    void addApex(int i) {
        if (this.apices == null) {
            this.apices = new ArrayList<Integer>();
        }
        this.apices.add(i);
    }

    void addApices(List<Integer> list) {
        if (this.apices == null) {
            this.apices = new ArrayList<Integer>();
        }
        this.apices.addAll(list);
    }

    public boolean addInv(Chain c) {
        int i = c.size() - 2;
        while (i > -1) {
            this.add((Individual)c.get(i));
            this.directions.add(-c.dir(i + 1));
            --i;
        }
        return true;
    }

    public Chain inverse() {
        Chain result = new Chain();
        int i = this.size() - 1;
        while (i > -1) {
            result.add((Individual)this.get(i));
            --i;
        }
        return result;
    }

    public String baseSignature() {
        String t = "";
        int i = 0;
        while (i < this.size()) {
            t = String.valueOf(t) + this.getId(i) + " ";
            ++i;
        }
        return t;
    }

    @Override
    public Chain clone() {
        Chain chain = new Chain();
        chain.setSymmetry(this.symmetry);
        chain.addAll(this);
        if (this.subchains != null) {
            chain.subchains = new ArrayList<Chain>();
            for (Chain subchain : this.subchains) {
                chain.subchains.add(subchain.clone());
            }
        }
        return chain;
    }

    @Override
    public int compareTo(Chain c) {
        int result = new Integer(this.size()).compareTo(c.size());
        if (result == 0) {
            int i = 0;
            while (i < this.size()) {
                result = ((Individual)this.get(i)).compareTo((Individual)c.get(i));
                if (result != 0) break;
                ++i;
            }
        }
        return result;
    }

    boolean contains(Individual v, int n) {
        int i = 0;
        while (i < n) {
            if (((Individual)this.get(i)).getId() != 0 && ((Individual)this.get(i)).equals(v)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String coupleSignature() {
        boolean cons = false;
        String s = this.getFirst().getName();
        Individual lastAlter = this.getFirst();
        int i = 1;
        while (i < this.size()) {
            if (this.dir(i) == 0) {
                cons = true;
                if (!((Individual)this.get(i - 1)).equals(lastAlter)) {
                    s = String.valueOf(s) + " - " + ((Individual)this.get(i - 1)).getName();
                }
                lastAlter = (Individual)this.get(i);
                s = String.valueOf(s) + " = " + lastAlter.getName();
            }
            ++i;
        }
        s = cons ? String.valueOf(s) + " - " + this.getLast().getName() : String.valueOf(s) + " = " + this.getLast().getName();
        return s;
    }

    @Override
    public void removeLast() {
        this.directions.remove(this.size() - 2);
        this.remove(this.size() - 1);
    }

    @Override
    private void removeFirst() {
        this.directions.remove(0);
        this.remove(0);
    }

    public int dim() {
        int result;
        if (this.subchains != null) {
            result = this.subchains.size() / 2;
        } else {
            result = 1;
            for (int d : this.directions) {
                if (d != 0) continue;
                ++result;
            }
        }
        return result;
    }

    public int dir(int i) {
        return this.directions.get(i - 1);
    }

    @Override
    public boolean equals(Object e) {
        Chain c = (Chain)e;
        if (this.size() != c.size()) {
            return false;
        }
        int i = 0;
        while (i < this.size()) {
            if (!((Individual)this.get(i)).equals(c.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getCharacteristicNumber() {
        int result = 0;
        int i = 0;
        while (i < this.size()) {
            int a = 0;
            if (((Individual)this.get(i)).getGender().isMale()) {
                a = 1;
            } else if (((Individual)this.get(i)).getGender().isFemale()) {
                a = 2;
            } else if (this.get(i) instanceof Couple) {
                a = 1;
            } else {
                result = 0;
                break;
            }
            result += new Double(Math.pow(2.0, i) * (double)a).intValue();
            ++i;
        }
        if (this.getLast() instanceof Couple) {
            result *= -1;
        }
        return result;
    }

    public Vector getCharacteristicVector() {
        if (this.vector == null) {
            int n = this.subchains.size();
            int[] v = new int[n];
            int i = 0;
            while (i < n) {
                v[i] = this.subchains.get(i).getCharacteristicNumber();
                ++i;
            }
            this.vector = new Vector(v);
        }
        return this.vector;
    }

    public String getClusters(List<String> list) {
        if (list == null) {
            return "";
        }
        String str = "";
        for (String clu : list) {
            str = String.valueOf(str) + "\t" + this.getAttributeValue(clu);
        }
        return str;
    }

    private Chain getCopy(int i) {
        return this.clone().transform(i);
    }

    public Chain getCouple(int i) {
        Chain result = new Chain();
        int j = Chain.getSpouseIndex(i, 2 * this.dim());
        result = new Chain(this.subchains.get(i).getFirst(), this.subchains.get(j).getFirst());
        return result;
    }

    public static Chain getCouple(Individual ego, Individual alter, boolean crossSex, SymmetryType symmetry, Gender firstGender) {
        Chain result = symmetry == SymmetryType.INVARIABLE ? new Chain(ego, alter) : (crossSex ? (ego.getGender() == firstGender ? new Chain(ego, alter) : new Chain(alter, ego)) : (ego.getId() < alter.getId() ? new Chain(ego, alter) : new Chain(alter, ego)));
        return result;
    }

    public List<Chain> getCouples(boolean crossSex, SymmetryType symmetry, Gender firstGender) {
        ArrayList<Chain> result = new ArrayList<Chain>();
        int i = 0;
        while (i < 2 * this.dim()) {
            if (i > 0 && symmetry != SymmetryType.PERMUTABLE) break;
            Chain couple = this.getCouple(i);
            if (symmetry == SymmetryType.INVARIABLE) {
                result.add(couple);
            } else if (crossSex) {
                if (couple.getFirst().getGender() == firstGender) {
                    result.add(couple);
                } else {
                    result.add(couple.inverse());
                }
            } else if (couple.getFirst().getId() < couple.getLast().getId()) {
                result.add(couple);
            } else {
                result.add(couple.inverse());
            }
            ++i;
        }
        return result;
    }

    public List<Chain> getCouples() {
        ArrayList<Chain> result = new ArrayList<Chain>();
        int dim = this.dim();
        int i = 0;
        while (i < dim) {
            Chain couple = new Chain();
            Individual first = this.getPivot(2 * i);
            Individual second = this.getPivot(2 * i - 1);
            if (first.isMale()) {
                couple.add(first);
                couple.add(second);
            } else {
                couple.add(second);
                couple.add(first);
            }
            result.add(couple);
            ++i;
        }
        return result;
    }

    public int depth() {
        int result = 0;
        if (this.subchains != null) {
            for (Chain subchain : this.subchains) {
                int length = subchain.length();
                if (length <= result) continue;
                result = length;
            }
        } else {
            int length = 0;
            int i = 1;
            while (i < this.size()) {
                if (this.dir(i) > 0) {
                    length += this.dir(i);
                } else if (this.dir(i) < 0) {
                    if (i > 1 && this.dir(i - 1) > 0) {
                        length = 0;
                    }
                    length -= this.dir(i);
                } else {
                    if (length > result) {
                        result = length;
                    }
                    length = 0;
                }
                if (length > result) {
                    result = length;
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public Individual getFirst() {
        return (Individual)this.get(0);
    }

    public int getGenderInt(int i) {
        Gender gender = ((Individual)this.get(i)).getGender();
        if (gender == Gender.MALE) {
            return 0;
        }
        if (gender == Gender.FEMALE) {
            return 1;
        }
        return -1;
    }

    public int getId(int i) {
        return ((Individual)this.get(i)).getId();
    }

    @Override
    public Individual getLast() {
        return (Individual)this.get(this.size() - 1);
    }

    int getLastBranchSize() {
        int n = this.length();
        if (this.dir(n) == 0) {
            return 0;
        }
        int k = 1;
        int i = n;
        while (this.dir(i - 1) == this.dir(i)) {
            ++k;
            --i;
        }
        return k;
    }

    public Individual getLastMarried() {
        Individual result = null;
        int lastMarriageYear = -100000000;
        int i = 0;
        while (i < this.size()) {
            Integer year;
            if (this.dir(i) == 0 && (year = IndividualValuator.getMarriageYear((Individual)this.get(i), (Individual)this.get(i + 1))) != null && year > lastMarriageYear) {
                lastMarriageYear = year;
                result = (Individual)this.get(i);
            }
            ++i;
        }
        return result;
    }

    public Family getLastMarriage(Families domain) {
        Family result = null;
        int lastMarriageYear = -100000000;
        int i = 0;
        while (i < this.size() / 2 - 1) {
            Family family = domain.getBySpouses((Individual)this.get(2 * i), (Individual)this.get(2 * i + 1));
            Integer year = IndividualValuator.getMarriageYear(family);
            if (year != null && year > lastMarriageYear) {
                lastMarriageYear = year;
                result = family;
            }
            ++i;
        }
        return result;
    }

    public List<Family> getFamilyChain(Families domain, String relationType) {
        ArrayList<Family> result = new ArrayList<Family>();
        if (this.size() > 1) {
            int i = 0;
            if (relationType.equals("OPEN")) {
                i = 1;
            } else if (!relationType.equals("SPOUSE") && !relationType.equals("PARTN")) {
                i = 2;
            }
            int j = 0;
            while (j < this.size() / 2 - 1) {
                Individual ego = (Individual)this.get(i + 2 * j);
                Individual alter = (Individual)this.get(i + 2 * j + 1);
                Family family = domain.getBySpouses(ego, alter);
                result.add(family);
                ++j;
            }
        }
        return result;
    }

    public boolean hasNoFamiliesInDomain(Families domain, String relationType) {
        boolean result;
        if (relationType.equals("SPOUSE") || relationType.equals("PARTN")) {
            result = true;
            int j = 0;
            while (j < this.size() / 2) {
                Individual ego = (Individual)this.get(2 * j);
                Individual alter = (Individual)this.get(2 * j + 1);
                Family family = ego.isMale() ? domain.getBySpouses(ego, alter) : domain.getBySpouses(alter, ego);
                if (family != null) {
                    result = false;
                    break;
                }
                ++j;
            }
        } else {
            result = false;
        }
        return result;
    }

    public boolean hasFamiliesOutOfDomain(Families domain, String relationType) {
        boolean result;
        if (relationType.equals("SPOUSE") || relationType.equals("PARTN")) {
            result = false;
            int j = 0;
            while (j < this.size() / 2) {
                Individual ego = (Individual)this.get(2 * j);
                Individual alter = (Individual)this.get(2 * j + 1);
                Family family = ego.isMale() ? domain.getBySpouses(ego, alter) : domain.getBySpouses(alter, ego);
                if (family == null) {
                    result = true;
                    break;
                }
                ++j;
            }
        } else {
            result = false;
        }
        return result;
    }

    public int getLink(int i) {
        if (i == this.length()) {
            return 2;
        }
        int j = this.dir(i + 1);
        if (j == 0) {
            return 2;
        }
        if (j == -1) {
            return -1;
        }
        return ((Individual)this.get(i + 1)).getGender().toInt() % 2;
    }

    public Gender gender(int i) {
        Gender result = ((Individual)this.get(i)).getGender();
        return result;
    }

    public int getMarrPos(int pivotNr) {
        int marrNr = pivotNr / 2;
        if (pivotNr % 2 != 0) {
            marrNr = (pivotNr + 1) / 2;
        }
        int count = 0;
        int pos = 0;
        for (int dir : this.directions) {
            if (dir == 0 && ++count == marrNr) break;
            ++pos;
        }
        if (pivotNr % 2 == 0) {
            ++pos;
        }
        return pos;
    }

    public Individual getPivot(int i) {
        int n = 2 * this.dim();
        Individual result = this.subchains.get((i + n) % n).getFirst();
        return result;
    }

    boolean hasElementsInCommon(Chain c) {
        for (Individual vertex : c) {
            if (!this.contains(vertex)) continue;
            return true;
        }
        return false;
    }

    private boolean hasIntersectionIn(Cluster<Chain> c) {
        for (Chain r : c.getItems()) {
            if (!this.intersects(r)) continue;
            return true;
        }
        return false;
    }

    public boolean hasIntersectionIn(CircuitFinder rn) {
        for (Cluster<Chain> cluster : rn.getCircuits().getClusters()) {
            if (cluster.getFirstItem().length() >= this.length() || !this.hasIntersectionIn(cluster)) continue;
            return true;
        }
        return false;
    }

    private boolean intersects(Chain r) {
        int i = 0;
        while (i < 2 * r.dim()) {
            if (this.intersects(r, i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean intersects(Chain r, int i) {
        Chain s = r.transform(i);
        return this.getFirst().equals(s.getFirst()) && this.getLast().equals(s.getLast());
    }

    public boolean isHetero() {
        int i = 0;
        while (i < this.dim()) {
            if (this.getPivot(2 * i).getGender() == this.getPivot(2 * i - 1).getGender()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean sameSex() {
        Gender g2;
        Gender g1 = this.getFirst().getGender();
        if (g1 == (g2 = this.getLast().getGender())) {
            return true;
        }
        if (g1.isUnknown()) {
            this.getFirst().setGender(g2);
            return true;
        }
        if (g2.isUnknown()) {
            this.getLast().setGender(g1);
            return true;
        }
        return false;
    }

    public boolean isModel(List<Chain> models, boolean exact) {
        if (models == null) {
            return true;
        }
        for (Chain r : models) {
            if (!this.modelEquals(r, exact)) continue;
            return true;
        }
        return false;
    }

    public boolean modelEquals(Chain t, boolean exact) {
        Vector v = this.standard().getCharacteristicVector();
        Vector w = t.getCharacteristicVector();
        if (!exact) {
            w = t.standard().getCharacteristicVector();
        }
        return v.equals(w);
    }

    public boolean pivotal(int i) {
        if (i == 0 || i == this.size() - 1) {
            return true;
        }
        if (this.pivots == null) {
            return false;
        }
        for (int j : this.pivots) {
            if (j != i && j - 1 != i) continue;
            return true;
        }
        return false;
    }

    public int lastDir() {
        int result = this.size() < 2 ? 0 : this.directions.get(this.size() - 2);
        return result;
    }

    public int length() {
        return this.size() - 1;
    }

    private String letter(int i) {
        Gender gender = ((Individual)this.get(i)).getGender();
        int dir = this.dir(i);
        if (gender.isMale()) {
            if (dir == 1 && this.get(i) instanceof Couple) {
                return "X";
            }
            if (dir == 1) {
                return "F";
            }
            if (dir == -1) {
                return "S";
            }
            if (dir == 0) {
                return "H";
            }
        } else if (gender.isFemale()) {
            if (dir == 1) {
                return "M";
            }
            if (dir == -1) {
                return "D";
            }
            if (dir == 0) {
                return "W";
            }
        } else if (gender.isUnknown()) {
            if (dir == 1) {
                return "Pa";
            }
            if (dir == -1) {
                return "Ch";
            }
            if (dir == 0) {
                return "Sp";
            }
        }
        return "";
    }

    private String lit(int i, int key) {
        String s = "";
        switch (key) {
            case 0: {
                s = this.getId(i) == 0 ? ((Individual)this.get(i)).getName() : String.valueOf(this.getId(i));
                return this.surround(s, " ", i);
            }
            case 1: {
                if (!this.gender(i).isUnknown() || this.getId(i) != 0) {
                    // empty if block
                }
                return this.surround(String.valueOf(((Individual)this.get(i)).getGender().toChar()), "", i);
            }
            case 2: {
                if (i == 0) {
                    return "";
                }
                String[][] e = new String[][]{{"S", "D", ""}, {"H", "W", ""}, {"F", "M", "X"}};
                return e[this.dir(i) + 1][this.gender(i).toInt()];
            }
            case 3: {
                return String.valueOf(this.vector.getNumbers()[i]) + " ";
            }
            case 4: {
                String[] t = new String[]{" - ", " = "};
                if (i < 2 * this.dim()) {
                    s = t[i % 2];
                }
                return String.valueOf(this.getPivot(i).getName()) + s;
            }
            case 7: {
                return this.lit(i, 2);
            }
            case 8: {
                return this.lit(i, 2);
            }
            case 9: {
                String[][] p = new String[][]{{"g", "f", ""}, {"G.g", "F.f", ""}, {"G", "F", ""}};
                int k = this.dir(i) + 1;
                if (k == 1) {
                    k = 2;
                }
                if (this.quasiApical(i)) {
                    k = 1;
                }
                return p[k][this.gender(i).toInt()];
            }
        }
        return null;
    }

    public Chain neutralize(SiblingMode sib) {
        Chain result;
        block6: {
            block5: {
                if (sib != SiblingMode.NONE) break block5;
                result = this;
                break block6;
            }
            if (this.subchains == null) {
                this.getSubchains();
            }
            result = this.clone();
            int i = 0;
            while (i < this.dim()) {
                block7: {
                    Couple neutralApex;
                    Chain subchain2;
                    Chain subchain1;
                    block8: {
                        Family second;
                        subchain1 = result.subchains.get(2 * i);
                        subchain2 = result.subchains.get(2 * i + 1);
                        if (subchain1.size() < 2 || subchain2.size() < 2) break block7;
                        neutralApex = new Couple();
                        if (sib != SiblingMode.FULL) break block8;
                        Family first = ((Individual)subchain1.get(subchain1.size() - 2)).getOriginFamily();
                        if (first != (second = ((Individual)subchain2.get(subchain2.size() - 2)).getOriginFamily()) || first.getHusband() == null || first.getWife() == null) break block7;
                        neutralApex = new Couple(first.getHusband(), first.getWife());
                    }
                    result.set(result.indexOf(subchain1.getLast()), neutralApex);
                    subchain1.set(subchain1.size() - 1, neutralApex);
                    subchain2.set(subchain2.size() - 1, neutralApex);
                }
                ++i;
            }
        }
        return result;
    }

    private boolean quasiApical(int i) {
        return this.dir(i) == 0 && this.dir(i + 1) == 0 || (this.dir(i) == 1 || this.dir(i + 1) == -1) && this.dir(i) != this.dir(i + 1);
    }

    private Chain recombine() {
        int j;
        this.setOrder(this.getOrder() - 1);
        Chain r = new Chain();
        this.setPivots();
        if (this.pivots.size() == 0) {
            return r;
        }
        int i = j = this.pivots.get(0).intValue();
        while (i < this.size()) {
            r.add((Individual)this.get(i), this.directions.get(i));
            ++i;
        }
        i = 0;
        while (i < j) {
            r.add((Individual)this.get(i), this.directions.get(i));
            ++i;
        }
        return r;
    }

    public Chain reflect() {
        return this.transform(this.dim() * 2 - 1);
    }

    public ArrayList<String> report(String str) {
        ArrayList<String> rp = new ArrayList<String>();
        return rp;
    }

    public Chain rotate() {
        return this.transform(2);
    }

    private Chain rotate(int i) {
        return this.transform(2 * i);
    }

    @Override
    public void setAttribute(Attribute attribute) {
    }

    public List<Chain> getSubchains() {
        int i;
        if (this.subchains == null) {
            this.subchains = new ArrayList<Chain>();
            Chain subchain = new Chain();
            boolean up = true;
            i = 0;
            while (i < this.size()) {
                subchain.add((Individual)this.get(i));
                if (this.turn(i)) {
                    if (up) {
                        this.subchains.add(subchain.clone());
                    } else {
                        this.subchains.add(subchain.inverse());
                    }
                    up = !up;
                    subchain = new Chain();
                    if (i == 0 || this.dir(i) >= 0) {
                        subchain.add((Individual)this.get(i));
                        if (i == this.length() || this.dir(i + 1) == 0) {
                            this.subchains.add(subchain.clone());
                            if (i < this.length()) {
                                up = !up;
                                subchain = new Chain();
                            }
                        }
                    }
                }
                ++i;
            }
        }
        for (Chain subchain : this.subchains) {
            i = 0;
            while (i < subchain.length()) {
                subchain.directions.add(1);
                ++i;
            }
        }
        return this.subchains;
    }

    public void setPivots() {
        this.pivots = new ArrayList<Integer>();
        if (this.dim() == 1) {
            return;
        }
        int i = 1;
        while (i < this.size()) {
            if (this.dir(i) == 0) {
                this.pivots.add(i);
            }
            ++i;
        }
    }

    void setPivots(Chain r) {
        this.pivots = new ArrayList<Integer>();
        if (r.pivots != null) {
            this.pivots.addAll(r.pivots);
        }
        this.pivots.add(r.size());
    }

    private String sig(int i, Notation type) {
        String result = "";
        if (!(this.get(i) instanceof Couple)) {
            result = type == Notation.NUMBERS ? String.valueOf(this.getId(i)) : String.valueOf(((Individual)this.get(i)).getGender().toChar());
        } else if (type == Notation.NUMBERS) {
            result = ((Couple)this.get(i)).signature();
        }
        if (this.size() == 1 || i == 0 && this.dir(1) == -1 || i == this.size() - 1 && this.dir(this.size() - 1) == 1 || i > 0 && i < this.size() - 1 && this.dir(i) != this.dir(i + 1) && (this.dir(i) == 1 || this.dir(i + 1) == -1)) {
            result = "(" + result + ")";
        }
        return result;
    }

    public String signature() {
        return String.valueOf(this.signature(Notation.CLASSIC_GENDERED)) + "\t" + this.signature(Notation.POSITIONAL);
    }

    public String getPrologString() {
        String result = "";
        ArrayList<Character> var = new ArrayList<Character>();
        var.add(Character.valueOf(' '));
        char c = 'A';
        while (c < 'Z') {
            var.add(Character.valueOf(c));
            c = (char)(c + '\u0001');
        }
        boolean ascending = true;
        int lastId = 0;
        for (Chain subchain : this.subchains) {
            String relation = "";
            int i = 0;
            while (i < subchain.size()) {
                if (i > 0) {
                    relation = ((Individual)subchain.get(i)).isMale() ? "father" : (((Individual)subchain.get(i)).isFemale() ? "mother" : "parent");
                    relation = String.valueOf(relation) + "(" + var.get(subchain.getId(i)) + "," + var.get(subchain.getId(i - 1)) + ")";
                } else if (ascending && lastId > 0) {
                    relation = "married(" + lastId + "," + var.get(subchain.getId(0)) + ")";
                }
                if (result.length() == 0) {
                    result = relation;
                } else if (relation.length() > 0) {
                    result = String.valueOf(result) + "," + relation;
                }
                ++i;
            }
            if (!ascending) {
                lastId = subchain.getId(0);
            }
            ascending = !ascending;
        }
        return result;
    }

    public String signature(Notation type) {
        String result = "";
        switch (type) {
            case NUMBERS: {
                result = String.valueOf(this.sig(0, type)) + " ";
                int i = 1;
                while (i < this.size()) {
                    if (this.dir(i) == 0) {
                        result = String.valueOf(result) + ". ";
                    }
                    result = String.valueOf(result) + this.sig(i, type) + " ";
                    ++i;
                }
                break;
            }
            case CLASSIC: {
                int i = 1;
                while (i < this.size()) {
                    result = String.valueOf(result) + this.letter(i);
                    ++i;
                }
                result = result.replaceAll("XS", "B").replaceAll("XD", "Z").replaceAll("PaS", "B").replaceAll("PaD", "Z");
                break;
            }
            case CLASSIC_AGED: {
                int i = 1;
                while (i < this.size()) {
                    String age = "";
                    if (this.letter(i).equals("X") && i > 0 && i < this.length()) {
                        Integer secondAge;
                        Integer firstAge = Integer.parseInt(((Individual)this.get(i - 1)).getAttributeValue("POS"));
                        int comp = firstAge.compareTo(secondAge = Integer.valueOf(Integer.parseInt(((Individual)this.get(i + 1)).getAttributeValue("POS"))));
                        if (comp == 1) {
                            age = "e";
                        } else if (comp == -1) {
                            age = "y";
                        }
                    }
                    result = String.valueOf(result) + age + this.letter(i);
                    ++i;
                }
                result = result.replaceAll("XS", "B").replaceAll("XD", "Z").replaceAll("PaS", "B").replaceAll("PaD", "Z");
                break;
            }
            case CLASSIC_GENDERED: {
                result = String.valueOf(this.getFirst().getGender().toSymbol()) + this.signature(Notation.CLASSIC);
                break;
            }
            case CLASSIC_GENDERED_AGED: {
                result = String.valueOf(this.getFirst().getGender().toSymbol()) + this.signature(Notation.CLASSIC_AGED);
                break;
            }
            case POSITIONAL: {
                result = this.sig(0, type);
                int i = 1;
                while (i < this.size()) {
                    if (this.dir(i) == 0) {
                        result = String.valueOf(result) + ".";
                    }
                    result = String.valueOf(result) + this.sig(i, type);
                    ++i;
                }
                break;
            }
            case POSITIONAL_NEUTRAL: {
                result = this.signature(Notation.POSITIONAL).replaceAll("H", "X").replaceAll("F", "X");
                break;
            }
            case VECTOR: {
                result = this.getCharacteristicVector().toString();
                break;
            }
            case COUPLE: {
                result = String.valueOf(this.getFirst().getName()) + " (" + this.getFirst().getId() + ")" + " = " + this.getLast().getName() + " (" + this.getLast().getId() + ")";
                break;
            }
            case PIVOTS: {
                result = this.coupleSignature();
                break;
            }
            case CLOSING_RELATION: {
                if (this.closingRelation == null) break;
                result = this.closingRelation;
                break;
            }
            case GROUPS: {
                int i = 1;
                while (i < this.size()) {
                    if (this.get(i) instanceof Couple) {
                        result = String.valueOf(result) + ((Individual)this.get(i)).getName();
                    }
                    if (this.dir(i) == 0) {
                        result = String.valueOf(result) + " / ";
                    }
                    ++i;
                }
                break;
            }
        }
        return result;
    }

    public Chain standard() {
        Chain result = this.transform(this.standardEgoPosition());
        return result;
    }

    public Chain standard(List<Chain> models) {
        for (Chain r : models) {
            if (!this.modelEquals(r, false)) continue;
            return r;
        }
        return null;
    }

    private int standardEgoPosition() {
        int result = 0;
        if (this.getSymmetry() == SymmetryType.INVERTIBLE) {
            int i = 2 * this.dim() - 1;
            Vector standardVector = this.getCharacteristicVector();
            int comp = standardVector.genderedCompareTo(this.vector.transform(i));
            if (comp < 0) {
                result = i;
            }
        } else if (this.getSymmetry() == SymmetryType.PERMUTABLE) {
            int w = 2 * this.dim();
            Vector standardVector = this.getCharacteristicVector();
            int i = 1;
            while (i < w) {
                Vector transformedVector = this.vector.transform(i);
                int comp = standardVector.genderedCompareTo(transformedVector);
                if (comp < 0) {
                    result = i;
                    standardVector = transformedVector;
                }
                ++i;
            }
        }
        return result;
    }

    private String standardize() {
        String s = "";
        int i = 0;
        while (i < this.size()) {
            Individual v = (Individual)this.get(i);
            s = String.valueOf(s) + (Object)((Object)v.getGender());
            if ((this.dir(i) != 0 || i == this.size() - 1) && this.dir(i) != this.dir(i + 1)) {
                s = String.valueOf(s) + ".";
            }
            if (this.dir(i) == 1 && this.dir(i + 1) == 0) {
                s = String.valueOf(s) + ".";
            }
            ++i;
        }
        return s;
    }

    private String surround(String s, String t, int i) {
        if ((this.dir(i) == 1 || this.dir(i + 1) == -1) && this.dir(i) != this.dir(i + 1)) {
            s = "(" + s + ")";
        }
        if (this.dir(i) == 0 && i != 0) {
            s = "." + t + s;
        }
        return String.valueOf(s) + t;
    }

    public double sym() {
        int nrPermutations = ChainMaker.getPermutations(this).size();
        return 100.0 - MathUtils.percent(nrPermutations - 1, 2 * this.dim() - 1);
    }

    public Net toNet() {
        throw new Error("Unresolved compilation problems: \n\tr cannot be resolved\n\tThe method setCluster(int) is undefined for the type Individual\n\tThe method getCluster() is undefined for the type Individual\n\tThe method setCluster(int) is undefined for the type Individual\n\tThe field Net.individuals is not visible\n\tThe method setLink(Individual, int, boolean) is undefined for the type Individual\n\tThe method setLink(Individual, int, boolean) is undefined for the type Individual\n");
    }

    public Chain transform(int i) {
        if (i == 0) {
            return this;
        }
        Chain result = new Chain();
        result.setSymmetry(this.symmetry);
        result.subchains = new ArrayList<Chain>();
        if (i == 2 * this.dim() - 1) {
            result.directions.add(-this.dir(this.size() - 1));
            int j = this.size() - 1;
            while (j > 0) {
                result.add((Individual)this.get(j), -this.dir(j));
                --j;
            }
            result.add((Individual)this.get(0));
            j = i;
            while (j > -1) {
                result.subchains.add(this.subchains.get(j));
                --j;
            }
            return result;
        }
        int m = this.getMarrPos(i);
        if (i % 2 == 0) {
            int j = m;
            while (j < this.size()) {
                result.add((Individual)this.get(j), this.dir(j));
                ++j;
            }
            result.add((Individual)this.get(0), 0);
            j = 1;
            while (j < m) {
                result.add((Individual)this.get(j), this.dir(j));
                ++j;
            }
            j = i;
            while (j < i + 2 * this.dim()) {
                result.subchains.add(this.subchains.get(j % (2 * this.dim())));
                ++j;
            }
        } else {
            int j = m;
            while (j > -1) {
                result.add((Individual)this.get(j), -this.dir(j + 1));
                --j;
            }
            result.add((Individual)this.get(this.size() - 1), 0);
            j = this.size() - 2;
            while (j > m) {
                result.add((Individual)this.get(j), -this.dir(j + 1));
                --j;
            }
            j = i + 2 * this.dim();
            while (j > i) {
                result.subchains.add(this.subchains.get(j % (2 * this.dim())));
                --j;
            }
        }
        return result;
    }

    public void truncate(boolean reset) {
        this.removeFirst();
        if (this.pivots != null) {
            int i = 0;
            while (i < this.pivots.size()) {
                int p = this.pivots.get(i) - 1;
                this.pivots.set(i, p);
                ++i;
            }
        }
        if (reset) {
            this.size();
        }
    }

    private boolean turn(int i) {
        return i == this.length() || this.dir(i + 1) == 0 || i > 0 && this.dir(i + 1) != this.dir(i) && this.dir(i + 1) == -1 || i == 0 && this.dir(i + 1) < 0;
    }

    public Chain close() {
        Chain result;
        if (!this.sameSex() || this.size() < 3) {
            result = this;
        } else {
            if (this.dir(this.length()) != -1) {
                this.removeLast();
                result = this.recombine();
            } else if (this.dir(1) != 1) {
                this.truncate(false);
                result = this.recombine();
            }
            this.removeLast();
            this.truncate(false);
            result = this.close();
        }
        return result;
    }

    @Override
    public Object getAttributeValue(String propertyLabel) {
        return null;
    }

    public SymmetryType getSymmetry() {
        return this.symmetry;
    }

    public void setSymmetry(SymmetryType symmetry) {
        this.symmetry = symmetry;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public String hashKey() {
        return this.signature(Notation.NUMBERS);
    }
}

