/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import fr.devinsy.util.StringSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.UnionStatus;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.workers.AttributeWorker;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.util.NumberablesHashMap;
import org.tip.puck.util.ToolBox;
import org.tip.puckgui.InputSettings;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.models.IndividualChildrenModel;
import org.tip.puckgui.models.IndividualRelationsModel;
import org.tip.puckgui.models.IndividualSpousesModel;
import org.tip.puckgui.models.IndividualsCellRenderer;
import org.tip.puckgui.models.IndividualsModel;
import org.tip.puckgui.util.AutoComboBox;
import org.tip.puckgui.util.ComboBoxIds;
import org.tip.puckgui.views.AttributesPanel;
import org.tip.puckgui.views.MainWindow;

public class IndividualsPanel
extends JPanel {
    private static final long serialVersionUID = 651718283569255829L;
    private static final Logger logger = LoggerFactory.getLogger(IndividualsPanel.class);
    int reportCounter = 0;
    private StringSet attributeTemplates;
    private JPanel thisJPanel;
    private JTextField txtfldSearchIndividual;
    private NetGUI netGUI;
    private UnionStatus defaultUnionStatus = UnionStatus.MARRIED;
    private JTable tableIndividualSpouses;
    private JTable tableIndividualChildren;
    private JLabel lblIndividualId;
    private JLabel lblIndividualGender;
    JLabel lblIndividualParent1Id;
    JLabel lblIndividualParent2Id;
    JLabel lblIndividualParent1Name;
    JLabel lblIndividualParent2Name;
    JList individualList;
    JScrollPane individualsScrollPane;
    private static ImageIcon mediumFemaleIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/female-32x32.png"));
    private static ImageIcon mediumMaleIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/male-32x32.png"));
    private static ImageIcon mediumUnknowIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/unknown-32x32.png"));
    private static ImageIcon smallUnmarriedIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/unmarried-x16.png"));
    private static ImageIcon smallMarriedIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/married-x16.png"));
    private static ImageIcon smallDivorcedIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/divorced-x16.png"));
    private static ImageIcon mediumUnmarriedIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/unmarried-x23.png"));
    private static ImageIcon mediumMarriedIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/married-x23.png"));
    private static ImageIcon mediumDivorcedIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/divorced-x23.png"));
    private static ImageIcon largeFemaleIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/female-64x64.png"));
    private static ImageIcon largeMaleIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/male-64x64.png"));
    private static ImageIcon largeUnknowIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/unknown-64x64.png"));
    private static ImageIcon insertIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/insert-x16.png"));
    private static ImageIcon appendIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/append-x16.png"));
    private JLabel lblIndividualSpouses;
    private JLabel lblChildren;
    private JLabel lblFamilyId;
    private JLabel lblFamilyStatus;
    private JLabel lblPosition;
    private JTable tableIndividualRelations;
    private JLabel lblRelations;
    private JLabel lblIndividualFirstName;
    private AutoComboBox cmbbxIndividualFirstName;
    private AutoComboBox cmbbxIndividualLastName;
    private AttributesPanel attributesPanel;
    private JLabel lblIndividualLastName;
    private JLabel lblFirstLastNameSeparator;
    private AutoComboBox cmbbxIndividualParent1;
    private AutoComboBox cmbbxIndividualParent2;
    private AutoComboBox cmbbxIndividualChildrenIds;
    private AutoComboBox cmbbxIndividualSpousesIds;
    private AutoComboBox cmbbxIndividualSpousesOrders;
    private AutoComboBox cmbbxIndividualChildrenOrders;
    private JButton btnAddPartner;
    private JButton btnAddChild;
    private JTextField txtFldIndividualId;
    private boolean doLostFocus = true;
    private JToggleButton tglbtnIndividualIdStrategy;
    private JToggleButton tglbtnFamilyIdStrategy;
    private JButton btnDefaultUnionStatus;

    public IndividualsPanel(NetGUI guiManager) {
        this.thisJPanel = this;
        this.netGUI = guiManager;
        this.attributeTemplates = new StringSet();
        this.updateAttributeTemplates();
        this.setLayout(new BoxLayout(this, 1));
        JSplitPane individualsSplit = new JSplitPane();
        this.add(individualsSplit);
        individualsSplit.setAlignmentX(0.5f);
        JPanel individualsPanel = new JPanel();
        individualsPanel.setMinimumSize(new Dimension(200, 10));
        individualsSplit.setLeftComponent(individualsPanel);
        individualsPanel.setLayout(new BoxLayout(individualsPanel, 1));
        this.individualsScrollPane = new JScrollPane();
        this.individualsScrollPane.setVerticalScrollBarPolicy(22);
        individualsPanel.add(this.individualsScrollPane);
        this.individualList = new JList();
        this.individualList.setDoubleBuffered(true);
        this.individualList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                logger.debug("event = " + event.getValueIsAdjusting() + " " + event.getFirstIndex() + " " + event.getLastIndex() + " " + IndividualsPanel.this.individualList.getSelectedIndex());
                if (IndividualsPanel.this.individualList.getSelectedIndex() != -1) {
                    Individual individual = (Individual)((JList)event.getSource()).getModel().getElementAt(IndividualsPanel.this.individualList.getSelectedIndex());
                    IndividualsPanel.this.updateIndividualIdentity(individual);
                }
            }
        });
        this.individualList.setSelectionMode(0);
        this.individualList.setCellRenderer(new IndividualsCellRenderer());
        this.individualList.setModel(new IndividualsModel(null));
        this.individualsScrollPane.setViewportView(this.individualList);
        JPanel individualPanel = new JPanel();
        individualsSplit.setRightComponent(individualPanel);
        individualPanel.setAlignmentX(0.0f);
        individualPanel.setAlignmentY(0.0f);
        individualPanel.setLayout(new BoxLayout(individualPanel, 1));
        JPanel panelIndividualIdentity = new JPanel();
        individualPanel.add(panelIndividualIdentity);
        panelIndividualIdentity.setLayout(new BoxLayout(panelIndividualIdentity, 0));
        Component horizontalStrut = Box.createHorizontalStrut(20);
        panelIndividualIdentity.add(horizontalStrut);
        JPanel panel_2 = new JPanel();
        panelIndividualIdentity.add(panel_2);
        panel_2.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JPanel panel = new JPanel();
        panel_2.add((Component)panel, "2, 2");
        panel.setLayout(new BoxLayout(panel, 1));
        Component verticalStrut_9 = Box.createVerticalStrut(20);
        verticalStrut_9.setMaximumSize(new Dimension(20, 20));
        panel.add(verticalStrut_9);
        this.lblIndividualId = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.label.text_2"));
        this.lblIndividualId.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                logger.debug("Individual id clicked");
                IndividualsPanel.this.setIndividualIdEditorOn();
            }
        });
        this.lblIndividualId.setAlignmentX(1.0f);
        panel.add(this.lblIndividualId);
        this.txtFldIndividualId = new JTextField();
        this.txtFldIndividualId.setFocusTraversalKeysEnabled(false);
        this.txtFldIndividualId.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                try {
                    if (event.getKeyCode() == 27) {
                        logger.debug("escape pressed");
                        IndividualsPanel.this.txtFldIndividualId.transferFocus();
                    } else if (event.getKeyCode() == 10) {
                        logger.debug("enter pressed");
                        this.save();
                        IndividualsPanel.this.txtFldIndividualId.transferFocus();
                    } else if (event.getKeyCode() == 9) {
                        if (event.isShiftDown()) {
                            logger.debug("shift-tab pressed");
                            this.save();
                            IndividualsPanel.this.txtFldIndividualId.transferFocus();
                        } else {
                            logger.debug("tab pressed");
                            this.save();
                            IndividualsPanel.this.txtFldIndividualId.transferFocus();
                            IndividualsPanel.this.setFirstNameEditorOn();
                        }
                    }
                }
                catch (PuckException exception) {
                    IndividualsPanel.this.txtFldIndividualId.requestFocus();
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            public void save() throws PuckException {
                String input = IndividualsPanel.this.txtFldIndividualId.getText();
                logger.debug("[lbl,cmb]=[" + IndividualsPanel.this.lblIndividualId.getText() + "," + input + "]");
                if (!StringUtils.isNotBlank((CharSequence)input)) return;
                if (StringUtils.equals((CharSequence)IndividualsPanel.this.lblIndividualId.getText(), (CharSequence)input)) return;
                if (!NumberUtils.isDigits((String)(input = input.trim()))) {
                    IndividualsPanel.this.doLostFocus = false;
                    JOptionPane.showMessageDialog(IndividualsPanel.this.thisJPanel, "Numeric value required.", "Invalid id", 0);
                    IndividualsPanel.this.doLostFocus = true;
                    throw PuckExceptions.INVALID_PARAMETER.create();
                }
                int targetId = Integer.parseInt(input);
                Individual individual = (Individual)IndividualsPanel.this.netGUI.getNet().individuals().getById(targetId);
                if (individual == null) {
                    Individual currentIndividual = IndividualsPanel.this.getSelectedIndividual();
                    IndividualsPanel.this.netGUI.getNet().changeId(currentIndividual, targetId);
                    IndividualsPanel.this.netGUI.setChanged(true);
                    IndividualsPanel.this.lblIndividualId.setVisible(true);
                    IndividualsPanel.this.txtFldIndividualId.setVisible(false);
                    IndividualsPanel.this.netGUI.updateAll();
                    IndividualsPanel.this.select(currentIndividual);
                    return;
                }
                IndividualsPanel.this.doLostFocus = false;
                JOptionPane.showMessageDialog(IndividualsPanel.this.thisJPanel, "ID already in use.", "Invalid id", 0);
                IndividualsPanel.this.doLostFocus = true;
                throw PuckExceptions.INVALID_PARAMETER.create();
            }
        });
        this.txtFldIndividualId.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                logger.debug("FOCUS LOST INDIVIDUAL ID");
                if (IndividualsPanel.this.doLostFocus) {
                    IndividualsPanel.this.lblIndividualId.setVisible(true);
                    IndividualsPanel.this.txtFldIndividualId.setVisible(false);
                }
            }
        });
        panel.add(this.txtFldIndividualId);
        this.txtFldIndividualId.setColumns(10);
        Component verticalStrut_8 = Box.createVerticalStrut(10);
        verticalStrut_8.setMaximumSize(new Dimension(20, 10));
        panel.add(verticalStrut_8);
        this.lblPosition = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.lblNewLabel.text"));
        this.lblPosition.setAlignmentX(1.0f);
        panel.add(this.lblPosition);
        this.lblIndividualGender = new JLabel("");
        panel_2.add((Component)this.lblIndividualGender, "4, 2");
        this.lblIndividualGender.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                IndividualsPanel.this.lblIndividualGender.requestFocus();
                Individual currentIndividual = IndividualsPanel.this.getSelectedIndividual();
                if (currentIndividual != null) {
                    switch (currentIndividual.getGender()) {
                        case FEMALE: {
                            currentIndividual.setGender(Gender.MALE);
                            break;
                        }
                        case MALE: {
                            currentIndividual.setGender(Gender.UNKNOWN);
                            break;
                        }
                        case UNKNOWN: {
                            currentIndividual.setGender(Gender.FEMALE);
                        }
                    }
                    IndividualsPanel.this.updateIndividualIdentity(currentIndividual);
                    IndividualsPanel.this.netGUI.setChanged(true);
                }
            }
        });
        this.lblIndividualGender.setFont(new Font("Dialog", 0, 24));
        this.lblIndividualGender.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/female-64x64.png")));
        this.lblIndividualFirstName = new JLabel("X");
        this.lblIndividualFirstName.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                logger.debug("First Name clicked");
                IndividualsPanel.this.setFirstNameEditorOn();
            }
        });
        panel_2.add((Component)this.lblIndividualFirstName, "6, 2");
        this.lblIndividualFirstName.setFont(new Font("Dialog", 0, 24));
        this.cmbbxIndividualFirstName = new AutoComboBox(null);
        this.cmbbxIndividualFirstName.setVisible(false);
        this.cmbbxIndividualFirstName.setStrict(false);
        this.cmbbxIndividualFirstName.setMaximumRowCount(10);
        this.cmbbxIndividualFirstName.getEditor().getEditorComponent().setFocusTraversalKeysEnabled(false);
        this.cmbbxIndividualFirstName.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                logger.debug("FOCUS GAINED FIRST NAME");
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                logger.debug("FOCUS LOST FIRST NAME");
                IndividualsPanel.this.cmbbxIndividualFirstName.setVisible(false);
                IndividualsPanel.this.lblIndividualFirstName.setVisible(true);
                IndividualsPanel.this.cmbbxIndividualFirstName.setDataList(new ArrayList());
            }
        });
        this.cmbbxIndividualFirstName.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 27) {
                    logger.debug("escape pressed");
                    if (StringUtils.isBlank((CharSequence)IndividualsPanel.this.lblIndividualFirstName.getText())) {
                        IndividualsPanel.this.cmbbxIndividualFirstName.getEditor().setItem("?");
                        this.save();
                    }
                    IndividualsPanel.this.cmbbxIndividualFirstName.getEditor().getEditorComponent().transferFocus();
                } else if (event.getKeyCode() == 10) {
                    logger.debug("enter pressed");
                    this.save();
                    IndividualsPanel.this.cmbbxIndividualFirstName.getEditor().getEditorComponent().transferFocus();
                } else if (event.getKeyCode() == 9) {
                    if (event.isShiftDown()) {
                        logger.debug("shift-tab pressed");
                        this.save();
                        IndividualsPanel.this.cmbbxIndividualFirstName.getEditor().getEditorComponent().transferFocus();
                        IndividualsPanel.this.setIndividualIdEditorOn();
                    } else {
                        logger.debug("tab pressed");
                        this.save();
                        IndividualsPanel.this.cmbbxIndividualFirstName.getEditor().getEditorComponent().transferFocus();
                        IndividualsPanel.this.setLastNameEditorOn();
                    }
                }
            }

            public void save() {
                Individual individual;
                String input = (String)IndividualsPanel.this.cmbbxIndividualFirstName.getEditor().getItem();
                logger.debug("[lbl,cmb]=[" + IndividualsPanel.this.lblIndividualFirstName.getText() + "," + input + "]");
                if (!StringUtils.equals((CharSequence)IndividualsPanel.this.lblIndividualFirstName.getText(), (CharSequence)input) && (individual = IndividualsPanel.this.getIdentityIndividual()) != null) {
                    if (StringUtils.isBlank((CharSequence)input)) {
                        IndividualsPanel.this.lblIndividualFirstName.setText("?");
                        individual.setFirstName("?");
                    } else {
                        IndividualsPanel.this.lblIndividualFirstName.setText(input);
                        individual.setFirstName(input);
                    }
                    IndividualsPanel.this.netGUI.setChanged(true);
                    IndividualsPanel.this.netGUI.updateAll();
                }
            }
        });
        panel_2.add((Component)this.cmbbxIndividualFirstName, "7, 2");
        this.lblFirstLastNameSeparator = new JLabel("/");
        this.lblFirstLastNameSeparator.setFont(new Font("Dialog", 0, 24));
        panel_2.add((Component)this.lblFirstLastNameSeparator, "9, 2");
        this.lblIndividualLastName = new JLabel("Y");
        this.lblIndividualLastName.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                logger.debug("Last Name clicked");
                IndividualsPanel.this.setLastNameEditorOn();
            }
        });
        this.lblIndividualLastName.setFont(new Font("Dialog", 0, 24));
        panel_2.add((Component)this.lblIndividualLastName, "11, 2, right, default");
        this.cmbbxIndividualLastName = new AutoComboBox(null);
        this.cmbbxIndividualLastName.setVisible(false);
        this.cmbbxIndividualLastName.setStrict(false);
        this.cmbbxIndividualLastName.setMaximumRowCount(10);
        this.cmbbxIndividualLastName.getEditor().getEditorComponent().setFocusTraversalKeysEnabled(false);
        this.cmbbxIndividualLastName.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                logger.debug("FOCUS GAINED LAST NAME");
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                logger.debug("FOCUS LOST LAST NAME");
                IndividualsPanel.this.cmbbxIndividualLastName.setVisible(false);
                IndividualsPanel.this.lblIndividualLastName.setVisible(true);
                IndividualsPanel.this.cmbbxIndividualLastName.setDataList(new ArrayList());
            }
        });
        this.cmbbxIndividualLastName.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 27) {
                    logger.debug("escape pressed");
                    IndividualsPanel.this.cmbbxIndividualLastName.getEditor().getEditorComponent().transferFocus();
                } else if (event.getKeyCode() == 10) {
                    logger.debug("enter pressed");
                    this.save();
                    IndividualsPanel.this.cmbbxIndividualLastName.getEditor().getEditorComponent().transferFocus();
                } else if (event.getKeyCode() == 9) {
                    if (event.isShiftDown()) {
                        logger.debug("shift-tab pressed");
                        this.save();
                        IndividualsPanel.this.setFirstNameEditorOn();
                    } else {
                        logger.debug("tab pressed");
                        this.save();
                        IndividualsPanel.this.cmbbxIndividualLastName.getEditor().getEditorComponent().transferFocus();
                        IndividualsPanel.this.setParent1IdEditorOn();
                    }
                }
            }

            public void save() {
                String input = (String)IndividualsPanel.this.cmbbxIndividualLastName.getEditor().getItem();
                logger.debug("[lbl,cmb]=[" + IndividualsPanel.this.lblIndividualLastName.getText() + "," + input + "]");
                if (!StringUtils.equals((CharSequence)input, (CharSequence)IndividualsPanel.this.lblIndividualLastName.getText()) && NumberUtils.isDigits((String)IndividualsPanel.this.lblIndividualId.getText())) {
                    Individual individual = (Individual)IndividualsPanel.this.netGUI.getNet().individuals().getById(Integer.parseInt(IndividualsPanel.this.lblIndividualId.getText()));
                    individual.setLastName(input);
                    IndividualsPanel.this.netGUI.setChanged(true);
                    IndividualsPanel.this.netGUI.updateAll();
                }
            }
        });
        panel_2.add((Component)this.cmbbxIndividualLastName, "12, 2, fill, default");
        Component horizontalGlue_2 = Box.createHorizontalGlue();
        panelIndividualIdentity.add(horizontalGlue_2);
        JPanel panel_12 = new JPanel();
        panelIndividualIdentity.add(panel_12);
        panel_12.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.DEFAULT_COLSPEC, ColumnSpec.decode((String)"max(100dlu;default)")}, new RowSpec[]{FormFactory.GLUE_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.GLUE_ROWSPEC}));
        this.cmbbxIndividualParent1 = new AutoComboBox(null);
        this.cmbbxIndividualParent1.setStrict(false);
        this.cmbbxIndividualParent1.setVisible(false);
        this.cmbbxIndividualParent1.setMaximumRowCount(10);
        this.cmbbxIndividualParent1.getEditor().getEditorComponent().setFocusTraversalKeysEnabled(false);
        this.cmbbxIndividualParent1.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                logger.debug("FOCUS GAINED PARENT 1 ID");
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                logger.debug("FOCUS LOST PARENT 1 ID");
                if (IndividualsPanel.this.doLostFocus) {
                    logger.debug("unfocus parent 1 ID");
                    IndividualsPanel.this.cmbbxIndividualParent1.setVisible(false);
                    IndividualsPanel.this.lblIndividualParent1Id.setVisible(true);
                    IndividualsPanel.this.lblIndividualParent1Name.setVisible(true);
                    IndividualsPanel.this.cmbbxIndividualParent1.setDataList(new ArrayList());
                }
            }
        });
        this.cmbbxIndividualParent1.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                try {
                    if (event.getKeyCode() == 27) {
                        logger.debug("escape pressed");
                        IndividualsPanel.this.cmbbxIndividualParent1.getEditor().getEditorComponent().transferFocus();
                    } else if (event.getKeyCode() == 10) {
                        logger.debug("enter pressed");
                        this.save();
                        IndividualsPanel.this.cmbbxIndividualParent1.getEditor().getEditorComponent().transferFocus();
                    } else if (event.getKeyCode() == 9) {
                        if (event.isShiftDown()) {
                            logger.debug("shift-tab pressed");
                            this.save();
                            IndividualsPanel.this.cmbbxIndividualParent1.getEditor().getEditorComponent().transferFocus();
                            IndividualsPanel.this.setLastNameEditorOn();
                        } else {
                            logger.debug("tab pressed");
                            this.save();
                            IndividualsPanel.this.cmbbxIndividualParent1.getEditor().getEditorComponent().transferFocus();
                            IndividualsPanel.this.setParent2IdEditorOn();
                        }
                    }
                }
                catch (PuckException exception) {
                    logger.debug("SAVE FAILED");
                    IndividualsPanel.this.cmbbxIndividualParent1.getEditor().getEditorComponent().requestFocus();
                }
            }

            public void save() throws PuckException {
                String input = (String)IndividualsPanel.this.cmbbxIndividualParent1.getEditor().getItem();
                logger.debug("[lbl,cmb]=[" + IndividualsPanel.this.lblIndividualParent1Id.getText() + "," + input + "]");
                Individual currentIndividual = IndividualsPanel.this.netGUI.selectedIndividual();
                Individual newFather = ComboBoxIds.getOrCreateIndividualFromInput(IndividualsPanel.this.netGUI.getIndividualIdStrategy(), IndividualsPanel.this.netGUI.getNet(), input, Gender.MALE);
                if (newFather != currentIndividual.getFather()) {
                    Individual ego = IndividualsPanel.this.getIdentityIndividual();
                    String errorMessage = IndividualsPanel.controlPartners(InputSettings.CheckLevel.ERROR, newFather, ego.getMother(), ego);
                    if (errorMessage != null) {
                        IndividualsPanel.this.doLostFocus = false;
                        JOptionPane.showMessageDialog(IndividualsPanel.this.thisJPanel, errorMessage, "Error", 0);
                        IndividualsPanel.this.doLostFocus = true;
                        throw PuckExceptions.INVALID_PARAMETER.create();
                    }
                    NetUtils.setKinFather(IndividualsPanel.this.netGUI.getNet(), newFather, ego);
                    if (ego.getOriginFamily().numberOfParents() == 2) {
                        ego.getOriginFamily().setUnionStatus(IndividualsPanel.this.getDefaultUnionStatus());
                    }
                    IndividualsPanel.this.netGUI.updateAll();
                    IndividualsPanel.this.netGUI.selectIndividualsTab(currentIndividual);
                    String warningMessage = IndividualsPanel.controlPartners(InputSettings.CheckLevel.WARNING, newFather, ego.getMother(), ego);
                    if (warningMessage != null) {
                        JOptionPane.showMessageDialog(IndividualsPanel.this.thisJPanel, warningMessage, "Warning", 2);
                    }
                }
            }
        });
        panel_12.add((Component)this.cmbbxIndividualParent1, "5, 2, 2, 1, fill, default");
        this.cmbbxIndividualParent2 = new AutoComboBox(null);
        this.cmbbxIndividualParent2.setStrict(false);
        this.cmbbxIndividualParent2.setVisible(false);
        this.cmbbxIndividualParent2.setMaximumRowCount(10);
        this.cmbbxIndividualParent2.getEditor().getEditorComponent().setFocusTraversalKeysEnabled(false);
        this.cmbbxIndividualParent2.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                logger.debug("FOCUS GAINED PARENT 2 ID");
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                logger.debug("FOCUS LOST PARENT 2 ID");
                if (IndividualsPanel.this.doLostFocus) {
                    IndividualsPanel.this.cmbbxIndividualParent2.setVisible(false);
                    IndividualsPanel.this.lblIndividualParent2Id.setVisible(true);
                    IndividualsPanel.this.lblIndividualParent2Name.setVisible(true);
                    IndividualsPanel.this.cmbbxIndividualParent2.setDataList(new ArrayList());
                }
            }
        });
        this.cmbbxIndividualParent2.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                try {
                    if (event.getKeyCode() == 27) {
                        logger.debug("escape pressed");
                        IndividualsPanel.this.cmbbxIndividualParent2.getEditor().getEditorComponent().transferFocus();
                    } else if (event.getKeyCode() == 10) {
                        logger.debug("enter pressed");
                        this.save();
                        IndividualsPanel.this.cmbbxIndividualParent2.getEditor().getEditorComponent().transferFocus();
                    } else if (event.getKeyCode() == 9) {
                        if (event.isShiftDown()) {
                            logger.debug("shift-tab pressed");
                            this.save();
                            IndividualsPanel.this.cmbbxIndividualParent2.getEditor().getEditorComponent().transferFocus();
                            IndividualsPanel.this.setParent1IdEditorOn();
                        } else {
                            logger.debug("tab pressed");
                            this.save();
                            IndividualsPanel.this.cmbbxIndividualParent2.getEditor().getEditorComponent().transferFocus();
                        }
                    }
                }
                catch (PuckException exception) {
                    logger.debug("SAVE FAILED");
                    IndividualsPanel.this.cmbbxIndividualParent2.getEditor().getEditorComponent().requestFocus();
                }
            }

            public void save() throws PuckException {
                String input = (String)IndividualsPanel.this.cmbbxIndividualParent2.getEditor().getItem();
                logger.debug("[lbl,cmb]=[" + IndividualsPanel.this.lblIndividualParent2Id.getText() + "," + input + "]");
                Individual currentIndividual = IndividualsPanel.this.netGUI.selectedIndividual();
                Individual newMother = ComboBoxIds.getOrCreateIndividualFromInput(IndividualsPanel.this.netGUI.getIndividualIdStrategy(), IndividualsPanel.this.netGUI.getNet(), input, Gender.FEMALE);
                if (newMother != currentIndividual.getMother()) {
                    Individual ego = IndividualsPanel.this.getIdentityIndividual();
                    String errorMessage = IndividualsPanel.controlPartners(InputSettings.CheckLevel.ERROR, ego.getFather(), newMother, ego);
                    if (errorMessage != null) {
                        IndividualsPanel.this.doLostFocus = false;
                        JOptionPane.showMessageDialog(IndividualsPanel.this.thisJPanel, errorMessage, "Error", 0);
                        IndividualsPanel.this.doLostFocus = true;
                        throw PuckExceptions.INVALID_PARAMETER.create();
                    }
                    NetUtils.setKinMother(IndividualsPanel.this.netGUI.getNet(), newMother, IndividualsPanel.this.getIdentityIndividual());
                    if (ego.getOriginFamily().numberOfParents() == 2) {
                        ego.getOriginFamily().setUnionStatus(IndividualsPanel.this.getDefaultUnionStatus());
                    }
                    IndividualsPanel.this.netGUI.updateAll();
                    IndividualsPanel.this.netGUI.selectIndividualsTab(currentIndividual);
                    String warningMessage = IndividualsPanel.controlPartners(InputSettings.CheckLevel.WARNING, ego.getFather(), newMother, ego);
                    if (warningMessage != null) {
                        JOptionPane.showMessageDialog(IndividualsPanel.this.thisJPanel, warningMessage, "Warning", 2);
                    }
                }
            }
        });
        this.lblFamilyId = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.lblFamilyid.text"));
        this.lblFamilyId.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Individual selected;
                int selectedIndex;
                if (event.getClickCount() == 2 && (selectedIndex = IndividualsPanel.this.individualList.getSelectedIndex()) != -1 && (selected = (Individual)((IndividualsModel)IndividualsPanel.this.individualList.getModel()).getElementAt(selectedIndex)) != null && selected.getOriginFamily() != null) {
                    IndividualsPanel.this.netGUI.selectFamiliesTab(selected.getOriginFamily());
                }
            }
        });
        panel_12.add((Component)this.lblFamilyId, "2, 2, 1, 4");
        this.lblFamilyStatus = new JLabel("");
        panel_12.add((Component)this.lblFamilyStatus, "4, 2, 1, 4");
        this.lblFamilyStatus.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Individual selected;
                int selectedIndex;
                if (event.getClickCount() == 2 && (selectedIndex = IndividualsPanel.this.individualList.getSelectedIndex()) != -1 && (selected = (Individual)((IndividualsModel)IndividualsPanel.this.individualList.getModel()).getElementAt(selectedIndex)) != null && selected.getOriginFamily() != null) {
                    IndividualsPanel.this.netGUI.selectFamiliesTab(selected.getOriginFamily());
                }
            }
        });
        this.lblFamilyStatus.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/unmarried-x23.png")));
        JPopupMenu popupMenu_4 = new JPopupMenu();
        IndividualsPanel.addPopup(this.lblFamilyStatus, popupMenu_4);
        JMenuItem mntmCreate = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.mntmCreate.text"));
        mntmCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndividualsPanel.this.addOriginFamily();
            }
        });
        mntmCreate.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        popupMenu_4.add(mntmCreate);
        this.lblIndividualParent1Id = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblIndividualParent1Id.text"));
        panel_12.add((Component)this.lblIndividualParent1Id, "5, 3");
        this.lblIndividualParent1Id.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                logger.debug("Parent 1 id clicked");
                IndividualsPanel.this.setParent1IdEditorOn();
            }
        });
        this.lblIndividualParent1Id.setHorizontalAlignment(4);
        this.lblIndividualParent1Id.setAlignmentX(1.0f);
        this.lblIndividualParent1Name = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblFather.text"));
        panel_12.add((Component)this.lblIndividualParent1Name, "6, 3");
        this.lblIndividualParent1Name.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                try {
                    Individual selected;
                    if (event.getClickCount() == 2 && (selected = IndividualsPanel.this.getIdentityIndividual()) != null && selected.getFather() != null) {
                        IndividualsPanel.this.netGUI.changeSegmentationToCluster(selected.getFather());
                    }
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.lblIndividualParent1Name.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/male-32x32.png")));
        JPopupMenu popupMenu_2 = new JPopupMenu();
        IndividualsPanel.addPopup(this.lblIndividualParent1Name, popupMenu_2);
        JMenuItem mntmSwapParent = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.mntmSwapParent.text"));
        mntmSwapParent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Individual currentIndividual = IndividualsPanel.this.netGUI.selectedIndividual();
                if (currentIndividual != null && currentIndividual.isNotOrphan()) {
                    NetUtils.swapParents(currentIndividual.getOriginFamily());
                    IndividualsPanel.this.netGUI.setChanged(true);
                    IndividualsPanel.this.netGUI.updateAll();
                    IndividualsPanel.this.netGUI.selectIndividualsTab(currentIndividual);
                }
            }
        });
        JMenuItem mntmDelete_2 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.mntmDelete_2.text"));
        mntmDelete_2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Family family;
                Individual ego = IndividualsPanel.this.getIdentityIndividual();
                if (ego != null && (family = ego.getOriginFamily()) != null && family.getFather() != null) {
                    NetUtils.removeFather(family);
                    try {
                        IndividualsPanel.this.netGUI.getSegmentation().refresh();
                    }
                    catch (PuckException exception) {
                        exception.printStackTrace();
                    }
                    IndividualsPanel.this.netGUI.updateAll();
                    IndividualsPanel.this.netGUI.setChanged(true);
                }
            }
        });
        popupMenu_2.add(mntmDelete_2);
        popupMenu_2.add(mntmSwapParent);
        this.lblIndividualParent2Id = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblIndividualParent2Id.text"));
        this.lblIndividualParent2Id.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                logger.debug("Parent 2 id clicked");
                IndividualsPanel.this.setParent2IdEditorOn();
            }
        });
        panel_12.add((Component)this.lblIndividualParent2Id, "5, 4");
        this.lblIndividualParent2Id.setHorizontalAlignment(4);
        this.lblIndividualParent2Id.setAlignmentX(1.0f);
        this.lblIndividualParent2Name = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblMother.text"));
        panel_12.add((Component)this.lblIndividualParent2Name, "6, 4");
        this.lblIndividualParent2Name.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                try {
                    Individual selected = IndividualsPanel.this.getIdentityIndividual();
                    if (selected != null && selected.getMother() != null) {
                        IndividualsPanel.this.netGUI.changeSegmentationToCluster(selected.getMother());
                    }
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.lblIndividualParent2Name.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/female-32x32.png")));
        JPopupMenu popupMenu_3 = new JPopupMenu();
        IndividualsPanel.addPopup(this.lblIndividualParent2Name, popupMenu_3);
        JMenuItem mntmDelete_3 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.mntmDelete_3.text"));
        mntmDelete_3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Family family;
                Individual ego = IndividualsPanel.this.getIdentityIndividual();
                if (ego != null && (family = ego.getOriginFamily()) != null && family.getMother() != null) {
                    NetUtils.removeMother(family);
                    try {
                        IndividualsPanel.this.netGUI.getSegmentation().refresh();
                    }
                    catch (PuckException exception) {
                        exception.printStackTrace();
                    }
                    IndividualsPanel.this.netGUI.updateAll();
                    IndividualsPanel.this.netGUI.setChanged(true);
                }
            }
        });
        popupMenu_3.add(mntmDelete_3);
        panel_12.add((Component)this.cmbbxIndividualParent2, "5, 5, 2, 1, fill, default");
        JPanel panel_9 = new JPanel();
        panelIndividualIdentity.add(panel_9);
        panel_9.setLayout(new BoxLayout(panel_9, 1));
        JPanel panel_10 = new JPanel();
        panel_9.add(panel_10);
        panel_10.setLayout(new BoxLayout(panel_10, 0));
        JPanel panel_11 = new JPanel();
        panel_9.add(panel_11);
        panel_11.setLayout(new BoxLayout(panel_11, 0));
        JPanel panel_3 = new JPanel();
        panelIndividualIdentity.add(panel_3);
        panel_3.setLayout(new BoxLayout(panel_3, 1));
        Component verticalStrut_7 = Box.createVerticalStrut(10);
        verticalStrut_7.setMaximumSize(new Dimension(30, 16));
        panel_3.add(verticalStrut_7);
        JPanel panel_4 = new JPanel();
        panelIndividualIdentity.add(panel_4);
        panel_4.setLayout(new BoxLayout(panel_4, 1));
        Component horizontalStrut_1 = Box.createHorizontalStrut(20);
        panelIndividualIdentity.add(horizontalStrut_1);
        Component verticalStrut = Box.createVerticalStrut(10);
        individualPanel.add(verticalStrut);
        JPanel panel_6 = new JPanel();
        individualPanel.add(panel_6);
        panel_6.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane_1 = new JSplitPane();
        panel_6.add((Component)splitPane_1, "Center");
        splitPane_1.setOrientation(0);
        JSplitPane splitPane_2 = new JSplitPane();
        splitPane_2.setOrientation(0);
        splitPane_1.setRightComponent(splitPane_2);
        JPanel panelIndividualChildren = new JPanel();
        panelIndividualChildren.setPreferredSize(new Dimension(10, 150));
        panelIndividualChildren.setBorder(new EmptyBorder(0, 0, 0, 10));
        panelIndividualChildren.setMinimumSize(new Dimension(10, 100));
        splitPane_2.setLeftComponent(panelIndividualChildren);
        panelIndividualChildren.setLayout(new BoxLayout(panelIndividualChildren, 1));
        Component verticalStrut_1 = Box.createVerticalStrut(5);
        panelIndividualChildren.add(verticalStrut_1);
        JPanel panel_7 = new JPanel();
        panel_7.setAlignmentX(0.0f);
        panelIndividualChildren.add(panel_7);
        panel_7.setLayout(new BoxLayout(panel_7, 0));
        this.lblChildren = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblChildren.text"));
        panel_7.add(this.lblChildren);
        Component horizontalStrut_4 = Box.createHorizontalStrut(20);
        panel_7.add(horizontalStrut_4);
        this.btnAddChild = new JButton(" + ");
        this.btnAddChild.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logger.debug("Add Child");
                IndividualsPanel.this.addChild();
            }
        });
        this.btnAddChild.setBorder(new EmptyBorder(0, 0, 0, 0));
        panel_7.add(this.btnAddChild);
        Component horizontalStrut_5 = Box.createHorizontalStrut(5);
        panel_7.add(horizontalStrut_5);
        JLabel lblCtrlk = new JLabel("(Ctrl-K)");
        panel_7.add(lblCtrlk);
        JScrollPane scrollPane_2 = new JScrollPane();
        scrollPane_2.setAlignmentX(0.0f);
        scrollPane_2.setBackground(new Color(255, 255, 255));
        scrollPane_2.setPreferredSize(new Dimension(3, 200));
        panelIndividualChildren.add(scrollPane_2);
        this.tableIndividualChildren = new JTable();
        this.tableIndividualChildren.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                block9: {
                    try {
                        int selectedIndex;
                        if (event.getClickCount() != 2 || (selectedIndex = IndividualsPanel.this.tableIndividualChildren.getSelectedRow()) == -1) break block9;
                        switch (IndividualsPanel.this.tableIndividualChildren.getSelectedColumn()) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                Individual selected = ((IndividualChildrenModel)IndividualsPanel.this.tableIndividualChildren.getModel()).children().get(selectedIndex);
                                if (selected != null) {
                                    IndividualsPanel.this.netGUI.changeSegmentationToCluster(selected);
                                }
                                break;
                            }
                            case 5: {
                                Individual selected = ((IndividualChildrenModel)IndividualsPanel.this.tableIndividualChildren.getModel()).children().get(selectedIndex);
                                if (selected == null || selected.getOtherParent(IndividualsPanel.this.getIdentityIndividual()) == null) break;
                                IndividualsPanel.this.netGUI.changeSegmentationToCluster(selected.getOtherParent(IndividualsPanel.this.getIdentityIndividual()));
                            }
                            default: {
                                break;
                            }
                        }
                    }
                    catch (PuckException exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        JPopupMenu popupMenu_1 = new JPopupMenu();
        IndividualsPanel.addPopup(this.tableIndividualChildren, popupMenu_1);
        JMenuItem mntmDelete_1 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.mntmDelete_1.text"));
        mntmDelete_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logger.debug("Delete " + ArrayUtils.toString((Object)IndividualsPanel.this.tableIndividualChildren.getSelectedRows()));
                int[] selectedRowIds = IndividualsPanel.this.tableIndividualChildren.getSelectedRows();
                if (selectedRowIds.length != 0) {
                    ArrayUtils.reverse((int[])selectedRowIds);
                    int[] nArray = selectedRowIds;
                    int n = selectedRowIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int rowIndex = nArray[n2];
                        int childId = (Integer)IndividualsPanel.this.tableIndividualChildren.getModel().getValueAt(rowIndex, 0);
                        IndividualsPanel.this.netGUI.getNet().removeChild((Individual)IndividualsPanel.this.netGUI.getNet().individuals().getById(childId));
                        ++n2;
                    }
                    IndividualsPanel.this.netGUI.setChanged(true);
                    IndividualsPanel.this.netGUI.updateAll();
                }
            }
        });
        popupMenu_1.add(mntmDelete_1);
        scrollPane_2.setViewportView(this.tableIndividualChildren);
        this.tableIndividualChildren.setBorder(new LineBorder(new Color(169, 169, 169)));
        this.tableIndividualChildren.setSelectionMode(2);
        this.tableIndividualChildren.setModel(new IndividualChildrenModel(this.netGUI, null));
        this.cmbbxIndividualChildrenIds = new AutoComboBox(null);
        this.cmbbxIndividualChildrenIds.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                logger.debug("FOCUS LOST CHILDREN TABLE " + IndividualsPanel.this.tableIndividualChildren.isEditing());
                if (IndividualsPanel.this.tableIndividualChildren.isEditing()) {
                    IndividualsPanel.this.tableIndividualChildren.getColumnModel().getColumn(0).getCellEditor().cancelCellEditing();
                }
                if (((IndividualChildrenModel)IndividualsPanel.this.tableIndividualChildren.getModel()).isNewEditionOn()) {
                    ((IndividualChildrenModel)IndividualsPanel.this.tableIndividualChildren.getModel()).escapeNewEdition();
                }
            }
        });
        this.cmbbxIndividualChildrenIds.setEditable(true);
        this.cmbbxIndividualChildrenIds.setStrict(false);
        this.cmbbxIndividualChildrenIds.setMaximumRowCount(10);
        DefaultCellEditor editor = new DefaultCellEditor(this.cmbbxIndividualChildrenIds);
        this.tableIndividualChildren.getColumnModel().getColumn(0).setCellEditor(editor);
        this.tableIndividualChildren.getColumnModel().getColumn(0).setMinWidth(10);
        this.tableIndividualChildren.getColumnModel().getColumn(0).setPreferredWidth(90);
        this.tableIndividualChildren.getColumnModel().getColumn(0).setMaxWidth(110);
        this.tableIndividualChildren.getColumnModel().getColumn(1).setMinWidth(10);
        this.tableIndividualChildren.getColumnModel().getColumn(1).setMaxWidth(30);
        this.tableIndividualChildren.getColumnModel().getColumn(1).setResizable(false);
        ArrayList<Integer> childrenOrderList = new ArrayList<Integer>(99);
        int order = 1;
        while (order < 100) {
            childrenOrderList.add(order);
            ++order;
        }
        this.cmbbxIndividualChildrenOrders = new AutoComboBox(childrenOrderList);
        this.cmbbxIndividualChildrenOrders.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                logger.debug("FOCUS LOST CHILDREN TABLE(2) " + IndividualsPanel.this.tableIndividualChildren.isEditing());
                if (IndividualsPanel.this.tableIndividualChildren.isEditing()) {
                    IndividualsPanel.this.tableIndividualChildren.getColumnModel().getColumn(3).getCellEditor().cancelCellEditing();
                }
                if (((IndividualChildrenModel)IndividualsPanel.this.tableIndividualChildren.getModel()).isNewEditionOn()) {
                    ((IndividualChildrenModel)IndividualsPanel.this.tableIndividualChildren.getModel()).escapeNewEdition();
                }
            }
        });
        this.cmbbxIndividualChildrenOrders.setEditable(true);
        this.cmbbxIndividualChildrenOrders.setStrict(false);
        this.cmbbxIndividualChildrenOrders.setMaximumRowCount(10);
        DefaultCellEditor orderEditor = new DefaultCellEditor(this.cmbbxIndividualChildrenOrders);
        this.tableIndividualChildren.getColumnModel().getColumn(3).setCellEditor(orderEditor);
        this.tableIndividualChildren.getColumnModel().getColumn(3).setPreferredWidth(50);
        this.tableIndividualChildren.getColumnModel().getColumn(3).setMaxWidth(50);
        this.tableIndividualChildren.getColumnModel().getColumn(3).setResizable(false);
        this.tableIndividualChildren.getColumnModel().getColumn(4).setPreferredWidth(100);
        this.tableIndividualChildren.getColumnModel().getColumn(4).setMaxWidth(125);
        this.tableIndividualChildren.getColumnModel().getColumn(4).setResizable(false);
        Component verticalStrut_3 = Box.createVerticalStrut(10);
        panelIndividualChildren.add(verticalStrut_3);
        JSplitPane splitPane_3 = new JSplitPane();
        splitPane_3.setOrientation(0);
        splitPane_2.setRightComponent(splitPane_3);
        JPanel panel_1 = new JPanel();
        splitPane_3.setRightComponent(panel_1);
        panel_1.setLayout(new BoxLayout(panel_1, 1));
        Component verticalStrut_10 = Box.createVerticalStrut(5);
        panel_1.add(verticalStrut_10);
        JPanel panel_8 = new JPanel();
        panel_8.setAlignmentX(0.0f);
        panel_1.add(panel_8);
        panel_8.setLayout(new BoxLayout(panel_8, 0));
        this.lblRelations = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.lblRelations.text"));
        panel_8.add(this.lblRelations);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(3, 100));
        scrollPane.setAlignmentX(0.0f);
        panel_1.add(scrollPane);
        this.tableIndividualRelations = new JTable();
        this.tableIndividualRelations.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    int selectedIndex = IndividualsPanel.this.tableIndividualRelations.getSelectedRow();
                    Relation relation = ((IndividualRelationsModel)IndividualsPanel.this.tableIndividualRelations.getModel()).getDelegate().get(selectedIndex);
                    IndividualsPanel.this.netGUI.selectRelationTab(relation);
                }
            }
        });
        this.tableIndividualRelations.setModel(new IndividualRelationsModel(null));
        scrollPane.setViewportView(this.tableIndividualRelations);
        this.attributesPanel = new AttributesPanel(this.netGUI, null, this.attributeTemplates);
        splitPane_3.setLeftComponent(this.attributesPanel);
        this.tableIndividualRelations.getColumnModel().getColumn(0).setMinWidth(10);
        this.tableIndividualRelations.getColumnModel().getColumn(0).setPreferredWidth(90);
        this.tableIndividualRelations.getColumnModel().getColumn(0).setMaxWidth(110);
        JPanel panelIndividualSpouses = new JPanel();
        panelIndividualSpouses.setPreferredSize(new Dimension(10, 150));
        panelIndividualSpouses.setMinimumSize(new Dimension(10, 100));
        panelIndividualSpouses.setBorder(new EmptyBorder(0, 0, 0, 10));
        panelIndividualSpouses.setAlignmentY(0.0f);
        panelIndividualSpouses.setAlignmentX(0.0f);
        splitPane_1.setLeftComponent(panelIndividualSpouses);
        panelIndividualSpouses.setLayout(new BoxLayout(panelIndividualSpouses, 1));
        Component verticalStrut_6 = Box.createVerticalStrut(5);
        panelIndividualSpouses.add(verticalStrut_6);
        JPanel panel_5 = new JPanel();
        panel_5.setAlignmentX(0.0f);
        panelIndividualSpouses.add(panel_5);
        panel_5.setLayout(new BoxLayout(panel_5, 0));
        this.lblIndividualSpouses = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblSpouses.text"));
        panel_5.add(this.lblIndividualSpouses);
        Component horizontalStrut_3 = Box.createHorizontalStrut(20);
        panel_5.add(horizontalStrut_3);
        this.btnAddPartner = new JButton(" + ");
        this.btnAddPartner.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logger.debug("Add partner");
                IndividualsPanel.this.addPartner();
            }
        });
        this.btnAddPartner.setBorder(new EmptyBorder(0, 0, 0, 0));
        panel_5.add(this.btnAddPartner);
        Component horizontalStrut_2 = Box.createHorizontalStrut(5);
        panel_5.add(horizontalStrut_2);
        JLabel lblCtrlp = new JLabel("(Ctrl-P)");
        panel_5.add(lblCtrlp);
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setPreferredSize(new Dimension(3, 200));
        scrollPane_1.setBackground(new Color(255, 255, 255));
        scrollPane_1.setAlignmentX(0.0f);
        panelIndividualSpouses.add(scrollPane_1);
        this.tableIndividualSpouses = new JTable();
        this.tableIndividualSpouses.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                try {
                    if (event.getClickCount() == 1) {
                        logger.debug("one click");
                    } else if (event.getClickCount() == 2) {
                        int selectedIndex = IndividualsPanel.this.tableIndividualSpouses.getSelectedRow();
                        int selectedColumn = IndividualsPanel.this.tableIndividualSpouses.getSelectedColumn();
                        logger.debug("[index, col]=[" + selectedIndex + "," + selectedColumn + "]");
                        if (selectedIndex != -1 && selectedColumn != -1) {
                            Family targetFamily;
                            if (selectedColumn > 0 && selectedColumn < 3) {
                                Individual selected = ((IndividualSpousesModel)IndividualsPanel.this.tableIndividualSpouses.getModel()).spouses().get(selectedIndex);
                                if (selected != null) {
                                    IndividualsPanel.this.netGUI.changeSegmentationToCluster(selected);
                                }
                            } else if (selectedColumn >= 3 && (targetFamily = ((IndividualSpousesModel)IndividualsPanel.this.tableIndividualSpouses.getModel()).getFamily(selectedIndex)) != null) {
                                IndividualsPanel.this.netGUI.selectFamiliesTab(targetFamily);
                            }
                        }
                    }
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        JPopupMenu popupMenu = new JPopupMenu();
        IndividualsPanel.addPopup(this.tableIndividualSpouses, popupMenu);
        JMenuItem mntmDelete = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.mntmDelete.text"));
        mntmDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logger.debug("Delete " + ArrayUtils.toString((Object)IndividualsPanel.this.tableIndividualSpouses.getSelectedRows()));
                int[] selectedRowIds = IndividualsPanel.this.tableIndividualSpouses.getSelectedRows();
                if (selectedRowIds.length != 0) {
                    ArrayUtils.reverse((int[])selectedRowIds);
                    int[] nArray = selectedRowIds;
                    int n = selectedRowIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int rowIndex = nArray[n2];
                        Family family = ((IndividualSpousesModel)IndividualsPanel.this.tableIndividualSpouses.getModel()).getFamily(rowIndex);
                        if (family.isSingleParent()) {
                            NetUtils.removeSpouse(family, IndividualsPanel.this.getSelectedIndividual());
                            if (family.isEmpty()) {
                                IndividualsPanel.this.netGUI.getNet().remove(family);
                            }
                        } else {
                            Individual spouse = ((IndividualSpousesModel)IndividualsPanel.this.tableIndividualSpouses.getModel()).getSpouse(rowIndex);
                            NetUtils.removeSpouse(family, spouse);
                            if (family.isEmpty()) {
                                IndividualsPanel.this.netGUI.getNet().remove(family);
                            }
                        }
                        ++n2;
                    }
                    IndividualsPanel.this.netGUI.setChanged(true);
                    IndividualsPanel.this.netGUI.updateAll();
                }
            }
        });
        popupMenu.add(mntmDelete);
        scrollPane_1.setViewportView(this.tableIndividualSpouses);
        this.tableIndividualSpouses.setBorder(new LineBorder(new Color(169, 169, 169)));
        this.tableIndividualSpouses.setSelectionMode(0);
        this.tableIndividualSpouses.setModel(new IndividualSpousesModel(this.netGUI, null));
        this.tableIndividualSpouses.getTableHeader().setReorderingAllowed(false);
        this.cmbbxIndividualSpousesIds = new AutoComboBox(null);
        this.cmbbxIndividualSpousesIds.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                logger.debug("FOCUS LOST SPOUSES TABLE " + IndividualsPanel.this.tableIndividualSpouses.isEditing());
                if (IndividualsPanel.this.tableIndividualSpouses.isEditing()) {
                    IndividualsPanel.this.tableIndividualSpouses.getColumnModel().getColumn(0).getCellEditor().cancelCellEditing();
                }
                if (((IndividualSpousesModel)IndividualsPanel.this.tableIndividualSpouses.getModel()).isNewEditionOn()) {
                    ((IndividualSpousesModel)IndividualsPanel.this.tableIndividualSpouses.getModel()).escapeNewEdition();
                }
            }
        });
        this.cmbbxIndividualSpousesIds.setEditable(true);
        this.cmbbxIndividualSpousesIds.setStrict(false);
        this.cmbbxIndividualSpousesIds.setMaximumRowCount(10);
        DefaultCellEditor editor2 = new DefaultCellEditor(this.cmbbxIndividualSpousesIds);
        this.tableIndividualSpouses.getColumnModel().getColumn(0).setCellEditor(editor2);
        this.tableIndividualSpouses.getColumnModel().getColumn(0).setMinWidth(10);
        this.tableIndividualSpouses.getColumnModel().getColumn(0).setPreferredWidth(90);
        this.tableIndividualSpouses.getColumnModel().getColumn(0).setMaxWidth(110);
        this.tableIndividualSpouses.getColumnModel().getColumn(1).setMinWidth(10);
        this.tableIndividualSpouses.getColumnModel().getColumn(1).setMaxWidth(30);
        this.tableIndividualSpouses.getColumnModel().getColumn(1).setResizable(false);
        ArrayList<Integer> spousesOrderList = new ArrayList<Integer>(99);
        int order2 = 1;
        while (order2 < 100) {
            spousesOrderList.add(order2);
            ++order2;
        }
        this.cmbbxIndividualSpousesOrders = new AutoComboBox(spousesOrderList);
        this.cmbbxIndividualSpousesOrders.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                logger.debug("FOCUS LOST CHILDREN TABLE(2) " + IndividualsPanel.this.tableIndividualSpouses.isEditing());
                if (IndividualsPanel.this.tableIndividualSpouses.isEditing()) {
                    IndividualsPanel.this.tableIndividualSpouses.getColumnModel().getColumn(3).getCellEditor().cancelCellEditing();
                }
                if (((IndividualSpousesModel)IndividualsPanel.this.tableIndividualSpouses.getModel()).isNewEditionOn()) {
                    ((IndividualSpousesModel)IndividualsPanel.this.tableIndividualSpouses.getModel()).escapeNewEdition();
                }
            }
        });
        this.cmbbxIndividualSpousesOrders.setEditable(true);
        this.cmbbxIndividualSpousesOrders.setStrict(false);
        this.cmbbxIndividualSpousesOrders.setMaximumRowCount(10);
        DefaultCellEditor spousesOrderEditor = new DefaultCellEditor(this.cmbbxIndividualSpousesOrders);
        this.tableIndividualSpouses.getColumnModel().getColumn(3).setCellEditor(spousesOrderEditor);
        this.tableIndividualSpouses.getColumnModel().getColumn(3).setMinWidth(10);
        this.tableIndividualSpouses.getColumnModel().getColumn(3).setPreferredWidth(50);
        this.tableIndividualSpouses.getColumnModel().getColumn(3).setMaxWidth(50);
        this.tableIndividualSpouses.getColumnModel().getColumn(4).setMinWidth(10);
        this.tableIndividualSpouses.getColumnModel().getColumn(4).setMaxWidth(30);
        this.tableIndividualSpouses.getColumnModel().getColumn(4).setResizable(false);
        this.tableIndividualSpouses.getColumnModel().getColumn(5).setMinWidth(10);
        this.tableIndividualSpouses.getColumnModel().getColumn(5).setPreferredWidth(90);
        this.tableIndividualSpouses.getColumnModel().getColumn(5).setMaxWidth(110);
        Component verticalStrut_2 = Box.createVerticalStrut(10);
        panelIndividualSpouses.add(verticalStrut_2);
        this.tableIndividualChildren.getColumnModel().getColumn(3).setPreferredWidth(100);
        JPanel individualsButtonsPanel = new JPanel();
        this.add(individualsButtonsPanel);
        individualsButtonsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        individualsButtonsPanel.setLayout(new BoxLayout(individualsButtonsPanel, 0));
        JButton btnAddIndividual = new JButton("");
        btnAddIndividual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IndividualsPanel.this.addIndividual();
            }
        });
        btnAddIndividual.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnNewButton_1.toolTipText"));
        btnAddIndividual.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/add.png")));
        individualsButtonsPanel.add(btnAddIndividual);
        JButton btnRemoveIndividual = new JButton("");
        btnRemoveIndividual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Individual target = IndividualsPanel.this.getSelectedIndividual();
                if (target != null) {
                    int selectedIndex = IndividualsPanel.this.individualList.getSelectedIndex();
                    IndividualsPanel.this.netGUI.getNet().remove(target);
                    ((IndividualsModel)IndividualsPanel.this.individualList.getModel()).setSource(IndividualsPanel.this.netGUI.getNet().individuals());
                    if (IndividualsPanel.this.netGUI.getNet().individuals().size() != 0) {
                        if (selectedIndex == IndividualsPanel.this.netGUI.getNet().individuals().size()) {
                            --selectedIndex;
                        }
                        IndividualsPanel.this.individualList.setSelectedIndex(selectedIndex);
                    }
                    IndividualsPanel.this.netGUI.updateAll();
                    IndividualsPanel.this.netGUI.setChanged(true);
                }
            }
        });
        btnRemoveIndividual.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnNewButton.toolTipText"));
        btnRemoveIndividual.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/remove.png")));
        individualsButtonsPanel.add(btnRemoveIndividual);
        JButton btnIndividualsPrevious = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnPrevious.text"));
        btnIndividualsPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selectedIndex = IndividualsPanel.this.individualList.getSelectedIndex();
                if (selectedIndex == -1) {
                    int size = IndividualsPanel.this.individualList.getModel().getSize();
                    if (size != 0) {
                        selectedIndex = size - 1;
                        IndividualsPanel.this.individualList.setSelectedIndex(selectedIndex);
                        IndividualsPanel.this.individualList.ensureIndexIsVisible(selectedIndex);
                    }
                } else if (selectedIndex > 0) {
                    IndividualsPanel.this.individualList.setSelectedIndex(--selectedIndex);
                    IndividualsPanel.this.individualList.ensureIndexIsVisible(selectedIndex);
                }
            }
        });
        Component horizontalStrut_6 = Box.createHorizontalStrut(20);
        individualsButtonsPanel.add(horizontalStrut_6);
        JButton btnSort = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.btnSort.text"));
        btnSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Individual selectedIndividual = IndividualsPanel.this.getSelectedIndividual();
                ((IndividualsModel)IndividualsPanel.this.individualList.getModel()).touchSorting();
                if (selectedIndividual != null) {
                    IndividualsPanel.this.select(selectedIndividual);
                }
            }
        });
        individualsButtonsPanel.add(btnSort);
        Component horizontalGlue_4 = Box.createHorizontalGlue();
        individualsButtonsPanel.add(horizontalGlue_4);
        individualsButtonsPanel.add(btnIndividualsPrevious);
        JButton btnIndividualsNext = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnNext.text"));
        btnIndividualsNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selectedIndex = IndividualsPanel.this.individualList.getSelectedIndex();
                int size = IndividualsPanel.this.individualList.getModel().getSize();
                if (selectedIndex == -1) {
                    if (size != 0) {
                        selectedIndex = 0;
                        IndividualsPanel.this.individualList.setSelectedIndex(selectedIndex);
                        IndividualsPanel.this.individualList.ensureIndexIsVisible(selectedIndex);
                    }
                } else if (selectedIndex < size - 1) {
                    IndividualsPanel.this.individualList.setSelectedIndex(++selectedIndex);
                    IndividualsPanel.this.individualList.ensureIndexIsVisible(selectedIndex);
                }
            }
        });
        individualsButtonsPanel.add(btnIndividualsNext);
        Component horizontalGlue = Box.createHorizontalGlue();
        individualsButtonsPanel.add(horizontalGlue);
        JPanel panel_13 = new JPanel();
        individualsButtonsPanel.add(panel_13);
        panel_13.setLayout(new BoxLayout(panel_13, 0));
        this.tglbtnIndividualIdStrategy = new JToggleButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.tglbtnIndividualIdStratgy.text"));
        this.tglbtnIndividualIdStrategy.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.tglbtnIndividualIdStratgy.toolTipText"));
        this.tglbtnIndividualIdStrategy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IndividualsPanel.this.tglbtnIndividualIdStrategy.isSelected()) {
                    IndividualsPanel.this.tglbtnIndividualIdStrategy.setIcon(appendIcon);
                } else {
                    IndividualsPanel.this.tglbtnIndividualIdStrategy.setIcon(insertIcon);
                }
            }
        });
        this.tglbtnIndividualIdStrategy.setIcon(insertIcon);
        panel_13.add(this.tglbtnIndividualIdStrategy);
        this.tglbtnFamilyIdStrategy = new JToggleButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.tglbtnFamilyIdStrategy.text"));
        this.tglbtnFamilyIdStrategy.setEnabled(false);
        this.tglbtnFamilyIdStrategy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IndividualsPanel.this.tglbtnFamilyIdStrategy.isSelected()) {
                    IndividualsPanel.this.tglbtnFamilyIdStrategy.setIcon(appendIcon);
                } else {
                    IndividualsPanel.this.tglbtnFamilyIdStrategy.setIcon(insertIcon);
                }
            }
        });
        this.tglbtnFamilyIdStrategy.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.tglbtnFamilyIdStrategy.toolTipText"));
        this.tglbtnFamilyIdStrategy.setIcon(insertIcon);
        panel_13.add(this.tglbtnFamilyIdStrategy);
        this.btnDefaultUnionStatus = new JButton("");
        this.btnDefaultUnionStatus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (IndividualsPanel.this.defaultUnionStatus) {
                    case UNMARRIED: {
                        IndividualsPanel.this.defaultUnionStatus = UnionStatus.MARRIED;
                        IndividualsPanel.this.btnDefaultUnionStatus.setIcon(smallMarriedIcon);
                        break;
                    }
                    case MARRIED: {
                        IndividualsPanel.this.defaultUnionStatus = UnionStatus.DIVORCED;
                        IndividualsPanel.this.btnDefaultUnionStatus.setIcon(smallDivorcedIcon);
                        break;
                    }
                    case DIVORCED: {
                        IndividualsPanel.this.defaultUnionStatus = UnionStatus.UNMARRIED;
                        IndividualsPanel.this.btnDefaultUnionStatus.setIcon(smallUnmarriedIcon);
                        break;
                    }
                    default: {
                        IndividualsPanel.this.defaultUnionStatus = UnionStatus.UNMARRIED;
                        IndividualsPanel.this.btnDefaultUnionStatus.setIcon(smallUnmarriedIcon);
                    }
                }
            }
        });
        this.btnDefaultUnionStatus.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.btnDefaultUnionStatus.toolTipText"));
        this.btnDefaultUnionStatus.setIcon(smallMarriedIcon);
        panel_13.add(this.btnDefaultUnionStatus);
        Component horizontalGlue_1 = Box.createHorizontalGlue();
        individualsButtonsPanel.add(horizontalGlue_1);
        JLabel lblIndividualsSearch = new JLabel(" ");
        lblIndividualsSearch.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblSearch.text"));
        lblIndividualsSearch.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/find.png")));
        individualsButtonsPanel.add(lblIndividualsSearch);
        lblIndividualsSearch.setMinimumSize(new Dimension(300, 15));
        this.txtfldSearchIndividual = new JTextField();
        this.txtfldSearchIndividual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index;
                String pattern = IndividualsPanel.this.txtfldSearchIndividual.getText();
                logger.debug("Search individual=[" + pattern + "]");
                if (StringUtils.isNotBlank((CharSequence)pattern) && (index = ((IndividualsModel)IndividualsPanel.this.individualList.getModel()).nextSearchedIndividualIndex(pattern)) != -1) {
                    IndividualsPanel.this.individualList.setSelectedIndex(index);
                    IndividualsPanel.this.individualList.ensureIndexIsVisible(index);
                }
            }
        });
        individualsButtonsPanel.add(this.txtfldSearchIndividual);
        this.txtfldSearchIndividual.setMaximumSize(new Dimension(500, 50));
        this.txtfldSearchIndividual.setText("");
        this.txtfldSearchIndividual.setColumns(15);
    }

    public void addChild() {
        if (((IndividualChildrenModel)this.tableIndividualChildren.getModel()).getSource() != null && !((IndividualChildrenModel)this.tableIndividualChildren.getModel()).isNewEditionOn()) {
            Family targetFamily = ((IndividualSpousesModel)this.tableIndividualSpouses.getModel()).getFamily(this.tableIndividualSpouses.getSelectedRow());
            ((IndividualChildrenModel)this.tableIndividualChildren.getModel()).setNewItem(targetFamily);
            this.tableIndividualChildren.scrollRectToVisible(this.tableIndividualChildren.getCellRect(this.tableIndividualChildren.getModel().getRowCount() - 1, 0, true));
            this.tableIndividualChildren.setRowSelectionInterval(this.tableIndividualChildren.getModel().getRowCount() - 1, this.tableIndividualChildren.getModel().getRowCount() - 1);
            this.tableIndividualChildren.editCellAt(this.tableIndividualChildren.getModel().getRowCount() - 1, 0);
            this.tableIndividualChildren.getEditorComponent().requestFocus();
        }
    }

    public void addIndividual() {
        try {
            logger.debug("ID Strategy = " + (Object)((Object)this.getIndividualIdStrategy()));
            Individual individual = this.netGUI.getNet().createIndividual(this.getIndividualIdStrategy(), "", Gender.UNKNOWN);
            this.netGUI.setChanged(true);
            this.netGUI.updateAll();
            this.netGUI.selectIndividualsTab(individual);
            this.setFirstNameEditorOn();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String title = "Error computerum est";
            String message = "Error occured during working: " + exception.getMessage();
            JOptionPane.showMessageDialog(null, message, title, 0);
        }
    }

    public void addOriginFamily() {
        Individual currentIndividual;
        if (((IndividualSpousesModel)this.tableIndividualSpouses.getModel()).getSource() != null && !((IndividualSpousesModel)this.tableIndividualSpouses.getModel()).isNewEditionOn() && (currentIndividual = this.getSelectedIndividual()) != null && currentIndividual.getOriginFamily() == null) {
            Family family = this.netGUI.getNet().createFamily(null, null, new Individual[0]);
            family.setUnionStatus(this.getDefaultUnionStatus());
            currentIndividual.setOriginFamily(family);
            family.getChildren().add(currentIndividual);
            this.netGUI.updateAll();
        }
    }

    public void addPartner() {
        if (((IndividualSpousesModel)this.tableIndividualSpouses.getModel()).getSource() != null && !((IndividualSpousesModel)this.tableIndividualSpouses.getModel()).isNewEditionOn()) {
            ((IndividualSpousesModel)this.tableIndividualSpouses.getModel()).setNewItem();
            this.tableIndividualSpouses.scrollRectToVisible(this.tableIndividualSpouses.getCellRect(this.tableIndividualSpouses.getModel().getRowCount() - 1, 0, true));
            this.tableIndividualSpouses.setRowSelectionInterval(this.tableIndividualSpouses.getModel().getRowCount() - 1, this.tableIndividualSpouses.getModel().getRowCount() - 1);
            this.tableIndividualSpouses.editCellAt(this.tableIndividualSpouses.getModel().getRowCount() - 1, 0);
            this.tableIndividualSpouses.getEditorComponent().requestFocus();
        }
    }

    public UnionStatus getDefaultUnionStatus() {
        UnionStatus result = this.defaultUnionStatus;
        return result;
    }

    public NumberablesHashMap.IdStrategy getFamilyIdStrategy() {
        NumberablesHashMap.IdStrategy result = this.tglbtnFamilyIdStrategy.isSelected() ? NumberablesHashMap.IdStrategy.APPEND : NumberablesHashMap.IdStrategy.FILL;
        return result;
    }

    public Individual getIdentityIndividual() {
        Individual result = NumberUtils.isDigits((String)this.lblIndividualId.getText()) ? (Individual)this.netGUI.getNet().individuals().getById(Integer.parseInt(this.lblIndividualId.getText())) : null;
        return result;
    }

    public Individual getIdentityParent1() {
        Individual result = NumberUtils.isDigits((String)this.lblIndividualParent1Id.getText()) ? (Individual)this.netGUI.getNet().individuals().getById(Integer.parseInt(this.lblIndividualParent1Id.getText())) : null;
        return result;
    }

    public Individual getIdentityParent2() {
        Individual result = NumberUtils.isDigits((String)this.lblIndividualParent2Id.getText()) ? (Individual)this.netGUI.getNet().individuals().getById(Integer.parseInt(this.lblIndividualParent2Id.getText())) : null;
        return result;
    }

    public NumberablesHashMap.IdStrategy getIndividualIdStrategy() {
        NumberablesHashMap.IdStrategy result = this.tglbtnIndividualIdStrategy.isSelected() ? NumberablesHashMap.IdStrategy.APPEND : NumberablesHashMap.IdStrategy.FILL;
        return result;
    }

    public Individual getSelectedIndividual() {
        Individual result = this.individualList.getSelectedIndex() == -1 ? null : (Individual)((IndividualsModel)this.individualList.getModel()).getElementAt(this.individualList.getSelectedIndex());
        return result;
    }

    public void select(Individual individual) {
        int individualIndex = ((IndividualsModel)this.individualList.getModel()).indexOf(individual);
        if (individualIndex >= 0 && individualIndex < ((IndividualsModel)this.individualList.getModel()).getSize()) {
            this.individualList.setSelectedIndex(individualIndex);
            this.individualList.ensureIndexIsVisible(individualIndex);
        } else if (((IndividualsModel)this.individualList.getModel()).getSize() != 0) {
            this.individualList.setSelectedIndex(0);
            this.individualList.ensureIndexIsVisible(0);
        } else {
            this.updateIndividualIdentity(null);
        }
    }

    public void selectByIndex(int individualIndex) {
        if (individualIndex >= 0 && individualIndex < ((IndividualsModel)this.individualList.getModel()).getSize()) {
            this.individualList.setSelectedIndex(individualIndex);
            this.individualList.ensureIndexIsVisible(individualIndex);
        } else if (((IndividualsModel)this.individualList.getModel()).getSize() != 0) {
            this.individualList.setSelectedIndex(0);
            this.individualList.ensureIndexIsVisible(0);
        } else {
            this.updateIndividualIdentity(null);
        }
    }

    private void setFirstNameEditorOn() {
        List<String> firstNames = this.netGUI.getNet().individuals().firstNames();
        this.cmbbxIndividualFirstName.setDataList(firstNames);
        Individual currentIndividual = this.getIdentityIndividual();
        if (currentIndividual != null) {
            int firstNameIndex = ToolBox.indexOf(currentIndividual.getFirstName(), firstNames);
            this.cmbbxIndividualFirstName.setSelectedIndex(firstNameIndex);
        }
        this.lblIndividualFirstName.setVisible(false);
        this.cmbbxIndividualFirstName.setVisible(true);
        this.cmbbxIndividualFirstName.requestFocus();
    }

    public void setFocusOnFind() {
        this.txtfldSearchIndividual.requestFocus();
    }

    private void setIndividualIdEditorOn() {
        this.txtFldIndividualId.setText(this.lblIndividualId.getText());
        this.lblIndividualId.setVisible(false);
        this.txtFldIndividualId.setVisible(true);
        this.txtFldIndividualId.requestFocus();
    }

    private void setLastNameEditorOn() {
        List<String> lastNames = this.netGUI.getNet().individuals().lastNames();
        this.cmbbxIndividualLastName.setDataList(lastNames);
        Individual currentIndividual = this.getIdentityIndividual();
        if (currentIndividual != null) {
            int lastNameIndex = ToolBox.indexOf(currentIndividual.getLastName(), lastNames);
            this.cmbbxIndividualLastName.setSelectedIndex(lastNameIndex);
        }
        this.lblIndividualLastName.setVisible(false);
        this.cmbbxIndividualLastName.setVisible(true);
        this.cmbbxIndividualLastName.requestFocus();
    }

    private void setParent1IdEditorOn() {
        this.setParent1IdEditorOnWithoutFocus();
        this.cmbbxIndividualParent1.requestFocus();
    }

    private void setParent1IdEditorOnWithoutFocus() {
        List<Individual> individuals = ((IndividualsModel)this.individualList.getModel()).toSortedList();
        ArrayList<String> items = new ArrayList<String>(individuals.size());
        for (Individual individual : individuals) {
            items.add(String.valueOf(individual.getId()) + " " + individual.getName());
        }
        this.cmbbxIndividualParent1.setDataList(items);
        Individual currentParent = this.getIdentityParent1();
        if (currentParent == null) {
            this.cmbbxIndividualParent1.setSelectedIndex(-1);
        } else {
            int currentItemIndex = ToolBox.indexOf(String.valueOf(currentParent.getId()) + " " + currentParent.getName(), items);
            this.cmbbxIndividualParent1.setSelectedIndex(currentItemIndex);
        }
        this.lblIndividualParent1Id.setVisible(false);
        this.lblIndividualParent1Name.setVisible(false);
        this.cmbbxIndividualParent1.setVisible(true);
    }

    private void setParent2IdEditorOn() {
        List<Individual> individuals = ((IndividualsModel)this.individualList.getModel()).toSortedList();
        ArrayList<String> items = new ArrayList<String>(individuals.size());
        for (Individual individual : individuals) {
            items.add(String.valueOf(individual.getId()) + " " + individual.getName());
        }
        this.cmbbxIndividualParent2.setDataList(items);
        Individual currentParent = this.getIdentityParent2();
        if (currentParent == null) {
            this.cmbbxIndividualParent2.setSelectedIndex(-1);
        } else {
            int currentItemIndex = ToolBox.indexOf(String.valueOf(currentParent.getId()) + " " + currentParent.getName(), items);
            this.cmbbxIndividualParent2.setSelectedIndex(currentItemIndex);
        }
        this.lblIndividualParent2Id.setVisible(false);
        this.lblIndividualParent2Name.setVisible(false);
        this.cmbbxIndividualParent2.setVisible(true);
        this.cmbbxIndividualParent2.requestFocus();
    }

    public void update() {
        int selectedIndividual = this.individualList.getSelectedIndex();
        ((IndividualsModel)this.individualList.getModel()).setSource(this.netGUI.getCurrentIndividuals());
        this.selectByIndex(selectedIndividual);
    }

    public void update(Individual individual) {
        ((IndividualsModel)this.individualList.getModel()).setSource(this.netGUI.getCurrentIndividuals());
        this.select(individual);
    }

    public void updateAttributeTemplates() {
        this.attributeTemplates.clear();
        if (this.netGUI.getNet() != null) {
            List<String> templates = AttributeWorker.getExogenousAttributeDescriptors(this.netGUI.getNet().individuals(), null).labels();
            this.attributeTemplates.addAll(templates);
        }
    }

    public void updateIndividualIdentity() {
        this.updateIndividualIdentity(this.getSelectedIndividual());
    }

    public void updateIndividualIdentity(Individual source) {
        if (source == null) {
            logger.debug("updateIndividualIdentity(null)");
        } else {
            logger.debug("updateIndividualIdentity(" + source.getId() + ")");
        }
        if (source == null) {
            this.lblIndividualId.setText("---");
            this.lblIndividualId.setVisible(true);
            this.txtFldIndividualId.setVisible(false);
            this.lblIndividualGender.setIcon(largeUnknowIcon);
            this.lblIndividualFirstName.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individual.unknown"));
            this.lblIndividualLastName.setText("");
            this.lblFirstLastNameSeparator.setVisible(false);
            this.lblPosition.setText("(--/--)");
            this.lblFamilyId.setText("---");
            this.lblFamilyStatus.setIcon(mediumUnmarriedIcon);
            this.lblIndividualParent1Id.setText("---");
            this.lblIndividualParent1Name.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individual.unknown"));
            this.lblIndividualParent1Name.setIcon(mediumUnknowIcon);
            this.lblIndividualParent2Id.setText("---");
            this.lblIndividualParent2Name.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individual.unknown"));
            this.lblIndividualParent2Name.setIcon(mediumUnknowIcon);
            this.lblIndividualSpouses.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblSpouses.text"));
            ((IndividualSpousesModel)this.tableIndividualSpouses.getModel()).setSource(null);
            this.cmbbxIndividualSpousesIds.setDataList(new ArrayList(0));
            this.lblChildren.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblChildren.text"));
            ((IndividualChildrenModel)this.tableIndividualChildren.getModel()).setSource(null);
            this.cmbbxIndividualChildrenIds.setDataList(new ArrayList(0));
            this.attributesPanel.setSource(null);
            this.lblRelations.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.lblRelations.text"));
            ((IndividualRelationsModel)this.tableIndividualRelations.getModel()).setSource(null);
            this.btnAddPartner.setEnabled(false);
            this.btnAddChild.setEnabled(false);
        } else {
            this.lblIndividualId.setText(String.valueOf(source.getId()));
            this.lblIndividualId.setVisible(true);
            this.txtFldIndividualId.setVisible(false);
            switch (source.getGender()) {
                case FEMALE: {
                    this.lblIndividualGender.setIcon(largeFemaleIcon);
                    break;
                }
                case MALE: {
                    this.lblIndividualGender.setIcon(largeMaleIcon);
                    break;
                }
                case UNKNOWN: {
                    this.lblIndividualGender.setIcon(largeUnknowIcon);
                }
            }
            this.lblIndividualFirstName.setText(source.getFirstName());
            String lastName = source.getLastName();
            if (StringUtils.isBlank((CharSequence)lastName)) {
                this.lblFirstLastNameSeparator.setVisible(false);
                this.lblIndividualLastName.setText("      ");
            } else {
                this.lblFirstLastNameSeparator.setVisible(true);
                this.lblIndividualLastName.setText(source.getLastName());
            }
            this.lblPosition.setText("(" + (this.individualList.getSelectedIndex() + 1) + "/" + this.individualList.getModel().getSize() + ")");
            if (source.getOriginFamily() == null) {
                this.lblFamilyId.setText("---");
                this.lblFamilyStatus.setIcon(mediumUnmarriedIcon);
            } else {
                this.lblFamilyId.setText(String.valueOf(source.getOriginFamily().getId()));
                switch (source.getOriginFamily().getUnionStatus()) {
                    case UNMARRIED: {
                        this.lblFamilyStatus.setIcon(mediumUnmarriedIcon);
                        break;
                    }
                    case MARRIED: {
                        this.lblFamilyStatus.setIcon(mediumMarriedIcon);
                        break;
                    }
                    case DIVORCED: {
                        this.lblFamilyStatus.setIcon(mediumDivorcedIcon);
                        break;
                    }
                    default: {
                        this.lblFamilyStatus.setIcon(largeUnknowIcon);
                    }
                }
            }
            if (source.getFather() == null) {
                this.lblIndividualParent1Id.setText("---");
                this.lblIndividualParent1Name.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individual.unknown"));
                this.lblIndividualParent1Name.setIcon(mediumUnknowIcon);
            } else {
                this.lblIndividualParent1Id.setText(String.valueOf(source.getFather().getId()));
                this.lblIndividualParent1Name.setText(source.getFather().getName());
                switch (source.getFather().getGender()) {
                    case FEMALE: {
                        this.lblIndividualParent1Name.setIcon(mediumFemaleIcon);
                        break;
                    }
                    case MALE: {
                        this.lblIndividualParent1Name.setIcon(mediumMaleIcon);
                        break;
                    }
                    case UNKNOWN: {
                        this.lblIndividualParent1Name.setIcon(mediumUnknowIcon);
                    }
                }
            }
            if (source.getMother() == null) {
                this.lblIndividualParent2Id.setText("---");
                this.lblIndividualParent2Name.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individual.unknown"));
                this.lblIndividualParent2Name.setIcon(mediumUnknowIcon);
            } else {
                this.lblIndividualParent2Id.setText(String.valueOf(source.getMother().getId()));
                this.lblIndividualParent2Name.setText(source.getMother().getName());
                switch (source.getMother().getGender()) {
                    case FEMALE: {
                        this.lblIndividualParent2Name.setIcon(mediumFemaleIcon);
                        break;
                    }
                    case MALE: {
                        this.lblIndividualParent2Name.setIcon(mediumMaleIcon);
                        break;
                    }
                    case UNKNOWN: {
                        this.lblIndividualParent2Name.setIcon(mediumUnknowIcon);
                    }
                }
            }
            ((IndividualSpousesModel)this.tableIndividualSpouses.getModel()).setSource(source);
            this.lblIndividualSpouses.setText(String.valueOf(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblSpouses.text")) + " (" + source.getPersonalFamilies().size() + ")");
            ComboBoxIds.instance().update(((IndividualsModel)this.individualList.getModel()).toSortedList());
            this.cmbbxIndividualSpousesIds.setDataList(ComboBoxIds.instance().items());
            this.cmbbxIndividualChildrenIds.setDataList(ComboBoxIds.instance().items());
            ((IndividualChildrenModel)this.tableIndividualChildren.getModel()).setSource(source);
            this.lblChildren.setText(String.valueOf(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblChildren.text")) + " (" + ((IndividualChildrenModel)this.tableIndividualChildren.getModel()).children().size() + ")");
            this.attributesPanel.setSource(source.attributes());
            this.lblRelations.setText(String.valueOf(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.lblRelations.text")) + " (" + source.relations().size() + ")");
            ((IndividualRelationsModel)this.tableIndividualRelations.getModel()).setSource(source);
            this.btnAddPartner.setEnabled(true);
            this.btnAddChild.setEnabled(true);
        }
    }

    private static void addPopup(Component component, final JPopupMenu popup) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }

    public static String controlFixedPartners(InputSettings.CheckLevel level, Individual father, Individual mother, Individual ... children) {
        String result = NetUtils.isRolesFixedByGender(father, mother) ? IndividualsPanel.controlPartners(level, father, mother, children) : IndividualsPanel.controlPartners(level, father, mother, children);
        return result;
    }

    public static String controlPartners(InputSettings.CheckLevel level, Individual father, Individual mother, Individual ... children) {
        String result = level == InputSettings.CheckLevel.ERROR && NetUtils.isSame(father, mother) ? "Same parent twice detected." : (PuckGUI.instance().getPreferences().getInputSettings().getSameSexSpouses() == level && NetUtils.isSameSex(father, mother) ? "Same sex spouses detected." : (PuckGUI.instance().getPreferences().getInputSettings().getFemaleFathersOrMaleMothers() == level && NetUtils.isFemaleFatherOrMaleMother(father, mother) ? "Female Father or Male Mother or detected." : (PuckGUI.instance().getPreferences().getInputSettings().getParentChildMarriages() == level && NetUtils.isParentChildMarriage(father, mother, children) ? "Parent-child marriages detected." : null)));
        return result;
    }
}

