/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.workers.ExpandCriteria;
import org.tip.puck.net.workers.ExpansionMode;

public class ExpandInputDialog
extends JDialog {
    private static final long serialVersionUID = 4031359596254807624L;
    private final JPanel contentPanel = new JPanel();
    private ExpandCriteria dialogCriteria;
    private static ExpandCriteria lastCriteria = new ExpandCriteria();
    private JSpinner spnnrMaxStep;
    private JRadioButton rdbtnHorizontal;
    private JRadioButton rdbtnDescendingUterine;
    private JRadioButton rdbtnDescendingAgnatic;
    private JRadioButton rdbtnDescending;
    private JRadioButton rdbtnAscendingUterine;
    private JRadioButton rdbtnAscendingAgnatic;
    private JRadioButton rdbtnAscending;
    private JRadioButton rdbtnAllKin;
    private JRadioButton rdbtnAllRelated;
    private JRadioButton rdbtnUniversal;
    private final ButtonGroup buttonGroupExpansionMode = new ButtonGroup();

    public ExpandInputDialog() {
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle("Expand Input");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(ExpandInputDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ExpandInputDialog.this.dialogCriteria = null;
                ExpandInputDialog.this.setVisible(false);
            }
        });
        this.setBounds(100, 100, 390, 380);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblTarget = new JLabel("Expansion Mode:");
        this.contentPanel.add((Component)lblTarget, "2, 2, right, default");
        JPanel panel = new JPanel();
        this.contentPanel.add((Component)panel, "4, 2, fill, fill");
        panel.setLayout(new BoxLayout(panel, 1));
        this.rdbtnUniversal = new JRadioButton("Universal");
        this.buttonGroupExpansionMode.add(this.rdbtnUniversal);
        panel.add(this.rdbtnUniversal);
        this.rdbtnAllRelated = new JRadioButton("All Related");
        this.buttonGroupExpansionMode.add(this.rdbtnAllRelated);
        panel.add(this.rdbtnAllRelated);
        this.rdbtnAllKin = new JRadioButton("All Kin");
        this.buttonGroupExpansionMode.add(this.rdbtnAllKin);
        panel.add(this.rdbtnAllKin);
        this.rdbtnAscending = new JRadioButton("Ascending");
        this.buttonGroupExpansionMode.add(this.rdbtnAscending);
        panel.add(this.rdbtnAscending);
        this.rdbtnAscendingAgnatic = new JRadioButton("Ascending Agnatic");
        this.buttonGroupExpansionMode.add(this.rdbtnAscendingAgnatic);
        panel.add(this.rdbtnAscendingAgnatic);
        this.rdbtnAscendingUterine = new JRadioButton("Ascending Uterine");
        this.buttonGroupExpansionMode.add(this.rdbtnAscendingUterine);
        panel.add(this.rdbtnAscendingUterine);
        this.rdbtnDescending = new JRadioButton("Descending");
        this.buttonGroupExpansionMode.add(this.rdbtnDescending);
        panel.add(this.rdbtnDescending);
        this.rdbtnDescendingAgnatic = new JRadioButton("Descending Agnatic");
        this.buttonGroupExpansionMode.add(this.rdbtnDescendingAgnatic);
        panel.add(this.rdbtnDescendingAgnatic);
        this.rdbtnDescendingUterine = new JRadioButton("Descending Uterine");
        this.buttonGroupExpansionMode.add(this.rdbtnDescendingUterine);
        panel.add(this.rdbtnDescendingUterine);
        this.rdbtnHorizontal = new JRadioButton("Horizontal");
        this.buttonGroupExpansionMode.add(this.rdbtnHorizontal);
        panel.add(this.rdbtnHorizontal);
        JLabel lblLabel = new JLabel("Max step:");
        this.contentPanel.add((Component)lblLabel, "2, 4, right, default");
        this.spnnrMaxStep = new JSpinner();
        this.spnnrMaxStep.setModel(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        this.contentPanel.add((Component)this.spnnrMaxStep, "4, 4");
        JLabel lblNo = new JLabel("0 = no limit");
        this.contentPanel.add((Component)lblNo, "4, 6, center, default");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpandInputDialog.this.dialogCriteria = null;
                ExpandInputDialog.this.setVisible(false);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        JButton okButton = new JButton("Expand");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpandCriteria criteria = ExpandInputDialog.this.getCriteria();
                if (ExpandCriteria.isValid(criteria)) {
                    lastCriteria = criteria;
                    ExpandInputDialog.this.dialogCriteria = criteria;
                    ExpandInputDialog.this.setVisible(false);
                } else {
                    String title = "Invalid input";
                    String message = "Please, check your input.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                }
            }
        });
        Component horizontalStrut = Box.createHorizontalStrut(20);
        buttonPane.add(horizontalStrut);
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.setCriteria(lastCriteria);
    }

    public ExpandCriteria getCriteria() {
        ExpandCriteria result = new ExpandCriteria();
        if (this.rdbtnAllKin.isSelected()) {
            result.setExpansionMode(ExpansionMode.KIN);
            result.setFiliationType(FiliationType.COGNATIC);
            result.setSubTitle("expanded_ALL_KIN");
        } else if (this.rdbtnAllRelated.isSelected()) {
            result.setExpansionMode(ExpansionMode.RELATED);
            result.setFiliationType(null);
            result.setSubTitle("expanded_RELATIONS");
        } else if (this.rdbtnAscending.isSelected()) {
            result.setExpansionMode(ExpansionMode.PARENT);
            result.setFiliationType(FiliationType.COGNATIC);
            result.setSubTitle("expanded_UP");
        } else if (this.rdbtnAscendingAgnatic.isSelected()) {
            result.setExpansionMode(ExpansionMode.PARENT);
            result.setFiliationType(FiliationType.AGNATIC);
            result.setSubTitle("expanded_UP_A");
        } else if (this.rdbtnAscendingUterine.isSelected()) {
            result.setExpansionMode(ExpansionMode.PARENT);
            result.setFiliationType(FiliationType.UTERINE);
            result.setSubTitle("expanded_UP_U");
        } else if (this.rdbtnDescending.isSelected()) {
            result.setExpansionMode(ExpansionMode.CHILD);
            result.setFiliationType(FiliationType.COGNATIC);
            result.setSubTitle("");
        } else if (this.rdbtnDescendingAgnatic.isSelected()) {
            result.setExpansionMode(ExpansionMode.CHILD);
            result.setFiliationType(FiliationType.AGNATIC);
            result.setSubTitle("expanded_DOWN_A");
        } else if (this.rdbtnDescendingUterine.isSelected()) {
            result.setExpansionMode(ExpansionMode.CHILD);
            result.setFiliationType(FiliationType.UTERINE);
            result.setSubTitle("expanded_DOWN_U");
        } else if (this.rdbtnHorizontal.isSelected()) {
            result.setExpansionMode(ExpansionMode.SPOUSE);
            result.setFiliationType(FiliationType.COGNATIC);
            result.setSubTitle("expanded_MARR");
        } else if (this.rdbtnUniversal.isSelected()) {
            result.setExpansionMode(ExpansionMode.ALL);
            result.setFiliationType(FiliationType.COGNATIC);
            result.setSubTitle("expanded_ALL");
        }
        result.setMaxStep((Integer)this.spnnrMaxStep.getValue());
        return result;
    }

    public ExpandCriteria getDialogCriteria() {
        ExpandCriteria result = this.dialogCriteria;
        return result;
    }

    private void setCriteria(ExpandCriteria source) {
        if (source != null) {
            this.rdbtnAllKin.setSelected(false);
            this.rdbtnAllRelated.setSelected(false);
            this.rdbtnAscending.setSelected(false);
            this.rdbtnAscendingAgnatic.setSelected(false);
            this.rdbtnAscendingUterine.setSelected(false);
            this.rdbtnDescending.setSelected(false);
            this.rdbtnDescendingAgnatic.setSelected(false);
            this.rdbtnDescendingUterine.setSelected(false);
            this.rdbtnHorizontal.setSelected(false);
            this.rdbtnUniversal.setSelected(false);
            block0 : switch (source.getExpansionMode()) {
                case ALL: {
                    this.rdbtnUniversal.setSelected(true);
                    break;
                }
                case CHILD: {
                    if (source.getFiliationType() == null) {
                        this.rdbtnDescending.setSelected(true);
                        break;
                    }
                    switch (source.getFiliationType()) {
                        case AGNATIC: {
                            this.rdbtnDescendingAgnatic.setSelected(true);
                            break block0;
                        }
                        case UTERINE: {
                            this.rdbtnDescendingUterine.setSelected(true);
                            break block0;
                        }
                    }
                    this.rdbtnDescending.setSelected(true);
                    break;
                }
                case KIN: {
                    this.rdbtnUniversal.setSelected(true);
                    break;
                }
                case PARENT: {
                    if (source.getFiliationType() == null) {
                        this.rdbtnAscending.setSelected(true);
                        break;
                    }
                    switch (source.getFiliationType()) {
                        case AGNATIC: {
                            this.rdbtnAscendingAgnatic.setSelected(true);
                            break block0;
                        }
                        case UTERINE: {
                            this.rdbtnAscendingUterine.setSelected(true);
                            break block0;
                        }
                    }
                    this.rdbtnAscending.setSelected(true);
                    break;
                }
                case RELATED: {
                    this.rdbtnAllRelated.setSelected(true);
                    break;
                }
                case SPOUSE: {
                    this.rdbtnHorizontal.setSelected(true);
                }
            }
            this.spnnrMaxStep.setValue(source.getMaxStep());
        }
    }

    public static void main(String[] args) {
        ExpandInputDialog.showDialog();
    }

    public static ExpandCriteria showDialog() {
        ExpandInputDialog dialog = new ExpandInputDialog();
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        ExpandCriteria result = dialog.getDialogCriteria();
        return result;
    }
}

