/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.models;

import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Role;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.util.ComboBoxIds;

public class ActorsModel
extends AbstractTableModel {
    private static final long serialVersionUID = 2955121752027361350L;
    private static final Logger logger = LoggerFactory.getLogger(ActorsModel.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.tip.puckgui.messages");
    private NetGUI netGUI;
    private Actors source;
    private Actors delegate;
    private Relation relation;

    public ActorsModel(Actors source, NetGUI netGUI, Relation selectedRelation) {
        this.setSource(source, netGUI, selectedRelation);
    }

    public Class getColumnClass(int columnIndex) {
        Class result;
        if (this.source == null) {
            result = String.class;
        } else {
            switch (columnIndex) {
                case 0: {
                    result = String.class;
                    break;
                }
                case 1: {
                    result = Number.class;
                    break;
                }
                case 2: {
                    result = String.class;
                    break;
                }
                case 3: {
                    result = Number.class;
                    break;
                }
                default: {
                    result = String.class;
                }
            }
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        int result = 4;
        return result;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String result;
        switch (columnIndex) {
            case 0: {
                result = "Role";
                break;
            }
            case 1: {
                result = "Id";
                break;
            }
            case 2: {
                result = "Name";
                break;
            }
            case 3: {
                result = "Order";
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        int result = this.delegate.size();
        return result;
    }

    public Actors getSource() {
        Actors result = this.source;
        return result;
    }

    public Actors getTarget() {
        Actors result = this.delegate;
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result;
        if (this.delegate == null) {
            result = null;
        } else if (this.delegate.get(rowIndex) == null) {
            result = "";
        } else {
            switch (columnIndex) {
                case 0: {
                    result = ((Actor)this.delegate.get(rowIndex)).getRole().getName();
                    break;
                }
                case 1: {
                    result = ((Actor)this.delegate.get(rowIndex)).getIndividual().getId();
                    break;
                }
                case 2: {
                    result = ((Actor)this.delegate.get(rowIndex)).getIndividual().getName();
                    break;
                }
                case 3: {
                    result = ((Actor)this.delegate.get(rowIndex)).getRelationOrder();
                    break;
                }
                default: {
                    result = null;
                }
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean result;
        switch (columnIndex) {
            case 0: 
            case 1: 
            case 3: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public void setNetGUI(NetGUI guiManager) {
        this.netGUI = guiManager;
    }

    public void setNewItem() throws PuckException {
        this.netGUI.getNet().createRelationActor(this.relation, this.netGUI.getCurrentIndividuals().getFirstFreeId(), ((Role)this.relation.getModel().roles().get(0)).getName());
        this.netGUI.updateIndividualIdentity();
        this.netGUI.updateRelationIdentity(this.relation.getModel());
    }

    public void setSource(Actors source, NetGUI netGUI, Relation selectedRelation) {
        this.source = source;
        this.delegate = source == null ? new Actors() : source;
        this.netGUI = netGUI;
        this.relation = selectedRelation;
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        logger.debug("setValueAt " + rowIndex + " " + columnIndex + " " + value);
        Actor actor = (Actor)this.delegate.get(rowIndex);
        if (columnIndex == 0) {
            actor.setRole(this.relation.getModel().roles().getByName((String)value));
            this.netGUI.setChanged(true);
            this.netGUI.updateAll();
        } else if (columnIndex == 1) {
            if (this.netGUI != null) {
                Individual newIndividual = ComboBoxIds.getOrCreateIndividualFromInput(this.netGUI.getNet(), value, Gender.UNKNOWN);
                if (newIndividual == null) {
                    this.netGUI.getNet().removeRelationActor(this.relation, actor);
                    this.netGUI.setChanged(true);
                    this.netGUI.updateAll();
                } else if (newIndividual != actor.getIndividual()) {
                    this.netGUI.getNet().replaceIndividualInActor(this.relation, actor, newIndividual);
                    actor.setIndividual(newIndividual);
                    this.netGUI.setChanged(true);
                    this.netGUI.updateAll();
                }
            }
        } else if (columnIndex == 3) {
            actor.setRelationOrder((Integer)value);
            this.netGUI.setChanged(true);
            this.netGUI.updateAll();
        }
    }
}

