/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.census.workers.CensusDetail;
import org.tip.puck.util.ToolBox;
import org.tip.puckgui.Language;
import org.tip.puckgui.Preferences;

public class PreferencesFile {
    private static final Logger logger = LoggerFactory.getLogger(PreferencesFile.class);

    public static Map<String, String> convertObjectToProperties(String namespace, Object bean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        BeanUtilsBean bub = new BeanUtilsBean(new ConvertUtilsBean(){

            public String convert(Object value) {
                String result = StringUtils.equals((CharSequence)value.getClass().getName(), (CharSequence)"java.util.ArrayList") && ((ArrayList)value).isEmpty() ? "" : super.convert(value);
                return result;
            }
        });
        Map properties = bub.describe(bean);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Object key : properties.keySet()) {
            result.put(String.valueOf(namespace) + "." + (String)key, (String)properties.get(key));
        }
        return result;
    }

    public static void convertPropertiesToObject(String namespace, Object bean, Properties sourceProperties) throws IllegalAccessException, InvocationTargetException {
        BeanUtilsBean bub = new BeanUtilsBean(new ConvertUtilsBean(){

            public Object convert(String value, Class clazz) {
                Object result = clazz.isEnum() ? Enum.valueOf(clazz, value) : super.convert(value, clazz);
                return result;
            }
        });
        HashMap<String, String> beanProperties = new HashMap<String, String>();
        String namespacePattern = String.valueOf(namespace) + ".";
        for (Object key : sourceProperties.keySet()) {
            if (!((String)key).startsWith(namespacePattern)) continue;
            beanProperties.put(((String)key).substring(namespacePattern.length()), (String)sourceProperties.get(key));
        }
        bub.populate(bean, beanProperties);
    }

    public static Preferences load(File file) throws PuckException {
        Preferences result;
        try {
            String autoLoadLastFileValue;
            result = new Preferences();
            Properties properties = new Properties();
            properties.load(new FileInputStream(file));
            String languageLabel = properties.getProperty("language");
            if (languageLabel != null) {
                Language language = Language.valueOf(languageLabel);
                if (language == null) {
                    logger.warn("Unknown language in preference file.");
                } else {
                    result.setLanguage(language);
                }
            }
            if ((autoLoadLastFileValue = (String)properties.get("autoloadlastfile")) != null) {
                result.setAutoLoadLastFile(Boolean.parseBoolean(autoLoadLastFileValue));
            }
            PreferencesFile.convertPropertiesToObject("inputSettings", result.getInputSettings(), properties);
            int detailIndex = 1;
            while (detailIndex <= 10) {
                String rootLabel = "census.details." + detailIndex;
                if (properties.get(String.valueOf(rootLabel) + ".label") != null) {
                    ((CensusDetail)result.getCensusCriteria().getCensusDetails().get(detailIndex - 1)).setLabel((String)properties.get(String.valueOf(rootLabel) + ".label"));
                }
                if (properties.get(String.valueOf(rootLabel) + ".report") != null) {
                    ((CensusDetail)result.getCensusCriteria().getCensusDetails().get(detailIndex - 1)).setReport(Boolean.parseBoolean((String)properties.get(String.valueOf(rootLabel) + ".report")));
                }
                if (properties.get(String.valueOf(rootLabel) + ".diagram") != null) {
                    ((CensusDetail)result.getCensusCriteria().getCensusDetails().get(detailIndex - 1)).setDiagram(Boolean.parseBoolean((String)properties.get(String.valueOf(rootLabel) + ".diagram")));
                }
                ++detailIndex;
            }
            PreferencesFile.convertPropertiesToObject("census", result.getCensusCriteria(), properties);
            PreferencesFile.convertPropertiesToObject("differentialCensus", result.getDifferentialCensusCriteria(), properties);
            PreferencesFile.convertPropertiesToObject("agentSimulation", result.getAgentSimulationCriteria(), properties);
            PreferencesFile.convertPropertiesToObject("virtualFieldwork", result.getVirtualFieldworkCriteria(), properties);
            PreferencesFile.convertPropertiesToObject("agentSimulationVariations", result.getAgentSimulationVariationsCriteria(), properties);
            PreferencesFile.convertPropertiesToObject("virtualFieldworkVariations", result.getVirtualFieldworkVariationsCriteria(), properties);
            PreferencesFile.convertPropertiesToObject("randomPermutation", result.getRandomPermutationCriteria(), properties);
            PreferencesFile.convertPropertiesToObject("reshuffling", result.getReshufflingCriteria(), properties);
            PreferencesFile.convertPropertiesToObject("randomDistribution", result.getRandomDistributionCriteria(), properties);
            PreferencesFile.convertPropertiesToObject("generateRules", result.getGenerateRulesCriteria(), properties);
            PreferencesFile.convertPropertiesToObject("randomCorpusMas", result.getRandomCorpusMASCriteria(), properties);
        }
        catch (FileNotFoundException exception) {
            throw PuckExceptions.FILE_NOT_FOUND.create("Preferences file not found: " + file.getAbsolutePath(), new Object[0]);
        }
        catch (IOException exception) {
            throw PuckExceptions.BAD_FILE_FORMAT.create("Error reading (1) preferences file: " + exception.getMessage(), new Object[0]);
        }
        catch (IllegalAccessException exception) {
            throw PuckExceptions.BAD_FILE_FORMAT.create("Error reading (2) preferences file: " + exception.getMessage(), new Object[0]);
        }
        catch (InvocationTargetException exception) {
            throw PuckExceptions.BAD_FILE_FORMAT.create("Error reading (3) preferences file: " + exception.getMessage(), new Object[0]);
        }
        return result;
    }

    public static void save(File file, Preferences source) throws PuckException {
        logger.info("Saving preferences in [" + file.getAbsolutePath() + "]");
        try {
            Properties properties = new Properties();
            properties.put("language", source.getLanguage().toString());
            properties.put("autoloadlastfile", Boolean.toString(source.isAutoLoadLastFile()));
            properties.putAll(PreferencesFile.convertObjectToProperties("inputSettings", source.getInputSettings()));
            int detailIndex = 1;
            while (detailIndex <= 10) {
                properties.put("census.details." + detailIndex + ".label", ToolBox.toString(((CensusDetail)source.getCensusCriteria().getCensusDetails().get(detailIndex - 1)).getLabel()));
                properties.put("census.details." + detailIndex + ".report", Boolean.toString(((CensusDetail)source.getCensusCriteria().getCensusDetails().get(detailIndex - 1)).isReport()));
                properties.put("census.details." + detailIndex + ".diagram", Boolean.toString(((CensusDetail)source.getCensusCriteria().getCensusDetails().get(detailIndex - 1)).isDiagram()));
                ++detailIndex;
            }
            properties.putAll(PreferencesFile.convertObjectToProperties("census", source.getCensusCriteria()));
            properties.putAll(PreferencesFile.convertObjectToProperties("differentialCensus", source.getDifferentialCensusCriteria()));
            properties.putAll(PreferencesFile.convertObjectToProperties("agentSimulation", source.getAgentSimulationCriteria()));
            properties.putAll(PreferencesFile.convertObjectToProperties("virtualFieldwork", source.getVirtualFieldworkCriteria()));
            properties.putAll(PreferencesFile.convertObjectToProperties("agentSimulationVariations", source.getAgentSimulationVariationsCriteria()));
            properties.putAll(PreferencesFile.convertObjectToProperties("virtualFieldworkVariations", source.getVirtualFieldworkVariationsCriteria()));
            properties.putAll(PreferencesFile.convertObjectToProperties("randomPermutation", source.getRandomPermutationCriteria()));
            properties.putAll(PreferencesFile.convertObjectToProperties("reshuffling", source.getReshufflingCriteria()));
            properties.putAll(PreferencesFile.convertObjectToProperties("randomDistribution", source.getRandomDistributionCriteria()));
            properties.putAll(PreferencesFile.convertObjectToProperties("generateRules", source.getGenerateRulesCriteria()));
            properties.putAll(PreferencesFile.convertObjectToProperties("randomCorpusMas", source.getRandomCorpusMASCriteria()));
            properties.store(new FileOutputStream(file), null);
        }
        catch (IllegalAccessException exception) {
            throw PuckExceptions.BAD_FILE_FORMAT.create("Error reading (1) preferences file: " + exception.getMessage(), new Object[0]);
        }
        catch (InvocationTargetException exception) {
            throw PuckExceptions.BAD_FILE_FORMAT.create("Error reading (2) preferences file: " + exception.getMessage(), new Object[0]);
        }
        catch (NoSuchMethodException exception) {
            throw PuckExceptions.BAD_FILE_FORMAT.create("Error reading (3) preferences file: " + exception.getMessage(), new Object[0]);
        }
        catch (FileNotFoundException exception) {
            throw PuckExceptions.FILE_NOT_FOUND.create("Preferences file not found: " + file.getAbsolutePath(), new Object[0]);
        }
        catch (IOException exception) {
            throw PuckExceptions.BAD_FILE_FORMAT.create("Error reading (4) preferences file: " + exception.getMessage(), new Object[0]);
        }
    }
}

