/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MathUtils {
    public static int compare(Boolean alpha, Boolean bravo) {
        int result = alpha == null && bravo == null ? 0 : (alpha == null ? -1 : (bravo == null ? 1 : alpha.compareTo(bravo)));
        return result;
    }

    public static int compare(Double alpha, Double bravo) {
        int result = alpha == null && bravo == null ? 0 : (alpha == null ? -1 : (bravo == null ? 1 : alpha.compareTo(bravo)));
        return result;
    }

    public static int compare(Integer alpha, Integer bravo) {
        int result = alpha == null && bravo == null ? 0 : (alpha == null ? -1 : (bravo == null ? 1 : alpha.compareTo(bravo)));
        return result;
    }

    public static int compare(Long alpha, Long bravo) {
        int result = alpha == null && bravo == null ? 0 : (alpha == null ? -1 : (bravo == null ? 1 : alpha.compareTo(bravo)));
        return result;
    }

    public static int compareOrder(Integer alpha, Integer bravo) {
        int result = alpha == null && bravo == null ? 0 : (alpha == null ? 1 : (bravo == null ? -1 : alpha.compareTo(bravo)));
        return result;
    }

    public static boolean isDecimalInteger(double value) {
        boolean result = (double)((int)value) == value;
        return result;
    }

    public static boolean isDecimalInteger(Double value) {
        boolean result = value == null ? false : MathUtils.isDecimalInteger((double)value);
        return result;
    }

    public static double meanValue(Map<Integer, Integer> map) {
        double result = 0.0;
        double totalNumber = 0.0;
        double totalValue = 0.0;
        for (int value : map.keySet()) {
            totalValue += (double)value;
            totalNumber += (double)map.get(value).intValue();
        }
        result = totalValue / totalNumber;
        return result;
    }

    public static double medianValue(Map<Integer, Integer> map) {
        double result = 0.0;
        double totalNumber = 0.0;
        for (int value : map.keySet()) {
            totalNumber += (double)map.get(value).intValue();
        }
        double half = totalNumber / 2.0;
        double count = 0.0;
        for (int value : map.keySet()) {
            if (!((count += (double)map.get(value).intValue()) >= half)) continue;
            result = value;
            break;
        }
        return result;
    }

    public static double percent(double a, double b) {
        double result = b == 0.0 ? 0.0 : (double)Math.round(10000.0 * (a / b)) / 100.0;
        return result;
    }

    public static double percent(double a, double b, int dec) {
        double result;
        if (b == 0.0) {
            result = 0.0;
        } else {
            double k = Math.pow(10.0, dec);
            result = (double)Math.round(100.0 * k * (a / b)) / k;
        }
        return result;
    }

    public static double percent(int a, int b) {
        double result = MathUtils.percent(new Double(a), new Double(b));
        return result;
    }

    public static double jacquard(double a, double b) {
        double result = MathUtils.percent(a - b, a + b);
        return result;
    }

    public static double herfindahl(List<Double> list) {
        double sum = 0.0;
        for (Double item : list) {
            sum += item.doubleValue();
        }
        double result = 0.0;
        for (Double item : list) {
            result += Math.pow(item / sum, 2.0);
        }
        result = MathUtils.round(100.0 * result, 2);
        return result;
    }

    public static double round(double value, int decimalNumber) {
        double shifter = Math.pow(10.0, decimalNumber);
        double result = (double)((int)(value * shifter)) / shifter;
        return result;
    }

    public static double roundHundredth(double value) {
        double result = (double)Math.round(100.0 * value) / 100.0;
        return result;
    }

    public static int toIntAmplified(double value, int factor) {
        int result = new Double((double)factor * value).intValue();
        return result;
    }

    public static String toString(double value) {
        String result = MathUtils.isDecimalInteger(value) ? String.valueOf((int)value) : String.valueOf(value);
        return result;
    }

    public static String toString(Double value) {
        String result = value == null ? "" : MathUtils.toString((double)value);
        return result;
    }

    public static <E> double[] intersectionRates(Collection<E> firstSet, Collection<E> secondSet) {
        double[] result = new double[3];
        int firstSize = firstSet.size();
        int secondSize = secondSet.size();
        int shareSize = 0;
        for (E element : firstSet) {
            if (!secondSet.contains(element)) continue;
            ++shareSize;
        }
        result[0] = MathUtils.percent(shareSize, firstSize);
        result[1] = MathUtils.percent(shareSize, secondSize);
        result[2] = MathUtils.percent(shareSize, firstSize + secondSize - shareSize);
        return result;
    }
}

