/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.sequences;

import java.util.Map;
import java.util.TreeMap;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.report.ReportTable;
import org.tip.puck.util.Numberable;

public class Sequence
implements Comparable<Sequence>,
Numberable {
    int id;
    Map<String, Relation> events;

    public Sequence(int id) {
        this.id = id;
        this.events = new TreeMap<String, Relation>();
    }

    public Roles getRoles() {
        Roles result = new Roles();
        for (Relation relation : this.events.values()) {
            for (Actor actor : relation.actors()) {
                if (result.contains(actor.getRole())) continue;
                result.add(actor.getRole());
            }
        }
        return result;
    }

    public Individuals individuals() {
        Individuals result = new Individuals();
        for (Relation relation : this.events.values()) {
            for (Actor actor : relation.actors()) {
                if (result.contains(actor.getIndividual())) continue;
                result.add(actor.getIndividual());
            }
        }
        return result;
    }

    public ReportTable roleTable() {
        Individuals individuals = this.individuals();
        ReportTable result = new ReportTable(this.events.size() + 1, individuals.size() + 1);
        result.set(0, 0, this.id);
        int columnIndex = 1;
        for (Individual individual : individuals) {
            result.set(0, columnIndex, individual.getName());
            ++columnIndex;
        }
        int rowIndex = 1;
        for (String eventOrder : this.events.keySet()) {
            result.set(rowIndex, 0, eventOrder);
            columnIndex = 1;
            Relation event = this.events.get(eventOrder);
            for (Individual individual : individuals) {
                String rolesAsString = " - ";
                Roles roles = event.actors().getRoles(individual.getId());
                if (roles != null && roles.size() > 0) {
                    rolesAsString = roles.nameList().toString();
                }
                result.set(rowIndex, columnIndex, rolesAsString);
                ++columnIndex;
            }
            ++rowIndex;
        }
        return result;
    }

    public ReportTable interactionTable() {
        Individuals individuals = this.individuals();
        ReportTable result = new ReportTable(individuals.size() + 1, individuals.size() + 1);
        result.set(0, 0, this.id);
        int columnIndex = 1;
        for (Individual individual : individuals) {
            result.set(0, columnIndex, individual.getName());
            ++columnIndex;
        }
        int rowIndex = 1;
        for (Individual individual1 : individuals) {
            result.set(rowIndex, 0, individual1.getName());
            columnIndex = 1;
            for (Individual individual2 : individuals) {
                if (columnIndex >= rowIndex) break;
                String roles1AsString = "";
                String roles2AsString = "";
                for (String eventOrder : this.events.keySet()) {
                    Relation event = this.events.get(eventOrder);
                    Roles roles1 = event.actors().getRoles(individual1.getId());
                    Roles roles2 = event.actors().getRoles(individual2.getId());
                    if (roles1 == null || roles1.size() <= 0 || roles2 == null || roles2.size() <= 0) continue;
                    roles1AsString = String.valueOf(roles1AsString) + roles1.nameList().toString();
                    roles2AsString = String.valueOf(roles2AsString) + roles2.nameList().toString();
                }
                result.set(rowIndex, columnIndex, roles1AsString);
                result.set(columnIndex, rowIndex, roles2AsString);
                ++columnIndex;
            }
            ++rowIndex;
        }
        return result;
    }

    public void put(String order, Relation relation) {
        this.events.put(order, relation);
    }

    public Map<String, Relation> getEvents() {
        return this.events;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String hashKey() {
        return String.valueOf(this.id);
    }

    @Override
    public int compareTo(Sequence sequence) {
        throw new Error("Unresolved compilation problem: \n\tThe method compare(int, int) is undefined for the type Integer\n");
    }
}

