/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.segmentation;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.segmentation.FamilySegment;
import org.tip.puck.segmentation.IndividualSegment;
import org.tip.puck.segmentation.RelationSegment;
import org.tip.puck.segmentation.Segment;

public class Segments
extends ArrayList<Segment> {
    private static final long serialVersionUID = -3414487104570655587L;

    public Segment addSegment(Segment source, PartitionCriteria criteria) throws PuckException {
        if (source == null || criteria == null || StringUtils.isBlank((CharSequence)criteria.getRelationModelName())) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Segment result = criteria.getRelationModelName().equals(PartitionCriteria.RelationModelCanonicalNames.INDIVIDUAL.toString()) ? new IndividualSegment(source, criteria) : (criteria.getRelationModelName().equals(PartitionCriteria.RelationModelCanonicalNames.FAMILY.toString()) ? new FamilySegment(source, criteria) : new RelationSegment(source, criteria));
        this.add(result);
        return result;
    }
}

