/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.report;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableImage;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLSHelper {
    private static final Logger logger = LoggerFactory.getLogger(XLSHelper.class);
    private WritableWorkbook workbook;
    private int currentSheet;
    private int currentRow;
    private int currentColumn;

    public XLSHelper(WritableWorkbook source) {
        this.workbook = source;
        this.currentSheet = -1;
        this.currentRow = 0;
        this.currentColumn = 0;
    }

    public XLSHelper append(long source) throws RowsExceededException, WriteException, IndexOutOfBoundsException {
        this.workbook.getSheet(this.currentSheet).addCell((WritableCell)new Label(this.currentColumn, this.currentRow, String.valueOf(source)));
        ++this.currentColumn;
        return this;
    }

    public XLSHelper append(String source) throws RowsExceededException, WriteException, IndexOutOfBoundsException {
        if (source == null) {
            ++this.currentColumn;
        } else {
            String[] lines;
            String[] stringArray = lines = source.split("\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String[] tokens;
                String line = stringArray[n2];
                String[] stringArray2 = tokens = line.split("\t");
                int n3 = tokens.length;
                int n4 = 0;
                while (n4 < n3) {
                    String token = stringArray2[n4];
                    this.workbook.getSheet(this.currentSheet).addCell((WritableCell)new Label(this.currentColumn, this.currentRow, token));
                    ++this.currentColumn;
                    ++n4;
                }
                if (lines.length > 1) {
                    ++this.currentRow;
                    this.currentColumn = 0;
                }
                ++n2;
            }
        }
        return this;
    }

    public XLSHelper appendln() {
        ++this.currentRow;
        this.currentColumn = 0;
        return this;
    }

    public XLSHelper appendln(BufferedImage source) throws RowsExceededException, WriteException, IndexOutOfBoundsException {
        try {
            int columnSize = 5;
            int rowSize = (int)Math.round((double)(columnSize * 4) / 1.6);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)source, "PNG", baos);
            WritableImage image = new WritableImage(1.0, (double)this.currentRow, (double)columnSize, (double)rowSize, baos.toByteArray());
            this.workbook.getSheet(this.currentSheet).addImage(image);
            this.currentRow += rowSize;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.appendln("Sorry, error including image.");
        }
        return this;
    }

    public XLSHelper appendln(long source) throws RowsExceededException, WriteException, IndexOutOfBoundsException {
        this.append(source);
        this.appendln();
        return this;
    }

    public XLSHelper appendln(String source) throws RowsExceededException, WriteException, IndexOutOfBoundsException {
        this.append(source);
        this.appendln();
        return this;
    }

    public void newPage() {
        this.newPage(String.valueOf(this.currentSheet));
    }

    public void newPage(String name) {
        ++this.currentSheet;
        this.workbook.createSheet(name, this.currentSheet);
        this.currentRow = 0;
        this.currentColumn = 0;
    }
}

