/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.partitions;

import fr.devinsy.util.StringList;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.partitions.Intervals;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.Values;

public class PartitionCriteria {
    private String relationModelName;
    private String label;
    private String labelParameter;
    private PartitionType type;
    private String pattern;
    private Double start;
    private Double size;
    private Double count;
    private Double end;
    private Double min;
    private Double max;
    private Intervals intervals;
    private CumulationType cumulationType;
    private FamilyScope familyScope;
    private ValueFilter valueFilter;
    private SizeFilter sizeFilter;
    private Values values;

    public PartitionCriteria() {
        this.type = PartitionType.RAW;
        this.cumulationType = CumulationType.NONE;
        this.familyScope = FamilyScope.SOME;
        this.valueFilter = ValueFilter.NONE;
        this.sizeFilter = SizeFilter.NONE;
    }

    public PartitionCriteria(String label) {
        this.label = label;
        this.type = PartitionType.RAW;
        this.cumulationType = CumulationType.NONE;
        this.familyScope = FamilyScope.SOME;
        this.valueFilter = ValueFilter.NONE;
        this.sizeFilter = SizeFilter.NONE;
    }

    public Double getCount() {
        return this.count;
    }

    public CumulationType getCumulationType() {
        return this.cumulationType;
    }

    public Double getEnd() {
        return this.end;
    }

    public FamilyScope getFamilyScope() {
        return this.familyScope;
    }

    public Intervals getIntervals() {
        return this.intervals;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLabelParameter() {
        return this.labelParameter;
    }

    public Double getMax() {
        return this.max;
    }

    public Double getMin() {
        return this.min;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getRelationModelName() {
        return this.relationModelName;
    }

    public Double getSize() {
        return this.size;
    }

    public SizeFilter getSizeFilter() {
        return this.sizeFilter;
    }

    public Double getStart() {
        return this.start;
    }

    public PartitionType getType() {
        return this.type;
    }

    public ValueFilter getValueFilter() {
        return this.valueFilter;
    }

    public Values getValues() {
        return this.values;
    }

    public void setValues(Values values) {
        this.values = values;
    }

    public boolean isValid() {
        boolean result = !StringUtils.isBlank((CharSequence)this.label) && this.type != null;
        return result;
    }

    public void setCount(Double count) {
        this.count = count;
    }

    public void setCumulationType(CumulationType cumulationType) {
        this.cumulationType = cumulationType == null ? CumulationType.NONE : cumulationType;
    }

    public void setEnd(Double end) {
        this.end = end;
    }

    public void setFamilyScope(FamilyScope familyScope) {
        this.familyScope = familyScope == null ? FamilyScope.SOME : familyScope;
    }

    public void setIntervals(Intervals intervals) {
        this.intervals = intervals;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLabelParameter(String labelParameter) {
        this.labelParameter = labelParameter;
    }

    public void setMax(Double max) {
        this.max = max;
    }

    public void setMin(Double min) {
        this.min = min;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setRelationModelName(String relationModelName) {
        this.relationModelName = relationModelName;
    }

    public void setSize(Double size) {
        this.size = size;
    }

    public void setSizeFilter(SizeFilter sizeFilter) {
        this.sizeFilter = sizeFilter;
    }

    public void setStart(Double start) {
        this.start = start;
    }

    public void setType(PartitionType type) {
        this.type = type;
    }

    public void setValueFilter(ValueFilter valueFilter) {
        this.valueFilter = valueFilter;
    }

    public String toShortString() {
        StringList title = new StringList(20);
        if (StringUtils.isNotBlank((CharSequence)this.relationModelName)) {
            if (this.relationModelName.equals(RelationModelCanonicalNames.INDIVIDUAL.toString())) {
                title.append("Ind. ");
            } else if (this.relationModelName.equals(RelationModelCanonicalNames.FAMILY.toString())) {
                title.append("Fam. ");
            } else {
                title.append(this.relationModelName).append(" ");
            }
        }
        title.append(this.label);
        if (StringUtils.isNotBlank((CharSequence)this.labelParameter)) {
            title.append(" ").append(this.labelParameter);
        }
        if (this.type == PartitionType.BINARIZATION) {
            title.append(" ").append(this.pattern);
        } else if (this.type == PartitionType.FREE_GROUPING) {
            title.append(" ").append(this.intervals.toBasicStepString());
        } else if (this.type == PartitionType.COUNTED_GROUPING) {
            title.append(" ").append(MathUtils.toString(this.start)).append(",c").append(MathUtils.toString(this.count)).append(",").append(MathUtils.toString(this.end));
        } else if (this.type == PartitionType.SIZED_GROUPING) {
            title.append(" ").append(MathUtils.toString(this.start)).append(",s").append(MathUtils.toString(this.size)).append(",").append(MathUtils.toString(this.end));
        }
        if (this.getCumulationType() != CumulationType.NONE) {
            title.append(" ").append(this.getCumulationType().toString());
        }
        title.append(" ").append(this.familyScope.toString().toLowerCase());
        String result = title.toString();
        return result;
    }

    public String toString() {
        String result;
        switch (this.type) {
            case RAW: {
                result = String.format("type=%s,label=%s,parameter=%s,cumulation=%s,scope=%s", this.type.toString(), this.label, this.labelParameter, this.cumulationType.toString(), this.familyScope.toString());
                break;
            }
            case BINARIZATION: {
                result = String.format("type=%s,label=%s,parameter=%s,pattern=%s,cumulation=%s,scope=%s", this.type.toString(), this.label, this.labelParameter, this.pattern, this.cumulationType.toString(), this.familyScope.toString());
                break;
            }
            case FREE_GROUPING: {
                result = String.format("type=%s,label=%s,parameter=%s,steps=%s,cumulation=%s,scope=%s", this.type.toString(), this.label, this.labelParameter, this.intervals.toStepString(), this.cumulationType.toString(), this.familyScope.toString());
                break;
            }
            case COUNTED_GROUPING: {
                result = String.format("type=%s,label=%s,parameter=%s,start=%s,count=%s,end=%s,cumulation=%s,scope=%s", this.type.toString(), this.label, this.labelParameter, String.valueOf(this.start), String.valueOf(this.count), String.valueOf(this.end), this.cumulationType.toString(), this.familyScope.toString());
                break;
            }
            case SIZED_GROUPING: {
                result = String.format("type=%s,label=%s,parameter=%s,start=%s,size=%s,end=%s,cumulation=%s,scope=%s", this.type.toString(), this.label, this.labelParameter, String.valueOf(this.start), String.valueOf(this.size), String.valueOf(this.end), this.cumulationType.toString(), this.familyScope.toString());
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    public static PartitionCriteria createBinarization(String label, String labelParameter, String pattern) {
        PartitionCriteria result = new PartitionCriteria();
        result.setType(PartitionType.BINARIZATION);
        result.setLabel(label);
        result.setLabelParameter(labelParameter);
        result.setPattern(pattern);
        return result;
    }

    public static PartitionCriteria createCountedGrouping(String label, String labelParameter, Double start, Double count, Double end) {
        PartitionCriteria result = new PartitionCriteria();
        result.setType(PartitionType.COUNTED_GROUPING);
        result.setLabel(label);
        result.setLabelParameter(labelParameter);
        result.setStart(start);
        result.setCount(count);
        result.setEnd(end);
        return result;
    }

    public static PartitionCriteria createGrouping(String label, String steps) {
        PartitionCriteria result = PartitionCriteria.createGrouping(label, null, PartitionMaker.getIntervals(steps));
        return result;
    }

    public static PartitionCriteria createGrouping(String label, String labelParameter, Intervals intervals) {
        PartitionCriteria result = new PartitionCriteria();
        result.setType(PartitionType.FREE_GROUPING);
        result.setLabel(label);
        result.setLabelParameter(labelParameter);
        result.setIntervals(intervals);
        return result;
    }

    public static PartitionCriteria createGrouping(String label, String labelParameter, String steps) {
        PartitionCriteria result = PartitionCriteria.createGrouping(label, labelParameter, PartitionMaker.getIntervals(steps));
        return result;
    }

    public static PartitionCriteria createRaw(String label) {
        PartitionCriteria result = PartitionCriteria.createRaw(label, null);
        return result;
    }

    public static PartitionCriteria createRaw(String label, String labelParameter) {
        PartitionCriteria result = new PartitionCriteria();
        result.setType(PartitionType.RAW);
        result.setLabel(label);
        result.setLabelParameter(labelParameter);
        return result;
    }

    public static PartitionCriteria createSizedGrouping(String label, String labelParameter, Double start, Double size, Double end) {
        PartitionCriteria result = new PartitionCriteria();
        result.setType(PartitionType.SIZED_GROUPING);
        result.setLabel(label);
        result.setLabelParameter(labelParameter);
        result.setStart(start);
        result.setSize(size);
        result.setEnd(end);
        return result;
    }

    public static enum CumulationType {
        NONE,
        ASCENDANT,
        DESCENDANT;

    }

    public static enum FamilyScope {
        ALL,
        SOME;

    }

    public static enum PartitionType {
        RAW,
        BINARIZATION,
        FREE_GROUPING,
        SIZED_GROUPING,
        COUNTED_GROUPING,
        PARTIALIZATION;

    }

    public static enum RelationModelCanonicalNames {
        INDIVIDUAL,
        FAMILY;

    }

    public static enum SizeFilter {
        NONE,
        TRIM,
        EMPTY,
        HOLES;

    }

    public static enum ValueFilter {
        NONE,
        NULL,
        ZERO;

    }
}

