/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net;

import java.util.HashMap;
import java.util.Map;
import oldcore.calc.partitions.Clusterable;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.Families;
import org.tip.puck.net.Family;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Gender;
import org.tip.puck.net.IndividualComparator;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.KinType;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.statistics.StatisticsWorker;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.NumberedIntegers;
import org.tip.puck.util.Trafo;

public class Individual
implements Comparable<Individual>,
Numberable,
Clusterable {
    private int id;
    private Gender gender;
    private String name;
    private Family originFamily;
    private final Families personalFamilies;
    private final Attributes attributes;
    private final Relations relations2;
    private Map<String, Individuals> relations;
    private Integer birthOrder;

    public Individual(int id) {
        this.id = id;
        this.gender = Gender.UNKNOWN;
        this.personalFamilies = new Families();
        this.relations2 = new Relations();
        this.attributes = new Attributes();
    }

    public Individual(int id, String name, Gender gender) {
        this.id = id;
        this.setName(name);
        this.gender = gender == null ? Gender.UNKNOWN : gender;
        this.personalFamilies = new Families();
        this.relations2 = new Relations();
        this.attributes = new Attributes();
    }

    public void addPersonalFamily(Family family) {
        this.personalFamilies.add(family);
    }

    public void addRelation(String label, Individual alter) {
        if (this.relations == null) {
            this.relations = new HashMap<String, Individuals>();
        }
        if (this.relations.get(label) == null) {
            this.relations.put(label, new Individuals());
        }
        this.relations.get(label).add(alter);
    }

    public void adjust(Individual other) {
        this.name = other.getName();
        this.gender = other.getGender();
        for (Attribute attribute : other.attributes().values()) {
            this.attributes.put(attribute.getLabel(), new Attribute(attribute.getLabel(), attribute.getValue()));
        }
    }

    public Attributes attributes() {
        return this.attributes;
    }

    public Individuals bilateralCousins(FiliationType filiation, boolean cross) {
        Individuals result = new Individuals();
        for (Individual paternal : this.firstCousins(Gender.MALE, filiation, cross)) {
            for (Individual maternal : this.firstCousins(Gender.FEMALE, filiation, cross)) {
                if (!paternal.equals(maternal)) continue;
                result.add(paternal);
            }
        }
        return result;
    }

    public Individual clone() {
        Individual result = new Individual(this.id, this.name, this.gender);
        return result;
    }

    public Individual cloneWithAttributes() {
        Individual result = new Individual(this.id, this.name, this.gender);
        for (Attribute attribute : this.attributes().values()) {
            result.attributes().put(attribute.getLabel(), new Attribute(attribute.getLabel(), attribute.getValue()));
        }
        return result;
    }

    @Override
    public int compareTo(Individual other) {
        int result = other == null ? 1 : new Integer(this.getId()).compareTo(other.getId());
        return result;
    }

    public Individuals coSpouses() {
        Individuals result = new Individuals();
        for (Individual spouse : this.getSpouses()) {
            for (Individual coSpouse : spouse.getSpouses()) {
                if (coSpouse == this) continue;
                result.add(coSpouse);
            }
        }
        return result;
    }

    public Individuals crossSexCousins(FiliationType type) {
        Individuals result = new Individuals();
        for (Individual parent : this.getParents()) {
            if (!parent.hasLinkingGender(type)) continue;
            for (Individual grandparent : parent.getParents()) {
                if (!grandparent.hasLinkingGender(type) || grandparent.isSterile()) continue;
                for (Individual oblique : grandparent.getChildren()) {
                    if (!oblique.hasLinkingGender(type) || oblique == parent || oblique.isSterile()) continue;
                    for (Individual cousin : oblique.getChildren()) {
                        if (cousin.getGender() == this.getGender()) continue;
                        result.put(cousin);
                    }
                }
            }
        }
        return result;
    }

    public int depth() {
        int result = StatisticsWorker.depth(this, new NumberedIntegers(1000), FiliationType.COGNATIC);
        return result;
    }

    public Individuals doubleCrossCousins(Gender gender, FiliationType filiation) {
        Individuals result = new Individuals();
        for (Individual cousin : this.firstCousins(gender.invert(), FiliationType.COGNATIC, true)) {
            Individual otherGrandParent = this.getParent(gender.invert()).getParent(filiation);
            Individual cousinsOtherGrandParent = cousin.getParent(gender).getParent(filiation);
            for (Individual grandOblique : otherGrandParent.siblings(FiliationType.COGNATIC)) {
                if (!grandOblique.equals(cousinsOtherGrandParent)) continue;
                result.add(cousin);
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = obj != null && this.getId() == ((Individual)obj).getId();
        return result;
    }

    public Individuals firstCousins() {
        Individuals result = new Individuals();
        for (Individual parent : this.getParents()) {
            for (Individual auntOrUncle : parent.siblings()) {
                for (Individual cousin : auntOrUncle.getChildren()) {
                    result.add(cousin);
                }
            }
        }
        return result;
    }

    public Individuals firstCousins(Gender parentGender, FiliationType filiation, boolean cross) {
        Individuals result = new Individuals();
        Individual parent = this.getParent(parentGender);
        if (parent != null) {
            for (Individual auntOrUncle : parent.siblings(filiation)) {
                if (auntOrUncle.getGender() != parentGender != cross && auntOrUncle.isSterile()) continue;
                for (Individual cousin : auntOrUncle.getChildren()) {
                    result.add(cousin);
                }
            }
        }
        return result;
    }

    public Individuals fullSameSexSiblings() {
        Individuals result = this.originFamily.getChildren(this.getGender());
        result.removeById(this.getId());
        return result;
    }

    public Individuals fullSiblings() {
        Individuals result = this.originFamily.getChildren();
        result.removeById(this.getId());
        return result;
    }

    public Families getActiveUnionsAt(int year) {
        Families result = new Families();
        for (Family family : this.personalFamilies) {
            if (!family.isActiveAt(year)) continue;
            result.add(family);
        }
        return result;
    }

    @Override
    public String getAttributeValue(String label) {
        String result = this.attributes.getValue(label);
        return result;
    }

    public Integer getBirthOrder() {
        return this.birthOrder;
    }

    public Individuals getChildren() {
        Individuals result = this.personalFamilies.children();
        return result;
    }

    public Individual getFather() {
        Individual result = this.originFamily == null ? null : this.originFamily.getFather();
        return result;
    }

    public String getFirstName() {
        int slashIndex;
        String result = this.name == null ? null : ((slashIndex = this.name.indexOf(47)) == -1 ? this.name.trim() : this.name.substring(0, slashIndex).trim());
        return result;
    }

    public Gender getGender() {
        Gender result = this.gender;
        return result;
    }

    @Override
    public int getId() {
        int result = this.id;
        return result;
    }

    public Individuals getInlaws(FiliationType filiation) {
        Individuals result = new Individuals();
        for (Individual sibling : this.siblings(filiation)) {
            if (sibling.hasLinkingGender(filiation)) continue;
            for (Individual inLaw : sibling.getSpouses()) {
                result.add(inLaw);
            }
        }
        for (Individual spouse : this.getSpouses()) {
            for (Individual inLaw : spouse.siblings(filiation)) {
                result.add(inLaw);
            }
        }
        return result;
    }

    public Individuals getKin() {
        Individuals result = new Individuals();
        for (KinType type : KinType.basicTypes()) {
            result.add(this.getKin(type));
        }
        return result;
    }

    @Deprecated
    public Individuals getKin(int key) {
        Individuals result;
        switch (key) {
            case -1: {
                result = this.getChildren();
                break;
            }
            case 0: {
                result = this.getSpouses();
                break;
            }
            case 1: {
                result = this.getParents();
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public Individuals getKin(KinType type) {
        Individuals result;
        switch (type) {
            case CHILD: {
                result = this.getChildren();
                break;
            }
            case SPOUSE: {
                result = this.getSpouses();
                break;
            }
            case PARENT: {
                result = this.getParents();
                break;
            }
            default: {
                result = new Individuals();
            }
        }
        return result;
    }

    public Individuals getKin(KinType kinType, FiliationType filiationType) {
        Individuals result;
        switch (kinType) {
            case CHILD: {
                if (filiationType.hasLinkingGender(this.gender)) {
                    result = this.getChildren();
                    break;
                }
                result = new Individuals();
                break;
            }
            case SPOUSE: {
                result = this.getSpouses();
                break;
            }
            case PARENT: {
                if (filiationType == FiliationType.COGNATIC) {
                    result = this.getParents();
                    break;
                }
                result = new Individuals();
                if (filiationType == FiliationType.AGNATIC) {
                    result.add(this.getFather());
                    break;
                }
                if (filiationType != FiliationType.UTERINE) break;
                result.add(this.getMother());
                break;
            }
            default: {
                result = new Individuals();
            }
        }
        return result;
    }

    public Individual getKin(KinType type, IndividualComparator.Sorting sorting, int order) {
        Individual result = null;
        Individuals kin = this.getKin(type);
        if (order <= kin.size()) {
            result = kin.toSortedList(sorting).get(order - 1);
        }
        return result;
    }

    public String getLastName() {
        String result;
        if (this.name == null) {
            result = null;
        } else {
            int slashIndex = this.name.indexOf(47);
            if (slashIndex == -1) {
                result = null;
            } else {
                result = this.name.substring(slashIndex + 1).replaceAll("/", " ").trim();
                if (result.length() == 0) {
                    result = null;
                }
            }
        }
        return result;
    }

    public Individuals getMarriedSpouses() {
        Individuals result = this.personalFamilies.marriedSpouses(this);
        return result;
    }

    public Individual getMother() {
        Individual result = this.originFamily == null ? null : this.originFamily.getMother();
        return result;
    }

    public String getName() {
        String result = this.name;
        return result;
    }

    public String getNamePart(int subnames) {
        String result;
        if (subnames == 0) {
            result = this.name;
        } else {
            String[] splitName = this.name.split("\\/");
            result = "";
            int i = 0;
            while (i < Math.min(subnames, splitName.length)) {
                result = String.valueOf(result) + " " + splitName[i];
                ++i;
            }
        }
        result = Trafo.trim(result);
        return result;
    }

    public String getNameTrimmed() {
        String result = this.name;
        if (result != null) {
            result = result.trim();
        }
        return result;
    }

    public Family getOriginFamily() {
        return this.originFamily;
    }

    public Individual getOtherParent(Individual parent) {
        Individual result = this.originFamily == null ? null : this.originFamily.getOtherParent(parent);
        return result;
    }

    public Individual getParent(FiliationType filiation) {
        Individual result = null;
        switch (filiation) {
            case AGNATIC: {
                result = this.getFather();
                break;
            }
            case UTERINE: {
                result = this.getMother();
            }
        }
        return result;
    }

    public Individual getParent(Gender gender) {
        Individual result = null;
        switch (gender) {
            case MALE: {
                result = this.getFather();
                break;
            }
            case FEMALE: {
                result = this.getMother();
            }
        }
        return result;
    }

    @Deprecated
    public Individual getParent(int key) {
        Individual result = null;
        switch (key) {
            case 0: {
                result = this.getFather();
            }
            case 1: {
                result = this.getMother();
            }
        }
        return result;
    }

    public Individuals getParents() {
        Individuals result = new Individuals();
        if (this.originFamily != null) {
            if (this.originFamily.getHusband() != null) {
                result.add(this.originFamily.getHusband());
            }
            if (this.originFamily.getWife() != null) {
                result.add(this.originFamily.getWife());
            }
        }
        return result;
    }

    public Individuals getParents(FiliationType line) {
        Individuals result = new Individuals();
        if (this.originFamily != null) {
            if (line.hasLinkingGender(Gender.MALE) && this.originFamily.getHusband() != null) {
                result.add(this.originFamily.getHusband());
            }
            if (line.hasLinkingGender(Gender.FEMALE) && this.originFamily.getWife() != null) {
                result.add(this.originFamily.getWife());
            }
        }
        return result;
    }

    public Individuals getPartners() {
        Individuals result = this.personalFamilies.getPartners(this);
        return result;
    }

    public Families getPersonalFamilies() {
        return this.personalFamilies;
    }

    public Individuals getRelated() {
        Individuals result = new Individuals();
        for (Relation relation : this.relations()) {
            for (Individual individual : relation.getIndividuals()) {
                if (individual == this) continue;
                result.put(individual);
            }
        }
        return result;
    }

    public Individuals getRelated(String relationType) {
        Individuals result = new Individuals();
        for (Relation relation : this.relations()) {
            if (!relation.getModel().getName().equals("relationType")) continue;
            for (Individual individual : relation.getIndividuals()) {
                if (individual == this) continue;
                result.put(individual);
            }
        }
        return result;
    }

    public Individuals getSpouses() {
        Individuals result = this.getUnions(true).getPartners(this);
        return result;
    }

    public Individuals getSpousesAt(int year) {
        Individuals result = this.getActiveUnionsAt(year).getPartners(this);
        return result;
    }

    public String getTrimmedName() {
        String result = this.name == null ? null : this.name.trim();
        return result;
    }

    public Families getUnions(boolean married) {
        Families result = new Families();
        for (Family family : this.personalFamilies) {
            if (!family.isMarried() && married) continue;
            result.add(family);
        }
        return result;
    }

    @Override
    public String hashKey() {
        return String.valueOf(this.id);
    }

    public boolean hasLinkingGender(FiliationType type) {
        boolean result;
        switch (type) {
            case COGNATIC: {
                result = true;
                break;
            }
            case AGNATIC: {
                result = this.isMale();
                break;
            }
            case UTERINE: {
                result = this.isFemale();
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public int height() {
        int result = this.height(new NumberedIntegers(1000));
        return result;
    }

    public int height(NumberedIntegers depthData) {
        int result;
        Individuals children = this.getChildren();
        if (children.size() == 0) {
            result = 0;
        } else {
            result = 0;
            for (Individual child : children) {
                Integer childDepth = (Integer)depthData.get(child.getId());
                if (childDepth == null) {
                    childDepth = child.height(depthData);
                    depthData.put(child.getId(), childDepth);
                }
                result = Math.max(result, childDepth);
            }
            ++result;
        }
        return result;
    }

    public boolean isFemale() {
        boolean result = this.gender.isFemale();
        return result;
    }

    public boolean isFertile() {
        boolean result = this.personalFamilies.containsChild();
        return result;
    }

    public boolean isHalfOrphan() {
        boolean result = this.originFamily != null && (this.originFamily.getHusband() == null || this.originFamily.getWife() == null);
        return result;
    }

    public boolean isMale() {
        boolean result = this.gender.isMale();
        return result;
    }

    public boolean isNotOrphan() {
        boolean result = !this.isOrphan();
        return result;
    }

    public boolean isNotOrphanOfFather() {
        boolean result = !this.isOrphanOfFather();
        return result;
    }

    public boolean isNotOrphanOfMother() {
        boolean result = !this.isOrphanOfMother();
        return result;
    }

    public boolean isNotPartnerWith(Individual source) {
        boolean result = !this.isPartnerWith(source);
        return result;
    }

    public boolean isNotSingle() {
        boolean result = !this.isSingle();
        return result;
    }

    public boolean isOrphan() {
        boolean result = this.originFamily == null || this.originFamily.isOrphan();
        return result;
    }

    public boolean isOrphanOfFather() {
        boolean result = this.originFamily == null || this.originFamily.getFather() == null && this.originFamily.getMother() != null;
        return result;
    }

    public boolean isOrphanOfMother() {
        boolean result = this.originFamily == null || this.originFamily.getFather() != null && this.originFamily.getMother() == null;
        return result;
    }

    public boolean isParent(Individual parent) {
        boolean result = this.originFamily == null ? false : this.originFamily.isParent(parent);
        return result;
    }

    public boolean isPartnerWith(Individual source) {
        Family target = this.personalFamilies.getBySpouses(this, source);
        boolean result = target != null;
        return result;
    }

    public boolean isSingle() {
        boolean result = this.getUnions(true).size() == 0;
        return result;
    }

    public boolean isSingle(String relationType) {
        boolean result = relationType.equals("SPOUSE") ? this.getUnions(true).size() == 0 : this.getUnions(false).size() == 0;
        return result;
    }

    public boolean isSterile() {
        boolean result = !this.personalFamilies.containsChild();
        return result;
    }

    public boolean isUnknown() {
        boolean result = this.gender.isUnknown();
        return result;
    }

    public Individuals obliqueCousins(Gender gender) {
        Individuals result = new Individuals();
        for (Individual crossCousin : this.firstCousins(gender.invert(), FiliationType.COGNATIC, true)) {
            for (Individual oblique : this.obliques(gender, gender.invert(), FiliationType.COGNATIC)) {
                if (!crossCousin.equals(oblique) || result.contains(crossCousin)) continue;
                result.add(crossCousin);
            }
            if (!crossCousin.equals(this.getParent(gender)) || result.contains(crossCousin)) continue;
            result.add(crossCousin);
        }
        return result;
    }

    public Individuals obliques(FiliationType filiation) {
        Individuals result = new Individuals();
        for (Individual sibling : this.siblings(filiation)) {
            if (!sibling.hasLinkingGender(filiation)) continue;
            for (Individual auntOrUncle : sibling.getChildren()) {
                result.add(auntOrUncle);
            }
        }
        return result;
    }

    public Individuals obliques(Gender parentGender, Gender alterGender, FiliationType filiation) {
        Individuals result = new Individuals();
        Individual parent = this.getParent(parentGender);
        if (parent != null) {
            for (Individual auntOrUncle : parent.siblings(filiation)) {
                if (auntOrUncle.getGender() == alterGender) continue;
                result.add(auntOrUncle);
            }
        }
        return result;
    }

    public Relations relations() {
        Relations result = this.relations2;
        return result;
    }

    @Override
    public void setAttribute(Attribute attribute) {
    }

    public void setAttribute(String label, String value) {
        this.attributes.put(label, value);
    }

    public void setBirthOrder(Integer order) {
        this.birthOrder = order == null || order < 1 ? null : order;
    }

    public void setFirstName(String value) {
        this.setName(value, this.getLastName());
    }

    public void setGender(Gender value) {
        this.gender = value == null ? Gender.UNKNOWN : value;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public void setLastName(String value) {
        this.setName(this.getFirstName(), value);
    }

    public boolean setMinimalAttributeValue(String label, String value) {
        boolean result = false;
        String oldStringValue = this.getAttributeValue(label);
        if (oldStringValue == null || Integer.parseInt(oldStringValue) > Integer.parseInt(value)) {
            this.setAttribute(label, value);
            result = true;
        }
        return result;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public void setName(String firstName, String lastName) {
        String newName = firstName == null ? (StringUtils.isBlank((CharSequence)lastName) ? "" : "/" + lastName.trim()) : (StringUtils.isBlank((CharSequence)lastName) ? firstName.trim() : String.valueOf(firstName.trim()) + "/" + lastName.trim());
        this.name = newName;
    }

    public void setOriginFamily(Family family) {
        this.originFamily = family;
    }

    public Individuals siblingCousins(FiliationType filiation) {
        Individuals result = new Individuals();
        FiliationType otherFiliation = filiation.invert();
        Individual otherParent = this.getParent(otherFiliation);
        if (otherParent != null) {
            for (Individual sibling : this.siblings(filiation)) {
                Individual stepParent = sibling.getParent(otherFiliation);
                if (!otherParent.siblings(filiation).contains(stepParent)) continue;
                result.add(sibling);
            }
        }
        return result;
    }

    public Individuals siblings() {
        Individuals result = new Individuals();
        for (Individual parent : this.getParents()) {
            for (Individual sibling : parent.getChildren()) {
                result.add(sibling);
            }
        }
        return result;
    }

    public Individuals siblings(FiliationType filiation) {
        Individuals result = new Individuals();
        for (Individual parent : this.getParents()) {
            if (!parent.hasLinkingGender(filiation)) continue;
            for (Individual sibling : parent.getChildren()) {
                if (sibling == this) continue;
                result.add(sibling);
            }
        }
        return result;
    }

    public String signature() {
        String result = String.valueOf(this.id) + " " + this.name;
        return result;
    }

    public String toString() {
        String result = String.valueOf(this.getTrimmedName()) + " (" + this.id + ")";
        return result;
    }
}

