/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.selz;

import java.io.File;
import java.security.InvalidParameterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.io.selz.SELZODSFile;
import org.tip.puck.io.selz.SELZTXTFile;
import org.tip.puck.io.selz.SELZXLSFile;
import org.tip.puck.net.Net;

public class SELZFile {
    private static final Logger logger = LoggerFactory.getLogger(SELZFile.class);

    public static Net load(File source, String charsetName) throws PuckException {
        Net result;
        if (source == null) {
            throw new InvalidParameterException("Null parameter");
        }
        String fileName = source.getName().toLowerCase();
        if (fileName.endsWith(".ods")) {
            result = SELZODSFile.load(source);
        } else if (fileName.endsWith(".txt")) {
            result = SELZTXTFile.load(source, charsetName);
        } else if (fileName.endsWith(".xls")) {
            result = SELZXLSFile.load(source);
        } else {
            throw new InvalidParameterException("Unknown extension.");
        }
        return result;
    }

    public static void save(File target, Net source) throws PuckException {
        if (source == null) {
            throw new InvalidParameterException("Null parameter");
        }
        String fileName = target.getName().toLowerCase();
        if (fileName.endsWith(".ods")) {
            SELZODSFile.save(target, source);
        } else if (fileName.endsWith(".txt")) {
            SELZTXTFile.save(target, source);
        } else if (fileName.endsWith(".xls")) {
            SELZXLSFile.save(target, source);
        } else {
            throw new InvalidParameterException("Unknown extension.");
        }
    }
}

