/*
 * Decompiled with CFR 0.152.
 */
package oldcore.calc.network;

import java.util.Arrays;
import org.tip.puck.net.Individual;
import org.tip.puck.net.KinType;

public class Edge {
    private Individual alter;
    private Individual ego;
    private KinType type;

    private Edge() {
    }

    public Edge(Individual v, Individual w, KinType i) {
        this.ego = v;
        this.alter = w;
        this.type = i;
    }

    public Edge(Individual v, Individual w, int i, boolean sym) {
        if (sym || v.getId() < w.getId()) {
            this.ego = v;
            this.alter = w;
            this.type = this.type(i, 1);
        } else {
            this.ego = w;
            this.alter = v;
            this.type = this.type(i, -1);
        }
    }

    public Edge(Individual v, Individual w, KinType kinType, boolean sym) {
        if (sym || v.getId() < w.getId()) {
            this.ego = v;
            this.alter = w;
            this.type = kinType;
        } else {
            this.ego = w;
            this.alter = v;
            this.type = kinType.inverse();
        }
        System.out.println(String.valueOf(this.ego.signature()) + " " + this.alter.signature() + " " + (Object)((Object)this.type));
    }

    public boolean equals(Object o) {
        return Arrays.equals(this.getKey(), ((Edge)o).getKey());
    }

    public Individual getAlter() {
        return this.alter;
    }

    public Individual getEgo() {
        return this.ego;
    }

    private int[] getKey() {
        int[] key = new int[]{this.ego.getId(), this.alter.getId()};
        return key;
    }

    public int getMode() {
        if (this.type == KinType.SPOUSE) {
            return 0;
        }
        return 1;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getKey());
    }

    private Edge inverse() {
        Edge e = new Edge();
        e.ego = this.alter;
        e.alter = this.ego;
        e.type = this.invType();
        return e;
    }

    public Edge inverse(Individual v) {
        if (v == this.alter) {
            return this.inverse();
        }
        return this;
    }

    private KinType invType() {
        KinType result;
        switch (this.type) {
            case SPOUSE: {
                result = KinType.SPOUSE;
                break;
            }
            case CHILD: {
                result = KinType.PARENT;
                break;
            }
            case PARENT: {
                result = KinType.CHILD;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private KinType type(int i, int k) {
        if (i == 0) {
            return KinType.SPOUSE;
        }
        if (i == k) {
            if (this.alter.isMale()) {
                return KinType.FATHER;
            }
            if (this.alter.isFemale()) {
                return KinType.MOTHER;
            }
        }
        return KinType.CHILD;
    }

    public KinType getType() {
        return this.type;
    }
}

