package org.tip.puckgui.views;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingConstants;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Net;
import org.tip.puck.net.random.RandomNetMaker;
import org.tip.puck.net.workers.NetReporter;
import org.tip.puck.report.Report;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.views.mas.CousinsWeightFactor;
import org.tip.puckgui.views.mas.Divorce2WeightFactor;
import org.tip.puckgui.views.mas.DivorceWeightFactor;
import org.tip.puckgui.views.mas.NormalAgeDifferenceWeightFactor;
import org.tip.puckgui.views.mas.NormalAgeWeightFactor;
import org.tip.puckgui.views.mas.PregnancyWeightFactor;
import org.tip.puckgui.views.mas.WeightFactor;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;

/**
 * 
 * @author TIP
 */
public class RandomCorpusMASInputWindow extends JFrame {

	static private final Logger logger = LoggerFactory.getLogger(RandomCorpusMASInputWindow.class);

	private static final long serialVersionUID = -6113524443785800524L;

	private JFrame thisJFrame;
	private JPanel contentPane;
	private JSpinner spnrInitialPopulation;
	private JSpinner spnrFertilityRate;
	private JSpinner spnrMaxAge;
	private JSpinner spnrYear;
	private JSpinner spnrDivorceProbability;
	private JCheckBox chckbxDivorce;
	private JCheckBox chckbxDivorce2;
	private JCheckBox chckbxNormalAgeFemale;
	private JCheckBox chckbxNormalAgeMale;
	private JCheckBox chckbxNormalAgeUnknown;
	private JCheckBox chckbxNormalAgeDifference;
	private JCheckBox chckbxCousins;
	private JCheckBox chckbxPregnancy;
	private JPanel panelDivorce;
	private JPanel panelDivorce2;
	private JPanel panelNormalAgeDifference;
	private JPanel panelCousins;
	private JPanel panelPregnancy;
	private JPanel panelNormalAgeMale;
	private JPanel panelNormalAgeUnknown;
	private JPanel panelNormalAgeFemale;
	private JSpinner spnrNormalAgeDifferenceStdev;
	private JSpinner spnrNormalAgeDifferenceMean;
	private JSpinner spnrNormalAgeMaleMean;
	private JSpinner spnrNormalAgeMaleStdev;
	private JSpinner spnrNormalAgeFemaleMean;
	private JSpinner spnrNormalAgeFemaleStdev;
	private JSpinner spnrFemaleDivorceWeight;
	private JSpinner spnrMaleDivorceWeight;
	private JSpinner spnrBothDivorceWeight;
	private JSpinner spnrCousinsCharlie;
	private JSpinner spnrPregnancyAlpha;
	private JSpinner spnrNormalAgeUnknownMean;
	private JSpinner spnrNormalAgeUnknownStdev;
	private JSpinner spnrCousinsAlpha;
	private JSpinner spnrCousinsBravo;
	private JLabel lblChildren;
	private JCheckBox chckbxChildren;
	private JPanel panelChildren;
	private JLabel label_12;
	private JSpinner spinner;

	/**
	 * Similar with VirtualFielworkInputWindow.
	 */
	public RandomCorpusMASInputWindow(final NetGUI gui) {

		// /////////////////////////////////
		setIconImage(Toolkit.getDefaultToolkit().getImage(RandomCorpusMASInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));

		this.thisJFrame = this;
		setTitle("Random Corpus");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 676, 657);
		setLocationRelativeTo(null);

		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(new BorderLayout(0, 0));

		JPanel buttonPanel = new JPanel();
		contentPane.add(buttonPanel, BorderLayout.SOUTH);

		JButton btnCancel = new JButton("Cancel");
		btnCancel.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Close.
				dispose();
			}
		});

		JButton btnRestoreDefaults = new JButton("Restore defaults");
		btnRestoreDefaults.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Restore Defaults.
				setDefaultCriteria();
			}
		});
		buttonPanel.add(btnRestoreDefaults);
		buttonPanel.add(btnCancel);

		JButton btnLaunch = new JButton("Launch");
		getRootPane().setDefaultButton(btnLaunch);
		btnLaunch.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Launch.
				try {
					//
					RandomCorpusCriteria criteria = getCriteria();

					//
					PuckGUI.instance().getPreferences().setRandomCorpusCriteria(criteria);
					criteria.setMas(true);
					//

					RandomNetMaker randomNetMaker = new RandomNetMaker(criteria);
					Net targetNet = randomNetMaker.createRandomMASNet();

					// Build report.
					Report report = NetReporter.reportRandomCorpusMAS(criteria, randomNetMaker.getMas(), targetNet);

					//
					NetGUI newGUI = PuckGUI.instance().createNetGUI(new File(targetNet.getLabel()), targetNet);
					newGUI.addReportTab(report);

					//
					dispose();

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(thisJFrame, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		buttonPanel.add(btnLaunch);

		JPanel panel = new JPanel();
		panel.setBorder(new TitledBorder(null, "Simulation parameters", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		contentPane.add(panel, BorderLayout.NORTH);
		panel.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("100dlu"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, }));

		JLabel lblYear = new JLabel("Year:");
		lblYear.setHorizontalAlignment(SwingConstants.CENTER);
		panel.add(lblYear, "2, 2, right, default");

		spnrYear = new JSpinner();
		spnrYear.setModel(new SpinnerNumberModel(new Integer(300), new Integer(1), null, new Integer(1)));
		panel.add(spnrYear, "4, 2");

		JLabel lblInitialPopulation = new JLabel("Initial population:");
		panel.add(lblInitialPopulation, "2, 4, right, default");

		spnrInitialPopulation = new JSpinner();
		spnrInitialPopulation.setModel(new SpinnerNumberModel(new Integer(100), new Integer(1), null, new Integer(1)));
		panel.add(spnrInitialPopulation, "4, 4");

		spnrFertilityRate = new JSpinner();
		spnrFertilityRate.setModel(new SpinnerNumberModel(new Double(2.), new Double(0.0), new Double(100.0), new Double(1.)));
		((JSpinner.NumberEditor) spnrFertilityRate.getEditor()).getFormat().setMinimumFractionDigits(5);

		JLabel lblFertilityRate = new JLabel("Fertility rate:");
		panel.add(lblFertilityRate, "2, 6, right, default");
		panel.add(spnrFertilityRate, "4, 6");

		JLabel lblMaxAge = new JLabel("Max. age:");
		panel.add(lblMaxAge, "2, 8, right, default");

		spnrMaxAge = new JSpinner();
		spnrMaxAge.setModel(new SpinnerNumberModel(new Integer(70), new Integer(1), null, new Integer(1)));
		panel.add(spnrMaxAge, "4, 8");

		JPanel panel_3 = new JPanel();
		contentPane.add(panel_3, BorderLayout.CENTER);
		panel_3.setLayout(new BoxLayout(panel_3, BoxLayout.Y_AXIS));

		JPanel panel_1 = new JPanel();
		panel_3.add(panel_1);

		JPanel panelWeightFactors = new JPanel();
		panel_3.add(panelWeightFactors);
		panelWeightFactors.setBorder(new TitledBorder(null, "Weight factors", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelWeightFactors.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), },
				new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
						FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
						FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
						FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
						FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode("default:grow"), FormFactory.RELATED_GAP_ROWSPEC, }));

		JLabel lblDivorce = new JLabel("Divorce");
		panelWeightFactors.add(lblDivorce, "2, 2");

		chckbxDivorce = new JCheckBox("");
		chckbxDivorce.setSelected(true);
		chckbxDivorce.addItemListener(new ItemListener() {
			@Override
			public void itemStateChanged(final ItemEvent e) {
				//
				panelDivorce.setVisible(chckbxDivorce.isSelected());
			}
		});
		panelWeightFactors.add(chckbxDivorce, "4, 2");

		panelDivorce = new JPanel();
		panelDivorce.setEnabled(false);
		panelWeightFactors.add(panelDivorce, "6, 2, fill, fill");
		panelDivorce.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("50dlu"), },
				new RowSpec[] { FormFactory.DEFAULT_ROWSPEC, }));

		JLabel label = new JLabel("Probability:");
		panelDivorce.add(label, "1, 1");

		spnrDivorceProbability = new JSpinner();
		spnrDivorceProbability.setModel(new SpinnerNumberModel(new Double(0.01), new Double(0.0), new Double(1.0), new Double(0.01)));
		((JSpinner.NumberEditor) spnrDivorceProbability.getEditor()).getFormat().setMinimumFractionDigits(3);
		panelDivorce.add(spnrDivorceProbability, "3, 1");

		JLabel lblDivorce_1 = new JLabel("Divorce2");
		panelWeightFactors.add(lblDivorce_1, "2, 4");

		chckbxDivorce2 = new JCheckBox("");
		chckbxDivorce2.setSelected(true);
		chckbxDivorce2.addItemListener(new ItemListener() {
			@Override
			public void itemStateChanged(final ItemEvent e) {
				//
				panelDivorce2.setVisible(chckbxDivorce2.isSelected());
			}
		});
		panelWeightFactors.add(chckbxDivorce2, "4, 4");

		panelDivorce2 = new JPanel();
		panelWeightFactors.add(panelDivorce2, "6, 4, fill, fill");
		panelDivorce2.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("50dlu"),
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("50dlu"),
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("50dlu"), },
				new RowSpec[] { FormFactory.DEFAULT_ROWSPEC, }));

		JLabel label_1 = new JLabel("Female:");
		panelDivorce2.add(label_1, "1, 1");

		spnrFemaleDivorceWeight = new JSpinner();
		spnrFemaleDivorceWeight.setModel(new SpinnerNumberModel(new Double(0.01), new Double(0.0), new Double(1.0), new Double(0.01)));
		((JSpinner.NumberEditor) spnrFemaleDivorceWeight.getEditor()).getFormat().setMinimumFractionDigits(3);
		panelDivorce2.add(spnrFemaleDivorceWeight, "3, 1");

		JLabel label_2 = new JLabel("Male:");
		panelDivorce2.add(label_2, "5, 1");

		spnrMaleDivorceWeight = new JSpinner();
		spnrMaleDivorceWeight.setModel(new SpinnerNumberModel(new Double(0.01), new Double(0.0), new Double(1.0), new Double(0.01)));
		((JSpinner.NumberEditor) spnrMaleDivorceWeight.getEditor()).getFormat().setMinimumFractionDigits(3);
		panelDivorce2.add(spnrMaleDivorceWeight, "7, 1");

		JLabel label_3 = new JLabel("Both:");
		panelDivorce2.add(label_3, "9, 1");

		spnrBothDivorceWeight = new JSpinner();
		spnrBothDivorceWeight.setModel(new SpinnerNumberModel(new Double(0.01), new Double(0.0), new Double(1.0), new Double(0.01)));
		((JSpinner.NumberEditor) spnrBothDivorceWeight.getEditor()).getFormat().setMinimumFractionDigits(3);
		panelDivorce2.add(spnrBothDivorceWeight, "11, 1");

		JLabel lblNormalAgeFemale = new JLabel("Normal age female");
		panelWeightFactors.add(lblNormalAgeFemale, "2, 6");

		chckbxNormalAgeFemale = new JCheckBox("");
		chckbxNormalAgeFemale.setSelected(true);
		chckbxNormalAgeFemale.addItemListener(new ItemListener() {
			@Override
			public void itemStateChanged(final ItemEvent e) {
				//
				panelNormalAgeFemale.setVisible(chckbxNormalAgeFemale.isSelected());
			}
		});
		panelWeightFactors.add(chckbxNormalAgeFemale, "4, 6");

		panelNormalAgeFemale = new JPanel();
		panelWeightFactors.add(panelNormalAgeFemale, "6, 6, fill, fill");
		panelNormalAgeFemale.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("50dlu"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("50dlu"), }, new RowSpec[] { FormFactory.DEFAULT_ROWSPEC, }));

		JLabel label_4 = new JLabel("Mean:");
		panelNormalAgeFemale.add(label_4, "1, 1");

		spnrNormalAgeFemaleMean = new JSpinner();
		spnrNormalAgeFemaleMean.setModel(new SpinnerNumberModel(new Double(25), new Double(0.0), null, new Double(1)));
		((JSpinner.NumberEditor) spnrNormalAgeFemaleMean.getEditor()).getFormat().setMinimumFractionDigits(3);
		panelNormalAgeFemale.add(spnrNormalAgeFemaleMean, "3, 1");

		JLabel label_5 = new JLabel("Stdev:");
		panelNormalAgeFemale.add(label_5, "5, 1");

		spnrNormalAgeFemaleStdev = new JSpinner();
		spnrNormalAgeFemaleStdev.setModel(new SpinnerNumberModel(new Double(5), new Double(0.0), null, new Double(1)));
		((JSpinner.NumberEditor) spnrNormalAgeFemaleStdev.getEditor()).getFormat().setMinimumFractionDigits(3);
		panelNormalAgeFemale.add(spnrNormalAgeFemaleStdev, "7, 1");

		JLabel lblNormalAgeMale = new JLabel("Normal age male");
		panelWeightFactors.add(lblNormalAgeMale, "2, 8");

		chckbxNormalAgeMale = new JCheckBox("");
		chckbxNormalAgeMale.setSelected(true);
		chckbxNormalAgeMale.addItemListener(new ItemListener() {
			@Override
			public void itemStateChanged(final ItemEvent e) {
				//
				panelNormalAgeMale.setVisible(chckbxNormalAgeMale.isSelected());
			}
		});
		panelWeightFactors.add(chckbxNormalAgeMale, "4, 8");

		panelNormalAgeMale = new JPanel();
		panelWeightFactors.add(panelNormalAgeMale, "6, 8, fill, fill");
		panelNormalAgeMale.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("50dlu"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("50dlu"), }, new RowSpec[] { FormFactory.DEFAULT_ROWSPEC, }));

		JLabel label_6 = new JLabel("Mean:");
		panelNormalAgeMale.add(label_6, "1, 1");

		spnrNormalAgeMaleMean = new JSpinner();
		spnrNormalAgeMaleMean.setModel(new SpinnerNumberModel(new Double(25), new Double(0.0), null, new Double(1)));
		((JSpinner.NumberEditor) spnrNormalAgeMaleMean.getEditor()).getFormat().setMinimumFractionDigits(3);
		panelNormalAgeMale.add(spnrNormalAgeMaleMean, "3, 1");

		JLabel label_7 = new JLabel("Stdev:");
		panelNormalAgeMale.add(label_7, "5, 1");

		spnrNormalAgeMaleStdev = new JSpinner();
		spnrNormalAgeMaleStdev.setModel(new SpinnerNumberModel(new Double(5), new Double(0.0), null, new Double(1)));
		((JSpinner.NumberEditor) spnrNormalAgeMaleStdev.getEditor()).getFormat().setMinimumFractionDigits(3);
		panelNormalAgeMale.add(spnrNormalAgeMaleStdev, "7, 1");

		JLabel lblNormalAgeUnknown = new JLabel("Normal age unknown");
		panelWeightFactors.add(lblNormalAgeUnknown, "2, 10");

		chckbxNormalAgeUnknown = new JCheckBox("");
		chckbxNormalAgeUnknown.setSelected(true);
		chckbxNormalAgeUnknown.addItemListener(new ItemListener() {
			@Override
			public void itemStateChanged(final ItemEvent e) {
				//
				panelNormalAgeUnknown.setVisible(chckbxNormalAgeUnknown.isSelected());
			}
		});
		panelWeightFactors.add(chckbxNormalAgeUnknown, "4, 10");

		panelNormalAgeUnknown = new JPanel();
		panelWeightFactors.add(panelNormalAgeUnknown, "6, 10, fill, fill");
		panelNormalAgeUnknown.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("50dlu"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("50dlu"), }, new RowSpec[] { FormFactory.DEFAULT_ROWSPEC, }));

		JLabel label_8 = new JLabel("Mean:");
		panelNormalAgeUnknown.add(label_8, "1, 1");

		spnrNormalAgeUnknownMean = new JSpinner();
		spnrNormalAgeUnknownMean.setModel(new SpinnerNumberModel(new Double(25), new Double(0.0), null, new Double(1)));
		((JSpinner.NumberEditor) spnrNormalAgeUnknownMean.getEditor()).getFormat().setMinimumFractionDigits(3);
		panelNormalAgeUnknown.add(spnrNormalAgeUnknownMean, "3, 1");

		JLabel label_9 = new JLabel("Stdev:");
		panelNormalAgeUnknown.add(label_9, "5, 1");

		spnrNormalAgeUnknownStdev = new JSpinner();
		spnrNormalAgeUnknownStdev.setModel(new SpinnerNumberModel(new Double(5), new Double(0.0), null, new Double(1)));
		((JSpinner.NumberEditor) spnrNormalAgeUnknownStdev.getEditor()).getFormat().setMinimumFractionDigits(3);
		panelNormalAgeUnknown.add(spnrNormalAgeUnknownStdev, "7, 1");

		JLabel lblNormalAgeDifference = new JLabel("Normal age difference");
		panelWeightFactors.add(lblNormalAgeDifference, "2, 12");

		chckbxNormalAgeDifference = new JCheckBox("");
		chckbxNormalAgeDifference.setSelected(true);
		chckbxNormalAgeDifference.addItemListener(new ItemListener() {
			@Override
			public void itemStateChanged(final ItemEvent e) {
				//
				panelNormalAgeDifference.setVisible(chckbxNormalAgeDifference.isSelected());
			}
		});
		panelWeightFactors.add(chckbxNormalAgeDifference, "4, 12");

		panelNormalAgeDifference = new JPanel();
		panelWeightFactors.add(panelNormalAgeDifference, "6, 12, fill, fill");
		panelNormalAgeDifference.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("50dlu"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("50dlu"), }, new RowSpec[] { FormFactory.DEFAULT_ROWSPEC, }));

		JLabel label_10 = new JLabel("Mean:");
		panelNormalAgeDifference.add(label_10, "1, 1");

		spnrNormalAgeDifferenceMean = new JSpinner();
		spnrNormalAgeDifferenceMean.setModel(new SpinnerNumberModel(new Double(0.0), new Double(0.0), null, new Double(1)));
		((JSpinner.NumberEditor) spnrNormalAgeDifferenceMean.getEditor()).getFormat().setMinimumFractionDigits(3);
		panelNormalAgeDifference.add(spnrNormalAgeDifferenceMean, "3, 1");

		JLabel label_11 = new JLabel("Stdev:");
		panelNormalAgeDifference.add(label_11, "5, 1");

		spnrNormalAgeDifferenceStdev = new JSpinner();
		spnrNormalAgeDifferenceStdev.setModel(new SpinnerNumberModel(new Double(5), new Double(0.0), null, new Double(1)));
		((JSpinner.NumberEditor) spnrNormalAgeDifferenceStdev.getEditor()).getFormat().setMinimumFractionDigits(3);
		panelNormalAgeDifference.add(spnrNormalAgeDifferenceStdev, "7, 1");

		JLabel lblCousins = new JLabel("Cousins");
		panelWeightFactors.add(lblCousins, "2, 14");

		panelCousins = new JPanel();
		panelWeightFactors.add(panelCousins, "6, 14, fill, fill");
		panelCousins.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("50dlu"),
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("50dlu"),
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("50dlu"), },
				new RowSpec[] { FormFactory.DEFAULT_ROWSPEC, }));

		JLabel lblFirst = new JLabel("First:");
		panelCousins.add(lblFirst, "1, 1");

		spnrCousinsAlpha = new JSpinner();
		spnrCousinsAlpha.setModel(new SpinnerNumberModel(new Double(1), new Double(0.0), null, new Double(1)));
		((JSpinner.NumberEditor) spnrCousinsAlpha.getEditor()).getFormat().setMinimumFractionDigits(3);
		panelCousins.add(spnrCousinsAlpha, "3, 1");

		JLabel lblBravo = new JLabel("Second:");
		panelCousins.add(lblBravo, "5, 1");

		spnrCousinsBravo = new JSpinner();
		spnrCousinsBravo.setModel(new SpinnerNumberModel(new Double(1), new Double(0.0), null, new Double(1)));
		((JSpinner.NumberEditor) spnrCousinsBravo.getEditor()).getFormat().setMinimumFractionDigits(3);
		panelCousins.add(spnrCousinsBravo, "7, 1");

		JLabel lblCharlie = new JLabel("Third:");
		panelCousins.add(lblCharlie, "9, 1");

		spnrCousinsCharlie = new JSpinner();
		spnrCousinsCharlie.setModel(new SpinnerNumberModel(new Double(1), new Double(0.0), null, new Double(1)));
		((JSpinner.NumberEditor) spnrCousinsCharlie.getEditor()).getFormat().setMinimumFractionDigits(3);
		panelCousins.add(spnrCousinsCharlie, "11, 1");

		JLabel lblPregnancy = new JLabel("Pregnancy");
		panelWeightFactors.add(lblPregnancy, "2, 16");

		chckbxCousins = new JCheckBox("");
		chckbxCousins.setSelected(true);
		chckbxCousins.addItemListener(new ItemListener() {
			@Override
			public void itemStateChanged(final ItemEvent e) {
				//
				panelCousins.setVisible(chckbxCousins.isSelected());
			}
		});
		panelWeightFactors.add(chckbxCousins, "4, 14");

		panelPregnancy = new JPanel();
		panelWeightFactors.add(panelPregnancy, "6, 16, fill, fill");
		panelPregnancy.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("50dlu"), },
				new RowSpec[] { FormFactory.DEFAULT_ROWSPEC, }));

		JLabel lblAlpha_1 = new JLabel("Alpha:");
		panelPregnancy.add(lblAlpha_1, "1, 1");

		spnrPregnancyAlpha = new JSpinner();
		spnrPregnancyAlpha.setModel(new SpinnerNumberModel(new Double(0), new Double(0.0), null, new Double(1)));
		((JSpinner.NumberEditor) spnrPregnancyAlpha.getEditor()).getFormat().setMinimumFractionDigits(3);
		panelPregnancy.add(spnrPregnancyAlpha, "3, 1");

		chckbxPregnancy = new JCheckBox("");
		chckbxPregnancy.setSelected(true);
		chckbxPregnancy.addItemListener(new ItemListener() {
			@Override
			public void itemStateChanged(final ItemEvent e) {
				//
				panelPregnancy.setVisible(chckbxPregnancy.isSelected());
			}
		});
		panelWeightFactors.add(chckbxPregnancy, "4, 16");

		lblChildren = new JLabel("Children");
		panelWeightFactors.add(lblChildren, "2, 18");

		chckbxChildren = new JCheckBox("");
		chckbxChildren.setSelected(true);
		panelWeightFactors.add(chckbxChildren, "4, 18");

		panelChildren = new JPanel();
		FlowLayout flowLayout = (FlowLayout) panelChildren.getLayout();
		flowLayout.setAlignment(FlowLayout.LEFT);
		panelWeightFactors.add(panelChildren, "6, 18, fill, fill");

		label_12 = new JLabel("0:");
		panelChildren.add(label_12);

		spinner = new JSpinner();
		panelChildren.add(spinner);

		// //////////////////
		setDefaultCriteria(); // Useful to set default weight factors values.
		setCriteria(PuckGUI.instance().getPreferences().getRandomCorpusMASCriteria());
	}

	/**
	 * 
	 * @return
	 * @throws PuckException
	 */
	public RandomCorpusCriteria getCriteria() throws PuckException {
		RandomCorpusCriteria result;

		//
		result = new RandomCorpusCriteria();

		//
		result.setYear((Integer) spnrYear.getValue());
		result.setInitialPopulation((Integer) spnrInitialPopulation.getValue());
		result.setFertilityRate((Double) spnrFertilityRate.getValue());
		result.setMaxAge((Integer) spnrMaxAge.getValue());

		//
		result.weightFactors().clear();

		if (chckbxDivorce.isSelected()) {
			DivorceWeightFactor factor = new DivorceWeightFactor();
			factor.setProbability((Double) spnrDivorceProbability.getValue());
			result.weightFactors().add(factor);
		}

		if (chckbxDivorce2.isSelected()) {
			Divorce2WeightFactor factor = new Divorce2WeightFactor();
			factor.setFemaleProbability((Double) spnrFemaleDivorceWeight.getValue());
			factor.setMaleProbability((Double) spnrMaleDivorceWeight.getValue());
			factor.setBothProbability((Double) spnrBothDivorceWeight.getValue());
			result.weightFactors().add(factor);
		}

		if (chckbxNormalAgeFemale.isSelected()) {
			NormalAgeWeightFactor factor = new NormalAgeWeightFactor();
			factor.setGender(Gender.FEMALE);
			factor.setMean((Double) spnrNormalAgeFemaleMean.getValue());
			factor.setStdev((Double) spnrNormalAgeFemaleStdev.getValue());
			result.weightFactors().add(factor);
		}

		if (chckbxNormalAgeMale.isSelected()) {
			NormalAgeWeightFactor factor = new NormalAgeWeightFactor();
			factor.setGender(Gender.MALE);
			factor.setMean((Double) spnrNormalAgeMaleMean.getValue());
			factor.setStdev((Double) spnrNormalAgeMaleStdev.getValue());
			result.weightFactors().add(factor);
		}

		if (chckbxNormalAgeUnknown.isSelected()) {
			NormalAgeWeightFactor factor = new NormalAgeWeightFactor();
			factor.setGender(Gender.UNKNOWN);
			factor.setMean((Double) spnrNormalAgeUnknownMean.getValue());
			factor.setStdev((Double) spnrNormalAgeUnknownStdev.getValue());
			result.weightFactors().add(factor);
		}

		if (chckbxNormalAgeDifference.isSelected()) {
			NormalAgeDifferenceWeightFactor factor = new NormalAgeDifferenceWeightFactor();
			factor.setMean((Double) spnrNormalAgeDifferenceMean.getValue());
			factor.setStdev((Double) spnrNormalAgeDifferenceStdev.getValue());
			result.weightFactors().add(factor);
		}

		if (chckbxCousins.isSelected()) {
			CousinsWeightFactor factor = new CousinsWeightFactor();
			factor.setFirst((Double) spnrCousinsAlpha.getValue());
			factor.setSecond((Double) spnrCousinsBravo.getValue());
			factor.setThird((Double) spnrCousinsCharlie.getValue());
			result.weightFactors().add(factor);
		}

		if (chckbxPregnancy.isSelected()) {
			PregnancyWeightFactor factor = new PregnancyWeightFactor();
			factor.setFirst((Double) spnrPregnancyAlpha.getValue());
			result.weightFactors().add(factor);
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public void setCriteria(final RandomCorpusCriteria source) {
		//
		if (source == null) {
			setDefaultCriteria();
		} else {
			//
			spnrYear.setValue(source.getYear());
			spnrInitialPopulation.setValue(source.getInitialPopulation());
			spnrFertilityRate.setValue(source.getFertilityRate());
			spnrMaxAge.setValue(source.getMaxAge());

			chckbxDivorce.setSelected(false);
			chckbxDivorce2.setSelected(false);
			chckbxNormalAgeFemale.setSelected(false);
			chckbxNormalAgeMale.setSelected(false);
			chckbxNormalAgeUnknown.setSelected(false);
			chckbxNormalAgeDifference.setSelected(false);
			chckbxCousins.setSelected(false);
			chckbxPregnancy.setSelected(false);

			//
			for (WeightFactor factor : source.weightFactors()) {
				switch (factor.getType()) {
					case DIVORCE:
						chckbxDivorce.setSelected(true);
						spnrDivorceProbability.setValue(((DivorceWeightFactor) factor).getProbability());
					break;

					case DIVORCE2:
						chckbxDivorce2.setSelected(true);
						spnrFemaleDivorceWeight.setValue(((Divorce2WeightFactor) factor).getFemaleProbability());
						spnrMaleDivorceWeight.setValue(((Divorce2WeightFactor) factor).getMaleProbability());
						spnrBothDivorceWeight.setValue(((Divorce2WeightFactor) factor).getBothProbability());
					break;

					case NORMAL_AGE:
						NormalAgeWeightFactor normalAgeFactor = (NormalAgeWeightFactor) factor;
						switch (normalAgeFactor.getGender()) {
							case FEMALE:
								chckbxNormalAgeFemale.setSelected(true);
								spnrNormalAgeFemaleMean.setValue(normalAgeFactor.getMean());
								spnrNormalAgeFemaleStdev.setValue(normalAgeFactor.getStdev());
							break;

							case MALE:
								chckbxNormalAgeMale.setSelected(true);
								spnrNormalAgeMaleMean.setValue(normalAgeFactor.getMean());
								spnrNormalAgeMaleStdev.setValue(normalAgeFactor.getStdev());
							break;

							case UNKNOWN:
								chckbxNormalAgeUnknown.setSelected(true);
								spnrNormalAgeUnknownMean.setValue(normalAgeFactor.getMean());
								spnrNormalAgeUnknownStdev.setValue(normalAgeFactor.getStdev());
							break;
						}
					break;

					case NORMAL_AGE_DIFFERENCE:
						chckbxNormalAgeDifference.setSelected(true);
						spnrNormalAgeDifferenceMean.setValue(((NormalAgeDifferenceWeightFactor) factor).getMean());
						spnrNormalAgeDifferenceStdev.setValue(((NormalAgeDifferenceWeightFactor) factor).getStdev());
					break;

					case COUSINS:
						chckbxCousins.setSelected(true);
						spnrCousinsAlpha.setValue(((CousinsWeightFactor) factor).getFirst());
						spnrCousinsBravo.setValue(((CousinsWeightFactor) factor).getSecond());
						spnrCousinsCharlie.setValue(((CousinsWeightFactor) factor).getThird());
					break;

					case PREGNANCY:
						chckbxPregnancy.setSelected(true);
						spnrPregnancyAlpha.setValue(((PregnancyWeightFactor) factor).getFirst());
					break;
				}
			}
		}
	}

	/**
	 * 
	 */
	public void setDefaultCriteria() {
		// First pass with all fields.
		RandomCorpusCriteria defaultCriteria = new RandomCorpusCriteria();
		defaultCriteria.weightFactors().add(new DivorceWeightFactor());
		defaultCriteria.weightFactors().add(new Divorce2WeightFactor());
		{
			NormalAgeWeightFactor factor = new NormalAgeWeightFactor();
			factor.setGender(Gender.MALE);
			defaultCriteria.weightFactors().add(factor);
		}
		{
			NormalAgeWeightFactor factor = new NormalAgeWeightFactor();
			factor.setGender(Gender.FEMALE);
			defaultCriteria.weightFactors().add(factor);
		}
		{
			NormalAgeWeightFactor factor = new NormalAgeWeightFactor();
			factor.setGender(Gender.UNKNOWN);
			defaultCriteria.weightFactors().add(factor);
		}
		defaultCriteria.weightFactors().add(new NormalAgeDifferenceWeightFactor());
		defaultCriteria.weightFactors().add(new CousinsWeightFactor());
		defaultCriteria.weightFactors().add(new PregnancyWeightFactor());

		setCriteria(defaultCriteria);

		// Second pass without weight factors field.
		defaultCriteria.weightFactors().clear();
		setCriteria(defaultCriteria);
	}
}
