package org.tip.puckgui.views;

import java.awt.BorderLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;

import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingConstants;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Net;
import org.tip.puck.net.random.RandomNetMaker;
import org.tip.puck.net.workers.NetReporter;
import org.tip.puck.report.Report;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.views.mas.NormalAgeDifferenceWeightFactor;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;

/**
 * 
 * @author TIP
 */
public class RandomCorpusInputWindow extends JFrame {

	static private final Logger logger = LoggerFactory.getLogger(RandomCorpusInputWindow.class);

	private static final long serialVersionUID = -6113524443785800524L;

	private JFrame thisJFrame;
	private JPanel contentPane;
	private JSpinner spnrInitialPopulation;
	private JSpinner spnrFertilityRate;
	private JSpinner spnrMaxAge;
	private JSpinner spnrYear;
	private JSpinner spnrMarriage;
	private JCheckBox chckbxMarriage;
	private JCheckBox chckbxDivorce;
	private JCheckBox chckbxNormalAgeDifference;
	private JCheckBox chckbxCousins;
	private JPanel panelDivorce;
	private JPanel panelDivorce2;
	private JPanel panelNormalAgeDifference;
	private JPanel panelCousins;
	private JSpinner spnrNormalAgeDifferenceStdev;
	private JSpinner spnrNormalAgeDifferenceMean;
	private JSpinner spnrDivorce;
	private JSpinner spnrCousinsWeight;
	private JSpinner spnrMinAge;
	private JComboBox cmbxCousinsType;

	/**
	 * Similar with VirtualFielworkInputWindow.
	 */
	public RandomCorpusInputWindow(final NetGUI gui) {

		// /////////////////////////////////
		setIconImage(Toolkit.getDefaultToolkit().getImage(RandomCorpusInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));

		this.thisJFrame = this;
		setTitle("Random Corpus");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 676, 468);
		setLocationRelativeTo(null);

		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(new BorderLayout(0, 0));

		JPanel buttonPanel = new JPanel();
		contentPane.add(buttonPanel, BorderLayout.SOUTH);

		JButton btnCancel = new JButton("Cancel");
		btnCancel.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Close.
				dispose();
			}
		});

		JButton btnRestoreDefaults = new JButton("Restore defaults");
		btnRestoreDefaults.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Restore Defaults.
				setDefaultCriteria();
			}
		});
		buttonPanel.add(btnRestoreDefaults);
		buttonPanel.add(btnCancel);

		JButton btnLaunch = new JButton("Launch");
		getRootPane().setDefaultButton(btnLaunch);
		btnLaunch.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Launch.
				try {
					//
					RandomCorpusCriteria criteria = getCriteria();
					criteria.setMas(false);

					//
					PuckGUI.instance().getPreferences().setRandomCorpusCriteria(criteria);
					//
					Net targetNet = new RandomNetMaker(criteria).createRandomNet();
					targetNet.setLabel("randomNet");

					// Build report.
					Report report = NetReporter.reportRandomCorpus(criteria, targetNet);

					//
					NetGUI newGUI = PuckGUI.instance().createNetGUI(new File(targetNet.getLabel()), targetNet);
					newGUI.addReportTab(report);

					//
					dispose();

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(thisJFrame, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		buttonPanel.add(btnLaunch);

		JPanel panel = new JPanel();
		panel.setBorder(new TitledBorder(null, "Simulation parameters", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		contentPane.add(panel, BorderLayout.NORTH);
		panel.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("100dlu"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, ColumnSpec.decode("150dlu"), }, new RowSpec[] {
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, }));

		JLabel lblYear = new JLabel("Year:");
		lblYear.setHorizontalAlignment(SwingConstants.CENTER);
		panel.add(lblYear, "2, 2, right, default");

		spnrYear = new JSpinner();
		spnrYear.setModel(new SpinnerNumberModel(new Integer(300), new Integer(1), null, new Integer(1)));
		panel.add(spnrYear, "4, 2");

		JLabel lblInitialPopulation = new JLabel("Initial population:");
		panel.add(lblInitialPopulation, "2, 4, right, default");

		spnrInitialPopulation = new JSpinner();
		spnrInitialPopulation.setModel(new SpinnerNumberModel(new Integer(100), new Integer(1), null, new Integer(1)));
		panel.add(spnrInitialPopulation, "4, 4");

		spnrFertilityRate = new JSpinner();
		spnrFertilityRate.setModel(new SpinnerNumberModel(new Double(2.), new Double(0.0), new Double(100.0), new Double(1.)));
		((JSpinner.NumberEditor) spnrFertilityRate.getEditor()).getFormat().setMinimumFractionDigits(5);

		JLabel lblFertilityRate = new JLabel("Fertility rate:");
		panel.add(lblFertilityRate, "2, 6, right, default");
		panel.add(spnrFertilityRate, "4, 6");

		JLabel lblMaxAge = new JLabel("Max. age:");
		panel.add(lblMaxAge, "2, 8, right, default");

		spnrMaxAge = new JSpinner();
		spnrMaxAge.setModel(new SpinnerNumberModel(new Integer(70), new Integer(1), null, new Integer(1)));
		panel.add(spnrMaxAge, "4, 8");

		JLabel lblMinage = new JLabel("Min.age:");
		panel.add(lblMinage, "2, 10, right, default");

		spnrMinAge = new JSpinner();
		panel.add(spnrMinAge, "4, 10");

		JPanel panel_3 = new JPanel();
		contentPane.add(panel_3, BorderLayout.CENTER);
		panel_3.setLayout(new BoxLayout(panel_3, BoxLayout.Y_AXIS));

		JPanel panel_1 = new JPanel();
		panel_3.add(panel_1);

		JPanel panelWeightFactors = new JPanel();
		panel_3.add(panelWeightFactors);
		panelWeightFactors.setBorder(new TitledBorder(null, "Weight factors", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelWeightFactors.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), },
				new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
						FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
						FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, }));

		JLabel lblDivorce = new JLabel("Marriage");
		panelWeightFactors.add(lblDivorce, "2, 2");

		chckbxMarriage = new JCheckBox("");
		chckbxMarriage.setSelected(true);
		chckbxMarriage.addItemListener(new ItemListener() {
			@Override
			public void itemStateChanged(final ItemEvent e) {
				//
				panelDivorce.setVisible(chckbxMarriage.isSelected());
			}
		});
		panelWeightFactors.add(chckbxMarriage, "4, 2");

		panelDivorce = new JPanel();
		panelDivorce.setEnabled(false);
		panelWeightFactors.add(panelDivorce, "6, 2, fill, fill");
		panelDivorce.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("50dlu"), },
				new RowSpec[] { FormFactory.DEFAULT_ROWSPEC, }));

		JLabel label = new JLabel("Probability:");
		panelDivorce.add(label, "1, 1");

		spnrMarriage = new JSpinner();
		spnrMarriage.setModel(new SpinnerNumberModel(new Double(0.01), new Double(0.0), new Double(1.0), new Double(0.01)));
		((JSpinner.NumberEditor) spnrMarriage.getEditor()).getFormat().setMinimumFractionDigits(3);
		panelDivorce.add(spnrMarriage, "3, 1");

		JLabel lblDivorce_1 = new JLabel("Divorce");
		panelWeightFactors.add(lblDivorce_1, "2, 4");

		chckbxDivorce = new JCheckBox("");
		chckbxDivorce.setSelected(true);
		chckbxDivorce.addItemListener(new ItemListener() {
			@Override
			public void itemStateChanged(final ItemEvent e) {
				//
				panelDivorce2.setVisible(chckbxDivorce.isSelected());
			}
		});
		panelWeightFactors.add(chckbxDivorce, "4, 4");

		panelDivorce2 = new JPanel();
		panelWeightFactors.add(panelDivorce2, "6, 4, fill, fill");
		panelDivorce2.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("50dlu"),
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("50dlu"),
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("50dlu"), },
				new RowSpec[] { FormFactory.DEFAULT_ROWSPEC, }));

		JLabel lblProbability = new JLabel("Probability:");
		panelDivorce2.add(lblProbability, "1, 1");

		spnrDivorce = new JSpinner();
		spnrDivorce.setModel(new SpinnerNumberModel(new Double(0.01), new Double(0.0), new Double(1.0), new Double(0.01)));
		((JSpinner.NumberEditor) spnrDivorce.getEditor()).getFormat().setMinimumFractionDigits(3);
		panelDivorce2.add(spnrDivorce, "3, 1");

		JLabel lblNormalAgeDifference = new JLabel("Normal age difference");
		panelWeightFactors.add(lblNormalAgeDifference, "2, 6");

		chckbxNormalAgeDifference = new JCheckBox("");
		chckbxNormalAgeDifference.setSelected(true);
		chckbxNormalAgeDifference.addItemListener(new ItemListener() {
			@Override
			public void itemStateChanged(final ItemEvent e) {
				//
				panelNormalAgeDifference.setVisible(chckbxNormalAgeDifference.isSelected());
			}
		});
		panelWeightFactors.add(chckbxNormalAgeDifference, "4, 6");

		panelNormalAgeDifference = new JPanel();
		panelWeightFactors.add(panelNormalAgeDifference, "6, 6, fill, fill");
		panelNormalAgeDifference.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("50dlu"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("50dlu"), }, new RowSpec[] { FormFactory.DEFAULT_ROWSPEC, }));

		JLabel label_10 = new JLabel("Mean:");
		panelNormalAgeDifference.add(label_10, "1, 1");

		spnrNormalAgeDifferenceMean = new JSpinner();
		spnrNormalAgeDifferenceMean.setModel(new SpinnerNumberModel(new Double(0.0), new Double(0.0), null, new Double(1)));
		((JSpinner.NumberEditor) spnrNormalAgeDifferenceMean.getEditor()).getFormat().setMinimumFractionDigits(3);
		panelNormalAgeDifference.add(spnrNormalAgeDifferenceMean, "3, 1");

		JLabel label_11 = new JLabel("Stdev:");
		panelNormalAgeDifference.add(label_11, "5, 1");

		spnrNormalAgeDifferenceStdev = new JSpinner();
		spnrNormalAgeDifferenceStdev.setModel(new SpinnerNumberModel(new Double(5), new Double(0.0), null, new Double(1)));
		((JSpinner.NumberEditor) spnrNormalAgeDifferenceStdev.getEditor()).getFormat().setMinimumFractionDigits(3);
		panelNormalAgeDifference.add(spnrNormalAgeDifferenceStdev, "7, 1");

		JLabel lblCousins = new JLabel("First Cousins");
		panelWeightFactors.add(lblCousins, "2, 8");

		chckbxCousins = new JCheckBox("");
		chckbxCousins.setSelected(true);
		chckbxCousins.addItemListener(new ItemListener() {
			@Override
			public void itemStateChanged(final ItemEvent e) {
				//
				panelCousins.setVisible(chckbxCousins.isSelected());
			}
		});
		panelWeightFactors.add(chckbxCousins, "4, 8");

		panelCousins = new JPanel();
		panelWeightFactors.add(panelCousins, "6, 8, fill, fill");
		panelCousins.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("50dlu"),
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("50dlu:grow"),
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("50dlu"), },
				new RowSpec[] { FormFactory.DEFAULT_ROWSPEC, }));

		JLabel lblFirst = new JLabel("Weight:");
		panelCousins.add(lblFirst, "1, 1");

		spnrCousinsWeight = new JSpinner();
		spnrCousinsWeight.setModel(new SpinnerNumberModel(new Double(1), new Double(0.0), null, new Double(1)));
		((JSpinner.NumberEditor) spnrCousinsWeight.getEditor()).getFormat().setMinimumFractionDigits(3);
		panelCousins.add(spnrCousinsWeight, "3, 1");

		JLabel lblBravo = new JLabel("Type:");
		panelCousins.add(lblBravo, "5, 1, right, default");

		cmbxCousinsType = new JComboBox();
		cmbxCousinsType.setModel(new DefaultComboBoxModel(FiliationType.values()));
		cmbxCousinsType.setToolTipText("Type");
		panelCousins.add(cmbxCousinsType, "7, 1, fill, default");

		// //////////////////
		setDefaultCriteria(); // Useful to set default weight factors values.
		setCriteria(PuckGUI.instance().getPreferences().getRandomCorpusMASCriteria());
	}

	/**
	 * 
	 * @return
	 * @throws PuckException
	 */
	public RandomCorpusCriteria getCriteria() throws PuckException {
		RandomCorpusCriteria result;

		//
		result = new RandomCorpusCriteria();

		//
		result.setYear((Integer) spnrYear.getValue());
		result.setInitialPopulation((Integer) spnrInitialPopulation.getValue());
		result.setFertilityRate((Double) spnrFertilityRate.getValue());
		result.setMaxAge((Integer) spnrMaxAge.getValue());
		result.setMinAge((Integer) spnrMinAge.getValue());

		if (chckbxMarriage.isSelected()) {
			result.setMarriageRate(((Double) spnrMarriage.getValue()));
		}

		if (chckbxDivorce.isSelected()) {
			result.setDivorceRate(((Double) spnrDivorce.getValue()));
		}

		if (chckbxNormalAgeDifference.isSelected()) {
			NormalAgeDifferenceWeightFactor factor = new NormalAgeDifferenceWeightFactor();
			factor.setMean((Double) spnrNormalAgeDifferenceMean.getValue());
			factor.setStdev((Double) spnrNormalAgeDifferenceStdev.getValue());
			result.weightFactors().add(factor);
		}

		if (chckbxCousins.isSelected()) {
			result.setCousinPreferenceType((FiliationType) cmbxCousinsType.getSelectedItem());
			result.setCousinPreferenceWeight(((Double) spnrCousinsWeight.getValue()));
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public void setCriteria(final RandomCorpusCriteria source) {
		//
		if (source == null) {
			setDefaultCriteria();
		} else {
			//
			spnrYear.setValue(source.getYear());
			spnrInitialPopulation.setValue(source.getInitialPopulation());
			spnrFertilityRate.setValue(source.getFertilityRate());
			spnrMaxAge.setValue(source.getMaxAge());
			spnrMinAge.setValue(source.getMinAge());
			spnrMarriage.setValue(((source.getMarriageRate())));
			spnrDivorce.setValue(((source.getDivorceRate())));
			spnrNormalAgeDifferenceStdev.setValue(source.getStdevAgeDifference());
			spnrNormalAgeDifferenceMean.setValue(source.getMeanAgeDifference());
			spnrCousinsWeight.setValue(source.getCousinPreferenceWeight());
			cmbxCousinsType.setSelectedItem(source.cousinPreferenceType);

			chckbxDivorce.setSelected(true);
			chckbxNormalAgeDifference.setSelected(true);
			chckbxCousins.setSelected(true);
			chckbxMarriage.setSelected(true);

		}
	}

	/**
	 * 
	 */
	public void setDefaultCriteria() {
		RandomCorpusCriteria defaultCriteria = new RandomCorpusCriteria();
		setCriteria(defaultCriteria);

	}
}
