package org.tip.puckgui.views;

import java.util.ArrayList;
import java.util.List;

import org.tip.puck.census.chains.Chain;
import org.tip.puck.census.chains.ChainMaker;
import org.tip.puck.net.FiliationType;
import org.tip.puckgui.views.mas.CousinsWeightFactor;
import org.tip.puckgui.views.mas.Divorce2WeightFactor;
import org.tip.puckgui.views.mas.DivorceWeightFactor;
import org.tip.puckgui.views.mas.NormalAgeDifferenceWeightFactor;
import org.tip.puckgui.views.mas.NormalAgeWeightFactor;
import org.tip.puckgui.views.mas.PregnancyWeightFactor;
import org.tip.puckgui.views.mas.WeightFactor;

import fr.devinsy.util.StringList;

/**
 * 
 * @author TIP
 */
public class RandomCorpusCriteria {

	private int year;
	private int initialPopulation;
	private int maxAge;
	private int minAge;
	double meanAgeDifference;
	double stdevAgeDifference;
	double marriageRate;
	double fertilityRate;
	double divorceRate;
	FiliationType cousinPreferenceType;
	double cousinPreferenceWeight;

	private double sameMarriageProbability;
	private List<WeightFactor> weightFactors;
	private String illegalMarriages;
	private boolean mas;

	/**
	 * 
	 */
	public RandomCorpusCriteria() {

		this.initialPopulation = 1000;
		this.year = 1000;
		this.maxAge = 50;
		this.minAge = 15;
		this.meanAgeDifference = 0.;
		this.stdevAgeDifference = 7.;
		this.marriageRate = 0.2;
		this.fertilityRate = 2.;
		this.divorceRate = 0.01;

		this.cousinPreferenceType = FiliationType.COGNATIC;
		this.cousinPreferenceWeight = 1;

		this.sameMarriageProbability = 0.5;
		this.fertilityRate = 2.0;
		this.weightFactors = new ArrayList<WeightFactor>();
		this.illegalMarriages = "X(X)\nXX(X)\nX(X)X";
	}

	public FiliationType getCousinPreferenceType() {
		return cousinPreferenceType;
	}

	public double getCousinPreferenceWeight() {
		return cousinPreferenceWeight;
	}

	public double getDivorceRate() {
		return divorceRate;
	}

	public double getFertilityRate() {
		return fertilityRate;
	}

	public String getIllegalMarriages() {
		return illegalMarriages;
	}

	public int getInitialPopulation() {
		return initialPopulation;
	}

	public double getMarriageRate() {
		return marriageRate;
	}

	public int getMaxAge() {
		return maxAge;
	}

	public double getMeanAgeDifference() {
		return meanAgeDifference;
	}

	public int getMinAge() {
		return minAge;
	}

	public double getSameMarriageProbability() {
		return sameMarriageProbability;
	}

	public double getStdevAgeDifference() {
		return stdevAgeDifference;
	}

	public int getYear() {
		return year;
	}

	public boolean isMas() {
		return mas;
	}

	public void setCousinPreferenceType(final FiliationType cousinPreferenceType) {
		this.cousinPreferenceType = cousinPreferenceType;
	}

	public void setCousinPreferenceWeight(final double cousinPreferenceWeight) {
		this.cousinPreferenceWeight = cousinPreferenceWeight;
	}

	public void setDivorceRate(final double divorceRate) {
		this.divorceRate = divorceRate;
	}

	public void setFertilityRate(final double fertilityRate) {
		this.fertilityRate = fertilityRate;
	}

	public void setIllegalMarriages(final String illegalMarriages) {
		this.illegalMarriages = illegalMarriages;
	}

	public void setInitialPopulation(final int initialPopulation) {
		this.initialPopulation = initialPopulation;
	}

	public void setMarriageRate(final double marriageRate) {
		this.marriageRate = marriageRate;
	}

	public void setMas(final boolean mas) {
		this.mas = mas;
	}

	public void setMaxAge(final int maxAge) {
		this.maxAge = maxAge;
	}

	public void setMeanAgeDifference(final double meanAgeDifference) {
		this.meanAgeDifference = meanAgeDifference;
	}

	public void setMinAge(final int minAge) {
		this.minAge = minAge;
	}

	public void setSameMarriageProbability(final double sameMarriageProbability) {
		this.sameMarriageProbability = sameMarriageProbability;
	}

	public void setStdevAgeDifference(final double stdevAgeDifference) {
		this.stdevAgeDifference = stdevAgeDifference;
	}

	public void setYear(final int year) {
		this.year = year;
	}

	/**
	 * 
	 * @return
	 */
	public String toMASConfig() {
		String result;

		//
		StringList buffer = new StringList();
		buffer.appendln("# simulation parameters");
		buffer.append("years ").appendln(this.year);
		buffer.append("initialpopulation ").appendln(this.initialPopulation);
		buffer.append("probsamemarriage ").appendln(this.sameMarriageProbability);
		buffer.append("fertilityrate ").appendln(this.fertilityRate);
		buffer.append("maxage ").appendln(this.maxAge);
		buffer.appendln();
		buffer.appendln("# weight factors");
		for (WeightFactor factor : weightFactors) {
			switch (factor.getType()) {
				case DIVORCE:
					DivorceWeightFactor divorceFactor = (DivorceWeightFactor) factor;
					buffer.append("factor Divorce(").append(divorceFactor.getProbability()).appendln(")");
				break;
				case DIVORCE2:
					Divorce2WeightFactor divorce2Factor = (Divorce2WeightFactor) factor;
					buffer.append("factor Divorce2(").append(divorce2Factor.getFemaleProbability()).append(", ").append(divorce2Factor.getMaleProbability())
							.append(", ").append(divorce2Factor.getBothProbability()).appendln(")");
				break;
				case NORMAL_AGE:
					NormalAgeWeightFactor normalAgeFactor = (NormalAgeWeightFactor) factor;
					buffer.append("factor NormalAge(").append(normalAgeFactor.getGender().toString()).append(", ").append(normalAgeFactor.getMean())
							.append(", ").append(normalAgeFactor.getStdev()).appendln(")");
				break;
				case NORMAL_AGE_DIFFERENCE:
					NormalAgeDifferenceWeightFactor differenceFactor = (NormalAgeDifferenceWeightFactor) factor;
					buffer.append("factor NormalDifferenceAge(").append(differenceFactor.getMean()).append(", ").append(differenceFactor.getStdev())
							.appendln(")");
				break;

				case COUSINS:
					CousinsWeightFactor cousinsFactor = (CousinsWeightFactor) factor;
					buffer.append("factor Cousins(").append(cousinsFactor.getFirst()).append(", ").append(cousinsFactor.getSecond()).append(", ")
							.append(cousinsFactor.getThird()).appendln(")");
				break;

				case PREGNANCY:
					PregnancyWeightFactor pregnancyFactor = (PregnancyWeightFactor) factor;
					buffer.append("factor Pregnancy(").append(pregnancyFactor.getFirst()).appendln(")");
				break;
			}
		}
		// buffer.append("cousins 1.0 1.0 1.0");
		buffer.appendln();
		buffer.appendln(positionalNotationToPrologCode(this.illegalMarriages));

		//
		result = buffer.toString();

		//
		return result;
	}

	public List<WeightFactor> weightFactors() {
		return weightFactors;
	}

	/**
	 * This method translates a position notation relation in Prolog code.
	 * 
	 * @param formula
	 *            "XX(F)X"
	 */
	static public String positionalNotationToPrologCode(final String formula) {
		String result;

		StringList buffer = new StringList();

		List<Character> var = new ArrayList<Character>();
		var.add(' ');
		for (char c = 'A'; c <= 'Z'; c++) {
			var.add(c);
		}

		buffer.appendln("# illegal marriages");
		buffer.appendln("start prolog");
		buffer.appendln("parent(X, Y) :- mother(X, Y).\nparent(X, Y) :- father(X, Y).");

		String[] kinStrings = formula.split("\\s");
		for (String kinString : kinStrings) {
			Chain chain = ChainMaker.fromString(kinString);
			buffer.appendln("illegal(" + var.get(chain.getId(0)) + "," + var.get(chain.getLast().getId()) + ") :- " + chain.getPrologString() + ".");
		}

		//
		result = buffer.toString();

		//
		return result;
	}
}
