package org.tip.puckgui.views;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionCriteria.CumulationType;
import org.tip.puck.partitions.PartitionCriteria.PartitionType;
import org.tip.puck.partitions.PartitionCriteria.SizeFilter;
import org.tip.puck.partitions.PartitionCriteria.ValueFilter;
import org.tip.puck.util.MathUtils;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;

public class PartitionCriteriaShortPanel extends JPanel {

	private static final long serialVersionUID = 8629535949909082139L;
	static private final Logger logger = LoggerFactory.getLogger(PartitionCriteriaShortPanel.class);
	private List<String> targetLabels;
	private JTextField txtfldParameter;
	private JTextField txtfldPattern;
	private JTextField txtfldCountedStart;
	private JTextField txtfldCountedCount;
	private JTextField txtfldCountedEnd;
	private JTextField txtfldSteps;
	private JTextField txtfldSizedStart;
	private JTextField txtfldSizedSize;
	private JTextField txtfldSizedEnd;
	private JPanel panelRaw;
	private JPanel panelBinarization;
	private JPanel panelFreeGrouping;
	private JPanel panelCountedGrouping;
	private JPanel panelSizedGrouping;
	private JComboBox comboBoxLabel;
	private JComboBox comboBoxType;
	private JLabel lblnone;
	private JComboBox cmbbxCumulationType;
	private JButton buttonClear;
	private JComboBox cmbbxValueFilter;
	private JComboBox cmbbxSizeFilter;

	/**
	 * Create the panel.
	 */
	public PartitionCriteriaShortPanel(final List<String> labels, final PartitionCriteria defaultCriteria) {
		// Set default labels.
		if (labels == null) {
			targetLabels = new ArrayList<String>();
			targetLabels.add("");
		} else {
			targetLabels = new ArrayList<String>(labels.size() + 1);
			targetLabels.add("");
			targetLabels.addAll(labels);
		}

		setBorder(null);
		setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));

		JPanel panel_1 = new JPanel();
		add(panel_1);
		panel_1.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("left:30dlu"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.MIN_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.MIN_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				FormFactory.MIN_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.MIN_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.MIN_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, }));

		comboBoxLabel = new JComboBox(targetLabels.toArray());
		comboBoxLabel.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				//
				if (StringUtils.equals((String) comboBoxLabel.getSelectedItem(), "PEDG")) {
					cmbbxSizeFilter.setSelectedIndex(3);
				}
			}
		});
		panel_1.add(comboBoxLabel, "2, 2");
		comboBoxLabel.setSelectedIndex(0);
		comboBoxLabel.setMaximumRowCount(12);
		comboBoxLabel.setEditable(true);

		txtfldParameter = new JTextField();
		txtfldParameter.addFocusListener(new FocusAdapter() {
			@Override
			public void focusLost(final FocusEvent e) {
				//
				if ((StringUtils.equals((String) comboBoxLabel.getSelectedItem(), "PEDG")) && (NumberUtils.isNumber(txtfldParameter.getText()))) {
					String max = String.valueOf((int) Math.pow(2., new Double(txtfldParameter.getText())));
					txtfldCountedEnd.setText(max);
					txtfldSizedEnd.setText(max);
				}
			}
		});
		panel_1.add(txtfldParameter, "4, 2");
		txtfldParameter.setColumns(10);

		comboBoxType = new JComboBox(new Object[] {});
		comboBoxType.addItemListener(new ItemListener() {
			@Override
			public void itemStateChanged(final ItemEvent event) {
				//
				if (event.getStateChange() == ItemEvent.SELECTED) {
					PartitionType type;
					switch (comboBoxType.getSelectedIndex()) {
						case 0:
							type = PartitionType.RAW;
						break;
						case 1:
							type = PartitionType.BINARIZATION;
						break;
						case 2:
							type = PartitionType.FREE_GROUPING;
						break;
						case 3:
							type = PartitionType.COUNTED_GROUPING;
						break;
						case 4:
							type = PartitionType.SIZED_GROUPING;
						break;
						default:
							type = PartitionType.RAW;
					}
					display(type);
				}
			}
		});
		comboBoxType.setModel(new DefaultComboBoxModel(new String[] { "Raw", "Binarization", "Free Grouping", "Counted Grouping", "Sized Grouping" }));
		comboBoxType.setSelectedIndex(0);
		comboBoxType.setMaximumRowCount(12);
		panel_1.add(comboBoxType, "6, 2, fill, default");

		JPanel panel = new JPanel();
		panel_1.add(panel, "8, 2");
		panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));

		panelRaw = new JPanel();
		panel.add(panelRaw);
		panelRaw.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), }, new RowSpec[] {
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, }));

		lblnone = new JLabel("(none)");
		lblnone.setHorizontalAlignment(SwingConstants.CENTER);
		panelRaw.add(lblnone, "2, 2");

		panelBinarization = new JPanel();
		panel.add(panelBinarization);
		panelBinarization.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, }, new RowSpec[] {
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, }));

		txtfldPattern = new JTextField();
		panelBinarization.add(txtfldPattern, "2, 2, fill, default");
		txtfldPattern.setColumns(20);

		JLabel lblPattern = new JLabel("(pattern)");
		panelBinarization.add(lblPattern, "4, 2, left, default");

		panelFreeGrouping = new JPanel();
		panel.add(panelFreeGrouping);
		panelFreeGrouping.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"),
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.MIN_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, }));

		txtfldSteps = new JTextField();
		panelFreeGrouping.add(txtfldSteps, "2, 2, fill, default");
		txtfldSteps.setColumns(20);

		JLabel lblSteps = new JLabel("(steps)");
		panelFreeGrouping.add(lblSteps, "4, 2, left, default");

		panelCountedGrouping = new JPanel();
		panel.add(panelCountedGrouping);
		panelCountedGrouping.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, }, new RowSpec[] {
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, }));

		txtfldCountedStart = new JTextField();
		panelCountedGrouping.add(txtfldCountedStart, "2, 2, fill, default");
		txtfldCountedStart.setColumns(10);

		txtfldCountedCount = new JTextField();
		panelCountedGrouping.add(txtfldCountedCount, "4, 2, fill, default");
		txtfldCountedCount.setColumns(10);

		txtfldCountedEnd = new JTextField();
		panelCountedGrouping.add(txtfldCountedEnd, "6, 2, fill, default");
		txtfldCountedEnd.setColumns(10);

		JLabel lblStart = new JLabel("(start, count, end)");
		panelCountedGrouping.add(lblStart, "8, 2, right, default");

		panelSizedGrouping = new JPanel();
		panel.add(panelSizedGrouping);
		panelSizedGrouping.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, }, new RowSpec[] {
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, }));

		txtfldSizedStart = new JTextField();
		panelSizedGrouping.add(txtfldSizedStart, "2, 2, fill, default");
		txtfldSizedStart.setColumns(10);

		txtfldSizedSize = new JTextField();
		panelSizedGrouping.add(txtfldSizedSize, "4, 2, fill, default");
		txtfldSizedSize.setColumns(10);

		txtfldSizedEnd = new JTextField();
		panelSizedGrouping.add(txtfldSizedEnd, "6, 2, fill, default");
		txtfldSizedEnd.setColumns(10);

		JLabel lblSize = new JLabel("(start, size, end)");
		panelSizedGrouping.add(lblSize, "8, 2, right, default");

		cmbbxCumulationType = new JComboBox();
		cmbbxCumulationType.setModel(new DefaultComboBoxModel(new String[] { "None", "Asc.", "Desc." }));
		panel_1.add(cmbbxCumulationType, "10, 2, fill, default");

		cmbbxValueFilter = new JComboBox();
		cmbbxValueFilter.setModel(new DefaultComboBoxModel(new String[] { "None", "Null", "Zero" }));
		panel_1.add(cmbbxValueFilter, "12, 2, fill, default");

		buttonClear = new JButton("");
		buttonClear.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Clear button.
				clear();
			}
		});

		cmbbxSizeFilter = new JComboBox();
		cmbbxSizeFilter.setModel(new DefaultComboBoxModel(new String[] { "None", "Trim", "Empty", "Holes" }));
		panel_1.add(cmbbxSizeFilter, "14, 2, fill, default");
		buttonClear.setMaximumSize(new Dimension(18, 18));
		buttonClear.setIcon(new ImageIcon(PartitionCriteriaShortPanel.class.getResource("/org/tip/puckgui/images/edit-clear-16x16.png")));
		panel_1.add(buttonClear, "16, 2");

		// =========================================
		//
		display(PartitionType.RAW);

		//
		if (defaultCriteria != null) {
			//
			comboBoxLabel.setModel(new DefaultComboBoxModel(targetLabels.toArray()));
			if (defaultCriteria.getLabel() != null) {
				int index = targetLabels.indexOf(defaultCriteria.getLabel());
				if (index != -1) {
					comboBoxLabel.setSelectedIndex(index);
				}
			}

			//
			if (defaultCriteria.getLabelParameter() != null) {
				txtfldParameter.setText(defaultCriteria.getLabelParameter());
			}

			//
			if (defaultCriteria.getType() != null) {
				switch (defaultCriteria.getType()) {
					case RAW:
						comboBoxType.setSelectedIndex(0);
					break;

					case BINARIZATION:
						comboBoxType.setSelectedIndex(1);

						if (defaultCriteria.getPattern() != null) {
							txtfldPattern.setText(defaultCriteria.getPattern());
						}
					break;

					case FREE_GROUPING:
						comboBoxType.setSelectedIndex(2);

						if (defaultCriteria.getIntervals() != null) {
							txtfldSteps.setText(defaultCriteria.getIntervals().toBasicStepString());
						}
					break;

					case COUNTED_GROUPING:
						comboBoxType.setSelectedIndex(3);

						if (defaultCriteria.getStart() != null) {
							txtfldCountedStart.setText(MathUtils.toString(defaultCriteria.getStart()));
						}

						if (defaultCriteria.getCount() != null) {
							txtfldCountedCount.setText(MathUtils.toString(defaultCriteria.getCount()));
						}

						if (defaultCriteria.getEnd() != null) {
							txtfldCountedEnd.setText(MathUtils.toString(defaultCriteria.getEnd()));
						}
					break;

					case SIZED_GROUPING:
						comboBoxType.setSelectedIndex(4);

						if (defaultCriteria.getStart() != null) {
							txtfldSizedStart.setText(MathUtils.toString(defaultCriteria.getStart()));
						}

						if (defaultCriteria.getSize() != null) {
							txtfldSizedSize.setText(MathUtils.toString(defaultCriteria.getSize()));
						}

						if (defaultCriteria.getEnd() != null) {
							txtfldSizedEnd.setText(MathUtils.toString(defaultCriteria.getEnd()));
						}
					break;
				}
			}

			//
			if (defaultCriteria.getCumulationType() != null) {
				switch (defaultCriteria.getCumulationType()) {
					case NONE:
						cmbbxCumulationType.setSelectedIndex(0);
					break;
					case ASCENDANT:
						cmbbxCumulationType.setSelectedIndex(1);
					break;
					case DESCENDANT:
						cmbbxCumulationType.setSelectedIndex(2);
					break;
					default:
						cmbbxCumulationType.setSelectedIndex(0);
				}

			}

			//
			if (defaultCriteria.getValueFilter() != null) {
				switch (defaultCriteria.getValueFilter()) {
					case NONE:
						cmbbxValueFilter.setSelectedIndex(0);
					break;
					case NULL:
						cmbbxValueFilter.setSelectedIndex(1);
					break;
					case ZERO:
						cmbbxValueFilter.setSelectedIndex(2);
					break;
					default:
						cmbbxValueFilter.setSelectedIndex(0);
				}
			}

			//
			if (defaultCriteria.getSizeFilter() != null) {
				switch (defaultCriteria.getSizeFilter()) {
					case NONE:
						cmbbxSizeFilter.setSelectedIndex(0);
					break;
					case TRIM:
						cmbbxSizeFilter.setSelectedIndex(1);
					break;
					case EMPTY:
						cmbbxSizeFilter.setSelectedIndex(2);
					break;
					case HOLES:
						cmbbxSizeFilter.setSelectedIndex(3);
					break;
					default:
						cmbbxValueFilter.setSelectedIndex(0);
				}
			}
		}
	}

	/**
	 * 
	 */
	public void clear() {
		targetLabels.set(0, "");
		comboBoxLabel.setModel(new DefaultComboBoxModel(targetLabels.toArray()));
		display(PartitionType.RAW);
		comboBoxType.setSelectedIndex(0);
		txtfldParameter.setText("");
		txtfldPattern.setText("");
		txtfldSteps.setText("");
		txtfldCountedStart.setText("");
		txtfldCountedCount.setText("");
		txtfldCountedEnd.setText("");
		txtfldSizedStart.setText("");
		txtfldSizedSize.setText("");
		txtfldSizedEnd.setText("");
		cmbbxCumulationType.setSelectedIndex(0);
		cmbbxValueFilter.setSelectedIndex(0);
		cmbbxSizeFilter.setSelectedIndex(0);
	}

	/**
	 * 
	 * @param type
	 */
	public void display(final PartitionType type) {
		//
		panelRaw.setVisible(false);
		panelBinarization.setVisible(false);
		panelFreeGrouping.setVisible(false);
		panelCountedGrouping.setVisible(false);
		panelSizedGrouping.setVisible(false);

		//
		switch (type) {
			case RAW:
				panelRaw.setVisible(true);
			break;

			case BINARIZATION:
				panelBinarization.setVisible(true);
			break;

			case FREE_GROUPING:
				panelFreeGrouping.setVisible(true);
			break;

			case COUNTED_GROUPING:
				panelCountedGrouping.setVisible(true);
			break;

			case SIZED_GROUPING:
				panelSizedGrouping.setVisible(true);
			break;
		}
	}

	/**
	 * 
	 * @return
	 */
	public PartitionCriteria getCriteria() {
		PartitionCriteria result;

		//
		String label = (String) comboBoxLabel.getSelectedItem();

		//
		if (panelRaw.isVisible()) {
			result = PartitionCriteria.createRaw(label, txtfldParameter.getText());
		} else if (panelBinarization.isVisible()) {
			result = PartitionCriteria.createBinarization(label, txtfldParameter.getText(), txtfldPattern.getText());
		} else if (panelFreeGrouping.isVisible()) {
			result = PartitionCriteria.createGrouping(label, txtfldParameter.getText(), txtfldSteps.getText());
		} else if (panelCountedGrouping.isVisible()) {
			//
			Double start;
			if (NumberUtils.isNumber(txtfldCountedStart.getText())) {
				start = Double.parseDouble(txtfldCountedStart.getText());
			} else {
				start = null;
			}

			//
			Double count;
			if (NumberUtils.isNumber(txtfldCountedCount.getText())) {
				count = Double.parseDouble(txtfldCountedCount.getText());
			} else {
				count = null;
			}

			//
			Double end;
			if (NumberUtils.isNumber(txtfldCountedEnd.getText())) {
				end = Double.parseDouble(txtfldCountedEnd.getText());
			} else {
				end = null;
			}

			//
			result = PartitionCriteria.createCountedGrouping(label, txtfldParameter.getText(), start, count, end);
		} else if (panelSizedGrouping.isVisible()) {
			//
			Double start;
			if (NumberUtils.isNumber(txtfldSizedStart.getText())) {
				start = Double.parseDouble(txtfldSizedStart.getText());
			} else {
				start = null;
			}

			//
			Double size;
			if (NumberUtils.isNumber(txtfldSizedSize.getText())) {
				size = Double.parseDouble(txtfldSizedSize.getText());
			} else {
				size = null;
			}

			//
			Double end;
			if (NumberUtils.isNumber(txtfldSizedEnd.getText())) {
				end = Double.parseDouble(txtfldSizedEnd.getText());
			} else {
				end = null;
			}

			//
			result = PartitionCriteria.createSizedGrouping(label, txtfldParameter.getText(), start, size, end);
		} else {
			result = null;
		}

		//
		if (result != null) {
			//
			switch (cmbbxCumulationType.getSelectedIndex()) {
				case 0:
					result.setCumulationType(CumulationType.NONE);
				break;
				case 1:
					result.setCumulationType(CumulationType.ASCENDANT);
				break;
				case 2:
					result.setCumulationType(CumulationType.DESCENDANT);
				break;
				default:
					result.setCumulationType(CumulationType.NONE);
			}

			//
			switch (cmbbxValueFilter.getSelectedIndex()) {
				case 0:
					result.setValueFilter(ValueFilter.NONE);
				break;
				case 1:
					result.setValueFilter(ValueFilter.NULL);
				break;
				case 2:
					result.setValueFilter(ValueFilter.ZERO);
				break;
				default:
					result.setValueFilter(ValueFilter.NONE);
			}

			//
			switch (cmbbxSizeFilter.getSelectedIndex()) {
				case 0:
					result.setSizeFilter(SizeFilter.NONE);
				break;
				case 1:
					result.setSizeFilter(SizeFilter.TRIM);
				break;
				case 2:
					result.setSizeFilter(SizeFilter.EMPTY);
				break;
				case 3:
					result.setSizeFilter(SizeFilter.HOLES);
				break;
				default:
					result.setSizeFilter(SizeFilter.NONE);
			}
		}

		//
		return result;
	}
}
