package org.tip.puckgui.views;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import org.apache.commons.lang3.math.NumberUtils;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionCriteria.FamilyScope;
import org.tip.puck.partitions.PartitionCriteria.PartitionType;
import org.tip.puck.util.Labels;
import org.tip.puck.util.MathUtils;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;

public class PartitionCriteriaPanel extends JPanel {

	private static final long serialVersionUID = 8629535949909082139L;
	// static private final Logger logger =
	// LoggerFactory.getLogger(PartitionCriteriaPanel.class);
	private static PartitionCriteria defaultCriteria = null;
	private List<String> modelLabels;
	private JTextField txtfldParameter;
	private JTextField txtfldPattern;
	private JTextField txtfldCountedStart;
	private JTextField txtfldCountedCount;
	private JTextField txtfldCountedEnd;
	private JTextField txtfldSteps;
	private JTextField txtfldSizedStart;
	private JTextField txtfldSizedSize;
	private JTextField txtfldSizedEnd;
	private JPanel panelRaw;
	private JPanel panelBinarization;
	private JPanel panelFreeGrouping;
	private JPanel panelCountedGrouping;
	private JPanel panelSizedGrouping;
	private final ButtonGroup buttonGroupType = new ButtonGroup();
	private JComboBox cmbbxLabel;
	private final ButtonGroup buttonGroupScope = new ButtonGroup();
	private JRadioButton rdbtnSome;
	private JRadioButton rdbtnAll;
	private JComboBox cmbbxModel;

	/**
	 * Create the panel.
	 */
	public PartitionCriteriaPanel(final List<Labels> modelsLabels) {
		// Canonize labels.
		List<String> modelLabels = new ArrayList<String>();
		for (Labels labels : modelsLabels) {
			modelLabels.add(labels.getName());
			labels.sort();
		}

		setBorder(new TitledBorder(null, "Partition Criteria", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));

		JPanel panelGenericData2 = new JPanel();
		panelGenericData2.setAlignmentX(Component.LEFT_ALIGNMENT);
		add(panelGenericData2);
		panelGenericData2.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, }));

		JLabel lblModel = new JLabel("Model:");
		panelGenericData2.add(lblModel, "2, 2, right, default");

		cmbbxModel = new JComboBox(modelLabels.toArray());
		cmbbxModel.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				//
				int selectedModel = cmbbxModel.getSelectedIndex();

				//
				if (cmbbxLabel != null) {
					cmbbxLabel.setModel(new DefaultComboBoxModel(modelsLabels.get(selectedModel).toArray()));
				}
			}
		});
		cmbbxModel.setSelectedIndex(0);
		cmbbxModel.setMaximumRowCount(12);
		panelGenericData2.add(cmbbxModel, "4, 2, 3, 1, fill, default");

		JLabel lblLabel = new JLabel("Label:");
		panelGenericData2.add(lblLabel, "2, 4");

		cmbbxLabel = new JComboBox(new DefaultComboBoxModel(modelsLabels.get(0).toArray()));
		panelGenericData2.add(cmbbxLabel, "4, 4");
		cmbbxLabel.setSelectedIndex(0);
		cmbbxLabel.setMaximumRowCount(12);
		cmbbxLabel.setEditable(true);

		JLabel lblParameter = new JLabel("Parameter:");
		panelGenericData2.add(lblParameter, "6, 4");

		txtfldParameter = new JTextField();
		panelGenericData2.add(txtfldParameter, "8, 4");
		txtfldParameter.setColumns(10);

		Component verticalStrut = Box.createVerticalStrut(10);
		add(verticalStrut);

		JPanel panel_2 = new JPanel();
		panel_2.setAlignmentX(Component.LEFT_ALIGNMENT);
		add(panel_2);
		panel_2.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, }, new RowSpec[] {
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, }));

		JLabel lblType = new JLabel("Type:");
		panel_2.add(lblType, "2, 2, left, top");

		JPanel panelPartitionType = new JPanel();
		panelPartitionType.setAlignmentX(Component.LEFT_ALIGNMENT);
		add(panelPartitionType);
		panelPartitionType.setLayout(new BoxLayout(panelPartitionType, BoxLayout.X_AXIS));

		JPanel panelPartitionTypes = new JPanel();
		panelPartitionTypes.setAlignmentY(Component.TOP_ALIGNMENT);
		panelPartitionType.add(panelPartitionTypes);
		panelPartitionTypes.setLayout(new BoxLayout(panelPartitionTypes, BoxLayout.Y_AXIS));

		JRadioButton rdbtnRaw = new JRadioButton("Raw");
		buttonGroupType.add(rdbtnRaw);
		rdbtnRaw.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				display(PartitionType.RAW);
			}
		});
		rdbtnRaw.setSelected(true);
		panelPartitionTypes.add(rdbtnRaw);

		JRadioButton rdbtnBinarization = new JRadioButton("Binarization");
		buttonGroupType.add(rdbtnBinarization);
		rdbtnBinarization.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				display(PartitionType.BINARIZATION);
			}
		});
		panelPartitionTypes.add(rdbtnBinarization);

		JRadioButton rdbtnFreeGrouping = new JRadioButton("Free Grouping");
		buttonGroupType.add(rdbtnFreeGrouping);
		rdbtnFreeGrouping.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				display(PartitionType.FREE_GROUPING);
			}
		});
		panelPartitionTypes.add(rdbtnFreeGrouping);

		JRadioButton rdbtnCountedGrouping = new JRadioButton("Counted Grouping");
		buttonGroupType.add(rdbtnCountedGrouping);
		rdbtnCountedGrouping.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				display(PartitionType.COUNTED_GROUPING);
			}
		});
		panelPartitionTypes.add(rdbtnCountedGrouping);

		JRadioButton rdbtnSizedGrouping = new JRadioButton("Sized Grouping");
		buttonGroupType.add(rdbtnSizedGrouping);
		rdbtnSizedGrouping.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				display(PartitionType.SIZED_GROUPING);
			}
		});
		panelPartitionTypes.add(rdbtnSizedGrouping);

		JPanel panel = new JPanel();
		panel.setAlignmentY(Component.TOP_ALIGNMENT);
		panelPartitionType.add(panel);
		panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));

		panelRaw = new JPanel();
		panel.add(panelRaw);

		panelBinarization = new JPanel();
		panel.add(panelBinarization);
		panelBinarization.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, }));

		JLabel label_1 = new JLabel(" ");
		panelBinarization.add(label_1, "2, 2");

		JLabel lblPattern = new JLabel("Pattern:");
		panelBinarization.add(lblPattern, "2, 4, right, default");

		txtfldPattern = new JTextField();
		panelBinarization.add(txtfldPattern, "4, 4, fill, default");
		txtfldPattern.setColumns(10);

		panelFreeGrouping = new JPanel();
		panel.add(panelFreeGrouping);
		panelFreeGrouping.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, }));

		JLabel lblNewLabel = new JLabel(" ");
		panelFreeGrouping.add(lblNewLabel, "2, 2");

		JLabel label = new JLabel(" ");
		panelFreeGrouping.add(label, "2, 4");

		JLabel lblSteps = new JLabel("Steps:");
		panelFreeGrouping.add(lblSteps, "2, 6, right, default");

		txtfldSteps = new JTextField();
		panelFreeGrouping.add(txtfldSteps, "4, 6, fill, default");
		txtfldSteps.setColumns(10);

		JLabel lblExample = new JLabel("e.g. 1990 1993 2000");
		panelFreeGrouping.add(lblExample, "4, 8");

		panelCountedGrouping = new JPanel();
		panel.add(panelCountedGrouping);
		panelCountedGrouping.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, }));

		JLabel label_4 = new JLabel("    ");
		panelCountedGrouping.add(label_4, "2, 2");

		JLabel lblStart = new JLabel("Start:");
		panelCountedGrouping.add(lblStart, "2, 4, right, default");

		txtfldCountedStart = new JTextField();
		panelCountedGrouping.add(txtfldCountedStart, "4, 4, fill, default");
		txtfldCountedStart.setColumns(10);

		JLabel lblCount = new JLabel("Count:");
		panelCountedGrouping.add(lblCount, "2, 6, right, default");

		txtfldCountedCount = new JTextField();
		panelCountedGrouping.add(txtfldCountedCount, "4, 6, fill, default");
		txtfldCountedCount.setColumns(10);

		JLabel lblEnd = new JLabel("End:");
		panelCountedGrouping.add(lblEnd, "2, 8, right, default");

		txtfldCountedEnd = new JTextField();
		panelCountedGrouping.add(txtfldCountedEnd, "4, 8, fill, default");
		txtfldCountedEnd.setColumns(10);

		panelSizedGrouping = new JPanel();
		panel.add(panelSizedGrouping);
		panelSizedGrouping.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, }));

		JLabel label_2 = new JLabel("    ");
		panelSizedGrouping.add(label_2, "2, 2");

		JLabel lblStart_1 = new JLabel("Start:");
		panelSizedGrouping.add(lblStart_1, "2, 4, right, default");

		txtfldSizedStart = new JTextField();
		panelSizedGrouping.add(txtfldSizedStart, "4, 4, fill, default");
		txtfldSizedStart.setColumns(10);

		JLabel lblSize = new JLabel("Size:");
		panelSizedGrouping.add(lblSize, "2, 6, right, default");

		txtfldSizedSize = new JTextField();
		panelSizedGrouping.add(txtfldSizedSize, "4, 6, fill, default");
		txtfldSizedSize.setColumns(10);

		JLabel lblEnd_1 = new JLabel("End:");
		panelSizedGrouping.add(lblEnd_1, "2, 8, right, default");

		txtfldSizedEnd = new JTextField();
		panelSizedGrouping.add(txtfldSizedEnd, "4, 8, fill, default");
		txtfldSizedEnd.setColumns(10);

		JPanel panelFamilyScope = new JPanel();
		panelFamilyScope.setAlignmentX(Component.LEFT_ALIGNMENT);
		add(panelFamilyScope);
		panelFamilyScope.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, }));

		JLabel lblFamilyScope = new JLabel("Family Scope:");
		panelFamilyScope.add(lblFamilyScope, "2, 2");

		rdbtnSome = new JRadioButton("Some");
		buttonGroupScope.add(rdbtnSome);
		panelFamilyScope.add(rdbtnSome, "4, 2");
		rdbtnSome.setSelected(true);

		rdbtnAll = new JRadioButton("All");
		buttonGroupScope.add(rdbtnAll);
		panelFamilyScope.add(rdbtnAll, "6, 2");

		JPanel panel_1 = new JPanel();
		panel_1.setAlignmentX(Component.LEFT_ALIGNMENT);
		add(panel_1);
		panel_1.setLayout(new BoxLayout(panel_1, BoxLayout.Y_AXIS));

		// =========================================
		display(PartitionType.RAW);

		if (defaultCriteria != null) {
			// TODO
			// cmbbxLabel.setModel(new
			// DefaultComboBoxModel(targetLabels.toArray()));
			//
			// if (defaultCriteria.getLabel() != null) {
			// int index = targetLabels.indexOf(defaultCriteria.getLabel());
			// if (index != -1) {
			// cmbbxLabel.setSelectedIndex(index);
			// }
			// }

			//
			if (defaultCriteria.getLabelParameter() != null) {
				txtfldParameter.setText(defaultCriteria.getLabelParameter());
			}

			//
			if (defaultCriteria.getType() != null) {
				//
				display(defaultCriteria.getType());

				//
				switch (defaultCriteria.getType()) {
					case RAW:
						rdbtnRaw.setSelected(true);
					break;

					case BINARIZATION:
						rdbtnBinarization.setSelected(true);

						if (defaultCriteria.getPattern() != null) {
							txtfldPattern.setText(defaultCriteria.getPattern());
						}
					break;

					case FREE_GROUPING:
						rdbtnFreeGrouping.setSelected(true);

						if (defaultCriteria.getIntervals() != null) {
							txtfldSteps.setText(defaultCriteria.getIntervals().toBasicStepString());
						}
					break;

					case COUNTED_GROUPING:
						rdbtnCountedGrouping.setSelected(true);

						if (defaultCriteria.getStart() != null) {
							txtfldCountedStart.setText(MathUtils.toString(defaultCriteria.getStart()));
						}

						if (defaultCriteria.getCount() != null) {
							txtfldCountedCount.setText(MathUtils.toString(defaultCriteria.getCount()));
						}

						if (defaultCriteria.getEnd() != null) {
							txtfldCountedEnd.setText(MathUtils.toString(defaultCriteria.getEnd()));
						}
					break;

					case SIZED_GROUPING:
						rdbtnSizedGrouping.setSelected(true);

						if (defaultCriteria.getStart() != null) {
							txtfldSizedStart.setText(MathUtils.toString(defaultCriteria.getStart()));
						}

						if (defaultCriteria.getSize() != null) {
							txtfldSizedSize.setText(MathUtils.toString(defaultCriteria.getSize()));
						}

						if (defaultCriteria.getEnd() != null) {
							txtfldSizedEnd.setText(MathUtils.toString(defaultCriteria.getEnd()));
						}
					break;
				}
			}

			//
			if (defaultCriteria.getFamilyScope() == FamilyScope.SOME) {
				rdbtnSome.setSelected(true);
				rdbtnAll.setSelected(false);
			} else {
				rdbtnAll.setSelected(true);
				rdbtnSome.setSelected(false);
			}

		}
	}

	/**
	 * 
	 * @param type
	 */
	public void display(final PartitionType type) {
		//
		panelRaw.setVisible(false);
		panelBinarization.setVisible(false);
		panelFreeGrouping.setVisible(false);
		panelCountedGrouping.setVisible(false);
		panelSizedGrouping.setVisible(false);

		//
		switch (type) {
			case RAW:
				panelRaw.setVisible(true);
			break;

			case BINARIZATION:
				panelBinarization.setVisible(true);
			break;

			case FREE_GROUPING:
				panelFreeGrouping.setVisible(true);
			break;

			case COUNTED_GROUPING:
				panelCountedGrouping.setVisible(true);
			break;

			case SIZED_GROUPING:
				panelSizedGrouping.setVisible(true);
			break;
		}
	}

	/**
	 * 
	 * @return
	 */
	public PartitionCriteria getCriteria() {
		PartitionCriteria result;

		//
		String relationModelName = (String) cmbbxModel.getSelectedItem();

		//
		String label = (String) cmbbxLabel.getSelectedItem();

		//
		String parameter = txtfldParameter.getText();

		//
		if (panelRaw.isVisible()) {
			result = PartitionCriteria.createRaw(label, parameter);
			result.setRelationModelName(relationModelName);
		} else if (panelBinarization.isVisible()) {
			result = PartitionCriteria.createBinarization(label, txtfldParameter.getText(), txtfldPattern.getText());
			result.setRelationModelName(relationModelName);
		} else if (panelFreeGrouping.isVisible()) {
			result = PartitionCriteria.createGrouping(label, txtfldParameter.getText(), txtfldSteps.getText());
			result.setRelationModelName(relationModelName);
		} else if (panelCountedGrouping.isVisible()) {
			//
			Double start;
			if (NumberUtils.isNumber(txtfldCountedStart.getText())) {
				start = Double.parseDouble(txtfldCountedStart.getText());
			} else {
				start = null;
			}

			//
			Double count;
			if (NumberUtils.isNumber(txtfldCountedCount.getText())) {
				count = Double.parseDouble(txtfldCountedCount.getText());
			} else {
				count = null;
			}

			//
			Double end;
			if (NumberUtils.isNumber(txtfldCountedEnd.getText())) {
				end = Double.parseDouble(txtfldCountedEnd.getText());
			} else {
				end = null;
			}

			//
			result = PartitionCriteria.createCountedGrouping(label, parameter, start, count, end);
			result.setRelationModelName(relationModelName);
		} else if (panelSizedGrouping.isVisible()) {
			//
			Double start;
			if (NumberUtils.isNumber(txtfldSizedStart.getText())) {
				start = Double.parseDouble(txtfldSizedStart.getText());
			} else {
				start = null;
			}

			//
			Double size;
			if (NumberUtils.isNumber(txtfldSizedSize.getText())) {
				size = Double.parseDouble(txtfldSizedSize.getText());
			} else {
				size = null;
			}

			//
			Double end;
			if (NumberUtils.isNumber(txtfldSizedEnd.getText())) {
				end = Double.parseDouble(txtfldSizedEnd.getText());
			} else {
				end = null;
			}

			//
			result = PartitionCriteria.createSizedGrouping(label, parameter, start, size, end);
			result.setRelationModelName(relationModelName);
		} else {
			result = null;
		}

		//
		if (rdbtnSome.isSelected()) {
			result.setFamilyScope(FamilyScope.SOME);
		} else {
			result.setFamilyScope(FamilyScope.ALL);
		}

		//
		defaultCriteria = result;

		//
		return result;
	}
}
