package org.tip.puckgui.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.graphs.GraphType;
import org.tip.puck.util.ToolBox;
import org.tip.puckgui.util.GenericFileFilter;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;

/**
 * 
 * @author TIP
 */
public class PajekExportInputDialog extends JDialog {

	private static final long serialVersionUID = 2212434892206449348L;
	private final JPanel contentPanel = new JPanel();
	private static PajekExportCriteria defaultCriteria = new PajekExportCriteria();;
	private PajekExportCriteria inputedCriteria;
	private JTextField txtfldTargetFile;
	private final ButtonGroup buttonGroupGraphType = new ButtonGroup();
	private JRadioButton rdbtnPgraph;
	private JComboBox cmbbxLabel1;
	private JComboBox cmbbxLabel2;
	private JComboBox cmbbxLabel3;
	private JComboBox cmbbxLabel4;
	private JComboBox cmbbxLabel5;
	private JRadioButton rdbtnOregraph;
	private JRadioButton rdbtnTipgraph;
	private Object[] labels;
	private JDialog thisJDialog;
	private File file;
	private JPanel panelPartitionLabels;

	/**
	 * Create the dialog.
	 */
	public PajekExportInputDialog(final File file, final List<String> sourceLabels) {
		super();
		this.thisJDialog = this;
		this.file = file;
		if (file != null) {
			defaultCriteria.setTargetFileName(ToolBox.setExtension(file.getAbsoluteFile(), ".paj").getAbsolutePath());
		}
		setMinimumSize(new Dimension(350, 0));
		setResizable(false);
		if (sourceLabels == null) {
			labels = new String[1];
			labels[0] = "";
		} else {
			sourceLabels.add(0, "");
			labels = sourceLabels.toArray();
		}
		setModalityType(ModalityType.APPLICATION_MODAL);
		setModal(true);
		setAlwaysOnTop(true);
		setTitle("Export To Pajek Input");
		setIconImage(Toolkit.getDefaultToolkit().getImage(PajekExportInputDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
		addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosing(final WindowEvent e) {
				// Closing window.
				// Cancel button.
				inputedCriteria = null;
				setVisible(false);
			}
		});

		setBounds(100, 100, 387, 310);
		getContentPane().setLayout(new BorderLayout());
		contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		getContentPane().add(contentPanel, BorderLayout.CENTER);
		contentPanel.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("default:grow"), FormFactory.RELATED_GAP_COLSPEC, }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, }));
		{
			JPanel panel = new JPanel();
			panel.setBorder(new TitledBorder(null, "Graph Type", TitledBorder.LEADING, TitledBorder.TOP, null, null));
			contentPanel.add(panel, "2, 2, fill, fill");
			panel.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
					FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, }, new RowSpec[] {
					FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
					FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, }));
			{
				rdbtnOregraph = new JRadioButton("Ore-Graph");
				rdbtnOregraph.addActionListener(new ActionListener() {
					@Override
					public void actionPerformed(final ActionEvent e) {
						setEnablePartitionlabels(true);
					}
				});
				rdbtnOregraph.setSelected(true);
				panel.add(rdbtnOregraph, "2, 2");
				buttonGroupGraphType.add(rdbtnOregraph);
			}
			{
				rdbtnTipgraph = new JRadioButton("Tip-Graph");
				rdbtnTipgraph.addActionListener(new ActionListener() {
					@Override
					public void actionPerformed(final ActionEvent e) {
						setEnablePartitionlabels(true);
					}
				});
				panel.add(rdbtnTipgraph, "2, 4");
				buttonGroupGraphType.add(rdbtnTipgraph);
			}
			{
				rdbtnPgraph = new JRadioButton("P-Graph");
				rdbtnPgraph.addActionListener(new ActionListener() {
					@Override
					public void actionPerformed(final ActionEvent e) {
						setEnablePartitionlabels(false);
					}
				});
				panel.add(rdbtnPgraph, "2, 6");
				buttonGroupGraphType.add(rdbtnPgraph);
			}
		}
		{
			panelPartitionLabels = new JPanel();
			panelPartitionLabels.setBorder(new TitledBorder(null, "Partition Labels", TitledBorder.LEADING, TitledBorder.TOP, null, null));
			contentPanel.add(panelPartitionLabels, "4, 2, fill, fill");
			panelPartitionLabels.setLayout(new BoxLayout(panelPartitionLabels, BoxLayout.Y_AXIS));
			{
				cmbbxLabel1 = new JComboBox();
				panelPartitionLabels.add(cmbbxLabel1);
			}
			{
				cmbbxLabel2 = new JComboBox();
				panelPartitionLabels.add(cmbbxLabel2);
			}
			{
				cmbbxLabel3 = new JComboBox();
				panelPartitionLabels.add(cmbbxLabel3);
			}
			{
				cmbbxLabel4 = new JComboBox();
				panelPartitionLabels.add(cmbbxLabel4);
			}
			{
				cmbbxLabel5 = new JComboBox();
				panelPartitionLabels.add(cmbbxLabel5);
			}
		}
		{
			JPanel panel = new JPanel();
			panel.setBorder(new TitledBorder(null, "Target File", TitledBorder.LEADING, TitledBorder.TOP, null, null));
			contentPanel.add(panel, "2, 4, 3, 1, fill, fill");
			panel.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"),
					FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, },
					new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, }));
			{
				txtfldTargetFile = new JTextField();
				panel.add(txtfldTargetFile, "2, 2");
				txtfldTargetFile.setColumns(10);
			}
			{
				JButton buttonClear = new JButton("");
				buttonClear.addActionListener(new ActionListener() {
					@Override
					public void actionPerformed(final ActionEvent e) {
						// Clear.
						txtfldTargetFile.setText("");
					}
				});
				panel.add(buttonClear, "4, 2");
				buttonClear.setIcon(new ImageIcon(PajekExportInputDialog.class.getResource("/org/tip/puckgui/images/edit-clear-16x16.png")));
			}
			{
				JButton buttonBrowse = new JButton("...");
				buttonBrowse.addActionListener(new ActionListener() {
					@Override
					public void actionPerformed(final ActionEvent e) {
						// Browse.
						File targetFile;
						if (StringUtils.isBlank(txtfldTargetFile.getText())) {
							targetFile = file;
						} else {
							targetFile = ToolBox.setExtension(new File(txtfldTargetFile.getText()), ".paj");
						}

						File selection = selectFile(thisJDialog, targetFile);
						if (selection != null) {
							selection = ToolBox.setExtension(selection, ".paj");
							txtfldTargetFile.setText(selection.getAbsolutePath());
						}
					}
				});
				panel.add(buttonBrowse, "6, 2");
			}
		}
		{
			JPanel buttonPane = new JPanel();
			buttonPane.setLayout(new FlowLayout(FlowLayout.CENTER));
			getContentPane().add(buttonPane, BorderLayout.SOUTH);
			{
				JButton cancelButton = new JButton("Cancel");
				cancelButton.addActionListener(new ActionListener() {
					@Override
					public void actionPerformed(final ActionEvent e) {
						// Cancel button.
						inputedCriteria = null;
						setVisible(false);
					}
				});
				cancelButton.setActionCommand("Cancel");
				buttonPane.add(cancelButton);
			}
			{
				JButton btnExport = new JButton("Export");
				btnExport.addActionListener(new ActionListener() {
					@Override
					public void actionPerformed(final ActionEvent e) {
						//
						if (StringUtils.isBlank(txtfldTargetFile.getText())) {
							//
							String title = "Error computerum est";
							String message = "Please, enter a valid file.";

							//
							JOptionPane.showMessageDialog(null, message, title, JOptionPane.ERROR_MESSAGE);
						} else {
							boolean doExport;

							File targetFile = ToolBox.setExtension(new File(txtfldTargetFile.getText()), ".paj");

							if (targetFile.exists()) {
								//
								String title = "Confirm";
								String message = "A file already exists with name, erase?.";

								//
								int response = JOptionPane.showConfirmDialog(null, message, title, JOptionPane.YES_NO_OPTION);

								if (response == JOptionPane.YES_OPTION) {
									doExport = true;
								} else {
									doExport = false;
								}
							} else {
								doExport = true;
							}

							if (doExport) {
								//
								inputedCriteria = new PajekExportCriteria();

								//
								if (rdbtnOregraph.isSelected()) {
									inputedCriteria.setGraphType(GraphType.OreGraph);
								}
								if (rdbtnTipgraph.isSelected()) {
									inputedCriteria.setGraphType(GraphType.TipGraph);
								}
								if (rdbtnPgraph.isSelected()) {
									inputedCriteria.setGraphType(GraphType.PGraph);
								}

								//
								inputedCriteria.setTargetFileName(targetFile.getAbsolutePath());

								//
								inputedCriteria.getPartitionLabels().clear();
								inputedCriteria.getPartitionLabels().add((String) cmbbxLabel1.getSelectedItem());
								inputedCriteria.getPartitionLabels().add((String) cmbbxLabel2.getSelectedItem());
								inputedCriteria.getPartitionLabels().add((String) cmbbxLabel3.getSelectedItem());
								inputedCriteria.getPartitionLabels().add((String) cmbbxLabel4.getSelectedItem());
								inputedCriteria.getPartitionLabels().add((String) cmbbxLabel5.getSelectedItem());

								//
								defaultCriteria = inputedCriteria;

								//
								setVisible(false);
							}
						}
					}
				});
				btnExport.setActionCommand("OK");
				buttonPane.add(btnExport);
				getRootPane().setDefaultButton(btnExport);
			}
		}
		setCriteria(defaultCriteria);
	}

	/**
	 * 
	 * @return
	 */
	public PajekExportCriteria getCriteria() {
		PajekExportCriteria result;

		result = inputedCriteria;

		//
		return result;
	}

	/**
	 * 
	 * @param source
	 */
	private void setCriteria(final PajekExportCriteria source) {
		//
		if (source != null) {
			//
			rdbtnOregraph.setSelected(false);
			rdbtnPgraph.setSelected(false);
			rdbtnTipgraph.setSelected(false);
			switch (source.getGraphType()) {
				case OreGraph:
					rdbtnOregraph.setSelected(true);
					setEnablePartitionlabels(true);
				break;
				case PGraph:
					rdbtnPgraph.setSelected(true);
					setEnablePartitionlabels(false);
				break;
				case TipGraph:
					rdbtnTipgraph.setSelected(true);
					setEnablePartitionlabels(true);
				break;
			}

			//
			if (StringUtils.isNotBlank(source.getTargetFileName())) {
				txtfldTargetFile.setText(source.getTargetFileName());
			}

			//
			cmbbxLabel1.setModel(new DefaultComboBoxModel(labels));
			cmbbxLabel2.setModel(new DefaultComboBoxModel(labels));
			cmbbxLabel3.setModel(new DefaultComboBoxModel(labels));
			cmbbxLabel4.setModel(new DefaultComboBoxModel(labels));
			cmbbxLabel5.setModel(new DefaultComboBoxModel(labels));

			//
			int labelIndex = ArrayUtils.indexOf(labels, source.getPartitionLabels().get(0));
			if (labelIndex == -1) {
				labelIndex = 0;
			}
			cmbbxLabel1.setSelectedIndex(labelIndex);

			//
			labelIndex = ArrayUtils.indexOf(labels, source.getPartitionLabels().get(1));
			if (labelIndex == -1) {
				labelIndex = 0;
			}

			//
			labelIndex = ArrayUtils.indexOf(labels, source.getPartitionLabels().get(2));
			if (labelIndex == -1) {
				labelIndex = 0;
			}
			cmbbxLabel3.setSelectedIndex(labelIndex);

			//
			labelIndex = ArrayUtils.indexOf(labels, source.getPartitionLabels().get(3));
			if (labelIndex == -1) {
				labelIndex = 0;
			}
			cmbbxLabel4.setSelectedIndex(labelIndex);

			//
			labelIndex = ArrayUtils.indexOf(labels, source.getPartitionLabels().get(4));
			if (labelIndex == -1) {
				labelIndex = 0;
			}
			cmbbxLabel5.setSelectedIndex(labelIndex);
		}
	}

	/**
	 * 
	 * @param value
	 */
	private void setEnablePartitionlabels(final boolean value) {
		if (value) {
			cmbbxLabel1.setEnabled(true);
			cmbbxLabel2.setEnabled(true);
			cmbbxLabel3.setEnabled(true);
			cmbbxLabel4.setEnabled(true);
			cmbbxLabel5.setEnabled(true);
		} else {
			cmbbxLabel1.setEnabled(false);
			cmbbxLabel2.setEnabled(false);
			cmbbxLabel3.setEnabled(false);
			cmbbxLabel4.setEnabled(false);
			cmbbxLabel5.setEnabled(false);
		}
	}

	/**
	 * Launch the application.
	 */
	public static void main(final String[] args) {
		List<String> labels = new ArrayList<String>();
		labels.add("ALPHA");
		labels.add("BRAVO");
		labels.add("CHARLIE");
		PajekExportCriteria criteria = showDialog(new File("."), labels);
		if (criteria == null) {
			System.out.println("null");
		} else {
			System.out.println("return=" + criteria.getGraphType());
			System.out.println("return=" + criteria.getPartitionLabels());
			System.out.println("return=" + criteria.getTargetFileName());
		}
	}

	/**
	 * 
	 * 
	 * @param netGUI
	 * @param parentPanel
	 * @param folder
	 */
	static public File selectFile(final Component parentPanel, final File targetFile) {
		File result;

		//
		JFileChooser chooser = new JFileChooser();

		if ((targetFile != null) && (StringUtils.isNotBlank(targetFile.getAbsolutePath()))) {
			chooser.setSelectedFile(ToolBox.setExtension(targetFile, ".paj"));
		}
		chooser.setDialogTitle("Export to Pajek");
		chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		chooser.setAcceptAllFileFilterUsed(false);
		GenericFileFilter defaultFileFilter = new GenericFileFilter("Pajek Network (*.paj)", "paj");
		chooser.addChoosableFileFilter(defaultFileFilter);
		chooser.setFileFilter(defaultFileFilter);

		//
		if (chooser.showSaveDialog(parentPanel) == JFileChooser.APPROVE_OPTION) {
			System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
			System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
			result = chooser.getSelectedFile();
		} else {
			result = null;
		}

		//
		return result;
	}

	/**
	 * Launch the application.
	 */
	public static PajekExportCriteria showDialog(final File file, final List<String> sourceLabels) {
		PajekExportCriteria result;

		//
		PajekExportInputDialog dialog = new PajekExportInputDialog(file, sourceLabels);
		dialog.setLocationRelativeTo(null);
		dialog.pack();
		dialog.setVisible(true);

		//
		result = dialog.getCriteria();

		//
		return result;
	}
}
