package org.tip.puckgui.views;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

import oldcore.calc.transformations.TransformWorker;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.PuckManager;
import org.tip.puck.census.workers.CensusReporter;
import org.tip.puck.census.workers.KinshipChainsCriteria;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.workers.GraphReporter;
import org.tip.puck.io.ods.ODS1File;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.io.xls.XLS1File;
import org.tip.puck.net.Family;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Individual;
import org.tip.puck.net.IndividualComparator.Sorting;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.KinType;
import org.tip.puck.net.Net;
import org.tip.puck.net.random.RandomNetReporter;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.workers.AttributeWorker;
import org.tip.puck.net.workers.BicomponentWorker;
import org.tip.puck.net.workers.ControlReporter;
import org.tip.puck.net.workers.HairCutWorker;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.report.Report;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puck.statistics.StatisticsWorker;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.ToolBox;
import org.tip.puck.visualization.VisualizationController;
import org.tip.puck.visualization.style.implementations.OreGraph;
import org.tip.puck.visualization.style.implementations.PGraph;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.WindowGUI;
import org.tip.puckgui.util.GenericFileFilter;
import org.tip.puckgui.views.visualization.VisualizationPanel;

/**
 * 
 * @author TIP
 */
public class MainWindow {

	static private final Logger logger = LoggerFactory.getLogger(MainWindow.class);

	private int reportCounter = 0;
	private JFrame frmPuck;
	private NetGUI netGUI;
	private JMenuItem mntmSave;
	private JMenuItem mntmRevert;
	private JMenu mntmRecent;
	private JTabbedPane tabbedPaneCorpus;
	private CorpusPanel corpusTab;
	private FamiliesPanel familiesTab;
	private IndividualsPanel individualsTab;
	private SegmentationPanel segmentationPanel;

	/**
	 * Create the application.
	 */
	public MainWindow(final NetGUI guiManager) {
		//
		this.netGUI = guiManager;
		initialize();
		this.frmPuck.setVisible(true);

		//
		updateMenuItems();
		updateTitle();
		getCorpusTab().update();
		getIndividualsTab().update();
		getFamiliesTab().update();
		getIndividualsTab().select(null);
		getFamiliesTab().select(null);
		for (RelationModel relationModel : netGUI.getNet().relationModels()) {
			addTab(relationModel.getName(), new RelationsPanel(netGUI, relationModel));
		}
	}

	/**
	 * 
	 * @param report
	 */
	public void addRelationTab(final RelationModel relationModel) {
		if (relationModel != null) {
			//
			JPanel relationPanel = new RelationsPanel(netGUI, relationModel);

			//
			tabbedPaneCorpus.addTab(relationModel.getName(), null, relationPanel, null);
			tabbedPaneCorpus.setSelectedComponent(relationPanel);
		}
	}

	/**
	 * 
	 * @param report
	 */
	public void addReportTab(final Report report) {
		this.reportCounter += 1;
		JPanel reportPanel;
		if (report.containsSubReport()) {
			reportPanel = new ReportsPanel(this.netGUI, report);
		} else {
			reportPanel = new ReportPanel(this.netGUI, report);
		}
		tabbedPaneCorpus
				.addTab(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.reportTab.title") + "(" + this.reportCounter + ")", null, reportPanel, null); //$NON-NLS-1$ //$NON-NLS-2$
		tabbedPaneCorpus.setSelectedComponent(reportPanel);
	}

	/**
	 * 
	 * @param report
	 */
	public void addTab(final String title, final JPanel panel) {
		tabbedPaneCorpus.addTab(title, null, panel, null);
		tabbedPaneCorpus.setSelectedComponent(panel);
	}

	/**
	 * 
	 */
	public void closeCurrentTab() {
		tabbedPaneCorpus.remove(tabbedPaneCorpus.getSelectedIndex());
	}

	/**
	 * 
	 */
	public void closeRelationTabs() {

		for (RelationsPanel tab : getRelationTabs()) {
			tabbedPaneCorpus.remove(tab);
		}
	}

	/**
	 * 
	 */
	public void closeReportTabs() {
		for (int tabIndex = 3; tabIndex < tabbedPaneCorpus.getTabCount(); tabIndex++) {
			tabbedPaneCorpus.remove(tabIndex);
		}
	}

	/**
	 * 
	 */
	public void dispose() {
		this.frmPuck.dispose();
	}

	/**
	 * 
	 * @return
	 */
	public CorpusPanel getCorpusTab() {
		return corpusTab;
	}

	/**
	 * 
	 * @return
	 */
	public int getCurrentTabIndex() {
		int result;

		result = this.tabbedPaneCorpus.getSelectedIndex();

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public FamiliesPanel getFamiliesTab() {
		return familiesTab;
	}

	/**
	 * 
	 * @return
	 */
	public IndividualsPanel getIndividualsTab() {
		return individualsTab;
	}

	/**
	 * 
	 * @return
	 */
	public JFrame getJFrame() {
		JFrame result;

		result = this.frmPuck;

		//
		return result;
	}

	/**
	 * 
	 * @param relationModel
	 * @return
	 */
	public RelationsPanel getRelationTab(final RelationModel relationModel) {
		RelationsPanel result;

		int tabIndex = this.getRelationTabIndex(relationModel);
		if (tabIndex == -1) {
			result = null;
		} else {
			result = (RelationsPanel) this.tabbedPaneCorpus.getComponent(tabIndex);
		}

		//
		return result;
	}

	/**
	 * 
	 * @param relationModel
	 * @return
	 */
	public int getRelationTabIndex(final RelationModel relationModel) {
		int result;

		result = -1;
		boolean ended = false;
		int tabIndex = 0;
		while (!ended) {
			if (tabIndex < this.tabbedPaneCorpus.getComponentCount()) {
				Component tab = this.tabbedPaneCorpus.getComponent(tabIndex);
				if ((tab.getClass() == RelationsPanel.class) && (((RelationsPanel) tab).getRelationModel() == relationModel)) {
					ended = true;
					result = tabIndex;
				} else {
					tabIndex += 1;
				}
			} else {
				ended = true;
				result = -1;
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public List<RelationsPanel> getRelationTabs() {
		List<RelationsPanel> result;

		result = new ArrayList<RelationsPanel>();

		for (Component tab : this.tabbedPaneCorpus.getComponents()) {
			if (tab.getClass() == RelationsPanel.class) {
				result.add((RelationsPanel) tab);
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public SegmentationPanel getSegmentationPanel() {
		return segmentationPanel;
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frmPuck = new JFrame();
		frmPuck.addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosing(final WindowEvent e) {
				System.out.println("Closing event.");
				performCloseWindow();
			}
		});
		frmPuck.setIconImage(Toolkit.getDefaultToolkit().getImage(MainWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
		frmPuck.setTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.frmPuck.title")); //$NON-NLS-1$ //$NON-NLS-2$
		frmPuck.setBounds(50, 0, 1020, getDesktopHeight());

		frmPuck.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);

		JMenuBar menuBar = new JMenuBar();
		frmPuck.setJMenuBar(menuBar);

		JMenu mnFile = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnFile.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnFile.setMnemonic('F');
		menuBar.add(mnFile);

		JMenu mnNew = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnNew.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnFile.add(mnNew);

		JMenuItem mntmBlankCorpus = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmBlankCorpus.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmBlankCorpus.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// New Blank Corpus.
				PuckGUI.instance().createNetGUI();
			}
		});
		mnNew.add(mntmBlankCorpus);

		JMenu mnRandomnetwork = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnRandomnetwork.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnNew.add(mnRandomnetwork);

		JMenuItem mntmClassic = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmClassic.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmClassic.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// New Random Corpus.
				try {
					//
					RandomCorpusInputWindow window = new RandomCorpusInputWindow(netGUI);

					//
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);

					//
					window.setVisible(true);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnRandomnetwork.add(mntmClassic);

		JMenuItem mntmTelmo = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmTelmo.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmTelmo.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// New Random Corpus.
				try {
					//
					RandomCorpusMASInputWindow window = new RandomCorpusMASInputWindow(netGUI);

					//
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);

					//
					window.setVisible(true);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnRandomnetwork.add(mntmTelmo);

		JMenuItem mntmEmptyAllianceNetwork = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmEmptyAllianceNetwork.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmEmptyAllianceNetwork.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N, InputEvent.CTRL_MASK));
		mntmEmptyAllianceNetwork.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// New Alliance Network.
				try {
					//
					PuckGUI.instance().createGroupNetGUI(
							new Graph<Cluster<Individual>>(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("puckgui.defaultFileName")));

				} catch (PuckException exception) {
					exception.printStackTrace();
				}
			}
		});
		mnNew.add(mntmEmptyAllianceNetwork);

		JMenuItem mntmOpen = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOpen.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmOpen.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOpen.toolTipText")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmOpen.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O, InputEvent.CTRL_MASK));
		mntmOpen.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				//
				openFile(netGUI, frmPuck, netGUI.getFile().getParentFile());
			}
		});
		mnFile.add(mntmOpen);

		mntmRecent = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnNewMenu.text"));
		mntmRecent.addMenuListener(new MenuListener() {
			@Override
			public void menuCanceled(final MenuEvent e) {
			}

			@Override
			public void menuDeselected(final MenuEvent event) {
				// OpenRecent menu cleaning.
				JMenu openRecentMenu = (JMenu) event.getSource();
				openRecentMenu.removeAll();
			}

			@Override
			public void menuSelected(final MenuEvent event) {
				// OpenRecent menu updating.
				JMenu openRecentMenu = (JMenu) event.getSource();
				for (File file : PuckGUI.instance().recentFiles()) {
					openRecentMenu.add(new OpenRecentMenuItem(frmPuck, netGUI, file));
				}
			}
		});
		mnFile.add(mntmRecent);

		JMenu mnOpenRecentFolder = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnOpenFolder.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnOpenRecentFolder.addMenuListener(new MenuListener() {
			@Override
			public void menuCanceled(final MenuEvent event) {
			}

			@Override
			public void menuDeselected(final MenuEvent event) {
				// OpenRecentFolder menu cleaning.
				JMenu openRecentFolderMenu = (JMenu) event.getSource();
				openRecentFolderMenu.removeAll();
			}

			@Override
			public void menuSelected(final MenuEvent event) {
				// OpenRecentFodler menu updating.
				JMenu openRecentFolderMenu = (JMenu) event.getSource();
				for (File file : PuckGUI.instance().recentFolders()) {
					openRecentFolderMenu.add(new OpenRecentFolderMenuItem(frmPuck, netGUI, file));
				}
			}
		});
		mnFile.add(mnOpenRecentFolder);

		mntmRevert = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRevert.text"));
		mntmRevert.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_R, InputEvent.CTRL_MASK));
		mntmRevert.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRevert.toolTipText")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmRevert.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Revert.
				try {
					int response = JOptionPane.showConfirmDialog(frmPuck, "All changes will be lost. Confirm revert of this corpus?", "Revert confirm",
							JOptionPane.YES_NO_OPTION);

					if (response == JOptionPane.YES_OPTION) {
						netGUI.revert();
					}
				} catch (final PuckException exception) {
					//
					String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");

					//
					String message;
					switch (PuckExceptions.valueOf(exception.getCode())) {
						case FILE_NOT_FOUND:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
						break;
						case BAD_FILE_FORMAT:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
						break;
						case UNSUPPORTED_FILE_FORMAT:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
						break;
						case NOT_A_FILE:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
						break;
						case UNSUPPORTED_ENCODING:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
						break;
						default:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
					}

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmOpenEncoding = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOpenEncoding.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmOpenEncoding.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Open Encoding.
				try {
					openEncodingFile(netGUI, frmPuck, netGUI.getFile().getParentFile());

				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnFile.add(mntmOpenEncoding);
		mnFile.add(mntmRevert);

		JSeparator separator_4 = new JSeparator();
		mnFile.add(separator_4);

		mntmSave = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSave.text"));
		mntmSave.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSave.toolTipText")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmSave.setEnabled(false);
		mntmSave.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, InputEvent.CTRL_MASK));
		mntmSave.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				performSave(false, true);
			}
		});

		JMenuItem mntmFuse = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFuse.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmFuse.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Fuse.
				try {
					FuseInputWindow window = new FuseInputWindow(netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnFile.add(mntmFuse);

		JMenuItem mntmUpdateOverwriting = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUpdateOverwriting.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmUpdateOverwriting.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Update Overwriting.
				try {
					File file = selectFile(frmPuck, null);

					//
					if (file != null) {
						//
						Net updatedNet = PuckManager.updateNetOverwriting(netGUI.getNet(), file);

						//
						NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), updatedNet);
						newNetGui.setChanged(true, "-overwritten");
					}
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnFile.add(mntmUpdateOverwriting);

		JMenuItem mntmUpdateAppending = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUpdateAppending.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmUpdateAppending.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Update Appending.
				try {
					File file = selectFile(frmPuck, null);

					//
					if (file != null) {
						//
						Net updatedNet = PuckManager.updateNetAppending(netGUI.getNet(), file);

						//
						NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), updatedNet);
						newNetGui.setChanged(true, "-appended");
					}
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnFile.add(mntmUpdateAppending);

		JSeparator separator_5 = new JSeparator();
		mnFile.add(separator_5);

		mnFile.add(mntmSave);

		JMenuItem mntmSaveAs = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSaveAs.text"));
		mntmSaveAs.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSaveAs.toolTipText")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmSaveAs.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Save As.
				performSave(true, true);
			}
		});

		mnFile.add(mntmSaveAs);

		JMenuItem mntmSaveACopy = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSaveACopy.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmSaveACopy.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSaveACopy.toolTipText")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmSaveACopy.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Save a copy.
				performSave(true, false);
			}
		});
		mnFile.add(mntmSaveACopy);

		JMenuItem mntmClose = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmClose.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmClose.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmClose.toolTipText")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmClose.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_W, InputEvent.CTRL_MASK));
		mntmClose.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				performCloseCorpus();
			}
		});

		JSeparator separator = new JSeparator();
		mnFile.add(separator);

		JMenuItem mntmExportToPajek = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExportToPajek.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmExportToPajek.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Export to Pajek.
				// Linking Chains
				try {
					//
					PajekExportCriteria criteria = PajekExportInputDialog.showDialog(netGUI.getFile(),
							IndividualValuator.getAttributeLabels(netGUI.getNet().individuals()));

					//
					if (criteria != null) {
						PAJFile.exportToPajek(netGUI.getNet(), criteria.getTargetFileName(), criteria.getGraphType(), criteria.getPartitionLabelsNotBlank());
					}
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmImportXls = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmImportXls.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmImportXls.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Import XLS1.
				try {
					//
					// File file = selectFile(frmPuck, netGUI.getFile());
					File file = selectXLSFileToLoad(frmPuck, netGUI.getFile());

					//
					if (file != null) {
						//
						Net net = XLS1File.load(file);

						//
						if (netGUI.isBlank()) {
							netGUI.setFile(file);
							netGUI.setNet(net);
						} else {
							PuckGUI.instance().createNetGUI(file, net);
						}
					}
				} catch (final PuckException exception) {
					exception.printStackTrace();

					//
					String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");

					//
					String message;
					switch (PuckExceptions.valueOf(exception.getCode())) {
						case FILE_NOT_FOUND:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
						break;
						case BAD_FILE_FORMAT:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
						break;
						case UNSUPPORTED_FILE_FORMAT:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
						break;
						case NOT_A_FILE:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
						break;
						case UNSUPPORTED_ENCODING:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
						break;
						default:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
					}

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				} catch (final Exception exception) {
					exception.printStackTrace();

					//
					String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");

					String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmImportOds = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmImportOds.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmImportOds.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Import ODS1&2.
				try {
					//
					// File file = selectFile(frmPuck, netGUI.getFile());
					File file = selectODSFileToLoad(frmPuck, netGUI.getFile());

					//
					if (file != null) {
						//
						Net net = ODS1File.load(file);

						//
						if (netGUI.isBlank()) {
							netGUI.setFile(file);
							netGUI.setNet(net);
						} else {
							PuckGUI.instance().createNetGUI(file, net);
						}
					}
				} catch (final PuckException exception) {
					exception.printStackTrace();

					//
					String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");

					//
					String message;
					switch (PuckExceptions.valueOf(exception.getCode())) {
						case FILE_NOT_FOUND:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
						break;
						case BAD_FILE_FORMAT:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
						break;
						case UNSUPPORTED_FILE_FORMAT:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
						break;
						case NOT_A_FILE:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
						break;
						case UNSUPPORTED_ENCODING:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
						break;
						default:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
					}

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				} catch (final Exception exception) {
					exception.printStackTrace();

					//
					String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");

					String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnFile.add(mntmImportOds);
		mnFile.add(mntmImportXls);

		JMenuItem mntmExportXls = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExportXls.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmExportXls.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Export XLS 1.
				performXLS1Save();
			}
		});

		JMenuItem mntmExportOds = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExportOds.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmExportOds.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Export ODS 1.
				performODS1Save();
			}
		});
		mnFile.add(mntmExportOds);
		mnFile.add(mntmExportXls);
		mnFile.add(mntmExportToPajek);

		JSeparator separator_1 = new JSeparator();
		mnFile.add(separator_1);
		mnFile.add(mntmClose);

		JMenuItem mntmQuit = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmQuit.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmQuit.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmQuit.toolTipText")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmQuit.setMnemonic('Q');
		mntmQuit.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				//
				System.out.println("Quit action.");

				performQuit();
			}
		});

		JSeparator separator_7 = new JSeparator();
		mnFile.add(separator_7);
		mnFile.add(mntmQuit);

		JMenu mnEdit = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnNewMenu.text_1"));
		mnEdit.setMnemonic('E');
		menuBar.add(mnEdit);

		JMenuItem mntmCut = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCut.text"));
		mntmCut.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_CUT, 0));
		mntmCut.setEnabled(false);
		mnEdit.add(mntmCut);

		JMenuItem mntmCopy = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopy.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmCopy.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_COPY, 0));
		mntmCopy.setEnabled(false);
		mnEdit.add(mntmCopy);

		JMenuItem mntmPaste = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPaste.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmPaste.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_PASTE, 0));
		mntmPaste.setEnabled(false);
		mnEdit.add(mntmPaste);

		JMenuItem mntmDelete = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDelete.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmDelete.setEnabled(false);
		mnEdit.add(mntmDelete);

		JSeparator separator_2 = new JSeparator();
		mnEdit.add(separator_2);

		JMenuItem mntmPreferences = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPreferences.text"));
		mntmPreferences.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Preferences.
				try {
					PreferencesWindow preferences = new PreferencesWindow();
					preferences.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					preferences.setVisible(true);
				} catch (Exception exception) {
					exception.printStackTrace();
				}
			}
		});

		JMenuItem mntmAddIndividual = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddIndividual.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAddIndividual.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_I, InputEvent.CTRL_MASK));
		mntmAddIndividual.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Add Individual.
				individualsTab.addIndividual();
			}
		});
		mnEdit.add(mntmAddIndividual);

		JMenuItem mntmFind = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFind.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmFind.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Find.
				switch (tabbedPaneCorpus.getSelectedIndex()) {
					case 1:
						individualsTab.setFocusOnFind();
					break;
					case 2:
						familiesTab.setFocusOnFind();
					break;
					default:
				}
			}
		});

		JMenuItem mntmAddPartner = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddPartner.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAddPartner.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_P, InputEvent.CTRL_MASK));
		mntmAddPartner.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Add partner (menu item).
				switch (tabbedPaneCorpus.getSelectedIndex()) {
					case 1:
						individualsTab.addPartner();
					break;
					default:
				}
			}
		});

		JMenuItem mntmAddOriginFamily = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddOriginFamily.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAddOriginFamily.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Add Original Family.
				switch (tabbedPaneCorpus.getSelectedIndex()) {
					case 1:
						individualsTab.addOriginFamily();
					break;
					default:
				}
			}
		});
		mntmAddOriginFamily.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_U, InputEvent.CTRL_MASK));
		mnEdit.add(mntmAddOriginFamily);
		mnEdit.add(mntmAddPartner);

		JMenuItem mntmAddChild = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddChild.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAddChild.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Add child (menu item).
				switch (tabbedPaneCorpus.getSelectedIndex()) {
					case 1:
						individualsTab.addChild();
					break;
					case 2:
						familiesTab.addChild();
					break;
					default:
				}
			}
		});
		mntmAddChild.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_K, InputEvent.CTRL_MASK));
		mnEdit.add(mntmAddChild);

		JMenuItem mntmAddFamily = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddFamily.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAddFamily.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Add family.
				familiesTab.addFamily();
			}
		});
		mntmAddFamily.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_U, InputEvent.CTRL_MASK | InputEvent.SHIFT_MASK));
		mnEdit.add(mntmAddFamily);

		JMenuItem mntmAddRelationModel = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmNewMenuItem.text_1")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAddRelationModel.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Add Relation Model.
				try {
					RelationModelInputWindow window = new RelationModelInputWindow(netGUI, null);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnEdit.add(mntmAddRelationModel);
		mntmFind.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F, InputEvent.CTRL_MASK));
		mnEdit.add(mntmFind);

		JSeparator separator_9 = new JSeparator();
		mnEdit.add(separator_9);
		mnEdit.add(mntmPreferences);

		JMenu mnCorpus = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnCorpus.text")); //$NON-NLS-1$ //$NON-NLS-2$
		menuBar.add(mnCorpus);

		JMenuItem mntmListById = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListById.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmListById.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				try {
					Report report = StatisticsReporter.reportIndividuals(netGUI.getSegmentation(), Sorting.ID);
					netGUI.addReportTab(report);
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCorpus.add(mntmListById);

		JMenuItem mntmListByFirst = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListByFirst.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmListByFirst.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				try {
					Report report = StatisticsReporter.reportIndividuals(netGUI.getSegmentation(), Sorting.FIRSTN);
					netGUI.addReportTab(report);
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCorpus.add(mntmListByFirst);

		JMenuItem mntmListByLast = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListByLast.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmListByLast.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				try {
					Report report = StatisticsReporter.reportIndividuals(netGUI.getSegmentation(), Sorting.LASTN);
					netGUI.addReportTab(report);
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCorpus.add(mntmListByLast);

		JMenuItem mntmListByClusters = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListByClusters.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmListByClusters.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				try {
					ListByClusterInputWindow window = new ListByClusterInputWindow(netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCorpus.add(mntmListByClusters);

		JMenuItem mntmListRelatives = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListRelatives.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmListRelatives.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				try {
					ListRelativesByClusterInputWindow window = new ListRelativesByClusterInputWindow(netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCorpus.add(mntmListRelatives);

		JMenuItem mntmExportFamilyIds = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExportFamilyIds.text"));
		mntmExportFamilyIds.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Export family Ids by Husband.
				try {
					Report report = StatisticsReporter.reportFamiliesByHusband(netGUI.getNet());
					netGUI.addReportTab(report);
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmListMissingRelatives = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListMissingRelatives.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmListMissingRelatives.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				try {
					ListMissingRelativesByClusterInputWindow window = new ListMissingRelativesByClusterInputWindow(netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCorpus.add(mntmListMissingRelatives);
		mnCorpus.add(mntmExportFamilyIds);

		JMenuItem mntmListFamiliesBy = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListFamiliesBy.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmListFamiliesBy.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Export family Ids by Wife.
				try {
					Report report = StatisticsReporter.reportFamiliesByWife(netGUI.getNet());
					netGUI.addReportTab(report);
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCorpus.add(mntmListFamiliesBy);

		JMenuItem mntmHomonyms = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmHomonyms.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmHomonyms.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// List homonyms.
				try {
					Report report = StatisticsReporter.reportHomonyms(netGUI.getNet());
					netGUI.addReportTab(report);
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCorpus.add(mntmHomonyms);

		JMenu mnControls = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnControls.text"));
		mnCorpus.add(mnControls);

		JMenuItem mntmControl = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControl.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnControls.add(mntmControl);

		JSeparator separator_8 = new JSeparator();
		mnControls.add(separator_8);

		JMenuItem mntmControlSameSex = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlSameSex.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnControls.add(mntmControlSameSex);

		JMenuItem mntmControlFemaleFathers = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlFemaleFathers.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnControls.add(mntmControlFemaleFathers);

		JMenuItem mntmMultipleFathersOr = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmMultipleFathersOr.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmMultipleFathersOr.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Control Female Fathers or Male Mothers.
				try {
					Report report = ControlReporter.reportMultipleFathersOrMothers(netGUI.getNet(), ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnControls.add(mntmMultipleFathersOr);

		JMenuItem mntmControlCyclicDescent = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlCyclicDescent.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnControls.add(mntmControlCyclicDescent);

		JMenuItem mntmControlUnknownSex = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlUnknownSex.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnControls.add(mntmControlUnknownSex);

		JMenuItem mntmControlNamelessPersons = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlNamelessPersons.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnControls.add(mntmControlNamelessPersons);

		JMenuItem mntmControlParentchildMarriages = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlParentchildMarriages.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnControls.add(mntmControlParentchildMarriages);

		JMenuItem mntmAutomarriage = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAutomarriage.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAutomarriage.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Control Auto-marriages.
				try {
					Report report = ControlReporter.reportAutoMarriages(netGUI.getNet(), ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnControls.add(mntmAutomarriage);
		mntmControlParentchildMarriages.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Control Parent-Child marriages.
				try {
					Report report = ControlReporter.reportParentChildMarriages(netGUI.getNet(), ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmControlNamelessPersons.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Control Nameless persons.
				try {
					Report report = ControlReporter.reportNamelessPersons(netGUI.getNet(), ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmControlUnknownSex.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Control Unknown Sex Persons.
				try {
					Report report = ControlReporter.reportUnknownSexPersons(netGUI.getNet(), ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmControlCyclicDescent.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Control Cyclic Descent cases.
				try {
					Report report = ControlReporter.reportCyclicDescentCases(netGUI.getNet(), ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmControlFemaleFathers.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Control Female Fathers or Male Mothers.
				try {
					Report report = ControlReporter.reportFemaleFathersOrMaleMothers(netGUI.getNet(), ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmControlSameSex.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Control Same-Sex persons.
				try {
					Report report = ControlReporter.reportSameSexSpouses(netGUI.getNet(), ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmControl.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Control special features.
				try {
					ControlInputWindow window = new ControlInputWindow(netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JSeparator separator_6 = new JSeparator();
		mnCorpus.add(separator_6);

		JMenu mnTransform = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnTransform.text")); //$NON-NLS-1$ //$NON-NLS-2$
		menuBar.add(mnTransform);

		JMenuItem mntmAnonymizeByGender = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAnonymizeByGender.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAnonymizeByGender.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Copy and anonymize BGI.
				try {
					//
					Net newNet = new Net(netGUI.getNet());
					Individuals currentIndividuals = newNet.individuals().getByIds(netGUI.getCurrentIndividuals().getIds());

					//
					NetUtils.anonymizeByGenderAndId(currentIndividuals);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), newNet);
					newNetGui.setChanged(true, "-anonymized");
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmAnonymizeByFirst = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAnonymizeByFirst.text_1")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAnonymizeByFirst.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Copy and anonymize BFN.
				try {
					//
					Net targetNet = new Net(netGUI.getNet());
					Individuals currentIndividuals = targetNet.individuals().getByIds(netGUI.getCurrentIndividuals().getIds());

					//
					NetUtils.anonymizeByFirstName(currentIndividuals);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), targetNet);
					newNetGui.setChanged(true, "-anonymized");
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmAnonymizeByLast = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAnonymizeByLast.text_1")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAnonymizeByLast.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Copy and anonymize BFN.
				try {
					//
					Net newNet = new Net(netGUI.getNet());
					Individuals currentIndividuals = newNet.individuals().getByIds(netGUI.getCurrentIndividuals().getIds());

					//
					NetUtils.anonymizeByLastName(currentIndividuals);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), newNet);
					newNetGui.setChanged(true, "-anonymized");
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmDuplicate = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDuplicate.text"));
		mnTransform.add(mntmDuplicate);
		mntmDuplicate.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_D, InputEvent.CTRL_MASK));
		mntmDuplicate.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Duplicate Corpus.
				NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), new Net(netGUI.getNet()));
				newNetGui.setChanged(netGUI.isChanged());
			}
		});
		mnTransform.add(mntmAnonymizeByFirst);
		mnTransform.add(mntmAnonymizeByLast);
		mnTransform.add(mntmAnonymizeByGender);

		JMenuItem mntmNumberNames_1 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmNumberNames_1.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmNumberNames_1.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Copy and number names.
				try {
					//
					Net targetNet = netGUI.getNet();
					Individuals currentIndividuals = targetNet.individuals().getByIds(netGUI.getCurrentIndividuals().getIds());

					//
					NetUtils.numberNames(currentIndividuals);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), targetNet);
					newNetGui.setChanged(true, "-names_numbered");
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTransform.add(mntmNumberNames_1);

		JMenuItem mntmCleanAttribute = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCleanAttribute.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmCleanAttribute.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Clean attribute.
				try {
					String label = JOptionPane.showInputDialog("Clean attributes with blank or 0 as value.\nPlease, input attribute label:");
					if (StringUtils.isNotBlank(label)) {
						//
						Net newNet = new Net(netGUI.getNet());
						Individuals currentIndividuals = newNet.individuals().getByIds(netGUI.getCurrentIndividuals().getIds());

						int count = AttributeWorker.cleanAttribute(currentIndividuals, label);

						//
						String title = "Clean Attribute Result";
						String message = "Number of attribute removed: " + count;
						JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

						//
						NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), newNet);
						newNetGui.setChanged(true, "-cleaned");
					}
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}

			}
		});

		JSeparator separator_18 = new JSeparator();
		mnTransform.add(separator_18);

		JMenuItem mntmValuateExogeneousAttribute = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmValuateExogeneousAttribute.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmValuateExogeneousAttribute.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Valuate Exogeneous Attribute.
				try {
					//
					ValuateExogenousAttributeCriteria criteria = ValuateExogenousAttributeDialog.showDialog();

					//
					if (criteria != null) {
						//
						Net newNet = new Net(netGUI.getNet());

						//
						int count = AttributeWorker.valuateExogenousAttribute(newNet.individuals(), criteria.getSourceLabel(), criteria.getTargetLabel(),
								criteria.getValuePrefix());

						//
						String title = "Valuate Exogenous Attribute Count";
						String message = "Number of attribute touched: " + count;
						JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

						//
						if (count > 0) {
							NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), newNet);
							newNetGui.setChanged(true, "-attributeValuated");
						}
					}
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTransform.add(mntmValuateExogeneousAttribute);
		mnTransform.add(mntmCleanAttribute);

		JMenuItem mntmCopyRedefiningRelations = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopyRedefiningRelations.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmCopyRedefiningRelations.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Copy redifining relations.
				try {
					// TODO Migrate.
					Net target = TransformWorker.redefineRelations(netGUI.getNet(), "FIXME", KinType.CHILD);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), target);
					newNetGui.setChanged(netGUI.isChanged());
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmRemoveAttribute = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRemoveAttribute.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmRemoveAttribute.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Remove Attribute.
				try {
					//
					List<String> relationModelNames = netGUI.getNet().relationModels().sortedNameList();
					List<String> attributeNames = AttributeWorker.getExogenousAttributeLabels(netGUI.getNet(), null);
					RemoveAttributeCriteria criteria = RemoveAttributeInputDialog.showDialog(relationModelNames, attributeNames);

					//
					if (criteria != null) {
						//
						Net newNet = new Net(netGUI.getNet());

						//
						int count = AttributeWorker.removeAttribute(newNet, criteria.getScope(), criteria.getOptionalRelationName(), criteria.getLabel(),
								criteria.getType());

						//
						String title = "Remove Attribute Count";
						String message = "Number of attribute touched: " + count;
						JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

						//
						if (count > 0) {
							NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), newNet);
							newNetGui.setChanged(true, "-attributeRemoved");
						}
					}
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTransform.add(mntmRemoveAttribute);

		JSeparator separator_19 = new JSeparator();
		mnTransform.add(separator_19);
		mnTransform.add(mntmCopyRedefiningRelations);

		JMenuItem mntmMarryCoparents = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmMarryCoparents.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmMarryCoparents.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Copy without marked double individuals.
				try {
					//
					Net newNet = new Net(netGUI.getNet());

					//
					int count = NetUtils.marryCoparents(newNet);

					//
					String title = "Marry co-parents Result";
					String message = "Number of unmarried co-parents married: " + count;
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), newNet);
					newNetGui.setChanged(true, "-married");
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTransform.add(mntmMarryCoparents);

		JMenuItem mntmRenumber = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRenumber.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnTransform.add(mntmRenumber);
		mntmRenumber.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Renumberate.
				NetUtils.renumberate(netGUI.getNet());
				corpusTab.update();
				individualsTab.update();
				familiesTab.update();
				netGUI.setChanged(true, "re-numbered");
			}
		});
		mntmRenumber.setEnabled(false);

		JMenuItem mntmFamiliesAsRelations = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddEditableFamilies.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmFamiliesAsRelations.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {

				//
				try {
					//
					RelationModel model = NetUtils.createRelationsFromFamilies(netGUI.getNet());

					//
					netGUI.setChanged(true);

					//
					netGUI.addRelationTab(model);

					// Refresh.
					netGUI.updateAll();

				} catch (final PuckException exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTransform.add(mntmFamiliesAsRelations);

		JSeparator separator_10 = new JSeparator();
		mnTransform.add(separator_10);

		JSeparator separator_11 = new JSeparator();
		mnTransform.add(separator_11);

		JMenu mnReduce = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnReduce.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnTransform.add(mnReduce);

		JMenuItem mntmCuttingTails = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopyCuttingTails.text_1")); //$NON-NLS-1$ //$NON-NLS-2$
		mnReduce.add(mntmCuttingTails);

		JMenuItem mntmCopyWithoutMarked = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopyWithoutMarked.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnReduce.add(mntmCopyWithoutMarked);

		JMenuItem mntmCopyWithoutStruct = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopyWithoutStruct.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnReduce.add(mntmCopyWithoutStruct);

		JMenuItem mntmEliminateSingles = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmEliminateSingles.text"));
		mnReduce.add(mntmEliminateSingles);

		JMenuItem mntmCopyWithoutVirtuals = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopyWithoutVirtuals.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnReduce.add(mntmCopyWithoutVirtuals);
		mntmCopyWithoutVirtuals.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Copy without virtual individuals.
				try {
					//
					Net newNet = netGUI.getNet();
					Individuals currentIndividuals = newNet.individuals().getByIds(netGUI.getCurrentIndividuals().getIds());

					//
					int count = NetUtils.eliminateVirtuals(newNet, currentIndividuals);

					//
					String title = "Eliminate Virtuals Individuals Result";
					String message = "Number of individuals removed: " + count;
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), newNet);
					newNetGui.setChanged(true, "-wo_virtuals");
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmEliminateSingles.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Eliminate unmarried.
				try {
					//
					Chronometer chrono = new Chronometer();

					//
					Net newNet = netGUI.getNet();
					Individuals currentIndividuals = newNet.individuals().getByIds(netGUI.getCurrentIndividuals().getIds());

					//
					int previousIndividualCount = newNet.individuals().size();
					int count = NetUtils.eliminateSingles(newNet, currentIndividuals);

					//
					String title = "Eliminate Unmarried Result";
					String message = String.format("Eliminated singles: %d\nPrevious count: %d\nUpdated count: %d\nTime spent: %d ms", count,
							previousIndividualCount, netGUI.getNet().individuals().size(), chrono.stop().interval());
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), newNet);
					newNetGui.setChanged(true, "-wo_unmarried");
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmCopyWithoutStruct.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Eliminate Structural children.
				try {
					//
					Net newNet = netGUI.getNet();
					Individuals currentIndividuals = newNet.individuals().getByIds(netGUI.getCurrentIndividuals().getIds());

					//
					int count = NetUtils.eliminateStructuralChildren(newNet, currentIndividuals);

					//
					String title = "Eliminate Structural Children Result";
					String message = "Number of individuals removed: " + count;
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

					//
					NetGUI newNetGUI = PuckGUI.instance().createNetGUI(netGUI.getFile(), newNet);
					newNetGUI.setChanged(true, "-adults");
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmCopyWithoutMarked.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Copy without marked double individuals.
				try {
					//
					Net newNet = new Net(netGUI.getNet());
					Individuals currentIndividuals = newNet.individuals().getByIds(netGUI.getCurrentIndividuals().getIds());

					//
					int count = NetUtils.eliminateMarkedDoubles(newNet, currentIndividuals);

					//
					String title = "Eliminate Marked Double individuals Result";
					String message = "Number of individuals removed: " + count;
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), newNet);
					newNetGui.setChanged(true, "-univocal");
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmCuttingTails.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Copy cutting tails.
				try {
					Net newNet = new Net(netGUI.getNet());
					int count = HairCutWorker.shave(newNet);

					//
					String title = "Haircut Result";
					String message = "Number of individuals eliminated: " + count;
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), newNet);
					newNetGui.setChanged(true, "-shaved");
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmExtractCurrentSegment = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExtractCurrentSegment.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmExtractCurrentSegment.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Extract current segment.
				try {
					//
					Net newNet = NetUtils.extract(netGUI.getNet(), netGUI.getCurrentIndividuals());

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), newNet);
					newNetGui.setChanged(true, " " + netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out"));
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenu mnExtract = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnExtract.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnTransform.add(mnExtract);

		JMenuItem mntmExtractCore = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExtractCore.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnExtract.add(mntmExtractCore);

		JMenuItem mntmKernel = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmKernel.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnExtract.add(mntmKernel);

		JMenuItem mntmMaximalBicomponent = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmMaximalBicomponent.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnExtract.add(mntmMaximalBicomponent);
		mntmMaximalBicomponent.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Extract Maximal Bicomponent.
				try {
					Net target = BicomponentWorker.getMaximalBicomponent(netGUI.getNet());

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), target);
					newNetGui.setChanged(true, "-maxBicomponent");
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmExtractLargeClusters = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExtractLargeClusters.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnExtract.add(mntmExtractLargeClusters);

		JMenuItem mntmExtractPositiveCluster = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExtractPositiveCluster.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnExtract.add(mntmExtractPositiveCluster);
		mntmExtractPositiveCluster.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Extract positive cluster values.
				try {
					ClusterValueExtractionInputWindow window = new ClusterValueExtractionInputWindow(netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);

				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmExtractLargeClusters.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Extract large clusters.
				try {
					ClusterSizeExtractionInputWindow window = new ClusterSizeExtractionInputWindow(netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmKernel.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Extract Kernel.
				try {
					Net target = BicomponentWorker.getKernel(netGUI.getNet());

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), target);
					newNetGui.setChanged(true, "-kernel");
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmExtractCore.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Extract Core
				try {
					Net target = BicomponentWorker.getCore(netGUI.getNet());

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), target);
					newNetGui.setChanged(true, "-core");
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JSeparator separator_17 = new JSeparator();
		mnTransform.add(separator_17);
		mnTransform.add(mntmExtractCurrentSegment);

		JMenuItem mntmShufflePgraph = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmShufflePgraph.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmShufflePgraph.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Shuffle P-Graph.
				try {
					//
					ReshufflingNetworkInputWindow window = new ReshufflingNetworkInputWindow(netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenu mnNewMenu = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnNewMenu.text_2")); //$NON-NLS-1$ //$NON-NLS-2$
		mnTransform.add(mnNewMenu);

		JMenuItem mntmUniversal = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUniversal.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmUniversal.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Universal cluster expansion
				try {
					//
					Net newNet = NetUtils.expand(netGUI.getNet(), netGUI.getSegmentation().getCurrentSegment(), null);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), newNet);
					newNetGui.setChanged(true, " " + netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out") + "_expanded_ALL");
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnNewMenu.add(mntmUniversal);

		JMenuItem mntmBottomup = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmBottomup.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmBottomup.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Ascending cluster expansion
				try {
					//
					Net newNet = NetUtils.expand(netGUI.getNet(), netGUI.getSegmentation().getCurrentSegment(), KinType.PARENT);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), newNet);
					newNetGui.setChanged(true, " " + netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out") + "_expanded_UP");
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnNewMenu.add(mntmBottomup);

		JMenuItem mntmTopdown = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmTopdown.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmTopdown.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Descending cluster expansion
				try {
					//
					Net newNet = NetUtils.expand(netGUI.getNet(), netGUI.getSegmentation().getCurrentSegment(), KinType.CHILD);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), newNet);
					newNetGui.setChanged(true, " " + netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out") + "_expanded_DOWN");
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnNewMenu.add(mntmTopdown);

		JMenuItem mntmConjugal = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmConjugal.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmConjugal.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Horizontal cluster expansion
				try {
					//
					Net newNet = NetUtils.expand(netGUI.getNet(), netGUI.getSegmentation().getCurrentSegment(), KinType.SPOUSE);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), newNet);
					newNetGui.setChanged(true, " " + netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out") + "_expanded_MARR");
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnNewMenu.add(mntmConjugal);

		JSeparator separator_15 = new JSeparator();
		mnTransform.add(separator_15);

		JMenu mnShrink = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnShrink.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnTransform.add(mnShrink);

		JMenuItem mntmInterMarriageReport = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmIntermarriageReport.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnShrink.add(mntmInterMarriageReport);

		JMenuItem mntmFlowReport = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFlowReport_1.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnShrink.add(mntmFlowReport);
		mntmFlowReport.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Flow report 2.
				try {
					FlowNetworkInputWindow window = new FlowNetworkInputWindow(netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmInterMarriageReport.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// InterMarriage Report2
				// Reduce Report*.
				try {
					AllianceNetworkInputWindow window = new AllianceNetworkInputWindow(netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JSeparator separator_16 = new JSeparator();
		mnTransform.add(separator_16);
		mnTransform.add(mntmShufflePgraph);

		JMenuItem mntmVirtualFieldwork = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmVirtualFieldwork.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmVirtualFieldwork.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				try {
					FieldworkInputWindow window = new FieldworkInputWindow(netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTransform.add(mntmVirtualFieldwork);

		JMenuItem mntmVirtualFieldworkVariations = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmVirtualFieldworkVariations.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmVirtualFieldworkVariations.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				try {
					Report report = RandomNetReporter.reportVirtualFieldworkVariations(netGUI.getSegmentation());
					netGUI.addReportTab(report);
				} catch (PuckException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		});
		mnTransform.add(mntmVirtualFieldworkVariations);

		JMenu mnCensus = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnCensus.text")); //$NON-NLS-1$ //$NON-NLS-2$
		menuBar.add(mnCensus);

		JMenuItem mntmPedigree = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPedigree.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmPedigree.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Pedigree.
				try {
					//
					Individual ego = netGUI.selectedIndividual();
					if (ego == null) {
						//
						String title = "Information";
						String message = "Please, select an individual on the list.";

						//
						JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
					} else {
						String parameter = JOptionPane.showInputDialog(null, "Maximal generational depth: ", "Pedigree Report", JOptionPane.QUESTION_MESSAGE);

						logger.debug("parameter=[" + parameter + "]");
						if (parameter != null) {
							int maxDepth = Integer.parseInt(parameter);

							Report report = CensusReporter.reportPedigree(netGUI.getNet().getLabel(), ego, maxDepth);

							netGUI.addReportTab(report);
						}
					}
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCensus.add(mntmPedigree);

		JMenuItem mntmRelatives = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRelatives.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmRelatives.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Relatives
				try {
					//
					Individual ego = netGUI.selectedIndividual();
					if (ego == null) {
						//
						String title = "Information";
						String message = "Please, select an individual on the list.";

						//
						JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
					} else {
						String parameter = JOptionPane.showInputDialog(null, "Enter kinship string (in positional notation): ", "Chains Report",
								JOptionPane.QUESTION_MESSAGE);
						logger.debug("parameter=[" + parameter + "]");

						Report report = CensusReporter.reportRelatives(netGUI.getNet().getLabel(), ego, parameter);

						netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmProgeniture = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmProgeniture.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmProgeniture.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Progeniture.
				try {
					//
					Individual ego = netGUI.selectedIndividual();
					if (ego == null) {
						//
						String title = "Information";
						String message = "Please, select an individual on the list.";

						//
						JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
					} else {
						String parameter = JOptionPane
								.showInputDialog(null, "Maximal generational depth: ", "Progeniture Report", JOptionPane.QUESTION_MESSAGE);

						logger.debug("parameter=[" + parameter + "]");
						if (parameter != null) {
							int maxDepth = Integer.parseInt(parameter);

							Report report = CensusReporter.reportProgeniture(netGUI.getNet().getLabel(), ego, maxDepth);

							netGUI.addReportTab(report);
						}
					}
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCensus.add(mntmProgeniture);
		mnCensus.add(mntmRelatives);

		JMenuItem mntmKinshipChains = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmKinshipChains.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmKinshipChains.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Linking Chains
				try {
					Individual ego = netGUI.selectedIndividual();
					if (ego == null) {
						//
						String title = "Information";
						String message = "Please, select an individual on the list.";

						//
						JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
					} else {
						//
						KinshipChainsCriteria criteria = KinshipChainsInputDialog.showDialog();

						//
						if (criteria != null) {
							Individual alter = netGUI.getNet().get(criteria.getAlterId());

							Report report = CensusReporter.reportKinshipChains(netGUI.getNet().getLabel(), ego, alter, criteria.getMaximalDepth(),
									criteria.getMaximalOrder(), criteria.getChainClassification());

							netGUI.addReportTab(report);
						}
					}
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}

			}
		});
		mnCensus.add(mntmKinshipChains);

		JMenuItem mntmFindCircuit2 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFindCircuit2.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmFindCircuit2.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_H, InputEvent.CTRL_MASK));
		mntmFindCircuit2.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Find Circuit Report*.
				try {
					CensusInputWindow window = new CensusInputWindow(netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmDistances = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDistances.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmDistances.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {

				Individual ego = netGUI.selectedIndividual();
				StatisticsWorker.getDistances(ego, 100, FiliationType.COGNATIC);
			}
		});
		mnCensus.add(mntmDistances);

		JSeparator separator_13 = new JSeparator();
		mnCensus.add(separator_13);

		JMenuItem mntmBasicInformation = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmBasicInformation.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnCensus.add(mntmBasicInformation);
		mntmBasicInformation.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_B, InputEvent.CTRL_MASK));
		mntmBasicInformation.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Statistics.
				try {
					Chronometer chrono = new Chronometer();
					Report report = StatisticsReporter.reportBasicInformation(netGUI.getNet(), netGUI.getSegmentation());
					chrono.stop();
					logger.info(String.format("Time spent: %d ms", chrono.interval()));
					netGUI.addReportTab(report);
				} catch (final PuckException exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmBasicGraphs = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmBasicGraphs.text"));
		mnCensus.add(mntmBasicGraphs);
		mntmBasicGraphs.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Statistics.
				try {
					StatisticsInputWindow window = new StatisticsInputWindow(netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmBasicGraphs.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_G, InputEvent.CTRL_MASK));

		JMenuItem mntmPartitionStatistics = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPartitionStatistics.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmPartitionStatistics.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Partition Statistics.
				try {
					PartitionStatisticsInputWindow window = new PartitionStatisticsInputWindow(netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCensus.add(mntmPartitionStatistics);

		JSeparator separator_14 = new JSeparator();
		mnCensus.add(separator_14);
		mnCensus.add(mntmFindCircuit2);

		JMenuItem mntmDifferentialCensus = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDifferentialCensus.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmDifferentialCensus.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Find Circuit Report*.
				try {
					DifferentialCensusInputWindow window = new DifferentialCensusInputWindow(netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCensus.add(mntmDifferentialCensus);

		JSeparator separator_12 = new JSeparator();
		mnCensus.add(separator_12);

		JMenuItem mntmSynopsis = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSynopsis.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmSynopsis.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {

				File file = selectFolder(frmPuck, netGUI.getFile().getParentFile());

				//
				if (file != null) {
					//
					/*
					 * String pathname =
					 * "C:\\Documents and Settings\\Klaus Hamberger\\Mes Documents\\Testcorpus"
					 * ;
					 */
					String directory = file.getAbsolutePath();
					Report report = StatisticsReporter.reportSynopsis(directory);
					netGUI.addReportTab(report);
				}

			}
		});
		mnCensus.add(mntmSynopsis);

		JMenu mnDraw = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnDraw.text")); //$NON-NLS-1$ //$NON-NLS-2$
		menuBar.add(mnDraw);

		JMenuItem mntmOregraph = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOregraph.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmOregraph.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Ore-Graph visualization.
				try {
					//
					Graph<Individual> graph = NetUtils.createOreGraph(netGUI.getSegmentation());

					//
					VisualizationController vizController = VisualizationController.getSharedInstance();
					VisualizationPanel buildView = vizController.buildView(graph, OreGraph.class);

					netGUI.addTab("Ore-Graph Draw", buildView);

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();
				}
			}
		});
		mnDraw.add(mntmOregraph);

		JMenuItem mntmPgraph = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPgraph.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmPgraph.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// P-Graph visualization.
				try {
					//
					Graph<Individual> graph = NetUtils.createOreGraph(netGUI.getSegmentation());

					//
					VisualizationController vizController = VisualizationController.getSharedInstance();
					VisualizationPanel buildView = vizController.buildView(graph, PGraph.class);

					netGUI.addTab("P-Graph Draw", buildView);

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();
				}
			}
		});
		mnDraw.add(mntmPgraph);

		JMenu mnTools = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnTools.text")); //$NON-NLS-1$ //$NON-NLS-2$
		menuBar.add(mnTools);

		JMenuItem mntmCalculator = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCalculator.text"));
		mntmCalculator.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Call calculator.
				try {
					CalculatorWindow window = new CalculatorWindow(netGUI);
					window.getJFrame().setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.getJFrame().setVisible(true);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTools.add(mntmCalculator);

		JMenu mnWindows = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnWindows.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnWindows.addMenuListener(new MenuListener() {
			@Override
			public void menuCanceled(final MenuEvent e) {
			}

			@Override
			public void menuDeselected(final MenuEvent event) {
				// Windows menu cleaning.
				JMenu windowsMenu = (JMenu) event.getSource();
				windowsMenu.removeAll();
			}

			@Override
			public void menuSelected(final MenuEvent event) {
				// Windows menu updating.
				JMenu windowsMenu = (JMenu) event.getSource();
				for (WindowGUI windowGUI : PuckGUI.instance().windowGUIs()) {
					windowsMenu.add(new WindowMenuItem(windowGUI));
				}
			}
		});

		menuBar.add(mnWindows);

		JMenu mnHelp = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnHelp.text"));
		mnHelp.setMnemonic('H');
		menuBar.add(mnHelp);

		JMenuItem mntmOfficialWebSite = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOfficialWebSite.text"));
		mntmOfficialWebSite.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Puck Help.
				callPuckHelp((JMenuItem) event.getSource());
			}
		});
		mnHelp.add(mntmOfficialWebSite);

		JMenuItem mntmAboutPuck = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAboutPuck.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAboutPuck.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// About Puck.
				try {
					AboutPopup dialog = new AboutPopup();
					dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					dialog.setVisible(true);
				} catch (Exception exception) {
					exception.printStackTrace();
				}
			}
		});

		JSeparator separator_3 = new JSeparator();
		mnHelp.add(separator_3);
		mnHelp.add(mntmAboutPuck);

		JMenu mnFoo = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnFoo.text"));
		mnFoo.setVisible(false);
		mnFoo.setEnabled(false);
		menuBar.add(mnFoo);

		JMenuItem mntmFooworker = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFooworker.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnFoo.add(mntmFooworker);

		JMenuItem mntmTestDev = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmTestDev.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnFoo.add(mntmTestDev);
		mntmTestDev.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {

				// Test dev.
				// Launch.
				try {

					GraphReporter.test();
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();
				}

			}
		});
		mntmTestDev.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_T, InputEvent.CTRL_MASK));

		JMenuItem mntmVisualizationTest = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmVisualizationTdev.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmVisualizationTest.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Visualization test.
				try {
					org.tip.puckgui.views.visualization.Test.test(netGUI);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();
				}
			}
		});
		mntmVisualizationTest.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_E, InputEvent.CTRL_MASK | InputEvent.SHIFT_MASK));
		mnFoo.add(mntmVisualizationTest);
		mntmFooworker.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Preferences.
				try {
					FooReporterInputWindow window = new FooReporterInputWindow(netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (Exception exception) {
					exception.printStackTrace();
				}
			}
		});
		frmPuck.getContentPane().setLayout(new BoxLayout(frmPuck.getContentPane(), BoxLayout.Y_AXIS));

		segmentationPanel = new SegmentationPanel(netGUI);
		frmPuck.getContentPane().add(segmentationPanel);

		tabbedPaneCorpus = new JTabbedPane(JTabbedPane.TOP);
		frmPuck.getContentPane().add(tabbedPaneCorpus);

		corpusTab = new CorpusPanel(this.netGUI);
		tabbedPaneCorpus.addTab(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.corpusTab.title"), null, corpusTab, null); //$NON-NLS-1$ //$NON-NLS-2$

		individualsTab = new IndividualsPanel(this.netGUI);
		tabbedPaneCorpus
				.addTab(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individualsPanel.title"), null, individualsTab, null); //$NON-NLS-1$ //$NON-NLS-2$

		familiesTab = new FamiliesPanel(this.netGUI);
		tabbedPaneCorpus.addTab(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.familiesPanel.title"), null, familiesTab, null); //$NON-NLS-1$ //$NON-NLS-2$
	}

	/**
	 * 
	 */
	private void performCloseCorpus() {

		//
		boolean doClose;
		if (netGUI.isChanged()) {
			String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.closeConfirm.existingChange.title");
			String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.closeConfirm.existingChange.text");

			int response = JOptionPane.showConfirmDialog(frmPuck, message, title, JOptionPane.YES_NO_OPTION);

			if (response == JOptionPane.YES_OPTION) {
				doClose = true;
			} else {
				doClose = false;
			}
		} else {
			doClose = true;
		}

		//
		if (doClose) {
			if (PuckGUI.instance().windowGUIs().size() == 1) {
				//
				if (!netGUI.isBlank()) {
					netGUI.setBlank();
				}
			} else {
				PuckGUI.instance().close(netGUI);
				frmPuck.dispose();
			}
		}
	}

	/**
	 * 
	 */
	private void performCloseWindow() {
		//
		if (PuckGUI.instance().windowGUIs().size() == 1) {
			//
			if (netGUI.isBlank()) {
				PuckGUI.instance().exit();
			} else {
				netGUI.setBlank();
			}
		} else {
			//
			boolean doClose;
			if (netGUI.isChanged()) {
				String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.closeConfirm.existingChange.title");
				String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.closeConfirm.existingChange.text");

				int response = JOptionPane.showConfirmDialog(frmPuck, message, title, JOptionPane.YES_NO_OPTION);

				if (response == JOptionPane.YES_OPTION) {
					doClose = true;
				} else {
					doClose = false;
				}
			} else {
				doClose = true;
			}

			//
			if (doClose) {
				PuckGUI.instance().close(netGUI);
				frmPuck.dispose();
			}
		}
	}

	/**
	 * Performs a save action (Save, Save As, Save a Copy).
	 * 
	 * @param displayFileChooser
	 *            Flag to display a file chooser.
	 * 
	 * @param persistFileName
	 *            Flag to persist the file name in the current netGUI.
	 */
	protected void performODS1Save() {
		// Save As.
		try {
			File targetFile;
			if ((netGUI.getFile() != null) && (StringUtils.isNotBlank(netGUI.getFile().getAbsolutePath()))) {
				targetFile = ToolBox.setExtension(netGUI.getFile(), ".ods");
			} else {
				targetFile = null;
			}

			boolean ended = false;
			while (!ended) {

				// Manage possibility to select a target file.
				JFileChooser chooser = new JFileChooser();
				chooser.setSelectedFile(targetFile);

				chooser.setDialogTitle("Export to ODS version 1");
				chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
				chooser.setAcceptAllFileFilterUsed(false);
				GenericFileFilter defaultFileFilter = new GenericFileFilter("ODS version 1 (*.ods)", "ods");
				chooser.addChoosableFileFilter(defaultFileFilter);
				chooser.setFileFilter(defaultFileFilter);

				//
				if (chooser.showSaveDialog(frmPuck) == JFileChooser.APPROVE_OPTION) {
					System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
					System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
					targetFile = chooser.getSelectedFile();
					if (StringUtils.isBlank(ToolBox.getExtension(targetFile))) {
						targetFile = new File(targetFile.getAbsolutePath() + ".ods");
					}

				} else {
					// Nothing to do.
					System.out.println("No Selection ");
					ended = true;
				}

				//
				if (!ended) {
					boolean doSave;
					if (targetFile.exists()) {
						// Manage confirmation dialog.
						String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.title");
						String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.text");

						int response = JOptionPane.showConfirmDialog(frmPuck, message, title, JOptionPane.YES_NO_CANCEL_OPTION);

						if (response == JOptionPane.YES_OPTION) {
							doSave = true;
							ended = true;
						} else if (response == JOptionPane.NO_OPTION) {
							doSave = false;
							ended = false;
						} else {
							doSave = false;
							ended = true;
						}
					} else {
						doSave = true;
						ended = true;
					}

					if (doSave) {
						ODS1File.save(targetFile, netGUI.getNet());
					}
				}
			}
		} catch (final PuckException exception) {
			//
			String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");

			//
			String message;
			switch (PuckExceptions.valueOf(exception.getCode())) {
				case UNSUPPORTED_FILE_FORMAT:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
				break;
				case NOT_A_FILE:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
				break;
				case UNSUPPORTED_ENCODING:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
				break;
				default:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
			}

			//
			JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
		}
	}

	/**
	 * 
	 */
	private void performQuit() {
		//
		boolean doQuit;
		if (PuckGUI.instance().existsUnsavedChanges()) {
			String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.quitConfirm.existingChange.title");
			String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.quitConfirm.existingChange.text");

			int response = JOptionPane.showConfirmDialog(frmPuck, message, title, JOptionPane.YES_NO_OPTION);

			if (response == JOptionPane.YES_OPTION) {
				doQuit = true;
			} else {
				doQuit = false;
			}
		} else {
			doQuit = true;
		}

		//
		if (doQuit) {
			PuckGUI.instance().exit();
		}
	}

	/**
	 * Performs a save action (Save, Save As, Save a Copy).
	 * 
	 * @param displayFileChooser
	 *            Flag to display a file chooser.
	 * 
	 * @param persistFileName
	 *            Flag to persist the file name in the current netGUI.
	 */
	protected void performSave(final boolean displayFileChooser, final boolean persistFileName) {
		// Save As.
		try {
			File targetFile = netGUI.getFile();
			boolean displayChooser;
			if (ToolBox.getExtension(targetFile) == null) {
				displayChooser = true;
			} else {
				displayChooser = displayFileChooser;
			}

			boolean ended = false;
			while (!ended) {

				// Manage possibility to select a target file.
				if (displayChooser) {
					JFileChooser chooser = new JFileChooser();
					chooser.setSelectedFile(targetFile);

					chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.saveAsFileChooser.text"));
					chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
					chooser.setAcceptAllFileFilterUsed(false);
					GenericFileFilter defaultFileFilter = new GenericFileFilter(
							"Genealogic files (*.ged, *.ods, *.pl, *.puc, *.tip, *.txt, *.txt3, *.xls, *.xml)", "ged", "ods", "pl", "puc", "tip", "txt",
							"txt3", "xls", "xml");
					chooser.addChoosableFileFilter(defaultFileFilter);
					chooser.addChoosableFileFilter(new GenericFileFilter("OpenDocumentFormat Spreadsheet (*.ods)", "ods"));
					chooser.addChoosableFileFilter(new GenericFileFilter("GEDCOM (*.ged)", "ged"));
					chooser.addChoosableFileFilter(new GenericFileFilter("Prolog (*.pl)", "pl"));
					chooser.addChoosableFileFilter(new GenericFileFilter("PUCK (*.puc)", "puc"));
					chooser.addChoosableFileFilter(new GenericFileFilter("TIP (*.tip)", "tip"));
					chooser.addChoosableFileFilter(new GenericFileFilter("Text (*.txt)", "txt"));
					chooser.addChoosableFileFilter(new GenericFileFilter("Text version 3 (*.txt3)", "txt3"));
					chooser.addChoosableFileFilter(new GenericFileFilter("Microsoft Excel (*.xls)", "xls"));
					chooser.addChoosableFileFilter(new GenericFileFilter("Extensible Markup Language (*.xml)", "xml"));
					chooser.setFileFilter(defaultFileFilter);

					//
					if (chooser.showSaveDialog(frmPuck) == JFileChooser.APPROVE_OPTION) {
						System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
						System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
						targetFile = chooser.getSelectedFile();
						if (StringUtils.isBlank(ToolBox.getExtension(targetFile))) {
							targetFile = new File(targetFile.getAbsolutePath() + ".txt3");
						}

					} else {
						// Nothing to do.
						System.out.println("No Selection ");
						ended = true;
					}
				}

				//
				if (!ended) {
					boolean doSave;
					if (targetFile.exists()) {
						// Manage confirmation dialog.
						String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.title");
						String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.text");

						int response = JOptionPane.showConfirmDialog(frmPuck, message, title, JOptionPane.YES_NO_CANCEL_OPTION);

						if (response == JOptionPane.YES_OPTION) {
							doSave = true;
							ended = true;
						} else if (response == JOptionPane.NO_OPTION) {
							doSave = false;
							ended = false;
							displayChooser = true;
						} else {
							doSave = false;
							ended = true;
						}
					} else {
						doSave = true;
						ended = true;
					}

					if (doSave) {
						PuckManager.saveNet(targetFile, netGUI.getNet());
						if (persistFileName) {
							netGUI.setFile(targetFile);
						}
						netGUI.setChanged(false);
					}
				}
			}
		} catch (final PuckException exception) {
			//
			String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");

			//
			String message;
			switch (PuckExceptions.valueOf(exception.getCode())) {
				case UNSUPPORTED_FILE_FORMAT:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
				break;
				case NOT_A_FILE:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
				break;
				case UNSUPPORTED_ENCODING:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
				break;
				default:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
			}

			//
			JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
		}
	}

	/**
	 * Performs a save action (Save, Save As, Save a Copy).
	 * 
	 * @param displayFileChooser
	 *            Flag to display a file chooser.
	 * 
	 * @param persistFileName
	 *            Flag to persist the file name in the current netGUI.
	 */
	protected void performXLS1Save() {
		// Save As.
		try {
			File targetFile;
			if ((netGUI.getFile() != null) && (StringUtils.isNotBlank(netGUI.getFile().getAbsolutePath()))) {
				targetFile = ToolBox.setExtension(netGUI.getFile(), ".xls");
			} else {
				targetFile = null;
			}

			boolean ended = false;
			while (!ended) {

				// Manage possibility to select a target file.
				JFileChooser chooser = new JFileChooser();
				chooser.setSelectedFile(targetFile);

				chooser.setDialogTitle("Export to XLS version 1");
				chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
				chooser.setAcceptAllFileFilterUsed(false);
				GenericFileFilter defaultFileFilter = new GenericFileFilter("XLS version 1 (*.xls)", "xls");
				chooser.addChoosableFileFilter(defaultFileFilter);
				chooser.setFileFilter(defaultFileFilter);

				//
				if (chooser.showSaveDialog(frmPuck) == JFileChooser.APPROVE_OPTION) {
					System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
					System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
					targetFile = chooser.getSelectedFile();
					if (StringUtils.isBlank(ToolBox.getExtension(targetFile))) {
						targetFile = new File(targetFile.getAbsolutePath() + ".xls");
					}

				} else {
					// Nothing to do.
					System.out.println("No Selection ");
					ended = true;
				}

				//
				if (!ended) {
					boolean doSave;
					if (targetFile.exists()) {
						// Manage confirmation dialog.
						String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.title");
						String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.text");

						int response = JOptionPane.showConfirmDialog(frmPuck, message, title, JOptionPane.YES_NO_CANCEL_OPTION);

						if (response == JOptionPane.YES_OPTION) {
							doSave = true;
							ended = true;
						} else if (response == JOptionPane.NO_OPTION) {
							doSave = false;
							ended = false;
						} else {
							doSave = false;
							ended = true;
						}
					} else {
						doSave = true;
						ended = true;
					}

					if (doSave) {
						XLS1File.save(targetFile, netGUI.getNet());
					}
				}
			}
		} catch (final PuckException exception) {
			//
			String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");

			//
			String message;
			switch (PuckExceptions.valueOf(exception.getCode())) {
				case UNSUPPORTED_FILE_FORMAT:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
				break;
				case NOT_A_FILE:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
				break;
				case UNSUPPORTED_ENCODING:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
				break;
				default:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
			}

			//
			JOptionPane.showMessageDialog(frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
		}
	}

	/**
	 * 
	 * @param family
	 */
	public void selectFamiliesTab(final Family family) {
		this.tabbedPaneCorpus.setSelectedIndex(2);
		familiesTab.select(family);
	}

	/**
	 * 
	 */
	public void selectIndividualsTab() {
		this.tabbedPaneCorpus.setSelectedIndex(1);
	}

	/**
	 * 
	 */
	public void selectIndividualsTab(final Individual individual) {
		this.tabbedPaneCorpus.setSelectedIndex(1);
		this.individualsTab.select(individual);
	}

	/**
	 * 
	 * @param relation
	 */
	public void selectRelationTab(final Relation relation) {
		int tabIndex = getRelationTabIndex(relation.getModel());
		if (tabIndex != -1) {
			this.tabbedPaneCorpus.setSelectedIndex(tabIndex);
			RelationsPanel tab = (RelationsPanel) this.tabbedPaneCorpus.getComponent(tabIndex);
			tab.select(relation);
		}
	}

	/**
	 * 
	 * @param tabIndex
	 */
	public void selectTab(final int tabIndex) {
		this.tabbedPaneCorpus.setSelectedIndex(tabIndex);
	}

	/**
	 * 
	 */
	public void setIndividualsTab(final Individual individual) {
		this.individualsTab.select(individual);
	}

	public void toFront() {
		this.frmPuck.toFront();
	}

	/**
	 * 
	 * @param locale
	 */
	public void updateLocale(final Locale locale) {
		this.frmPuck.setLocale(locale);
		// initialize();
	}

	/**
	 * 
	 */
	public void updateMenuItems() {
		if (netGUI.isChanged()) {
			this.mntmSave.setEnabled(true);
			this.mntmRevert.setEnabled(true);
		} else {
			this.mntmSave.setEnabled(false);
			this.mntmRevert.setEnabled(false);
		}
	}

	/**
	 * 
	 */
	public void updateTitle() {
		String changeToken;
		if (netGUI.isChanged()) {
			changeToken = "*";

			// Set MAC OS X feature.
			frmPuck.getRootPane().putClientProperty("Window.documentModified", Boolean.TRUE);
		} else {
			changeToken = "";

			// Set MAC OS X feature.
			frmPuck.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
		}

		this.frmPuck.setTitle(changeToken + netGUI.getFile().getName() + "-" + netGUI.getId() + " - Puck");
	}

	/**
	 * 
	 */
	static public void callPuckHelp(final JMenuItem source) {
		String HELP_URL = "http://www.kintip.net/puck-aide-mainmenu-24";
		try {
			if (Desktop.isDesktopSupported()) {
				Desktop desktop = Desktop.getDesktop();
				if (desktop.isSupported(Desktop.Action.BROWSE)) {
					//
					java.net.URI uri = new java.net.URI(HELP_URL);
					desktop.browse(uri);
				} else if (source != null) {
					source.setEnabled(false);
				}
			} else if (source != null) {
				source.setEnabled(false);
			}
		} catch (java.io.IOException ioe) {
			ioe.printStackTrace();
			System.err.println("The system cannot find the URL specified: [" + HELP_URL + "]");
			JOptionPane.showMessageDialog(null, "Sorry, browser call failed.", "Error", JOptionPane.ERROR_MESSAGE);
		} catch (java.net.URISyntaxException use) {
			use.printStackTrace();
			System.out.println("Illegal character in path [" + HELP_URL + "]");
			JOptionPane.showMessageDialog(null, "Sorry, browser call failed.", "Error", JOptionPane.ERROR_MESSAGE);
		}
	}

	/**
	 * 
	 */
	public static int getDesktopHeight() {
		int result;

		Toolkit toolkit = Toolkit.getDefaultToolkit();

		// Get default screen size.
		Dimension dim = toolkit.getScreenSize();

		// Get default screen configuration.
		GraphicsConfiguration gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();

		// Get screen insets.
		Insets insets = toolkit.getScreenInsets(gconf);

		// Compute the desktop height.
		result = (int) (dim.getHeight() - insets.bottom - insets.top);

		//
		return result;
	}

	/**
	 * This classes is a static one to be called by OpenRecentMenuItem.java
	 * 
	 * 
	 * @param netGUI
	 * @param parentPanel
	 * @param folder
	 */
	static public void openEncodingFile(final NetGUI netGUI, final JFrame parentPanel, final File folder) {
		//
		String charsetName = OpenEncodingWindow.showDialog();
		logger.debug("charset=[" + charsetName + "]");

		//
		if (charsetName != null) {
			openFile(netGUI, parentPanel, folder, charsetName);
		}
	}

	/**
	 * This classes is a static one to be called by OpenRecentMenuItem.java
	 * 
	 * 
	 * @param netGUI
	 * @param parentPanel
	 * @param folder
	 */
	static public void openFile(final NetGUI netGUI, final JFrame parentPanel, final File folder) {
		openFile(netGUI, parentPanel, folder, PuckManager.DEFAULT_CHARSET_NAME);
	}

	/**
	 * This classes is a static one to be called by OpenRecentMenuItem.java
	 * 
	 * 
	 * @param netGUI
	 * @param parentPanel
	 * @param folder
	 */
	static public void openFile(final NetGUI netGUI, final JFrame parentPanel, final File folder, final String charsetName) {
		// Open file.
		try {
			//
			File file = selectFile(parentPanel, folder);

			//
			if (file != null) {
				//
				if (netGUI.isBlank()) {
					netGUI.updateFile(file, charsetName);
				} else {
					PuckGUI.instance().createNetGUI(file, charsetName);
				}
			}
		} catch (final PuckException exception) {
			exception.printStackTrace();

			//
			String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");

			//
			String message;
			switch (PuckExceptions.valueOf(exception.getCode())) {
				case FILE_NOT_FOUND:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
				break;
				case BAD_FILE_FORMAT:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
				break;
				case UNSUPPORTED_FILE_FORMAT:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
				break;
				case NOT_A_FILE:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
				break;
				case UNSUPPORTED_ENCODING:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
				break;
				default:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
			}

			//
			JOptionPane.showMessageDialog(parentPanel, message, title, JOptionPane.ERROR_MESSAGE);

		} catch (final Exception exception) {
			exception.printStackTrace();

			//
			String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");

			String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");

			//
			JOptionPane.showMessageDialog(parentPanel, message, title, JOptionPane.ERROR_MESSAGE);
		}
	}

	/**
	 * This classes is a static one to be called by OpenRecentMenuItem.java
	 * 
	 * 
	 * @param netGUI
	 * @param parentPanel
	 * @param folder
	 */
	static public File selectFile(final JFrame parentPanel, final File folder) {
		File result;

		//
		JFileChooser chooser = new JFileChooser();
		if ((folder != null) && (folder.exists()) && (folder.isDirectory())) {
			chooser.setCurrentDirectory(folder);
		} else if (PuckGUI.instance().recentFolders().isEmpty()) {
			chooser.setCurrentDirectory(new java.io.File("."));
		} else {
			chooser.setCurrentDirectory(PuckGUI.instance().recentFolders().getMoreRecent());
		}

		chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.openFileChooser.text"));
		chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		chooser.setAcceptAllFileFilterUsed(true);
		GenericFileFilter defaultFileFilter = new GenericFileFilter("Genealogic files (*.ged, *.ods, *.paj, *.pl, *.puc, *.tip, *.txt, *.txt3, *.xls, *.xml)",
				"ged", "ods", "paj", "pl", "puc", "tip", "txt", "txt3", "xls", "xml");
		chooser.addChoosableFileFilter(defaultFileFilter);
		chooser.addChoosableFileFilter(new GenericFileFilter("GEDCOM (*.ged)", "ged"));
		chooser.addChoosableFileFilter(new GenericFileFilter("OpenDocumentFormat Spreadsheet (*.ods)", "ods"));
		chooser.addChoosableFileFilter(new GenericFileFilter("Pajek Network (*.paj)", "paj"));
		chooser.addChoosableFileFilter(new GenericFileFilter("Prolog (*.pl)", "pl"));
		chooser.addChoosableFileFilter(new GenericFileFilter("PUCK (*.puc)", "puc"));
		chooser.addChoosableFileFilter(new GenericFileFilter("TIP (*.tip)", "tip"));
		chooser.addChoosableFileFilter(new GenericFileFilter("Text (*.txt)", "txt"));
		chooser.addChoosableFileFilter(new GenericFileFilter("Text version 3 (*.txt3)", "txt3"));
		chooser.addChoosableFileFilter(new GenericFileFilter("Microsoft Excel (*.xls)", "xls"));
		chooser.addChoosableFileFilter(new GenericFileFilter("Extensible Markup Language (*.xml)", "xml"));
		chooser.setFileFilter(defaultFileFilter);

		//
		if (chooser.showOpenDialog(parentPanel) == JFileChooser.APPROVE_OPTION) {
			System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
			System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
			result = chooser.getSelectedFile();
		} else {
			logger.debug("No Selection ");
			result = null;
		}

		//
		return result;
	}

	/**
	 * This classes is a static one to be called by OpenRecentMenuItem.java
	 * 
	 * 
	 * @param netGUI
	 * @param parentPanel
	 * @param folder
	 */
	static public File selectFolder(final JFrame parentPanel, final File folder) {
		File result;

		//
		JFileChooser chooser = new JFileChooser();
		if ((folder != null) && (folder.exists()) && (folder.isDirectory())) {
			chooser.setCurrentDirectory(folder);
		} else if (PuckGUI.instance().recentFolders().isEmpty()) {
			chooser.setCurrentDirectory(new java.io.File("."));
		} else {
			chooser.setCurrentDirectory(PuckGUI.instance().recentFolders().getMoreRecent());
		}

		chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.openFileChooser.text"));
		chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		chooser.setAcceptAllFileFilterUsed(true);

		//
		if (chooser.showOpenDialog(parentPanel) == JFileChooser.APPROVE_OPTION) {
			System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
			System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
			result = chooser.getSelectedFile();
		} else {
			logger.debug("No Selection ");
			result = null;
		}

		//
		return result;
	}

	/**
	 * 
	 * 
	 * @param netGUI
	 * @param parentPanel
	 * @param folder
	 */
	static public File selectODSFileToLoad(final Component parentPanel, final File targetFile) {
		File result;

		//
		JFileChooser chooser = new JFileChooser();

		if ((targetFile != null) && (StringUtils.isNotBlank(targetFile.getAbsolutePath()))) {
			chooser.setSelectedFile(ToolBox.setExtension(targetFile, ".ods"));
		}
		chooser.setDialogTitle("Import ODS version 1 & 2");
		chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		chooser.setAcceptAllFileFilterUsed(false);
		GenericFileFilter defaultFileFilter = new GenericFileFilter("ODS version 1 (*.ods)", "ods");
		chooser.addChoosableFileFilter(defaultFileFilter);
		chooser.setFileFilter(defaultFileFilter);

		//
		if (chooser.showOpenDialog(parentPanel) == JFileChooser.APPROVE_OPTION) {
			System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
			System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
			result = chooser.getSelectedFile();
		} else {
			result = null;
		}

		//
		return result;
	}

	/**
	 * 
	 * 
	 * @param netGUI
	 * @param parentPanel
	 * @param folder
	 */
	static public File selectXLSFileToLoad(final Component parentPanel, final File targetFile) {
		File result;

		//
		JFileChooser chooser = new JFileChooser();

		if ((targetFile != null) && (StringUtils.isNotBlank(targetFile.getAbsolutePath()))) {
			chooser.setSelectedFile(ToolBox.setExtension(targetFile, ".xls"));
		}
		chooser.setDialogTitle("Import XLS version 1 & 2");
		chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		chooser.setAcceptAllFileFilterUsed(false);
		GenericFileFilter defaultFileFilter = new GenericFileFilter("XLS version 1 (*.xls)", "xls");
		chooser.addChoosableFileFilter(defaultFileFilter);
		chooser.setFileFilter(defaultFileFilter);

		//
		if (chooser.showOpenDialog(parentPanel) == JFileChooser.APPROVE_OPTION) {
			System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
			System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
			result = chooser.getSelectedFile();
		} else {
			result = null;
		}

		//
		return result;
	}
}
