package org.tip.puckgui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneConstants;
import javax.swing.SwingConstants;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.UnionStatus;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.util.NumberablesHashMap.IdStrategy;
import org.tip.puck.util.ToolBox;
import org.tip.puckgui.InputSettings.CheckLevel;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.models.IndividualChildrenModel;
import org.tip.puckgui.models.IndividualRelationsModel;
import org.tip.puckgui.models.IndividualSpousesModel;
import org.tip.puckgui.models.IndividualsCellRenderer;
import org.tip.puckgui.models.IndividualsModel;
import org.tip.puckgui.util.AutoComboBox;
import org.tip.puckgui.util.ComboBoxIds;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;

/**
 * 
 * @author TIP
 */
public class IndividualsPanel extends JPanel {

	private static final long serialVersionUID = 651718283569255829L;

	static private final Logger logger = LoggerFactory.getLogger(IndividualsPanel.class);

	int reportCounter = 0;
	private JPanel thisJPanel;
	private JTextField txtfldSearchIndividual;
	private NetGUI netGUI;
	private UnionStatus defaultUnionStatus = UnionStatus.MARRIED;
	private JTable tableIndividualSpouses;
	private JTable tableIndividualChildren;
	private JLabel lblIndividualId;
	private JLabel lblIndividualGender;
	JLabel lblIndividualParent1Id;
	JLabel lblIndividualParent2Id;
	JLabel lblIndividualParent1Name;
	JLabel lblIndividualParent2Name;
	JList individualList;
	JScrollPane individualsScrollPane;
	private static ImageIcon mediumFemaleIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/female-32x32.png"));
	private static ImageIcon mediumMaleIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/male-32x32.png"));
	private static ImageIcon mediumUnknowIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/unknown-32x32.png"));
	private static ImageIcon smallUnmarriedIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/unmarried-x16.png"));
	private static ImageIcon smallMarriedIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/married-x16.png"));
	private static ImageIcon smallDivorcedIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/divorced-x16.png"));
	private static ImageIcon mediumUnmarriedIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/unmarried-x23.png"));
	private static ImageIcon mediumMarriedIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/married-x23.png"));
	private static ImageIcon mediumDivorcedIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/divorced-x23.png"));
	private static ImageIcon largeFemaleIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/female-64x64.png"));
	private static ImageIcon largeMaleIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/male-64x64.png"));
	private static ImageIcon largeUnknowIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/unknown-64x64.png"));
	private static ImageIcon insertIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/insert-x16.png"));
	private static ImageIcon appendIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/append-x16.png"));
	private JLabel lblIndividualSpouses;
	private JLabel lblChildren;
	private JLabel lblFamilyId;
	private JLabel lblFamilyStatus;
	private JLabel lblPosition;
	private JTable tableIndividualRelations;
	private JLabel lblRelations;
	private JLabel lblIndividualFirstName;
	private AutoComboBox cmbbxIndividualFirstName;
	private AutoComboBox cmbbxIndividualLastName;
	private AttributesPanel attributesPanel;
	private JLabel lblIndividualLastName;
	private JLabel lblFirstLastNameSeparator;
	private AutoComboBox cmbbxIndividualParent1;
	private AutoComboBox cmbbxIndividualParent2;
	private AutoComboBox cmbbxIndividualChildrenIds;
	private AutoComboBox cmbbxIndividualSpousesIds;
	private JButton btnAddPartner;
	private JButton btnAddChild;
	private JTextField txtFldIndividualId;
	private boolean doLostFocus = true;
	private JToggleButton tglbtnIndividualIdStrategy;
	private JToggleButton tglbtnFamilyIdStrategy;
	private JButton btnDefaultUnionStatus;

	/**
	 * Initialize the contents of the frame.
	 */
	public IndividualsPanel(final NetGUI guiManager) {

		//
		this.thisJPanel = this;
		this.netGUI = guiManager;

		//
		setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));

		JSplitPane individualsSplit = new JSplitPane();
		add(individualsSplit);
		individualsSplit.setAlignmentX(Component.CENTER_ALIGNMENT);

		JPanel individualsPanel = new JPanel();
		individualsPanel.setMinimumSize(new Dimension(200, 10));
		individualsSplit.setLeftComponent(individualsPanel);
		individualsPanel.setLayout(new BoxLayout(individualsPanel, BoxLayout.Y_AXIS));

		individualsScrollPane = new JScrollPane();
		individualsScrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
		individualsPanel.add(individualsScrollPane);

		individualList = new JList();
		individualList.setDoubleBuffered(true);
		individualList.addListSelectionListener(new ListSelectionListener() {
			@Override
			public void valueChanged(final ListSelectionEvent event) {
				logger.debug("event = " + event.getValueIsAdjusting() + " " + event.getFirstIndex() + " " + event.getLastIndex() + " "
						+ individualList.getSelectedIndex());

				// Selected.
				if (individualList.getSelectedIndex() != -1) {
					Individual individual = (Individual) ((JList) event.getSource()).getModel().getElementAt(individualList.getSelectedIndex());
					updateIndividualIdentity(individual);
				}
			}
		});
		individualList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

		individualList.setCellRenderer(new IndividualsCellRenderer());
		individualList.setModel(new IndividualsModel(null));
		individualsScrollPane.setViewportView(individualList);

		JPanel individualPanel = new JPanel();
		individualsSplit.setRightComponent(individualPanel);
		individualPanel.setAlignmentX(Component.LEFT_ALIGNMENT);
		individualPanel.setAlignmentY(Component.TOP_ALIGNMENT);
		individualPanel.setLayout(new BoxLayout(individualPanel, BoxLayout.Y_AXIS));

		JPanel panelIndividualIdentity = new JPanel();
		individualPanel.add(panelIndividualIdentity);
		panelIndividualIdentity.setLayout(new BoxLayout(panelIndividualIdentity, BoxLayout.X_AXIS));

		Component horizontalStrut = Box.createHorizontalStrut(20);
		panelIndividualIdentity.add(horizontalStrut);

		JPanel panel_2 = new JPanel();
		panelIndividualIdentity.add(panel_2);
		panel_2.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, }));

		JPanel panel = new JPanel();
		panel_2.add(panel, "2, 2");
		panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));

		Component verticalStrut_9 = Box.createVerticalStrut(20);
		verticalStrut_9.setMaximumSize(new Dimension(20, 20));
		panel.add(verticalStrut_9);

		lblIndividualId = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.label.text_2"));
		lblIndividualId.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent e) {
				//
				logger.debug("Individual id clicked");

				setIndividualIdEditorOn();
			}
		});

		lblIndividualId.setAlignmentX(Component.RIGHT_ALIGNMENT);
		panel.add(lblIndividualId);

		txtFldIndividualId = new JTextField();
		txtFldIndividualId.setFocusTraversalKeysEnabled(false);
		txtFldIndividualId.addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(final KeyEvent event) {
				// INDIVIDUAL ID KEYPRESSED.
				try {
					if (event.getKeyCode() == KeyEvent.VK_ESCAPE) {
						logger.debug("escape pressed");
						txtFldIndividualId.transferFocus();
					} else if (event.getKeyCode() == KeyEvent.VK_ENTER) {
						logger.debug("enter pressed");
						save();
						txtFldIndividualId.transferFocus();
					} else if (event.getKeyCode() == KeyEvent.VK_TAB) {
						if (event.isShiftDown()) {
							logger.debug("shift-tab pressed");
							save();
							txtFldIndividualId.transferFocus();
						} else {
							logger.debug("tab pressed");
							save();
							txtFldIndividualId.transferFocus();
							setFirstNameEditorOn();
						}
					}
				} catch (PuckException exception) {
					// Save failed.
					txtFldIndividualId.requestFocus();
				}
			}

			public void save() throws PuckException {
				//
				String input = txtFldIndividualId.getText();
				logger.debug("[lbl,cmb]=[" + lblIndividualId.getText() + "," + input + "]");

				if ((StringUtils.isNotBlank(input)) && (!StringUtils.equals(lblIndividualId.getText(), input))) {
					input = input.trim();
					if (NumberUtils.isDigits(input)) {
						//
						int targetId = Integer.parseInt(input);

						Individual individual = netGUI.getNet().individuals().getById(targetId);
						if (individual == null) {
							//
							Individual currentIndividual = getSelectedIndividual();
							netGUI.getNet().changeId(currentIndividual, targetId);
							netGUI.setChanged(true);

							//
							lblIndividualId.setVisible(true);
							txtFldIndividualId.setVisible(false);

							//
							netGUI.updateAll();

							//
							select(currentIndividual);
						} else {
							doLostFocus = false;
							JOptionPane.showMessageDialog(thisJPanel, "ID already in use.", "Invalid id", JOptionPane.ERROR_MESSAGE);
							doLostFocus = true;
							throw PuckExceptions.INVALID_PARAMETER.create();
						}
					} else {
						doLostFocus = false;
						JOptionPane.showMessageDialog(thisJPanel, "Numeric value required.", "Invalid id", JOptionPane.ERROR_MESSAGE);
						doLostFocus = true;
						throw PuckExceptions.INVALID_PARAMETER.create();
					}
				}
			}
		});

		txtFldIndividualId.addFocusListener(new FocusAdapter() {
			@Override
			public void focusLost(final FocusEvent e) {
				logger.debug("FOCUS LOST INDIVIDUAL ID");

				//
				if (doLostFocus) {
					lblIndividualId.setVisible(true);
					txtFldIndividualId.setVisible(false);
				}
			}
		});
		panel.add(txtFldIndividualId);
		txtFldIndividualId.setColumns(10);

		Component verticalStrut_8 = Box.createVerticalStrut(10);
		verticalStrut_8.setMaximumSize(new Dimension(20, 10));
		panel.add(verticalStrut_8);

		lblPosition = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.lblNewLabel.text")); //$NON-NLS-1$ //$NON-NLS-2$
		lblPosition.setAlignmentX(Component.RIGHT_ALIGNMENT);
		panel.add(lblPosition);

		lblIndividualGender = new JLabel("");
		panel_2.add(lblIndividualGender, "4, 2");
		lblIndividualGender.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent e) {
				// Click gender.
				lblIndividualGender.requestFocus();
				Individual currentIndividual = getSelectedIndividual();
				if (currentIndividual != null) {
					//
					switch (currentIndividual.getGender()) {
						case FEMALE:
							currentIndividual.setGender(Gender.MALE);
						break;
						case MALE:
							currentIndividual.setGender(Gender.UNKNOWN);
						break;
						case UNKNOWN:
							currentIndividual.setGender(Gender.FEMALE);
						break;
					}

					//
					updateIndividualIdentity(currentIndividual);

					//
					netGUI.setChanged(true);
				}
			}
		});
		lblIndividualGender.setFont(new Font("Dialog", Font.PLAIN, 24));
		lblIndividualGender.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/female-64x64.png")));

		lblIndividualFirstName = new JLabel("X");
		lblIndividualFirstName.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent e) {
				// Individual first name clicked.
				logger.debug("First Name clicked");
				setFirstNameEditorOn();
			}
		});
		panel_2.add(lblIndividualFirstName, "6, 2");
		lblIndividualFirstName.setFont(new Font("Dialog", Font.PLAIN, 24));

		cmbbxIndividualFirstName = new AutoComboBox(null);
		cmbbxIndividualFirstName.setVisible(false);
		cmbbxIndividualFirstName.setStrict(false);
		cmbbxIndividualFirstName.setMaximumRowCount(10);
		cmbbxIndividualFirstName.getEditor().getEditorComponent().setFocusTraversalKeysEnabled(false);

		// Custom manually.
		cmbbxIndividualFirstName.getEditor().getEditorComponent().addFocusListener(new FocusListener() {
			@Override
			public void focusGained(final FocusEvent arg0) {
				logger.debug("FOCUS GAINED FIRST NAME");
			}

			@Override
			public void focusLost(final FocusEvent arg0) {
				logger.debug("FOCUS LOST FIRST NAME");

				//
				cmbbxIndividualFirstName.setVisible(false);
				lblIndividualFirstName.setVisible(true);

				// Clean.
				cmbbxIndividualFirstName.setDataList(new ArrayList<String>());
			}
		});

		cmbbxIndividualFirstName.getEditor().getEditorComponent().addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(final KeyEvent event) {
				// Cancel.
				if (event.getKeyCode() == KeyEvent.VK_ESCAPE) {
					logger.debug("escape pressed");

					if (StringUtils.isBlank(lblIndividualFirstName.getText())) {
						cmbbxIndividualFirstName.getEditor().setItem("?");
						save();
					}
					cmbbxIndividualFirstName.getEditor().getEditorComponent().transferFocus();
				} else if (event.getKeyCode() == KeyEvent.VK_ENTER) {
					logger.debug("enter pressed");
					save();
					cmbbxIndividualFirstName.getEditor().getEditorComponent().transferFocus();
				} else if (event.getKeyCode() == KeyEvent.VK_TAB) {
					if (event.isShiftDown()) {
						logger.debug("shift-tab pressed");
						save();
						cmbbxIndividualFirstName.getEditor().getEditorComponent().transferFocus();
						setIndividualIdEditorOn();
					} else {
						logger.debug("tab pressed");
						save();
						cmbbxIndividualFirstName.getEditor().getEditorComponent().transferFocus();
						setLastNameEditorOn();
					}
				}
			}

			public void save() {
				String input = (String) cmbbxIndividualFirstName.getEditor().getItem();
				logger.debug("[lbl,cmb]=[" + lblIndividualFirstName.getText() + "," + input + "]");

				if (!StringUtils.equals(lblIndividualFirstName.getText(), input)) {
					//
					Individual individual = getIdentityIndividual();
					if (individual != null) {
						if (StringUtils.isBlank(input)) {
							lblIndividualFirstName.setText("?");
							individual.setFirstName("?");
						} else {
							lblIndividualFirstName.setText(input);
							individual.setFirstName(input);
						}

						//
						netGUI.setChanged(true);
						netGUI.updateAll();
					}
				}
			}
		});

		panel_2.add(cmbbxIndividualFirstName, "7, 2");

		lblFirstLastNameSeparator = new JLabel("/");
		lblFirstLastNameSeparator.setFont(new Font("Dialog", Font.PLAIN, 24));
		panel_2.add(lblFirstLastNameSeparator, "9, 2");

		lblIndividualLastName = new JLabel("Y");
		lblIndividualLastName.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent e) {
				// Individual last name clicked.
				logger.debug("Last Name clicked");
				setLastNameEditorOn();
			}
		});
		lblIndividualLastName.setFont(new Font("Dialog", Font.PLAIN, 24));
		panel_2.add(lblIndividualLastName, "11, 2, right, default");

		cmbbxIndividualLastName = new AutoComboBox(null);
		cmbbxIndividualLastName.setVisible(false);
		cmbbxIndividualLastName.setStrict(false);
		cmbbxIndividualLastName.setMaximumRowCount(10);
		cmbbxIndividualLastName.getEditor().getEditorComponent().setFocusTraversalKeysEnabled(false);

		// Custom manually.
		cmbbxIndividualLastName.getEditor().getEditorComponent().addFocusListener(new FocusListener() {
			@Override
			public void focusGained(final FocusEvent arg0) {
				logger.debug("FOCUS GAINED LAST NAME");
			}

			@Override
			public void focusLost(final FocusEvent arg0) {
				logger.debug("FOCUS LOST LAST NAME");

				//
				cmbbxIndividualLastName.setVisible(false);
				lblIndividualLastName.setVisible(true);

				// Clean.
				cmbbxIndividualLastName.setDataList(new ArrayList<String>());
			}
		});

		cmbbxIndividualLastName.getEditor().getEditorComponent().addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(final KeyEvent event) {
				// Cancel.
				if (event.getKeyCode() == KeyEvent.VK_ESCAPE) {
					logger.debug("escape pressed");

					cmbbxIndividualLastName.getEditor().getEditorComponent().transferFocus();
				} else if (event.getKeyCode() == KeyEvent.VK_ENTER) {
					logger.debug("enter pressed");
					save();
					cmbbxIndividualLastName.getEditor().getEditorComponent().transferFocus();
				} else if (event.getKeyCode() == KeyEvent.VK_TAB) {
					if (event.isShiftDown()) {
						logger.debug("shift-tab pressed");
						save();
						setFirstNameEditorOn();
					} else {
						logger.debug("tab pressed");
						save();
						cmbbxIndividualLastName.getEditor().getEditorComponent().transferFocus();
						setParent1IdEditorOn();
					}
				}
			}

			public void save() {
				String input = (String) cmbbxIndividualLastName.getEditor().getItem();
				logger.debug("[lbl,cmb]=[" + lblIndividualLastName.getText() + "," + input + "]");

				if (!StringUtils.equals(input, lblIndividualLastName.getText())) {
					if (NumberUtils.isDigits(lblIndividualId.getText())) {
						Individual individual = netGUI.getNet().individuals().getById(Integer.parseInt(lblIndividualId.getText()));
						individual.setLastName(input);
						netGUI.setChanged(true);
						netGUI.updateAll();
					}
				}
			}
		});

		panel_2.add(cmbbxIndividualLastName, "12, 2, fill, default");

		Component horizontalGlue_2 = Box.createHorizontalGlue();
		panelIndividualIdentity.add(horizontalGlue_2);

		JPanel panel_12 = new JPanel();
		panelIndividualIdentity.add(panel_12);
		panel_12.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.GLUE_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				FormFactory.DEFAULT_COLSPEC, FormFactory.DEFAULT_COLSPEC, ColumnSpec.decode("max(100dlu;default)"), }, new RowSpec[] {
				FormFactory.GLUE_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.GLUE_ROWSPEC, }));

		cmbbxIndividualParent1 = new AutoComboBox(null);
		cmbbxIndividualParent1.setStrict(false);
		cmbbxIndividualParent1.setVisible(false);
		cmbbxIndividualParent1.setMaximumRowCount(10);
		cmbbxIndividualParent1.getEditor().getEditorComponent().setFocusTraversalKeysEnabled(false);

		// Custom manually.
		cmbbxIndividualParent1.getEditor().getEditorComponent().addFocusListener(new FocusListener() {
			@Override
			public void focusGained(final FocusEvent arg0) {
				logger.debug("FOCUS GAINED PARENT 1 ID");
			}

			@Override
			public void focusLost(final FocusEvent arg0) {
				logger.debug("FOCUS LOST PARENT 1 ID");

				if (doLostFocus) {
					logger.debug("unfocus parent 1 ID");
					//
					cmbbxIndividualParent1.setVisible(false);
					lblIndividualParent1Id.setVisible(true);
					lblIndividualParent1Name.setVisible(true);

					// Clean.
					cmbbxIndividualParent1.setDataList(new ArrayList<String>());
				}
			}
		});

		cmbbxIndividualParent1.getEditor().getEditorComponent().addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(final KeyEvent event) {
				try {
					// Cancel.
					if (event.getKeyCode() == KeyEvent.VK_ESCAPE) {
						logger.debug("escape pressed");

						cmbbxIndividualParent1.getEditor().getEditorComponent().transferFocus();
					} else if (event.getKeyCode() == KeyEvent.VK_ENTER) {
						logger.debug("enter pressed");
						save();
						cmbbxIndividualParent1.getEditor().getEditorComponent().transferFocus();
					} else if (event.getKeyCode() == KeyEvent.VK_TAB) {
						if (event.isShiftDown()) {
							logger.debug("shift-tab pressed");
							save();
							cmbbxIndividualParent1.getEditor().getEditorComponent().transferFocus();
							setLastNameEditorOn();
						} else {
							logger.debug("tab pressed");
							save();
							cmbbxIndividualParent1.getEditor().getEditorComponent().transferFocus();
							setParent2IdEditorOn();
						}
					}
				} catch (PuckException exception) {
					// In case of failed save.
					logger.debug("SAVE FAILED");
					cmbbxIndividualParent1.getEditor().getEditorComponent().requestFocus();
				}
			}

			public void save() throws PuckException {
				String input = (String) cmbbxIndividualParent1.getEditor().getItem();
				logger.debug("[lbl,cmb]=[" + lblIndividualParent1Id.getText() + "," + input + "]");

				// In case of new partner created with id lesser than
				// the current individual, the current index
				// value becomes wrong. So we need to save the
				// previous one.
				Individual currentIndividual = netGUI.selectedIndividual();

				//
				Individual newFather = ComboBoxIds.getOrCreateIndividualFromInput(netGUI.getIndividualIdStrategy(), netGUI.getNet(), input, Gender.MALE);

				if (newFather != currentIndividual.getFather()) {
					// Make controls.
					Individual ego = getIdentityIndividual();

					// Check errors.
					String errorMessage = controlPartners(CheckLevel.ERROR, newFather, ego.getMother(), ego);
					if (errorMessage != null) {
						doLostFocus = false;
						JOptionPane.showMessageDialog(thisJPanel, errorMessage, "Error", JOptionPane.ERROR_MESSAGE);
						doLostFocus = true;
						throw PuckExceptions.INVALID_PARAMETER.create();
					} else {
						//
						NetUtils.setKinFather(netGUI.getNet(), newFather, ego);
						if (ego.getOriginFamily().numberOfParents() == 2) {
							ego.getOriginFamily().setUnionStatus(getDefaultUnionStatus());
						}
						netGUI.updateAll();

						// In case of new partner created with id lesser than
						// the
						// current individual, the current index value becomes
						// wrong. So we need to set the previous one.
						netGUI.selectIndividualsTab(currentIndividual);

						// Check warning.
						String warningMessage = controlPartners(CheckLevel.WARNING, newFather, ego.getMother(), ego);
						if (warningMessage != null) {
							JOptionPane.showMessageDialog(thisJPanel, warningMessage, "Warning", JOptionPane.WARNING_MESSAGE);
						}
					}
				}
			}
		});

		panel_12.add(cmbbxIndividualParent1, "5, 2, 2, 1, fill, default");

		cmbbxIndividualParent2 = new AutoComboBox(null);
		cmbbxIndividualParent2.setStrict(false);
		cmbbxIndividualParent2.setVisible(false);
		cmbbxIndividualParent2.setMaximumRowCount(10);
		cmbbxIndividualParent2.getEditor().getEditorComponent().setFocusTraversalKeysEnabled(false);

		// Custom manually.
		cmbbxIndividualParent2.getEditor().getEditorComponent().addFocusListener(new FocusListener() {
			@Override
			public void focusGained(final FocusEvent arg0) {
				logger.debug("FOCUS GAINED PARENT 2 ID");
			}

			@Override
			public void focusLost(final FocusEvent arg0) {
				logger.debug("FOCUS LOST PARENT 2 ID");

				//
				if (doLostFocus) {
					cmbbxIndividualParent2.setVisible(false);
					lblIndividualParent2Id.setVisible(true);
					lblIndividualParent2Name.setVisible(true);

					// Clean.
					cmbbxIndividualParent2.setDataList(new ArrayList<String>());
				}
			}
		});

		cmbbxIndividualParent2.getEditor().getEditorComponent().addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(final KeyEvent event) {
				try {
					//
					if (event.getKeyCode() == KeyEvent.VK_ESCAPE) {
						logger.debug("escape pressed");
						cmbbxIndividualParent2.getEditor().getEditorComponent().transferFocus();
					} else if (event.getKeyCode() == KeyEvent.VK_ENTER) {
						logger.debug("enter pressed");
						save();
						cmbbxIndividualParent2.getEditor().getEditorComponent().transferFocus();
					} else if (event.getKeyCode() == KeyEvent.VK_TAB) {
						if (event.isShiftDown()) {
							logger.debug("shift-tab pressed");
							save();
							cmbbxIndividualParent2.getEditor().getEditorComponent().transferFocus();
							setParent1IdEditorOn();
						} else {
							logger.debug("tab pressed");
							save();
							cmbbxIndividualParent2.getEditor().getEditorComponent().transferFocus();
						}
					}
				} catch (PuckException exception) {
					// In case of failed save.
					logger.debug("SAVE FAILED");
					cmbbxIndividualParent2.getEditor().getEditorComponent().requestFocus();
				}
			}

			public void save() throws PuckException {
				String input = (String) cmbbxIndividualParent2.getEditor().getItem();
				logger.debug("[lbl,cmb]=[" + lblIndividualParent2Id.getText() + "," + input + "]");

				// In case of new partner created with id lesser than
				// the current individual, the current index
				// value becomes wrong. So we need to save the
				// previous one.
				Individual currentIndividual = netGUI.selectedIndividual();

				//
				Individual newMother = ComboBoxIds.getOrCreateIndividualFromInput(netGUI.getIndividualIdStrategy(), netGUI.getNet(), input, Gender.FEMALE);

				if (newMother != currentIndividual.getMother()) {
					// Make controls.
					Individual ego = getIdentityIndividual();

					// Check errors.
					String errorMessage = controlPartners(CheckLevel.ERROR, ego.getFather(), newMother, ego);
					if (errorMessage != null) {
						doLostFocus = false;
						JOptionPane.showMessageDialog(thisJPanel, errorMessage, "Error", JOptionPane.ERROR_MESSAGE);
						doLostFocus = true;
						throw PuckExceptions.INVALID_PARAMETER.create();
					} else {
						//
						NetUtils.setKinMother(netGUI.getNet(), newMother, getIdentityIndividual());
						if (ego.getOriginFamily().numberOfParents() == 2) {
							ego.getOriginFamily().setUnionStatus(getDefaultUnionStatus());
						}
						netGUI.updateAll();

						// In case of new partner created with id lesser than
						// the
						// current individual, the current index value becomes
						// wrong. So we need to set the previous one.
						netGUI.selectIndividualsTab(currentIndividual);

						// Check warning.
						String warningMessage = controlPartners(CheckLevel.WARNING, ego.getFather(), newMother, ego);
						if (warningMessage != null) {
							JOptionPane.showMessageDialog(thisJPanel, warningMessage, "Warning", JOptionPane.WARNING_MESSAGE);
						}
					}
				}
			}
		});

		lblFamilyId = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.lblFamilyid.text"));
		lblFamilyId.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent event) {
				// Family Id clicked.
				if (event.getClickCount() == 2) {
					int selectedIndex = individualList.getSelectedIndex();
					if (selectedIndex != -1) {
						Individual selected = (Individual) ((IndividualsModel) individualList.getModel()).getElementAt(selectedIndex);
						if (selected != null) {
							if (selected.getOriginFamily() != null) {
								netGUI.selectFamiliesTab(selected.getOriginFamily());
							}
						}
					}
				}
			}
		});
		panel_12.add(lblFamilyId, "2, 2, 1, 4");

		lblFamilyStatus = new JLabel("");
		panel_12.add(lblFamilyStatus, "4, 2, 1, 4");
		lblFamilyStatus.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent event) {
				// Family Id clicked.
				if (event.getClickCount() == 2) {
					int selectedIndex = individualList.getSelectedIndex();
					if (selectedIndex != -1) {
						Individual selected = (Individual) ((IndividualsModel) individualList.getModel()).getElementAt(selectedIndex);
						if (selected != null) {
							if (selected.getOriginFamily() != null) {
								netGUI.selectFamiliesTab(selected.getOriginFamily());
							}
						}
					}
				}
			}
		});
		lblFamilyStatus.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/unmarried-x23.png")));

		JPopupMenu popupMenu_4 = new JPopupMenu();
		addPopup(lblFamilyStatus, popupMenu_4);

		JMenuItem mntmCreate = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.mntmCreate.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmCreate.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Create Origin Family.
				addOriginFamily();
			}
		});
		mntmCreate.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_U, InputEvent.CTRL_MASK));
		popupMenu_4.add(mntmCreate);

		lblIndividualParent1Id = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblIndividualParent1Id.text"));
		panel_12.add(lblIndividualParent1Id, "5, 3");
		lblIndividualParent1Id.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent e) {
				// Individual parent 1 id clicked.
				logger.debug("Parent 1 id clicked");
				setParent1IdEditorOn();
			}
		});
		lblIndividualParent1Id.setHorizontalAlignment(SwingConstants.RIGHT);
		lblIndividualParent1Id.setAlignmentX(Component.RIGHT_ALIGNMENT);

		lblIndividualParent1Name = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblFather.text"));
		panel_12.add(lblIndividualParent1Name, "6, 3");
		lblIndividualParent1Name.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent event) {
				try {
					// Parent 1 clicked.
					if (event.getClickCount() == 2) {
						Individual selected = getIdentityIndividual();
						if ((selected != null) && (selected.getFather() != null)) {
							netGUI.changeSegmentationToCluster(selected.getFather());
						}
					}
				} catch (final PuckException exception) {
					exception.printStackTrace();
				}
			}
		});
		lblIndividualParent1Name.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/male-32x32.png")));

		JPopupMenu popupMenu_2 = new JPopupMenu();
		addPopup(lblIndividualParent1Name, popupMenu_2);

		JMenuItem mntmSwapParent = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.mntmSwapParent.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmSwapParent.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Swap Individual parents.
				Individual currentIndividual = netGUI.selectedIndividual();
				if ((currentIndividual != null) && (currentIndividual.isNotOrphan())) {
					NetUtils.swapParents(currentIndividual.getOriginFamily());
					netGUI.setChanged(true);
					netGUI.updateAll();
					netGUI.selectIndividualsTab(currentIndividual);
				}
			}
		});

		JMenuItem mntmDelete_2 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.mntmDelete_2.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmDelete_2.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Delete parent 1.
				Individual ego = getIdentityIndividual();
				if (ego != null) {
					Family family = ego.getOriginFamily();

					if ((family != null) && (family.getFather() != null)) {
						//
						NetUtils.removeFather(family);

						try {
							netGUI.getSegmentation().refresh();
						} catch (PuckException exception) {
							// TODO Auto-generated catch block
							exception.printStackTrace();
						}
						netGUI.updateAll();
						netGUI.setChanged(true);
					}
				}
			}
		});
		popupMenu_2.add(mntmDelete_2);
		popupMenu_2.add(mntmSwapParent);

		lblIndividualParent2Id = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblIndividualParent2Id.text"));
		lblIndividualParent2Id.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent e) {
				// Individual parent 2 id clicked.
				logger.debug("Parent 2 id clicked");
				setParent2IdEditorOn();
			}
		});
		panel_12.add(lblIndividualParent2Id, "5, 4");
		lblIndividualParent2Id.setHorizontalAlignment(SwingConstants.RIGHT);
		lblIndividualParent2Id.setAlignmentX(Component.RIGHT_ALIGNMENT);

		lblIndividualParent2Name = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblMother.text"));
		panel_12.add(lblIndividualParent2Name, "6, 4");
		lblIndividualParent2Name.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent event) {
				// Individual Parent 2 clicked.
				try {
					Individual selected = getIdentityIndividual();
					if ((selected != null) && (selected.getMother() != null)) {
						netGUI.changeSegmentationToCluster(selected.getMother());
					}
				} catch (final PuckException exception) {
					exception.printStackTrace();
				}
			}
		});
		lblIndividualParent2Name.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/female-32x32.png")));

		JPopupMenu popupMenu_3 = new JPopupMenu();
		addPopup(lblIndividualParent2Name, popupMenu_3);

		JMenuItem mntmDelete_3 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.mntmDelete_3.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmDelete_3.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Delete parent 2.
				Individual ego = getIdentityIndividual();
				if (ego != null) {
					Family family = ego.getOriginFamily();

					if ((family != null) && (family.getMother() != null)) {
						//
						NetUtils.removeMother(family);

						try {
							netGUI.getSegmentation().refresh();
						} catch (PuckException exception) {
							// TODO Auto-generated catch block
							exception.printStackTrace();
						}
						netGUI.updateAll();
						netGUI.setChanged(true);
					}
				}
			}
		});
		popupMenu_3.add(mntmDelete_3);
		panel_12.add(cmbbxIndividualParent2, "5, 5, 2, 1, fill, default");

		JPanel panel_9 = new JPanel();
		panelIndividualIdentity.add(panel_9);
		panel_9.setLayout(new BoxLayout(panel_9, BoxLayout.Y_AXIS));

		JPanel panel_10 = new JPanel();
		panel_9.add(panel_10);
		panel_10.setLayout(new BoxLayout(panel_10, BoxLayout.X_AXIS));

		JPanel panel_11 = new JPanel();
		panel_9.add(panel_11);
		panel_11.setLayout(new BoxLayout(panel_11, BoxLayout.X_AXIS));

		JPanel panel_3 = new JPanel();
		panelIndividualIdentity.add(panel_3);
		panel_3.setLayout(new BoxLayout(panel_3, BoxLayout.Y_AXIS));

		Component verticalStrut_7 = Box.createVerticalStrut(10);
		verticalStrut_7.setMaximumSize(new Dimension(30, 16));
		panel_3.add(verticalStrut_7);

		JPanel panel_4 = new JPanel();
		panelIndividualIdentity.add(panel_4);
		panel_4.setLayout(new BoxLayout(panel_4, BoxLayout.Y_AXIS));

		Component horizontalStrut_1 = Box.createHorizontalStrut(20);
		panelIndividualIdentity.add(horizontalStrut_1);

		Component verticalStrut = Box.createVerticalStrut(10);
		individualPanel.add(verticalStrut);

		JPanel panel_6 = new JPanel();
		individualPanel.add(panel_6);
		panel_6.setLayout(new BorderLayout(0, 0));

		JSplitPane splitPane_1 = new JSplitPane();
		panel_6.add(splitPane_1, BorderLayout.CENTER);
		splitPane_1.setOrientation(JSplitPane.VERTICAL_SPLIT);

		JSplitPane splitPane_2 = new JSplitPane();
		splitPane_2.setOrientation(JSplitPane.VERTICAL_SPLIT);
		splitPane_1.setRightComponent(splitPane_2);

		JPanel panelIndividualChildren = new JPanel();
		panelIndividualChildren.setBorder(new EmptyBorder(0, 0, 0, 10));
		panelIndividualChildren.setMinimumSize(new Dimension(10, 150));
		splitPane_2.setLeftComponent(panelIndividualChildren);
		panelIndividualChildren.setLayout(new BoxLayout(panelIndividualChildren, BoxLayout.Y_AXIS));

		Component verticalStrut_1 = Box.createVerticalStrut(5);
		panelIndividualChildren.add(verticalStrut_1);

		JPanel panel_7 = new JPanel();
		panel_7.setAlignmentX(Component.LEFT_ALIGNMENT);
		panelIndividualChildren.add(panel_7);
		panel_7.setLayout(new BoxLayout(panel_7, BoxLayout.X_AXIS));

		lblChildren = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblChildren.text"));
		panel_7.add(lblChildren);

		Component horizontalStrut_4 = Box.createHorizontalStrut(20);
		panel_7.add(horizontalStrut_4);

		btnAddChild = new JButton(" + ");
		btnAddChild.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Add Child (menu item).
				logger.debug("Add Child");
				addChild();
			}
		});
		btnAddChild.setBorder(new EmptyBorder(0, 0, 0, 0));
		panel_7.add(btnAddChild);

		Component horizontalStrut_5 = Box.createHorizontalStrut(5);
		panel_7.add(horizontalStrut_5);

		JLabel lblCtrlk = new JLabel("(Ctrl-K)");
		panel_7.add(lblCtrlk);

		JScrollPane scrollPane_2 = new JScrollPane();
		scrollPane_2.setAlignmentX(Component.LEFT_ALIGNMENT);
		scrollPane_2.setBackground(new Color(255, 255, 255));
		scrollPane_2.setPreferredSize(new Dimension(3, 200));
		panelIndividualChildren.add(scrollPane_2);

		tableIndividualChildren = new JTable();
		tableIndividualChildren.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent event) {
				// Individual children clicked.
				try {
					if (event.getClickCount() == 2) {
						//
						int selectedIndex = tableIndividualChildren.getSelectedRow();
						if (selectedIndex != -1) {
							switch (tableIndividualChildren.getSelectedColumn()) {
								case 1:
								case 2:
								case 3:
								case 4: {
									Individual selected = ((IndividualChildrenModel) tableIndividualChildren.getModel()).children().get(selectedIndex);
									if (selected != null) {
										netGUI.changeSegmentationToCluster(selected);
									}
								}
								break;

								case 5: {
									Individual selected = ((IndividualChildrenModel) tableIndividualChildren.getModel()).children().get(selectedIndex);
									if ((selected != null) && (selected.getOtherParent(getIdentityIndividual()) != null)) {
										netGUI.changeSegmentationToCluster(selected.getOtherParent(getIdentityIndividual()));
									}
								}
								break;

								default:
							}
						}
					}
				} catch (final PuckException exception) {
					exception.printStackTrace();
				}
			}
		});

		JPopupMenu popupMenu_1 = new JPopupMenu();
		addPopup(tableIndividualChildren, popupMenu_1);

		JMenuItem mntmDelete_1 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.mntmDelete_1.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmDelete_1.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Delete individual children.
				logger.debug("Delete " + ArrayUtils.toString(tableIndividualChildren.getSelectedRows()));

				int[] selectedRowIds = tableIndividualChildren.getSelectedRows();
				if (selectedRowIds.length != 0) {
					ArrayUtils.reverse(selectedRowIds);
					for (int rowIndex : selectedRowIds) {
						int childId = (Integer) tableIndividualChildren.getModel().getValueAt(rowIndex, 0);
						netGUI.getNet().removeChild(netGUI.getNet().individuals().getById(childId));
					}

					//
					netGUI.setChanged(true);
					netGUI.updateAll();
				}
			}
		});
		popupMenu_1.add(mntmDelete_1);
		scrollPane_2.setViewportView(tableIndividualChildren);
		tableIndividualChildren.setBorder(new LineBorder(new Color(169, 169, 169)));
		tableIndividualChildren.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		tableIndividualChildren.setModel(new IndividualChildrenModel(netGUI, null));

		cmbbxIndividualChildrenIds = new AutoComboBox(null);
		cmbbxIndividualChildrenIds.getEditor().getEditorComponent().addFocusListener(new FocusListener() {
			@Override
			public void focusGained(final FocusEvent arg0) {
			}

			@Override
			public void focusLost(final FocusEvent arg0) {
				logger.debug("FOCUS LOST CHILDREN TABLE " + tableIndividualChildren.isEditing());
				if (tableIndividualChildren.isEditing()) {
					tableIndividualChildren.getColumnModel().getColumn(0).getCellEditor().cancelCellEditing();
				}

				if (((IndividualChildrenModel) tableIndividualChildren.getModel()).isNewEditionOn()) {
					((IndividualChildrenModel) tableIndividualChildren.getModel()).escapeNewEdition();
				}
			}
		});
		cmbbxIndividualChildrenIds.setEditable(true);
		cmbbxIndividualChildrenIds.setStrict(false);
		cmbbxIndividualChildrenIds.setMaximumRowCount(10);
		TableCellEditor editor = new DefaultCellEditor(cmbbxIndividualChildrenIds);
		tableIndividualChildren.getColumnModel().getColumn(0).setCellEditor(editor);
		tableIndividualChildren.getColumnModel().getColumn(0).setMinWidth(10);
		tableIndividualChildren.getColumnModel().getColumn(0).setPreferredWidth(90);
		tableIndividualChildren.getColumnModel().getColumn(0).setMaxWidth(110);

		tableIndividualChildren.getColumnModel().getColumn(1).setMinWidth(10);
		tableIndividualChildren.getColumnModel().getColumn(1).setMaxWidth(30);
		tableIndividualChildren.getColumnModel().getColumn(1).setResizable(false);
		tableIndividualChildren.getColumnModel().getColumn(3).setPreferredWidth(100);
		tableIndividualChildren.getColumnModel().getColumn(3).setMaxWidth(125);
		tableIndividualChildren.getColumnModel().getColumn(3).setResizable(false);
		tableIndividualChildren.getColumnModel().getColumn(4).setPreferredWidth(100);
		tableIndividualChildren.getColumnModel().getColumn(4).setMaxWidth(125);
		tableIndividualChildren.getColumnModel().getColumn(4).setResizable(false);

		Component verticalStrut_3 = Box.createVerticalStrut(10);
		panelIndividualChildren.add(verticalStrut_3);

		JSplitPane splitPane_3 = new JSplitPane();
		splitPane_3.setOrientation(JSplitPane.VERTICAL_SPLIT);
		splitPane_2.setRightComponent(splitPane_3);

		JPanel panel_1 = new JPanel();
		splitPane_3.setRightComponent(panel_1);
		panel_1.setLayout(new BoxLayout(panel_1, BoxLayout.Y_AXIS));

		Component verticalStrut_10 = Box.createVerticalStrut(5);
		panel_1.add(verticalStrut_10);

		JPanel panel_8 = new JPanel();
		panel_8.setAlignmentX(Component.LEFT_ALIGNMENT);
		panel_1.add(panel_8);
		panel_8.setLayout(new BoxLayout(panel_8, BoxLayout.X_AXIS));

		lblRelations = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.lblRelations.text"));
		panel_8.add(lblRelations);

		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setPreferredSize(new Dimension(3, 100));
		scrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
		panel_1.add(scrollPane);

		tableIndividualRelations = new JTable();
		tableIndividualRelations.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent event) {
				// Individual spouse clicked.
				if (event.getClickCount() == 2) {
					int selectedIndex = tableIndividualRelations.getSelectedRow();
					Relation relation = ((IndividualRelationsModel) tableIndividualRelations.getModel()).getDelegate().get(selectedIndex);
					// TODO
					netGUI.selectRelationTab(relation);
				}
			}
		});
		tableIndividualRelations.setModel(new IndividualRelationsModel(null));
		scrollPane.setViewportView(tableIndividualRelations);

		attributesPanel = new AttributesPanel(this.netGUI, (Attributes) null);
		splitPane_3.setLeftComponent(attributesPanel);
		tableIndividualRelations.getColumnModel().getColumn(0).setMinWidth(10);
		tableIndividualRelations.getColumnModel().getColumn(0).setPreferredWidth(90);
		tableIndividualRelations.getColumnModel().getColumn(0).setMaxWidth(110);

		JPanel panelIndividualSpouses = new JPanel();
		panelIndividualSpouses.setMinimumSize(new Dimension(10, 150));
		panelIndividualSpouses.setBorder(new EmptyBorder(0, 0, 0, 10));
		panelIndividualSpouses.setAlignmentY(Component.TOP_ALIGNMENT);
		panelIndividualSpouses.setAlignmentX(Component.LEFT_ALIGNMENT);
		splitPane_1.setLeftComponent(panelIndividualSpouses);
		panelIndividualSpouses.setLayout(new BoxLayout(panelIndividualSpouses, BoxLayout.Y_AXIS));

		Component verticalStrut_6 = Box.createVerticalStrut(5);
		panelIndividualSpouses.add(verticalStrut_6);

		JPanel panel_5 = new JPanel();
		panel_5.setAlignmentX(Component.LEFT_ALIGNMENT);
		panelIndividualSpouses.add(panel_5);
		panel_5.setLayout(new BoxLayout(panel_5, BoxLayout.X_AXIS));

		lblIndividualSpouses = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblSpouses.text"));
		panel_5.add(lblIndividualSpouses);

		Component horizontalStrut_3 = Box.createHorizontalStrut(20);
		panel_5.add(horizontalStrut_3);

		btnAddPartner = new JButton(" + ");
		btnAddPartner.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Add partner.
				logger.debug("Add partner");
				addPartner();
			}
		});
		btnAddPartner.setBorder(new EmptyBorder(0, 0, 0, 0));
		panel_5.add(btnAddPartner);

		Component horizontalStrut_2 = Box.createHorizontalStrut(5);
		panel_5.add(horizontalStrut_2);

		JLabel lblCtrlp = new JLabel("(Ctrl-P)");
		panel_5.add(lblCtrlp);

		JScrollPane scrollPane_1 = new JScrollPane();
		scrollPane_1.setPreferredSize(new Dimension(3, 200));
		scrollPane_1.setBackground(new Color(255, 255, 255));
		scrollPane_1.setAlignmentX(Component.LEFT_ALIGNMENT);
		panelIndividualSpouses.add(scrollPane_1);

		tableIndividualSpouses = new JTable();
		tableIndividualSpouses.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent event) {
				// Individual spouse clicked.
				try {
					if (event.getClickCount() == 1) {
						logger.debug("one click");
					} else if (event.getClickCount() == 2) {
						int selectedIndex = tableIndividualSpouses.getSelectedRow();
						int selectedColumn = tableIndividualSpouses.getSelectedColumn();
						logger.debug("[index, col]=[" + selectedIndex + "," + selectedColumn + "]");
						if ((selectedIndex != -1) && (selectedColumn != -1)) {
							if ((selectedColumn > 0) && (selectedColumn < 3)) {
								// Redirect to an individual.
								Individual selected = ((IndividualSpousesModel) tableIndividualSpouses.getModel()).spouses().get(selectedIndex);
								if (selected != null) {
									netGUI.changeSegmentationToCluster(selected);
								}
							} else if (selectedColumn >= 3) {
								// Redirect to a family.
								Family targetFamily = ((IndividualSpousesModel) tableIndividualSpouses.getModel()).getFamily(selectedIndex);
								if (targetFamily != null) {
									netGUI.selectFamiliesTab(targetFamily);
								}
							}
						}
					}
				} catch (final PuckException exception) {
					exception.printStackTrace();
				}
			}
		});

		JPopupMenu popupMenu = new JPopupMenu();
		addPopup(tableIndividualSpouses, popupMenu);

		JMenuItem mntmDelete = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.mntmDelete.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmDelete.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Delete individual partners.
				logger.debug("Delete " + ArrayUtils.toString(tableIndividualSpouses.getSelectedRows()));

				int[] selectedRowIds = tableIndividualSpouses.getSelectedRows();
				if (selectedRowIds.length != 0) {
					ArrayUtils.reverse(selectedRowIds);
					for (int rowIndex : selectedRowIds) {
						Family family = ((IndividualSpousesModel) tableIndividualSpouses.getModel()).getFamily(rowIndex);

						if (family.isSingleParent()) {
							NetUtils.removeSpouse(family, getSelectedIndividual());
							if (family.isEmpty()) {
								netGUI.getNet().remove(family);
							}
						} else {
							Individual spouse = ((IndividualSpousesModel) tableIndividualSpouses.getModel()).getSpouse(rowIndex);
							NetUtils.removeSpouse(family, spouse);
							if (family.isEmpty()) {
								netGUI.getNet().remove(family);
							}
						}
					}

					//
					netGUI.setChanged(true);
					netGUI.updateAll();
				}
			}
		});
		popupMenu.add(mntmDelete);
		scrollPane_1.setViewportView(tableIndividualSpouses);
		tableIndividualSpouses.setBorder(new LineBorder(new Color(169, 169, 169)));
		tableIndividualSpouses.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		tableIndividualSpouses.setModel(new IndividualSpousesModel(netGUI, null));
		tableIndividualSpouses.getTableHeader().setReorderingAllowed(false);

		//
		cmbbxIndividualSpousesIds = new AutoComboBox(null);
		cmbbxIndividualSpousesIds.getEditor().getEditorComponent().addFocusListener(new FocusListener() {
			@Override
			public void focusGained(final FocusEvent arg0) {
			}

			@Override
			public void focusLost(final FocusEvent arg0) {
				logger.debug("FOCUS LOST SPOUSES TABLE " + tableIndividualSpouses.isEditing());
				if (tableIndividualSpouses.isEditing()) {
					tableIndividualSpouses.getColumnModel().getColumn(0).getCellEditor().cancelCellEditing();
				}

				if (((IndividualSpousesModel) tableIndividualSpouses.getModel()).isNewEditionOn()) {
					((IndividualSpousesModel) tableIndividualSpouses.getModel()).escapeNewEdition();
				}
			}
		});
		cmbbxIndividualSpousesIds.setEditable(true);
		cmbbxIndividualSpousesIds.setStrict(false);
		cmbbxIndividualSpousesIds.setMaximumRowCount(10);
		TableCellEditor editor2 = new DefaultCellEditor(cmbbxIndividualSpousesIds);
		tableIndividualSpouses.getColumnModel().getColumn(0).setCellEditor(editor2);
		tableIndividualSpouses.getColumnModel().getColumn(0).setMinWidth(10);
		tableIndividualSpouses.getColumnModel().getColumn(0).setPreferredWidth(90);
		tableIndividualSpouses.getColumnModel().getColumn(0).setMaxWidth(110);
		tableIndividualSpouses.getColumnModel().getColumn(1).setMinWidth(10);
		tableIndividualSpouses.getColumnModel().getColumn(1).setMaxWidth(30);
		tableIndividualSpouses.getColumnModel().getColumn(1).setResizable(false);
		tableIndividualSpouses.getColumnModel().getColumn(3).setMinWidth(10);
		tableIndividualSpouses.getColumnModel().getColumn(3).setMaxWidth(30);
		tableIndividualSpouses.getColumnModel().getColumn(3).setResizable(false);
		tableIndividualSpouses.getColumnModel().getColumn(4).setMinWidth(10);
		tableIndividualSpouses.getColumnModel().getColumn(4).setPreferredWidth(90);
		tableIndividualSpouses.getColumnModel().getColumn(4).setMaxWidth(110);

		Component verticalStrut_2 = Box.createVerticalStrut(10);
		panelIndividualSpouses.add(verticalStrut_2);
		tableIndividualChildren.getColumnModel().getColumn(3).setPreferredWidth(100);

		JPanel individualsButtonsPanel = new JPanel();
		add(individualsButtonsPanel);
		individualsButtonsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		individualsButtonsPanel.setLayout(new BoxLayout(individualsButtonsPanel, BoxLayout.X_AXIS));

		JButton btnAddIndividual = new JButton("");
		btnAddIndividual.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Add an individual.
				addIndividual();
			}
		});
		btnAddIndividual.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnNewButton_1.toolTipText"));
		btnAddIndividual.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/add.png")));
		individualsButtonsPanel.add(btnAddIndividual);

		JButton btnRemoveIndividual = new JButton("");
		btnRemoveIndividual.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Remove individual.
				Individual target = getSelectedIndividual();
				if (target != null) {
					int selectedIndex = individualList.getSelectedIndex();
					netGUI.getNet().remove(target);
					((IndividualsModel) individualList.getModel()).setSource(netGUI.getNet().individuals());
					if (netGUI.getNet().individuals().size() != 0) {
						if (selectedIndex == netGUI.getNet().individuals().size()) {
							selectedIndex -= 1;
						}
						individualList.setSelectedIndex(selectedIndex);
					}
					netGUI.updateAll();
					netGUI.setChanged(true);
				}
			}
		});
		btnRemoveIndividual.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnNewButton.toolTipText"));
		btnRemoveIndividual.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/remove.png")));
		individualsButtonsPanel.add(btnRemoveIndividual);

		Component horizontalGlue_3 = Box.createHorizontalGlue();
		individualsButtonsPanel.add(horizontalGlue_3);

		JButton btnIndividualsPrevious = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnPrevious.text"));
		btnIndividualsPrevious.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Previous individual.
				int selectedIndex = individualList.getSelectedIndex();
				if (selectedIndex == -1) {
					int size = individualList.getModel().getSize();
					if (size != 0) {
						selectedIndex = size - 1;
						individualList.setSelectedIndex(selectedIndex);
						individualList.ensureIndexIsVisible(selectedIndex);
					}
				} else if (selectedIndex > 0) {
					selectedIndex -= 1;
					individualList.setSelectedIndex(selectedIndex);
					individualList.ensureIndexIsVisible(selectedIndex);
				}
			}
		});
		individualsButtonsPanel.add(btnIndividualsPrevious);

		JButton btnIndividualsNext = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnNext.text"));
		btnIndividualsNext.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Next individual.
				int selectedIndex = individualList.getSelectedIndex();
				int size = individualList.getModel().getSize();
				if (selectedIndex == -1) {
					if (size != 0) {
						selectedIndex = 0;
						individualList.setSelectedIndex(selectedIndex);
						individualList.ensureIndexIsVisible(selectedIndex);
					}
				} else if (selectedIndex < size - 1) {
					selectedIndex += 1;
					individualList.setSelectedIndex(selectedIndex);
					individualList.ensureIndexIsVisible(selectedIndex);
				}
			}
		});
		individualsButtonsPanel.add(btnIndividualsNext);

		Component horizontalGlue = Box.createHorizontalGlue();
		individualsButtonsPanel.add(horizontalGlue);

		JPanel panel_13 = new JPanel();
		individualsButtonsPanel.add(panel_13);
		panel_13.setLayout(new BoxLayout(panel_13, BoxLayout.X_AXIS));

		tglbtnIndividualIdStrategy = new JToggleButton(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.tglbtnIndividualIdStratgy.text")); //$NON-NLS-1$ //$NON-NLS-2$
		tglbtnIndividualIdStrategy.setToolTipText(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.tglbtnIndividualIdStratgy.toolTipText")); //$NON-NLS-1$ //$NON-NLS-2$
		tglbtnIndividualIdStrategy.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Click individual id strategy.
				if (tglbtnIndividualIdStrategy.isSelected()) {
					tglbtnIndividualIdStrategy.setIcon(appendIcon);
				} else {
					tglbtnIndividualIdStrategy.setIcon(insertIcon);
				}
			}
		});
		tglbtnIndividualIdStrategy.setIcon(insertIcon);
		panel_13.add(tglbtnIndividualIdStrategy);

		tglbtnFamilyIdStrategy = new JToggleButton(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.tglbtnFamilyIdStrategy.text")); //$NON-NLS-1$ //$NON-NLS-2$
		tglbtnFamilyIdStrategy.setEnabled(false);
		tglbtnFamilyIdStrategy.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Click family id strategy.
				if (tglbtnFamilyIdStrategy.isSelected()) {
					tglbtnFamilyIdStrategy.setIcon(appendIcon);
				} else {
					tglbtnFamilyIdStrategy.setIcon(insertIcon);
				}
			}
		});
		tglbtnFamilyIdStrategy.setToolTipText(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.tglbtnFamilyIdStrategy.toolTipText")); //$NON-NLS-1$ //$NON-NLS-2$
		tglbtnFamilyIdStrategy.setIcon(insertIcon);
		panel_13.add(tglbtnFamilyIdStrategy);

		btnDefaultUnionStatus = new JButton("");
		btnDefaultUnionStatus.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Click default union status.
				switch (defaultUnionStatus) {
					case UNMARRIED:
						defaultUnionStatus = UnionStatus.MARRIED;
						btnDefaultUnionStatus.setIcon(smallMarriedIcon);
					break;

					case MARRIED:
						defaultUnionStatus = UnionStatus.DIVORCED;
						btnDefaultUnionStatus.setIcon(smallDivorcedIcon);
					break;

					case DIVORCED:
						defaultUnionStatus = UnionStatus.UNMARRIED;
						btnDefaultUnionStatus.setIcon(smallUnmarriedIcon);
					break;

					default:
						defaultUnionStatus = UnionStatus.UNMARRIED;
						btnDefaultUnionStatus.setIcon(smallUnmarriedIcon);
				}
			}
		});
		btnDefaultUnionStatus.setToolTipText(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.btnDefaultUnionStatus.toolTipText")); //$NON-NLS-1$ //$NON-NLS-2$
		btnDefaultUnionStatus.setIcon(smallMarriedIcon);
		panel_13.add(btnDefaultUnionStatus);

		Component horizontalGlue_1 = Box.createHorizontalGlue();
		individualsButtonsPanel.add(horizontalGlue_1);

		JLabel lblIndividualsSearch = new JLabel(" ");
		lblIndividualsSearch.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblSearch.text")); //$NON-NLS-1$ //$NON-NLS-2$
		lblIndividualsSearch.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/find.png")));
		individualsButtonsPanel.add(lblIndividualsSearch);
		lblIndividualsSearch.setMinimumSize(new Dimension(300, 15));

		txtfldSearchIndividual = new JTextField();
		txtfldSearchIndividual.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Search individual.
				String pattern = txtfldSearchIndividual.getText();
				logger.debug("Search individual=[" + pattern + "]");
				if (StringUtils.isNotBlank(pattern)) {
					int index = ((IndividualsModel) individualList.getModel()).nextSearchedIndividualIndex(pattern);
					if (index != -1) {
						individualList.setSelectedIndex(index);
						individualList.ensureIndexIsVisible(index);
					}
				}
			}
		});
		individualsButtonsPanel.add(txtfldSearchIndividual);
		txtfldSearchIndividual.setMaximumSize(new Dimension(500, 50));
		txtfldSearchIndividual.setText("");
		txtfldSearchIndividual.setColumns(15);
	}

	/**
	 * 
	 */
	public void addChild() {
		// Add child.
		if (((IndividualChildrenModel) tableIndividualChildren.getModel()).getSource() != null) {
			if (!((IndividualChildrenModel) tableIndividualChildren.getModel()).isNewEditionOn()) {
				//
				Family targetFamily = ((IndividualSpousesModel) tableIndividualSpouses.getModel()).getFamily(tableIndividualSpouses.getSelectedRow());

				//
				((IndividualChildrenModel) tableIndividualChildren.getModel()).setNewItem(targetFamily);

				//
				tableIndividualChildren.scrollRectToVisible(tableIndividualChildren.getCellRect(tableIndividualChildren.getModel().getRowCount() - 1, 0, true));
				tableIndividualChildren.setRowSelectionInterval(tableIndividualChildren.getModel().getRowCount() - 1, tableIndividualChildren.getModel()
						.getRowCount() - 1);
				tableIndividualChildren.editCellAt(tableIndividualChildren.getModel().getRowCount() - 1, 0);
				tableIndividualChildren.getEditorComponent().requestFocus();
			}
		}
	}

	/**
	 * 
	 */
	public void addIndividual() {
		// Add an individual.
		try {
			//
			logger.debug("ID Strategy = " + getIndividualIdStrategy());
			Individual individual = netGUI.getNet().createIndividual(getIndividualIdStrategy(), "", Gender.UNKNOWN);

			netGUI.setChanged(true);
			netGUI.updateAll();
			netGUI.selectIndividualsTab(individual);

			setFirstNameEditorOn();

		} catch (final Exception exception) {
			// Show trace.
			exception.printStackTrace();

			//
			String title = "Error computerum est";
			String message = "Error occured during working: " + exception.getMessage();

			//
			JOptionPane.showMessageDialog(null, message, title, JOptionPane.ERROR_MESSAGE);
		}
	}

	/**
	 * 
	 */
	public void addOriginFamily() {
		//
		if (((IndividualSpousesModel) tableIndividualSpouses.getModel()).getSource() != null) {
			if (!((IndividualSpousesModel) tableIndividualSpouses.getModel()).isNewEditionOn()) {

				//
				Individual currentIndividual = getSelectedIndividual();

				if ((currentIndividual != null) && (currentIndividual.getOriginFamily() == null)) {
					//
					Family family = netGUI.getNet().createFamily(null, null);
					family.setUnionStatus(getDefaultUnionStatus());

					//
					currentIndividual.setOriginFamily(family);
					family.getChildren().add(currentIndividual);

					//
					netGUI.updateAll();
				}
			}
		}
	}

	/**
	 * 
	 */
	public void addPartner() {
		//
		if (((IndividualSpousesModel) tableIndividualSpouses.getModel()).getSource() != null) {
			if (!((IndividualSpousesModel) tableIndividualSpouses.getModel()).isNewEditionOn()) {
				//
				((IndividualSpousesModel) tableIndividualSpouses.getModel()).setNewItem();

				//
				tableIndividualSpouses.scrollRectToVisible(tableIndividualSpouses.getCellRect(tableIndividualSpouses.getModel().getRowCount() - 1, 0, true));
				tableIndividualSpouses.setRowSelectionInterval(tableIndividualSpouses.getModel().getRowCount() - 1, tableIndividualSpouses.getModel()
						.getRowCount() - 1);
				tableIndividualSpouses.editCellAt(tableIndividualSpouses.getModel().getRowCount() - 1, 0);
				tableIndividualSpouses.getEditorComponent().requestFocus();
			}
		}
	}

	/**
	 * 
	 * @return
	 */
	public UnionStatus getDefaultUnionStatus() {
		UnionStatus result;

		result = defaultUnionStatus;

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public IdStrategy getFamilyIdStrategy() {
		IdStrategy result;

		if (tglbtnFamilyIdStrategy.isSelected()) {
			result = IdStrategy.APPEND;
		} else {
			result = IdStrategy.FILL;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public Individual getIdentityIndividual() {
		Individual result;

		if (NumberUtils.isDigits(lblIndividualId.getText())) {
			result = netGUI.getNet().individuals().getById(Integer.parseInt(lblIndividualId.getText()));
		} else {
			result = null;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public Individual getIdentityParent1() {
		Individual result;

		if (NumberUtils.isDigits(lblIndividualParent1Id.getText())) {
			result = netGUI.getNet().individuals().getById(Integer.parseInt(lblIndividualParent1Id.getText()));
		} else {
			result = null;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public Individual getIdentityParent2() {
		Individual result;

		if (NumberUtils.isDigits(lblIndividualParent2Id.getText())) {
			result = netGUI.getNet().individuals().getById(Integer.parseInt(lblIndividualParent2Id.getText()));
		} else {
			result = null;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public IdStrategy getIndividualIdStrategy() {
		IdStrategy result;

		if (tglbtnIndividualIdStrategy.isSelected()) {
			result = IdStrategy.APPEND;
		} else {
			result = IdStrategy.FILL;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public Individual getSelectedIndividual() {
		Individual result;

		if (individualList.getSelectedIndex() == -1) {
			result = null;
		} else {
			result = (Individual) ((IndividualsModel) individualList.getModel()).getElementAt(individualList.getSelectedIndex());
		}

		//
		return result;
	}

	/**
	 * 
	 * @param target
	 */
	public void select(final Individual individual) {
		int individualIndex = ((IndividualsModel) individualList.getModel()).indexOf(individual);

		if ((individualIndex >= 0) && (individualIndex < ((IndividualsModel) this.individualList.getModel()).getSize())) {
			this.individualList.setSelectedIndex(individualIndex);
			this.individualList.ensureIndexIsVisible(individualIndex);
		} else if (((IndividualsModel) this.individualList.getModel()).getSize() != 0) {
			this.individualList.setSelectedIndex(0);
			this.individualList.ensureIndexIsVisible(0);
		} else {
			updateIndividualIdentity(null);
		}
	}

	/**
	 * 
	 * @param target
	 */
	public void selectByIndex(final int individualIndex) {

		if ((individualIndex >= 0) && (individualIndex < ((IndividualsModel) this.individualList.getModel()).getSize())) {
			this.individualList.setSelectedIndex(individualIndex);
			this.individualList.ensureIndexIsVisible(individualIndex);
		} else if (((IndividualsModel) this.individualList.getModel()).getSize() != 0) {
			this.individualList.setSelectedIndex(0);
			this.individualList.ensureIndexIsVisible(0);
		} else {
			updateIndividualIdentity(null);
		}
	}

	/**
	 * 
	 */
	private void setFirstNameEditorOn() {
		//
		List<String> firstNames = netGUI.getNet().individuals().firstNames();
		cmbbxIndividualFirstName.setDataList(firstNames);

		Individual currentIndividual = getIdentityIndividual();
		if (currentIndividual != null) {
			int firstNameIndex = ToolBox.indexOf(currentIndividual.getFirstName(), firstNames);
			cmbbxIndividualFirstName.setSelectedIndex(firstNameIndex);
		}

		//
		lblIndividualFirstName.setVisible(false);
		cmbbxIndividualFirstName.setVisible(true);
		cmbbxIndividualFirstName.requestFocus();
	}

	/**
	 * 
	 */
	public void setFocusOnFind() {
		txtfldSearchIndividual.requestFocus();
	}

	/**
	 * 
	 */
	private void setIndividualIdEditorOn() {
		//
		txtFldIndividualId.setText(lblIndividualId.getText());

		//
		lblIndividualId.setVisible(false);
		txtFldIndividualId.setVisible(true);

		//
		txtFldIndividualId.requestFocus();
	}

	/**
	 * 
	 */
	private void setLastNameEditorOn() {

		//
		List<String> lastNames = netGUI.getNet().individuals().lastNames();
		cmbbxIndividualLastName.setDataList(lastNames);

		//
		Individual currentIndividual = getIdentityIndividual();
		if (currentIndividual != null) {
			int lastNameIndex = ToolBox.indexOf(currentIndividual.getLastName(), lastNames);
			cmbbxIndividualLastName.setSelectedIndex(lastNameIndex);
		}

		//
		lblIndividualLastName.setVisible(false);
		cmbbxIndividualLastName.setVisible(true);
		cmbbxIndividualLastName.requestFocus();
	}

	/**
	 * 
	 */
	private void setParent1IdEditorOn() {
		//
		setParent1IdEditorOnWithoutFocus();

		//
		cmbbxIndividualParent1.requestFocus();
	}

	/**
	 * 
	 */
	private void setParent1IdEditorOnWithoutFocus() {
		//
		List<Individual> individuals = ((IndividualsModel) individualList.getModel()).toSortedList();
		List<String> items = new ArrayList<String>(individuals.size());
		for (Individual individual : individuals) {
			items.add(individual.getId() + " " + individual.getName());
		}
		cmbbxIndividualParent1.setDataList(items);

		//
		Individual currentParent = getIdentityParent1();
		if (currentParent == null) {
			cmbbxIndividualParent1.setSelectedIndex(-1);
		} else {
			int currentItemIndex = ToolBox.indexOf(currentParent.getId() + " " + currentParent.getName(), items);
			cmbbxIndividualParent1.setSelectedIndex(currentItemIndex);
		}

		//
		lblIndividualParent1Id.setVisible(false);
		lblIndividualParent1Name.setVisible(false);

		//
		cmbbxIndividualParent1.setVisible(true);
	}

	/**
	 * 
	 */
	private void setParent2IdEditorOn() {
		//
		List<Individual> individuals = ((IndividualsModel) individualList.getModel()).toSortedList();
		List<String> items = new ArrayList<String>(individuals.size());
		for (Individual individual : individuals) {
			items.add(individual.getId() + " " + individual.getName());
		}
		cmbbxIndividualParent2.setDataList(items);

		//
		Individual currentParent = getIdentityParent2();
		if (currentParent == null) {
			cmbbxIndividualParent2.setSelectedIndex(-1);
		} else {
			int currentItemIndex = ToolBox.indexOf(currentParent.getId() + " " + currentParent.getName(), items);
			cmbbxIndividualParent2.setSelectedIndex(currentItemIndex);
		}

		//
		lblIndividualParent2Id.setVisible(false);
		lblIndividualParent2Name.setVisible(false);

		//
		cmbbxIndividualParent2.setVisible(true);

		//
		cmbbxIndividualParent2.requestFocus();
	}

	/**
	 * 
	 */
	public void update() {
		//
		int selectedIndividual = individualList.getSelectedIndex();

		//
		((IndividualsModel) individualList.getModel()).setSource(this.netGUI.getCurrentIndividuals());

		//
		selectByIndex(selectedIndividual);
	}

	/**
	 * 
	 */
	public void update(final Individual individual) {
		//
		((IndividualsModel) individualList.getModel()).setSource(this.netGUI.getCurrentIndividuals());

		//
		select(individual);
	}

	/**
	 * 
	 */
	public void updateIndividualIdentity() {
		updateIndividualIdentity(getSelectedIndividual());
	}

	/**
	 * 
	 */
	public void updateIndividualIdentity(final Individual source) {
		if (source == null) {
			logger.debug("updateIndividualIdentity(null)");
		} else {
			logger.debug("updateIndividualIdentity(" + source.getId() + ")");
		}

		if (source == null) {
			//
			this.lblIndividualId.setText("---");
			this.lblIndividualId.setVisible(true);
			this.txtFldIndividualId.setVisible(false);
			this.lblIndividualGender.setIcon(largeUnknowIcon);
			this.lblIndividualFirstName.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individual.unknown"));
			this.lblIndividualLastName.setText("");

			this.lblFirstLastNameSeparator.setVisible(false);
			this.lblPosition.setText("(--/--)");

			//
			this.lblFamilyId.setText("---");
			this.lblFamilyStatus.setIcon(mediumUnmarriedIcon);

			//
			this.lblIndividualParent1Id.setText("---");
			this.lblIndividualParent1Name.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individual.unknown"));
			this.lblIndividualParent1Name.setIcon(mediumUnknowIcon);

			//
			this.lblIndividualParent2Id.setText("---");
			this.lblIndividualParent2Name.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individual.unknown"));
			this.lblIndividualParent2Name.setIcon(mediumUnknowIcon);

			//
			lblIndividualSpouses.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblSpouses.text"));
			((IndividualSpousesModel) tableIndividualSpouses.getModel()).setSource(null);
			cmbbxIndividualSpousesIds.setDataList(new ArrayList<String>(0));

			//
			lblChildren.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblChildren.text"));
			((IndividualChildrenModel) tableIndividualChildren.getModel()).setSource(null);
			cmbbxIndividualChildrenIds.setDataList(new ArrayList<String>(0));

			//
			attributesPanel.setSource(null);

			//
			lblRelations.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.lblRelations.text"));
			((IndividualRelationsModel) tableIndividualRelations.getModel()).setSource(null);

			//
			btnAddPartner.setEnabled(false);
			btnAddChild.setEnabled(false);

		} else {
			//
			this.lblIndividualId.setText(String.valueOf(source.getId()));
			this.lblIndividualId.setVisible(true);
			this.txtFldIndividualId.setVisible(false);
			switch (source.getGender()) {
				case FEMALE:
					this.lblIndividualGender.setIcon(largeFemaleIcon);
				break;
				case MALE:
					this.lblIndividualGender.setIcon(largeMaleIcon);
				break;
				case UNKNOWN:
					this.lblIndividualGender.setIcon(largeUnknowIcon);
				break;
			}
			this.lblIndividualFirstName.setText(source.getFirstName());

			//
			String lastName = source.getLastName();
			if (StringUtils.isBlank(lastName)) {
				this.lblFirstLastNameSeparator.setVisible(false);
				this.lblIndividualLastName.setText("      ");
			} else {
				this.lblFirstLastNameSeparator.setVisible(true);
				this.lblIndividualLastName.setText(source.getLastName());
			}

			//
			this.lblPosition.setText("(" + (this.individualList.getSelectedIndex() + 1) + "/" + this.individualList.getModel().getSize() + ")");

			//
			if (source.getOriginFamily() == null) {
				this.lblFamilyId.setText("---");
				this.lblFamilyStatus.setIcon(mediumUnmarriedIcon);
			} else {
				this.lblFamilyId.setText(String.valueOf(source.getOriginFamily().getId()));
				switch (source.getOriginFamily().getUnionStatus()) {
					case UNMARRIED:
						this.lblFamilyStatus.setIcon(mediumUnmarriedIcon);
					break;
					case MARRIED:
						this.lblFamilyStatus.setIcon(mediumMarriedIcon);
					break;
					case DIVORCED:
						this.lblFamilyStatus.setIcon(mediumDivorcedIcon);
					break;
					default:
						this.lblFamilyStatus.setIcon(largeUnknowIcon);
				}
			}

			//
			if (source.getFather() == null) {
				this.lblIndividualParent1Id.setText("---");
				this.lblIndividualParent1Name.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individual.unknown"));
				this.lblIndividualParent1Name.setIcon(mediumUnknowIcon);
			} else {
				this.lblIndividualParent1Id.setText(String.valueOf(source.getFather().getId()));
				this.lblIndividualParent1Name.setText(source.getFather().getName());
				switch (source.getFather().getGender()) {
					case FEMALE:
						this.lblIndividualParent1Name.setIcon(mediumFemaleIcon);
					break;
					case MALE:
						this.lblIndividualParent1Name.setIcon(mediumMaleIcon);
					break;
					case UNKNOWN:
						this.lblIndividualParent1Name.setIcon(mediumUnknowIcon);
					break;
				}
			}

			//
			if (source.getMother() == null) {
				this.lblIndividualParent2Id.setText("---");
				this.lblIndividualParent2Name.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individual.unknown"));
				this.lblIndividualParent2Name.setIcon(mediumUnknowIcon);
			} else {
				this.lblIndividualParent2Id.setText(String.valueOf(source.getMother().getId()));
				this.lblIndividualParent2Name.setText(source.getMother().getName());
				switch (source.getMother().getGender()) {
					case FEMALE:
						this.lblIndividualParent2Name.setIcon(mediumFemaleIcon);
					break;
					case MALE:
						this.lblIndividualParent2Name.setIcon(mediumMaleIcon);
					break;
					case UNKNOWN:
						this.lblIndividualParent2Name.setIcon(mediumUnknowIcon);
					break;
				}
			}

			//
			((IndividualSpousesModel) tableIndividualSpouses.getModel()).setSource(source);
			lblIndividualSpouses.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblSpouses.text") + " ("
					+ source.getPersonalFamilies().size() + ")");

			// Update selectable ids for all panels.
			ComboBoxIds.instance().update(((IndividualsModel) individualList.getModel()).toSortedList());
			cmbbxIndividualSpousesIds.setDataList(ComboBoxIds.instance().items());
			cmbbxIndividualChildrenIds.setDataList(ComboBoxIds.instance().items());

			//
			((IndividualChildrenModel) tableIndividualChildren.getModel()).setSource(source);
			lblChildren.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblChildren.text") + " ("
					+ ((IndividualChildrenModel) tableIndividualChildren.getModel()).children().size() + ")");

			//
			attributesPanel.setSource(source.attributes());

			//
			lblRelations.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.lblRelations.text") + " ("
					+ source.relations().size() + ")");
			((IndividualRelationsModel) tableIndividualRelations.getModel()).setSource(source);

			//
			btnAddPartner.setEnabled(true);
			btnAddChild.setEnabled(true);
		}
	}

	/**
	 * 
	 * @param component
	 * @param popup
	 */
	private static void addPopup(final Component component, final JPopupMenu popup) {
		component.addMouseListener(new MouseAdapter() {
			@Override
			public void mousePressed(final MouseEvent e) {
				if (e.isPopupTrigger()) {
					showMenu(e);
				}
			}

			@Override
			public void mouseReleased(final MouseEvent e) {
				if (e.isPopupTrigger()) {
					showMenu(e);
				}
			}

			private void showMenu(final MouseEvent e) {
				popup.show(e.getComponent(), e.getX(), e.getY());
			}
		});
	}

	/**
	 * 
	 * @param level
	 * @param father
	 * @param mother
	 * @param children
	 * @return
	 */
	public static String controlFixedPartners(final CheckLevel level, final Individual father, final Individual mother, final Individual... children) {
		String result;

		if (NetUtils.isRolesFixedByGender(father, mother)) {
			result = IndividualsPanel.controlPartners(level, father, mother, children);
		} else {
			result = IndividualsPanel.controlPartners(level, father, mother, children);
		}
		//
		return result;
	}

	/**
	 * 
	 * @param level
	 * @param father
	 * @param mother
	 * @param children
	 * @return
	 */
	public static String controlPartners(final CheckLevel level, final Individual father, final Individual mother, final Individual... children) {
		String result;

		if ((level == CheckLevel.ERROR) && (NetUtils.isSame(father, mother))) {
			result = "Same parent twice detected.";
		} else if ((PuckGUI.instance().getPreferences().getInputSettings().getSameSexSpouses() == level) && (NetUtils.isSameSex(father, mother))) {
			result = "Same sex spouses detected.";
		} else if ((PuckGUI.instance().getPreferences().getInputSettings().getFemaleFathersOrMaleMothers() == level)
				&& (NetUtils.isFemaleFatherOrMaleMother(father, mother))) {
			result = "Female Father or Male Mother or detected.";
		} else if ((PuckGUI.instance().getPreferences().getInputSettings().getParentChildMarriages() == level)
				&& (NetUtils.isParentChildMarriage(father, mother, children))) {
			result = "Parent-child marriages detected.";
		} else {
			result = null;
		}

		//
		return result;
	}
}
