package org.tip.puckgui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Set;

import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingConstants;
import javax.swing.border.EmptyBorder;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.KinType;
import org.tip.puck.net.random.RandomNetReporter;
import org.tip.puck.net.random.RandomNetExplorer;
import org.tip.puck.net.workers.MemoryCriteria;
import org.tip.puck.report.Report;
import org.tip.puck.statistics.StatisticsWorker;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;

public class FieldworkInputWindow extends JFrame {

	static private final Logger logger = LoggerFactory.getLogger(AllianceNetworkInputWindow.class);

	private static final long serialVersionUID = -6113524443785800524L;

	private JFrame thisJFrame;
	private NetGUI netGUI;
	private JPanel contentPane;
	private JSlider mmF;
	private JSlider mmM;
	private JSlider mmS;
	private JSlider mmD;
	private JSlider mmW;
	private JSlider fmF;
	private JSlider fmM;
	private JSlider fmS;
	private JSlider fmD;
	private JSlider fmW;
	private JSlider mfF;
	private JSlider mfM;
	private JSlider mfS;
	private JSlider mfD;
	private JSlider mfH;
	private JSlider ffF;
	private JSlider ffM;
	private JSlider ffS;
	private JSlider ffD;
	private JSlider ffH;
	private JSlider mAccept;
	private JSlider fAccept;
	private JSpinner nrInformantsSpinner;
	private JLabel lblNewLabel;
	private JLabel lblMother;
	private JLabel lblSon;
	private JLabel lblMother_1;
	private JLabel lblSon_1;
	private JLabel lblKinProximity;
	private JComboBox cbBoxDistanceType;
	private JLabel lblKinDegree;
	private JSpinner spinnerKinDegree;
	private JLabel lblNearKinPropensity;
	private JSpinner spinnerDistanceWeight;
	private JLabel lbMemory;
	private JSpinner spinnerDistanceFactor;

	/**
	 * Create the frame.
	 */
	public FieldworkInputWindow(final NetGUI netGUI) {

		this.thisJFrame = this;
		this.netGUI = netGUI;
		setTitle("Virtual Fieldwork");

		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 450, 656);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(new BorderLayout(0, 0));

		JPanel panel = new JPanel();
		contentPane.add(panel, BorderLayout.SOUTH);
		panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));

		JButton btnStart = new JButton("Start");
		btnStart.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// provisory, non-parametrized method
				try {
					Report report = new Report();

					MemoryCriteria criteria = new MemoryCriteria();

					// inf ego rel

					criteria.setMemoryProb(Gender.MALE, Gender.MALE, KinType.PARENT, Gender.MALE, decimal(mmF.getValue()));
					criteria.setMemoryProb(Gender.FEMALE, Gender.MALE, KinType.PARENT, Gender.MALE, decimal(mfF.getValue()));
					criteria.setMemoryProb(Gender.MALE, Gender.FEMALE, KinType.PARENT, Gender.MALE, decimal(mmM.getValue()));
					criteria.setMemoryProb(Gender.FEMALE, Gender.FEMALE, KinType.PARENT, Gender.MALE, decimal(mfM.getValue()));
					criteria.setMemoryProb(Gender.MALE, Gender.MALE, KinType.CHILD, Gender.MALE, decimal(mmS.getValue()));
					criteria.setMemoryProb(Gender.FEMALE, Gender.MALE, KinType.CHILD, Gender.MALE, decimal(mfS.getValue()));
					criteria.setMemoryProb(Gender.MALE, Gender.FEMALE, KinType.CHILD, Gender.MALE, decimal(mmD.getValue()));
					criteria.setMemoryProb(Gender.FEMALE, Gender.FEMALE, KinType.CHILD, Gender.MALE, decimal(mfD.getValue()));
					criteria.setMemoryProb(Gender.MALE, Gender.FEMALE, KinType.SPOUSE, Gender.MALE, decimal(mmW.getValue()));
					// criteria.setWomansWifeByMale(decimal(mfW.getValue()));
					// criteria.setMansHusbandByMale(decimal(mmH.getValue()));
					criteria.setMemoryProb(Gender.FEMALE, Gender.MALE, KinType.SPOUSE, Gender.MALE, decimal(mfH.getValue()));
					criteria.setMemoryProb(Gender.MALE, Gender.MALE, KinType.PARENT, Gender.FEMALE, decimal(fmF.getValue()));
					criteria.setMemoryProb(Gender.FEMALE, Gender.MALE, KinType.PARENT, Gender.FEMALE, decimal(ffF.getValue()));
					criteria.setMemoryProb(Gender.MALE, Gender.FEMALE, KinType.PARENT, Gender.FEMALE, decimal(fmM.getValue()));
					criteria.setMemoryProb(Gender.FEMALE, Gender.FEMALE, KinType.PARENT, Gender.FEMALE, decimal(ffM.getValue()));
					criteria.setMemoryProb(Gender.MALE, Gender.MALE, KinType.CHILD, Gender.FEMALE, decimal(fmS.getValue()));
					criteria.setMemoryProb(Gender.FEMALE, Gender.MALE, KinType.CHILD, Gender.FEMALE, decimal(ffS.getValue()));
					criteria.setMemoryProb(Gender.MALE, Gender.FEMALE, KinType.CHILD, Gender.FEMALE, decimal(fmD.getValue()));
					criteria.setMemoryProb(Gender.FEMALE, Gender.FEMALE, KinType.CHILD, Gender.FEMALE, decimal(ffD.getValue()));
					criteria.setMemoryProb(Gender.MALE, Gender.FEMALE, KinType.SPOUSE, Gender.FEMALE, decimal(fmW.getValue()));
					// criteria.setWomansWifeByFemale(decimal(mfW.getValue()));
					// criteria.setMansHusbandByFemale(decimal(mmH.getValue()));
					criteria.setMemoryProb(Gender.FEMALE, Gender.MALE, KinType.SPOUSE, Gender.FEMALE, decimal(ffH.getValue()));
					criteria.setDistanceType((FiliationType) cbBoxDistanceType.getSelectedItem());
					criteria.setMaxDistance((Integer) spinnerKinDegree.getValue());
					criteria.setDistanceWeight((Double) spinnerDistanceWeight.getValue());
					criteria.setDistanceFactor((Double) spinnerDistanceFactor.getValue());

					criteria.setNrInformants((Integer) nrInformantsSpinner.getValue());

					criteria.setMaleAcceptance(decimal(mAccept.getValue()));
					criteria.setFemaleAcceptance(decimal(fAccept.getValue()));

					report.inputs().add("nrInformants", criteria.getNrInformants());
					report.inputs().add("acceptance rate male", criteria.getMaleAcceptance());
					report.inputs().add("acceptance rate female", criteria.getFemaleAcceptance());
					report.inputs().add("loss rate", criteria.getDistanceFactor());

					for (int i = 0; i < 2; i++) {
						for (int j = 0; j < 2; j++) {
							for (int k = 0; k < 3; k++) {
								for (int l = 0; l < 2; l++) {
									String desc = "recall rate ";
									desc += MemoryCriteria.describe(i, j, k, l);
									double prob = criteria.getMemory(i, j, k, l);
									report.inputs().add(desc, prob);
								}
							}
						}
					}

					//

					Map<Individual, Set<Individual>> neighborSets = StatisticsWorker.neighborSets(netGUI.getSegmentation().getCurrentIndividuals(),
							criteria.getMaxDistance(), criteria.getDistanceType());

					RandomNetExplorer randomNetExplorer = new RandomNetExplorer(netGUI.getSegmentation(), criteria, null, neighborSets);
					randomNetExplorer.setReport(report);

					int runs = 1;
					int gen = 10;

					Report statsReport = RandomNetReporter.reportVirtualFieldwork(randomNetExplorer, runs, gen);

					NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), randomNetExplorer.getVirtualNet());
					newNetGui.setChanged(netGUI.isChanged());

					newNetGui.addReportTab(report);

					newNetGui.addReportTab(statsReport);

				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(thisJFrame, message, title, JOptionPane.ERROR_MESSAGE);
				}

			}
		});
		panel.add(btnStart);

		JPanel panel_1 = new JPanel();
		contentPane.add(panel_1, BorderLayout.CENTER);
		panel_1.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, }, new RowSpec[] {
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, }));

		JLabel lblNrinformants = new JLabel("Nr of Informants");
		panel_1.add(lblNrinformants, "4, 2, 3, 1");

		nrInformantsSpinner = new JSpinner();
		nrInformantsSpinner.setModel(new SpinnerNumberModel(new Integer(100), new Integer(0), null, new Integer(100)));
		panel_1.add(nrInformantsSpinner, "8, 2");

		lblKinProximity = new JLabel("Kin proximity");
		panel_1.add(lblKinProximity, "4, 4");

		cbBoxDistanceType = new JComboBox();
		cbBoxDistanceType.setModel(new DefaultComboBoxModel(FiliationType.values()));
		panel_1.add(cbBoxDistanceType, "8, 4, fill, default");

		lblKinDegree = new JLabel("Kin degree");
		panel_1.add(lblKinDegree, "4, 6");

		spinnerKinDegree = new JSpinner();
		spinnerKinDegree.setModel(new SpinnerNumberModel(new Integer(6), null, null, new Integer(1)));
		panel_1.add(spinnerKinDegree, "8, 6");

		lblNearKinPropensity = new JLabel("Near kin weight");
		panel_1.add(lblNearKinPropensity, "4, 8");

		spinnerDistanceWeight = new JSpinner();
		spinnerDistanceWeight.setModel(new SpinnerNumberModel(new Double(1), new Double(1), null, new Double(10)));
		panel_1.add(spinnerDistanceWeight, "8, 8");

		lbMemory = new JLabel("Memory");
		panel_1.add(lbMemory, "4, 10");

		spinnerDistanceFactor = new JSpinner();
		spinnerDistanceFactor.setModel(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.0));
		panel_1.add(spinnerDistanceFactor, "8, 10");

		Label label_3 = new Label("Male Informant");
		panel_1.add(label_3, "6, 12, center, default");

		Label label_4 = new Label("Female Informant");
		panel_1.add(label_4, "8, 12, center, default");

		JLabel lblNrInformants = new JLabel("Acceptance");
		panel_1.add(lblNrInformants, "4, 14, right, default");

		mAccept = new JSlider();
		mAccept.setValue(100);
		panel_1.add(mAccept, "6, 14");

		fAccept = new JSlider();
		fAccept.setValue(100);
		panel_1.add(fAccept, "8, 14");

		lblNewLabel = new JLabel("Kin Recall Rates");
		lblNewLabel.setBackground(new Color(255, 255, 255));
		lblNewLabel.setHorizontalAlignment(SwingConstants.CENTER);
		panel_1.add(lblNewLabel, "6, 16, 3, 1");

		Label label_1 = new Label("Men's Kin");
		panel_1.add(label_1, "6, 18, 3, 1, center, default");

		JLabel mFatherLabel = new JLabel("Father");
		mFatherLabel.setHorizontalAlignment(SwingConstants.LEFT);
		panel_1.add(mFatherLabel, "4, 20, left, default");

		mmF = new JSlider();
		mmF.setValue(100);
		panel_1.add(mmF, "6, 20");

		fmF = new JSlider();
		fmF.setValue(100);
		panel_1.add(fmF, "8, 20");

		lblMother = new JLabel("Mother");
		panel_1.add(lblMother, "4, 22");

		mmM = new JSlider();
		mmM.setValue(100);
		panel_1.add(mmM, "6, 22");

		fmM = new JSlider();
		fmM.setValue(100);
		panel_1.add(fmM, "8, 22");

		lblSon = new JLabel("Son");
		panel_1.add(lblSon, "4, 24");

		mmS = new JSlider();
		mmS.setValue(100);
		panel_1.add(mmS, "6, 24");

		fmS = new JSlider();
		fmS.setValue(100);
		panel_1.add(fmS, "8, 24");

		JLabel mDaughterLabel = new JLabel("Daughter");
		panel_1.add(mDaughterLabel, "4, 26");

		mmD = new JSlider();
		mmD.setValue(100);
		panel_1.add(mmD, "6, 26");

		fmD = new JSlider();
		fmD.setValue(100);
		panel_1.add(fmD, "8, 26");

		JLabel lblWife = new JLabel("Wife");
		panel_1.add(lblWife, "4, 28");

		mmW = new JSlider();
		mmW.setValue(100);
		panel_1.add(mmW, "6, 28");

		fmW = new JSlider();
		fmW.setValue(100);
		panel_1.add(fmW, "8, 28");

		Label label_6 = new Label("Women's Kin");
		panel_1.add(label_6, "6, 30, 3, 1, center, default");

		JLabel fFatherLabel = new JLabel("Father");
		fFatherLabel.setHorizontalAlignment(SwingConstants.LEFT);
		panel_1.add(fFatherLabel, "4, 32, left, default");

		mfF = new JSlider();
		mfF.setValue(100);
		panel_1.add(mfF, "6, 32");

		ffF = new JSlider();
		ffF.setValue(100);
		panel_1.add(ffF, "8, 32");

		lblMother_1 = new JLabel("Mother");
		panel_1.add(lblMother_1, "4, 34");

		mfM = new JSlider();
		mfM.setValue(100);
		panel_1.add(mfM, "6, 34");

		ffM = new JSlider();
		ffM.setValue(100);
		panel_1.add(ffM, "8, 34");

		lblSon_1 = new JLabel("Son");
		panel_1.add(lblSon_1, "4, 36");

		mfS = new JSlider();
		mfS.setValue(100);
		panel_1.add(mfS, "6, 36");

		ffS = new JSlider();
		ffS.setValue(100);
		panel_1.add(ffS, "8, 36");

		JLabel fDaughterLabel = new JLabel("Daughter");
		panel_1.add(fDaughterLabel, "4, 38");

		mfD = new JSlider();
		mfD.setValue(100);
		panel_1.add(mfD, "6, 38");

		ffD = new JSlider();
		ffD.setValue(100);
		panel_1.add(ffD, "8, 38");

		JLabel lblHusband = new JLabel("Husband");
		panel_1.add(lblHusband, "4, 40");

		mfH = new JSlider();
		mfH.setValue(100);
		panel_1.add(mfH, "6, 40");

		ffH = new JSlider();
		ffH.setValue(100);
		panel_1.add(ffH, "8, 40");

	}

	private double decimal(final Object number) {
		return new Double((Integer) number) / 100.;
	}

}
