package org.tip.puckgui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneConstants;
import javax.swing.SwingConstants;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.util.NumberablesHashMap.IdStrategy;
import org.tip.puck.util.ToolBox;
import org.tip.puckgui.InputSettings.CheckLevel;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.models.FamiliesCellRenderer;
import org.tip.puckgui.models.FamiliesModel;
import org.tip.puckgui.models.FamilyChildrenModel;
import org.tip.puckgui.util.AutoComboBox;
import org.tip.puckgui.util.ComboBoxIds;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;

/**
 * 
 * @author TIP
 */
public class FamiliesPanel extends JPanel {

	private static final long serialVersionUID = 651718283569255829L;

	static private final Logger logger = LoggerFactory.getLogger(FamiliesPanel.class);

	/**
	 * This variable is used to unmanage lost focus on edition mode.
	 */
	private boolean doLostFocus = true;

	int reportCounter = 0;
	private JPanel thisJPanel;
	private NetGUI netGUI;
	private static ImageIcon mediumFemaleIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/female-32x32.png"));
	private static ImageIcon mediumMaleIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/male-32x32.png"));
	private static ImageIcon mediumUnknowIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/unknown-32x32.png"));
	private static ImageIcon largeUnknowIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/unknown-64x64.png"));
	private static ImageIcon largeUnmarriedIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/unmarried-x45.png"));
	private static ImageIcon largeMarriedIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/married-x45.png"));
	private static ImageIcon largeDivorcedIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/divorced-x45.png"));
	private JTextField txtfldSearchFamily;
	private JList familyList;
	private JTable tableFamilyChildren;
	private JLabel lblFamilyId;
	private JLabel lblFamilyStatus;
	private JLabel lblFamilyFatherId;
	private JLabel lblFamilyFatherName;
	private JLabel lblFamilyMotherId;
	private JLabel lblFamilyMotherName;
	private JLabel lblFamilyChildren;
	private JLabel lblPosition;
	private AttributesPanel attributesPanel;
	private AutoComboBox cmbbxFamilyParent1;
	private AutoComboBox cmbbxFamilyParent2;
	private AutoComboBox cmbbxFamilyChildrenIds;
	private JButton btnAddChild;
	private JTextField txtFldFamilyId;

	/**
	 * Initialize the contents of the frame.
	 */
	public FamiliesPanel(final NetGUI guiManager) {
		//
		this.thisJPanel = this;
		this.netGUI = guiManager;

		//
		setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));

		JSplitPane familiesSplit = new JSplitPane();
		add(familiesSplit);
		familiesSplit.setAlignmentY(Component.CENTER_ALIGNMENT);
		familiesSplit.setAlignmentX(Component.CENTER_ALIGNMENT);

		JPanel familiesPanel = new JPanel();
		familiesPanel.setSize(new Dimension(400, 0));
		familiesPanel.setMinimumSize(new Dimension(200, 10));
		familiesSplit.setLeftComponent(familiesPanel);
		familiesPanel.setLayout(new BoxLayout(familiesPanel, BoxLayout.Y_AXIS));

		JScrollPane familiesScrollPane = new JScrollPane();
		familiesScrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
		familiesPanel.add(familiesScrollPane);

		familyList = new JList();
		familyList.addListSelectionListener(new ListSelectionListener() {
			@Override
			public void valueChanged(final ListSelectionEvent event) {
				// Select family.
				logger.debug("value changed = " + event.getValueIsAdjusting() + " " + event.getFirstIndex() + " " + event.getLastIndex() + " "
						+ familyList.getSelectedIndex());
				if (familyList.getSelectedIndex() != -1) {
					Family family = (Family) ((JList) event.getSource()).getModel().getElementAt(familyList.getSelectedIndex());
					updateFamilyIdentity(family);
				}
			}
		});
		familyList.setDoubleBuffered(true);
		familyList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		familyList.setCellRenderer(new FamiliesCellRenderer());
		familyList.setModel(new FamiliesModel(null));
		familiesScrollPane.setViewportView(familyList);

		JPanel familyPanel = new JPanel();
		familyPanel.setAlignmentY(Component.TOP_ALIGNMENT);
		familyPanel.setAlignmentX(Component.LEFT_ALIGNMENT);
		familiesSplit.setRightComponent(familyPanel);
		familyPanel.setLayout(new BoxLayout(familyPanel, BoxLayout.Y_AXIS));

		JPanel panelFamilyIdentity = new JPanel();
		familyPanel.add(panelFamilyIdentity);
		panelFamilyIdentity.setLayout(new BoxLayout(panelFamilyIdentity, BoxLayout.X_AXIS));

		Component horizontalStrut_2 = Box.createHorizontalStrut(20);
		panelFamilyIdentity.add(horizontalStrut_2);

		Component horizontalGlue_6 = Box.createHorizontalGlue();
		panelFamilyIdentity.add(horizontalGlue_6);

		JPanel panel_1 = new JPanel();
		panelFamilyIdentity.add(panel_1);
		panel_1.setLayout(new BoxLayout(panel_1, BoxLayout.Y_AXIS));

		Component verticalStrut_1 = Box.createVerticalStrut(10);
		verticalStrut_1.setMaximumSize(new Dimension(20, 10));
		panel_1.add(verticalStrut_1);

		lblFamilyId = new JLabel("555");
		lblFamilyId.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent e) {
				//
				setFamilyIdEditorOn();
			}
		});
		panel_1.add(lblFamilyId);
		lblFamilyId.setAlignmentX(Component.RIGHT_ALIGNMENT);

		txtFldFamilyId = new JTextField();
		txtFldFamilyId.setFocusTraversalKeysEnabled(false);
		txtFldFamilyId.setMaximumSize(new Dimension(200, 2147483647));
		txtFldFamilyId.addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(final KeyEvent event) {
				// FAMILY ID KEYPRESSED.

				try {
					if (event.getKeyCode() == KeyEvent.VK_ESCAPE) {
						logger.debug("escape pressed");
						txtFldFamilyId.transferFocus();
					} else if (event.getKeyCode() == KeyEvent.VK_ENTER) {
						logger.debug("enter pressed");
						save();
						txtFldFamilyId.transferFocus();
					} else if (event.getKeyCode() == KeyEvent.VK_TAB) {
						if (event.isShiftDown()) {
							logger.debug("shift-tab pressed");
							save();
							txtFldFamilyId.transferFocus();
						} else {
							logger.debug("tab pressed");
							save();
							txtFldFamilyId.transferFocus();
							setParent1EditorOn();
						}
					}
				} catch (PuckException exception) {
					// Save failed.
					txtFldFamilyId.requestFocus();
				}
			}

			public void save() throws PuckException {
				// Save new id.
				String input = txtFldFamilyId.getText();
				logger.debug("[lbl,cmb]=[" + lblFamilyId.getText() + "," + input + "]");

				if ((StringUtils.isNotBlank(input)) && (!StringUtils.equals(lblFamilyId.getText(), txtFldFamilyId.getText()))) {
					input = input.trim();
					if (NumberUtils.isDigits(input)) {
						//
						int targetId = Integer.parseInt(input);

						Family family = netGUI.getNet().families().getById(targetId);
						if (family == null) {
							//
							Family currentFamily = getSelectedFamily();
							netGUI.getNet().changeId(currentFamily, targetId);
							netGUI.setChanged(true);

							//
							netGUI.updateAll();

							//
							select(currentFamily);

						} else {
							doLostFocus = false;
							JOptionPane.showMessageDialog(thisJPanel, "ID already in use.", "Invalid id", JOptionPane.ERROR_MESSAGE);
							doLostFocus = true;
							throw PuckExceptions.INVALID_PARAMETER.create();
						}
					} else {
						doLostFocus = false;
						JOptionPane.showMessageDialog(thisJPanel, "Numeric value required.", "Invalid id", JOptionPane.ERROR_MESSAGE);
						doLostFocus = true;
						throw PuckExceptions.INVALID_PARAMETER.create();
					}
				}
			}
		});
		txtFldFamilyId.addFocusListener(new FocusAdapter() {
			@Override
			public void focusLost(final FocusEvent e) {
				logger.debug("FOCUS LOST FAMILY ID");

				//
				if (doLostFocus) {
					lblFamilyId.setVisible(true);
					txtFldFamilyId.setVisible(false);
				}
			}
		});
		txtFldFamilyId.setFocusTraversalKeysEnabled(false);
		panel_1.add(txtFldFamilyId);
		txtFldFamilyId.setColumns(10);

		Component verticalStrut = Box.createVerticalStrut(10);
		verticalStrut.setMaximumSize(new Dimension(20, 10));
		panel_1.add(verticalStrut);

		lblPosition = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("FamiliesPanel.lblNewLabel.text")); //$NON-NLS-1$ //$NON-NLS-2$
		lblPosition.setAlignmentX(Component.RIGHT_ALIGNMENT);
		panel_1.add(lblPosition);

		Component horizontalStrut_5 = Box.createHorizontalStrut(5);
		panelFamilyIdentity.add(horizontalStrut_5);

		lblFamilyStatus = new JLabel("");
		lblFamilyStatus.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent e) {
				// Click union status.
				lblFamilyStatus.requestFocus();
				Family currentFamily = getSelectedFamily();
				if (currentFamily != null) {
					switch (currentFamily.getUnionStatus()) {
						case UNMARRIED:
							currentFamily.setMarried();
						break;
						case MARRIED:
							currentFamily.setDivorced();
						break;
						case DIVORCED:
							currentFamily.setUnmarried();
						break;
					}

					//
					updateFamilyIdentity(currentFamily);

					//
					netGUI.setChanged(true);
				}
			}
		});
		lblFamilyStatus.setAlignmentX(Component.CENTER_ALIGNMENT);
		lblFamilyStatus.setIcon(largeUnmarriedIcon);
		lblFamilyStatus.setFont(new Font("Dialog", Font.PLAIN, 24));
		panelFamilyIdentity.add(lblFamilyStatus);

		Component horizontalStrut_4 = Box.createHorizontalStrut(20);
		panelFamilyIdentity.add(horizontalStrut_4);

		JPanel panel_5 = new JPanel();
		panel_5.setMaximumSize(new Dimension(32767, 200));
		panelFamilyIdentity.add(panel_5);
		panel_5.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.DEFAULT_COLSPEC, ColumnSpec.decode("default:grow"), }, new RowSpec[] {
				FormFactory.MIN_ROWSPEC, FormFactory.MIN_ROWSPEC, FormFactory.MIN_ROWSPEC, FormFactory.MIN_ROWSPEC, }));

		cmbbxFamilyParent1 = new AutoComboBox(null);
		cmbbxFamilyParent1.setStrict(false);
		cmbbxFamilyParent1.setVisible(false);
		cmbbxFamilyParent1.setEditable(true);
		cmbbxFamilyParent1.getEditor().getEditorComponent().setFocusTraversalKeysEnabled(false);

		// Custom manually.
		cmbbxFamilyParent1.getEditor().getEditorComponent().addFocusListener(new FocusListener() {
			@Override
			public void focusGained(final FocusEvent arg0) {
				logger.debug("FOCUS GAINED PARENT 1 ID");
			}

			@Override
			public void focusLost(final FocusEvent arg0) {
				logger.debug("FOCUS LOST PARENT 1 ID");

				if (doLostFocus) {
					//
					cmbbxFamilyParent1.setVisible(false);
					lblFamilyFatherId.setVisible(true);
					lblFamilyFatherName.setVisible(true);

					// Clean.
					cmbbxFamilyParent1.setDataList(new ArrayList<String>());
				}
			}
		});

		cmbbxFamilyParent1.getEditor().getEditorComponent().addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(final KeyEvent event) {

				try {
					if (event.getKeyCode() == KeyEvent.VK_ESCAPE) {
						logger.debug("escape pressed");
						cmbbxFamilyParent1.getEditor().getEditorComponent().transferFocus();
					} else if (event.getKeyCode() == KeyEvent.VK_ENTER) {
						logger.debug("enter pressed");
						save();
						cmbbxFamilyParent1.getEditor().getEditorComponent().transferFocus();
					} else if (event.getKeyCode() == KeyEvent.VK_TAB) {
						if (event.isShiftDown()) {
							logger.debug("shift-tab pressed");
							save();
							cmbbxFamilyParent1.getEditor().getEditorComponent().transferFocus();
							setFamilyIdEditorOn();
						} else {
							logger.debug("tab pressed");
							save();
							cmbbxFamilyParent1.getEditor().getEditorComponent().transferFocus();
							setParent2EditorOn();
						}
					}
				} catch (PuckException exception) {
					// In case of failed save.
					logger.debug("SAVE FAILED");
					cmbbxFamilyParent1.getEditor().getEditorComponent().requestFocus();
				}
			}

			public void save() throws PuckException {
				//
				String newFatherIdInput = (String) cmbbxFamilyParent1.getEditor().getItem();
				logger.debug("[lbl,cmb]=[" + lblFamilyFatherId.getText() + "," + newFatherIdInput + "]");

				//
				Individual newFather = ComboBoxIds.getOrCreateIndividualFromInput(netGUI.getIndividualIdStrategy(), netGUI.getNet(), newFatherIdInput,
						Gender.MALE);

				//
				Family currentFamily = getIdentityFamily();

				if (newFather != currentFamily.getFather()) {
					// Check errors.
					String errorMessage = IndividualsPanel.controlPartners(CheckLevel.ERROR, newFather, currentFamily.getMother(), currentFamily.getChildren()
							.toArray());
					if (errorMessage != null) {
						doLostFocus = false;
						JOptionPane.showMessageDialog(thisJPanel, errorMessage, "Error", JOptionPane.ERROR_MESSAGE);
						doLostFocus = true;
						throw PuckExceptions.INVALID_PARAMETER.create();
					} else {
						//
						Family previousFamily = netGUI.getNet().families().getBySpouses(newFather, currentFamily.getFather());
						if ((newFather != null) && (currentFamily.getMother() != null) && (previousFamily != null)
								&& (previousFamily.getId() != currentFamily.getId())) {
							doLostFocus = false;
							JOptionPane.showMessageDialog(thisJPanel, "This family already exists (" + previousFamily.getId() + ").", "Error",
									JOptionPane.ERROR_MESSAGE);
							doLostFocus = true;
							throw PuckExceptions.INVALID_PARAMETER.create();
						} else {
							//
							NetUtils.setKinFather(currentFamily, newFather);
							if (currentFamily.numberOfParents() == 2) {
								currentFamily.setUnionStatus(netGUI.getDefaultUnionStatus());
							}
							netGUI.setChanged(true);

							// Refresh.
							try {
								netGUI.getSegmentation().refresh();
							} catch (PuckException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
							netGUI.updateAll();

							// Check warning.
							String warningMessage = IndividualsPanel.controlPartners(CheckLevel.WARNING, newFather, currentFamily.getMother(), currentFamily
									.getChildren().toArray());
							if (warningMessage != null) {
								JOptionPane.showMessageDialog(thisJPanel, warningMessage, "Warning", JOptionPane.WARNING_MESSAGE);
							}
						}
					}
				}
			}
		});

		panel_5.add(cmbbxFamilyParent1, "1, 1, 2, 1, fill, default");

		lblFamilyFatherId = new JLabel("55");
		lblFamilyFatherId.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent e) {
				// Family parent 1 id clicked.
				logger.debug("parent 1 id clicked");
				setParent1EditorOn();
			}
		});
		lblFamilyFatherId.setHorizontalAlignment(SwingConstants.RIGHT);
		panel_5.add(lblFamilyFatherId, "1, 2, right, center");

		lblFamilyFatherName = new JLabel("anonymous");
		lblFamilyFatherName.setHorizontalAlignment(SwingConstants.LEFT);
		lblFamilyFatherName.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent event) {
				// Click on family father.
				try {
					if (event.getClickCount() == 2) {
						int selectedIndex = familyList.getSelectedIndex();
						if (selectedIndex != -1) {
							Family selected = (Family) ((FamiliesModel) familyList.getModel()).getElementAt(selectedIndex);
							if ((selected != null) && (selected.getFather() != null)) {
								netGUI.changeSegmentationToCluster(selected.getFather());
							}
						}
					}
				} catch (final PuckException exception) {
					exception.printStackTrace();
				}
			}
		});
		lblFamilyFatherName.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/unknown-32x32.png")));
		panel_5.add(lblFamilyFatherName, "2, 2, left, center");

		JPopupMenu popupMenu = new JPopupMenu();
		addPopup(lblFamilyFatherName, popupMenu);

		JMenuItem mntmSwapParents = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("FamiliesPanel.mntmSwapParents.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmSwapParents.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Swap Individual parents.
				Family currentFamily = getIdentityFamily();
				if ((currentFamily != null) && (currentFamily.getFather() != null) && (currentFamily.getMother() != null)) {
					NetUtils.swapParents(currentFamily);
					netGUI.setChanged(true);
					netGUI.updateAll();
					netGUI.selectFamiliesTab(currentFamily);
				}
			}
		});

		JMenuItem mntmDelete = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("FamiliesPanel.mntmDelete.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmDelete.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Delete parent 1.
				Family currentFamily = getIdentityFamily();
				if (currentFamily.getFather() != null) {
					//
					NetUtils.removeFather(currentFamily);

					try {
						netGUI.getSegmentation().refresh();
					} catch (PuckException exception) {
						// TODO Auto-generated catch block
						exception.printStackTrace();
					}
					netGUI.updateAll();
					netGUI.setChanged(true);
				}
			}
		});
		popupMenu.add(mntmDelete);

		JSeparator separator = new JSeparator();
		popupMenu.add(separator);
		popupMenu.add(mntmSwapParents);

		lblFamilyMotherId = new JLabel("5555");
		lblFamilyMotherId.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent e) {
				// Family parent 2 id clicked.
				logger.debug("parent 2 id clicked");
				setParent2EditorOn();
			}
		});
		lblFamilyMotherId.setHorizontalAlignment(SwingConstants.RIGHT);
		panel_5.add(lblFamilyMotherId, "1, 3, right, center");

		lblFamilyMotherName = new JLabel("anonymous");
		lblFamilyMotherName.setHorizontalAlignment(SwingConstants.LEFT);
		lblFamilyMotherName.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent event) {
				// Click on family mother.
				try {
					if (event.getClickCount() == 2) {
						int selectedIndex = familyList.getSelectedIndex();
						if (selectedIndex != -1) {
							Family selected = (Family) ((FamiliesModel) familyList.getModel()).getElementAt(selectedIndex);
							if ((selected != null) && (selected.getMother() != null)) {
								netGUI.changeSegmentationToCluster(selected.getMother());
							}
						}
					}
				} catch (final PuckException exception) {
					exception.printStackTrace();
				}
			}
		});
		lblFamilyMotherName.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/unknown-32x32.png")));
		panel_5.add(lblFamilyMotherName, "2, 3, left, center");

		JPopupMenu popupMenu_1 = new JPopupMenu();
		addPopup(lblFamilyMotherName, popupMenu_1);

		JMenuItem mntmDelete_1 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("FamiliesPanel.mntmDelete_1.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmDelete_1.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Delete parent 2.
				Family currentFamily = getIdentityFamily();
				if (currentFamily.getMother() != null) {
					//
					NetUtils.removeMother(currentFamily);

					try {
						netGUI.getSegmentation().refresh();
					} catch (PuckException exception) {
						// TODO Auto-generated catch block
						exception.printStackTrace();
					}
					netGUI.updateAll();
					netGUI.setChanged(true);
				}
			}
		});
		popupMenu_1.add(mntmDelete_1);

		cmbbxFamilyParent2 = new AutoComboBox(null);
		cmbbxFamilyParent2.setStrict(false);
		cmbbxFamilyParent2.setEditable(true);
		cmbbxFamilyParent2.setVisible(false);
		cmbbxFamilyParent2.getEditor().getEditorComponent().setFocusTraversalKeysEnabled(false);

		// Custom manually.
		cmbbxFamilyParent2.getEditor().getEditorComponent().addFocusListener(new FocusListener() {
			@Override
			public void focusGained(final FocusEvent arg0) {
				logger.debug("FOCUS GAINED PARENT 2 ID");
			}

			@Override
			public void focusLost(final FocusEvent arg0) {
				logger.debug("FOCUS LOST PARENT 2 ID");

				if (doLostFocus) {
					//
					cmbbxFamilyParent2.setVisible(false);
					lblFamilyMotherId.setVisible(true);
					lblFamilyMotherName.setVisible(true);

					// Clean.
					cmbbxFamilyParent2.setDataList(new ArrayList<String>());
				}
			}
		});

		cmbbxFamilyParent2.getEditor().getEditorComponent().addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(final KeyEvent event) {
				try {
					//
					if (event.getKeyCode() == KeyEvent.VK_ESCAPE) {
						logger.debug("escape pressed");
						cmbbxFamilyParent2.getEditor().getEditorComponent().transferFocus();
					} else if (event.getKeyCode() == KeyEvent.VK_ENTER) {
						logger.debug("enter pressed");
						save();
						cmbbxFamilyParent2.getEditor().getEditorComponent().transferFocus();
					} else if (event.getKeyCode() == KeyEvent.VK_TAB) {
						if (event.isShiftDown()) {
							logger.debug("shift-tab pressed");
							save();
							cmbbxFamilyParent2.getEditor().getEditorComponent().transferFocus();
							setParent1EditorOn();
						} else {
							logger.debug("tab pressed");
							save();
							cmbbxFamilyParent2.getEditor().getEditorComponent().transferFocus();
						}
					}
				} catch (PuckException exception) {
					// In case of failed save.
					logger.debug("SAVE FAILED");
					cmbbxFamilyParent2.getEditor().getEditorComponent().requestFocus();
				}
			}

			public void save() throws PuckException {
				String newMotherIdInput = (String) cmbbxFamilyParent2.getEditor().getItem();
				logger.debug("[lbl,cmb]=[" + lblFamilyMotherId.getText() + "," + newMotherIdInput + "]");

				//
				Family currentFamily = getIdentityFamily();

				//
				Individual newMother = ComboBoxIds.getOrCreateIndividualFromInput(netGUI.getIndividualIdStrategy(), netGUI.getNet(), newMotherIdInput,
						Gender.MALE);

				if (newMother != currentFamily.getMother()) {

					// Check errors.
					String errorMessage = IndividualsPanel.controlPartners(CheckLevel.ERROR, currentFamily.getFather(), newMother, currentFamily.getChildren()
							.toArray());
					if (errorMessage != null) {
						doLostFocus = false;
						JOptionPane.showMessageDialog(thisJPanel, errorMessage, "Error", JOptionPane.ERROR_MESSAGE);
						doLostFocus = true;
						throw PuckExceptions.INVALID_PARAMETER.create();
					} else {
						//
						Family previousFamily = netGUI.getNet().families().getBySpouses(newMother, currentFamily.getFather());
						if ((newMother != null) && (currentFamily.getFather() != null) && (previousFamily != null)
								&& (previousFamily.getId() != currentFamily.getId())) {
							doLostFocus = false;
							JOptionPane.showMessageDialog(thisJPanel, "This family already exists (" + previousFamily.getId() + ").", "Error",
									JOptionPane.ERROR_MESSAGE);
							doLostFocus = true;
							throw PuckExceptions.INVALID_PARAMETER.create();
						} else {
							//
							NetUtils.setKinMother(currentFamily, newMother);
							if (currentFamily.numberOfParents() == 2) {
								currentFamily.setUnionStatus(netGUI.getDefaultUnionStatus());
							}

							// Refresh.
							try {
								netGUI.getSegmentation().refresh();
							} catch (PuckException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
							netGUI.updateAll();
							netGUI.setChanged(true);

							// Check warning.
							String warningMessage = IndividualsPanel.controlPartners(CheckLevel.WARNING, currentFamily.getFather(), newMother, currentFamily
									.getChildren().toArray());
							if (warningMessage != null) {
								JOptionPane.showMessageDialog(thisJPanel, warningMessage, "Warning", JOptionPane.WARNING_MESSAGE);
							}
						}
					}
				}
			}
		});

		panel_5.add(cmbbxFamilyParent2, "1, 4, 2, 1, fill, default");

		Component horizontalStrut_3 = Box.createHorizontalStrut(20);
		panelFamilyIdentity.add(horizontalStrut_3);

		Component verticalStrut_7 = Box.createVerticalStrut(10);
		familyPanel.add(verticalStrut_7);

		JPanel panel = new JPanel();
		familyPanel.add(panel);
		panel.setLayout(new BorderLayout(0, 0));

		JSplitPane splitPane = new JSplitPane();
		panel.add(splitPane, BorderLayout.CENTER);
		splitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);

		JPanel panelFamilyChildren = new JPanel();
		panelFamilyChildren.setMinimumSize(new Dimension(10, 200));
		splitPane.setLeftComponent(panelFamilyChildren);
		panelFamilyChildren.setLayout(new BoxLayout(panelFamilyChildren, BoxLayout.Y_AXIS));

		JPanel panel_2 = new JPanel();
		panel_2.setAlignmentX(Component.LEFT_ALIGNMENT);
		panelFamilyChildren.add(panel_2);
		panel_2.setLayout(new BoxLayout(panel_2, BoxLayout.X_AXIS));

		lblFamilyChildren = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblChildren.text"));
		panel_2.add(lblFamilyChildren);

		Component horizontalStrut = Box.createHorizontalStrut(20);
		panel_2.add(horizontalStrut);

		btnAddChild = new JButton(" + ");
		btnAddChild.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Add Child (menu item).
				logger.debug("Add Child");
				addChild();
			}
		});
		btnAddChild.setBorder(new EmptyBorder(0, 0, 0, 0));
		panel_2.add(btnAddChild);

		Component horizontalStrut_1 = Box.createHorizontalStrut(5);
		panel_2.add(horizontalStrut_1);

		JLabel lblctrlk = new JLabel("(Ctrl-K)");
		panel_2.add(lblctrlk);

		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
		panelFamilyChildren.add(scrollPane);

		tableFamilyChildren = new JTable();
		tableFamilyChildren.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent event) {
				// Family children clicked.
				try {
					if (event.getClickCount() == 2) {
						int selectedIndex = tableFamilyChildren.getSelectedRow();
						int selectedColumn = tableFamilyChildren.getSelectedColumn();
						logger.debug("[index= " + selectedIndex + ", col]=[" + selectedColumn + "]");
						if (selectedIndex != -1) {
							if (selectedColumn > 0) {
								// tableFamilyChildren.editCellAt(selectedIndex,
								// 0);
								// //
								// tableFamilyChildren.getEditorComponent().requestFocus();
								// } else {
								Individual selected = ((FamilyChildrenModel) tableFamilyChildren.getModel()).children().get(selectedIndex);
								if (selected != null) {
									netGUI.changeSegmentationToCluster(selected);
								}
							}
						}
					}
				} catch (final PuckException exception) {
					exception.printStackTrace();
				}
			}
		});
		scrollPane.setViewportView(tableFamilyChildren);
		tableFamilyChildren.setBorder(new LineBorder(new Color(169, 169, 169)));
		tableFamilyChildren.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		tableFamilyChildren.getTableHeader().setReorderingAllowed(false);
		tableFamilyChildren.setModel(new FamilyChildrenModel(netGUI, null));

		JPopupMenu popupMenu_2 = new JPopupMenu();

		JMenuItem mntmDelete_2 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("FamiliesPanel.mntmDelete_2.text_1")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmDelete_2.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Delete family children.
				logger.debug("Delete " + ArrayUtils.toString(tableFamilyChildren.getSelectedRows()));

				int[] selectedRowIds = tableFamilyChildren.getSelectedRows();
				if (selectedRowIds.length != 0) {
					ArrayUtils.reverse(selectedRowIds);
					for (int rowIndex : selectedRowIds) {
						int childId = (Integer) tableFamilyChildren.getModel().getValueAt(rowIndex, 0);
						netGUI.getNet().removeChild(netGUI.getNet().individuals().getById(childId));
					}

					//
					netGUI.setChanged(true);
					netGUI.updateAll();
				}
			}
		});
		popupMenu_2.add(mntmDelete_2);
		addPopup(tableFamilyChildren, popupMenu_2);

		attributesPanel = new AttributesPanel(this.netGUI, null);
		splitPane.setRightComponent(attributesPanel);

		//
		cmbbxFamilyChildrenIds = new AutoComboBox(null);
		cmbbxFamilyChildrenIds.getEditor().getEditorComponent().addFocusListener(new FocusListener() {
			@Override
			public void focusGained(final FocusEvent arg0) {
			}

			@Override
			public void focusLost(final FocusEvent arg0) {
				logger.debug("FOCUS LOST FAMILY CHILDREN TABLE " + tableFamilyChildren.isEditing());
				if (tableFamilyChildren.isEditing()) {
					tableFamilyChildren.getColumnModel().getColumn(0).getCellEditor().cancelCellEditing();
				}

				if (((FamilyChildrenModel) tableFamilyChildren.getModel()).isNewEditionOn()) {
					((FamilyChildrenModel) tableFamilyChildren.getModel()).escapeNewEdition();
				}
			}
		});
		cmbbxFamilyChildrenIds.setEditable(true);
		cmbbxFamilyChildrenIds.setStrict(false);
		cmbbxFamilyChildrenIds.setMaximumRowCount(7);
		TableCellEditor editor = new DefaultCellEditor(cmbbxFamilyChildrenIds);
		tableFamilyChildren.getColumnModel().getColumn(0).setCellEditor(editor);
		tableFamilyChildren.getColumnModel().getColumn(0).setMinWidth(10);
		tableFamilyChildren.getColumnModel().getColumn(0).setPreferredWidth(90);
		tableFamilyChildren.getColumnModel().getColumn(0).setMaxWidth(110);
		tableFamilyChildren.getColumnModel().getColumn(1).setMinWidth(10);
		tableFamilyChildren.getColumnModel().getColumn(1).setMaxWidth(30);
		tableFamilyChildren.getColumnModel().getColumn(1).setResizable(false);
		tableFamilyChildren.getColumnModel().getColumn(3).setMaxWidth(125);
		tableFamilyChildren.getColumnModel().getColumn(3).setResizable(false);

		JPanel familiesButtonsPanel = new JPanel();
		add(familiesButtonsPanel);
		familiesButtonsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		familiesButtonsPanel.setLayout(new BoxLayout(familiesButtonsPanel, BoxLayout.X_AXIS));

		JButton btnAddFamily = new JButton("");
		btnAddFamily.addActionListener(new ActionListener() {
			// Add Family button clicked.
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Add family.
				logger.debug("Add family");
				addFamily();
			}
		});
		btnAddFamily.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnAddFamily.toolTipText")); //$NON-NLS-1$ //$NON-NLS-2$
		btnAddFamily.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/add.png")));
		familiesButtonsPanel.add(btnAddFamily);

		JButton btnRemoveFamily = new JButton("");
		btnRemoveFamily.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Remove family.
				Family target = getSelectedFamily();
				if (target != null) {
					int selectedIndex = familyList.getSelectedIndex();
					netGUI.getNet().remove(target);
					update();
					if (netGUI.getNet().families().size() != 0) {
						if (selectedIndex == netGUI.getNet().families().size()) {
							selectedIndex -= 1;
						}
						familyList.setSelectedIndex(selectedIndex);
					}
					netGUI.setChanged(true);
				}
			}
		});
		familiesButtonsPanel.add(btnRemoveFamily);
		btnRemoveFamily.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnRemoveFamily.toolTipText")); //$NON-NLS-1$ //$NON-NLS-2$
		btnRemoveFamily.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/remove.png")));

		Component horizontalGlue = Box.createHorizontalGlue();
		familiesButtonsPanel.add(horizontalGlue);

		JButton btnFamiliesPrevious = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnPrevious.text")); //$NON-NLS-1$ //$NON-NLS-2$
		btnFamiliesPrevious.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Previous family.
				int selectedIndex = familyList.getSelectedIndex();
				if (selectedIndex == -1) {
					if (netGUI.getNet().families().size() != 0) {
						selectedIndex = netGUI.getNet().families().size() - 1;
						familyList.setSelectedIndex(selectedIndex);
						familyList.ensureIndexIsVisible(selectedIndex);
					}
				} else if (selectedIndex > 0) {
					selectedIndex -= 1;
					familyList.setSelectedIndex(selectedIndex);
					familyList.ensureIndexIsVisible(selectedIndex);
				}
			}
		});
		familiesButtonsPanel.add(btnFamiliesPrevious);

		JButton btnFamiliesNext = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnNext.text")); //$NON-NLS-1$ //$NON-NLS-2$
		btnFamiliesNext.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Next family.
				int selectedIndex = familyList.getSelectedIndex();
				if (selectedIndex == -1) {
					if (netGUI.getNet().families().size() != 0) {
						selectedIndex = 0;
						familyList.setSelectedIndex(selectedIndex);
						familyList.ensureIndexIsVisible(selectedIndex);
					}
				} else if (selectedIndex < netGUI.getNet().families().size() - 1) {
					selectedIndex += 1;
					familyList.setSelectedIndex(selectedIndex);
					familyList.ensureIndexIsVisible(selectedIndex);
				}
			}
		});
		familiesButtonsPanel.add(btnFamiliesNext);

		Component horizontalGlue_4 = Box.createHorizontalGlue();
		familiesButtonsPanel.add(horizontalGlue_4);

		JLabel lblFamiliesSearch = new JLabel(" ");
		lblFamiliesSearch.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/find.png")));
		lblFamiliesSearch.setToolTipText("Search: ");
		lblFamiliesSearch.setMinimumSize(new Dimension(300, 15));
		familiesButtonsPanel.add(lblFamiliesSearch);

		txtfldSearchFamily = new JTextField();
		txtfldSearchFamily.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Search family.
				String pattern = txtfldSearchFamily.getText();
				logger.debug("Search family=[" + pattern + "]");
				if (StringUtils.isNotBlank(pattern)) {
					int index = ((FamiliesModel) familyList.getModel()).nextSearchedFamilyIndex(pattern);
					if (index != -1) {
						familyList.setSelectedIndex(index);
						familyList.ensureIndexIsVisible(index);
					}
				}
			}
		});
		txtfldSearchFamily.setText("");
		txtfldSearchFamily.setMaximumSize(new Dimension(500, 50));
		txtfldSearchFamily.setColumns(15);
		familiesButtonsPanel.add(txtfldSearchFamily);
	}

	/**
	 * 
	 */
	public void addChild() {
		// Add child.
		if (((FamilyChildrenModel) tableFamilyChildren.getModel()).getSource() != null) {
			if (!((FamilyChildrenModel) tableFamilyChildren.getModel()).isNewEditionOn()) {
				//
				((FamilyChildrenModel) tableFamilyChildren.getModel()).setNewItem();

				//
				tableFamilyChildren.scrollRectToVisible(tableFamilyChildren.getCellRect(tableFamilyChildren.getModel().getRowCount() - 1, 0, true));
				tableFamilyChildren.setRowSelectionInterval(tableFamilyChildren.getModel().getRowCount() - 1, tableFamilyChildren.getModel().getRowCount() - 1);
				tableFamilyChildren.editCellAt(tableFamilyChildren.getModel().getRowCount() - 1, 0);
				tableFamilyChildren.getEditorComponent().requestFocus();
			}
		}
	}

	/**
	 * 
	 */
	public void addFamily() {
		try {
			Family newFamily = netGUI.getNet().createFamily(IdStrategy.APPEND, null, null);

			netGUI.updateAll();
			netGUI.selectFamiliesTab(newFamily);

			setParent1EditorOn();
		} catch (final Exception exception) {
			// Show trace.
			exception.printStackTrace();

			//
			String title = "Error computerum est";
			String message = "Error occured during working: " + exception.getMessage();

			//
			JOptionPane.showMessageDialog(null, message, title, JOptionPane.ERROR_MESSAGE);
		}
	}

	/**
	 * 
	 * @return
	 */
	public Family getIdentityFamily() {
		Family result;

		if (NumberUtils.isDigits(lblFamilyId.getText())) {
			result = netGUI.getNet().families().getById(Integer.parseInt(lblFamilyId.getText()));
		} else {
			result = null;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public Individual getIdentityParent1() {
		Individual result;

		if (NumberUtils.isDigits(lblFamilyFatherId.getText())) {
			result = netGUI.getNet().individuals().getById(Integer.parseInt(lblFamilyFatherId.getText()));
		} else {
			result = null;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public Individual getIdentityParent2() {
		Individual result;

		if (NumberUtils.isDigits(lblFamilyMotherId.getText())) {
			result = netGUI.getNet().individuals().getById(Integer.parseInt(lblFamilyMotherId.getText()));
		} else {
			result = null;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public Family getSelectedFamily() {
		Family result;

		if (familyList.getSelectedIndex() == -1) {
			result = null;
		} else {
			result = (Family) ((FamiliesModel) familyList.getModel()).getElementAt(familyList.getSelectedIndex());
		}

		//
		return result;
	}

	/**
	 * 
	 * @param family
	 */
	public void select(final Family family) {
		int familyIndex = ((FamiliesModel) familyList.getModel()).indexOf(family);
		if ((familyIndex >= 0) && (familyIndex < ((FamiliesModel) this.familyList.getModel()).getSize())) {
			this.familyList.setSelectedIndex(familyIndex);
			this.familyList.ensureIndexIsVisible(familyIndex);
		} else if (((FamiliesModel) this.familyList.getModel()).getSize() != 0) {
			this.familyList.setSelectedIndex(0);
			this.familyList.ensureIndexIsVisible(0);
		} else {
			updateFamilyIdentity(null);
		}
	}

	/**
	 * 
	 * @param target
	 */
	public void selectByIndex(final int familyIndex) {

		if ((familyIndex >= 0) && (familyIndex < ((FamiliesModel) this.familyList.getModel()).getSize())) {
			this.familyList.setSelectedIndex(familyIndex);
			this.familyList.ensureIndexIsVisible(familyIndex);
		} else if (((FamiliesModel) this.familyList.getModel()).getSize() != 0) {
			this.familyList.setSelectedIndex(0);
			this.familyList.ensureIndexIsVisible(0);
		} else {
			updateFamilyIdentity(null);
		}
	}

	/**
	 * 
	 */
	private void setFamilyIdEditorOn() {
		//
		logger.debug("Family id clicked");

		txtFldFamilyId.setText(lblFamilyId.getText());

		//
		lblFamilyId.setVisible(false);
		txtFldFamilyId.setVisible(true);

		//
		txtFldFamilyId.requestFocus();
	}

	/**
	 * 
	 */
	public void setFocusOnFind() {
		txtfldSearchFamily.requestFocus();
	}

	/**
	 * 
	 */
	private void setParent1EditorOn() {
		// Family parent 1 id clicked.
		Individual currentParent = getIdentityParent1();

		// Populate combobox.
		List<Individual> individuals = netGUI.getNet().individuals().toSortedList();
		List<String> items = new ArrayList<String>(individuals.size());
		for (Individual individual : individuals) {
			items.add(individual.getId() + " " + individual.getName());
		}
		cmbbxFamilyParent1.setDataList(items);

		// Set combobox selected item.
		if (currentParent == null) {
			cmbbxFamilyParent1.setSelectedIndex(-1);
		} else {
			int currentItemIndex = ToolBox.indexOf(currentParent.getId() + " " + currentParent.getName(), items);
			cmbbxFamilyParent1.setSelectedIndex(currentItemIndex);
		}

		//
		lblFamilyFatherId.setVisible(false);
		lblFamilyFatherName.setVisible(false);

		//
		cmbbxFamilyParent1.setVisible(true);

		//
		cmbbxFamilyParent1.requestFocus();
	}

	/**
	 * 
	 */
	private void setParent2EditorOn() {
		// Family parent 2 id clicked.
		Individual currentParent2 = getIdentityParent2();

		//
		List<Individual> individuals = netGUI.getNet().individuals().toSortedList();
		List<String> items = new ArrayList<String>(individuals.size());
		for (Individual individual : individuals) {
			items.add(individual.getId() + " " + individual.getName());
		}
		cmbbxFamilyParent2.setDataList(items);

		// Set combobox selected item.
		if (currentParent2 == null) {
			cmbbxFamilyParent2.setSelectedIndex(-1);
		} else {
			int currentItemIndex = ToolBox.indexOf(currentParent2.getId() + " " + currentParent2.getName(), items);
			cmbbxFamilyParent2.setSelectedIndex(currentItemIndex);
		}

		//
		lblFamilyMotherId.setVisible(false);
		lblFamilyMotherName.setVisible(false);

		//
		cmbbxFamilyParent2.setVisible(true);

		//
		cmbbxFamilyParent2.requestFocus();
	}

	/**
	 * 
	 */
	public void update() {
		//
		int selectedFamily = familyList.getSelectedIndex();

		//
		((FamiliesModel) familyList.getModel()).setSource(this.netGUI.getCurrentFamilies());

		//
		selectByIndex(selectedFamily);
	}

	/**
	 * 
	 */
	public void updateFamilyIdentity(final Family source) {
		if (source == null) {
			logger.debug("updateFamilyIdentity null");
		} else {
			logger.debug("updateFamilyIdentity " + source.getId());
		}

		if (source == null) {
			//
			this.lblFamilyId.setText("---");
			this.txtFldFamilyId.setVisible(false);
			this.lblFamilyStatus.setIcon(largeUnknowIcon);
			this.lblPosition.setText("(--/--)");

			//
			this.lblFamilyFatherId.setText("---");
			this.lblFamilyFatherName.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individual.unknown"));
			this.lblFamilyFatherName.setIcon(mediumUnknowIcon);

			//
			this.lblFamilyMotherId.setText("---");
			this.lblFamilyMotherName.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individual.unknown"));
			this.lblFamilyMotherName.setIcon(mediumUnknowIcon);

			//
			lblFamilyChildren.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblChildren.text"));
			((FamilyChildrenModel) tableFamilyChildren.getModel()).setSource(null);

			//
			cmbbxFamilyChildrenIds.setDataList(new ArrayList<String>(0));

			//
			attributesPanel.setSource(null);

			//
			btnAddChild.setEnabled(false);
		} else {
			//
			this.lblFamilyId.setText(String.valueOf(source.getId()));
			txtFldFamilyId.setVisible(false);
			switch (source.getUnionStatus()) {
				case UNMARRIED:
					this.lblFamilyStatus.setIcon(largeUnmarriedIcon);
				break;
				case MARRIED:
					this.lblFamilyStatus.setIcon(largeMarriedIcon);
				break;
				case DIVORCED:
					this.lblFamilyStatus.setIcon(largeDivorcedIcon);
				break;
				default:
					this.lblFamilyStatus.setIcon(largeUnknowIcon);
			}
			this.lblPosition.setText("(" + (this.familyList.getSelectedIndex() + 1) + "/" + this.familyList.getModel().getSize() + ")");

			//
			if (source.getFather() == null) {
				this.lblFamilyFatherId.setText("---");
				this.lblFamilyFatherName.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individual.unknown"));
				this.lblFamilyFatherName.setIcon(mediumUnknowIcon);
			} else {
				this.lblFamilyFatherId.setText(String.valueOf(source.getFather().getId()));
				this.lblFamilyFatherName.setText(source.getFather().getName());
				switch (source.getFather().getGender()) {
					case FEMALE:
						this.lblFamilyFatherName.setIcon(mediumFemaleIcon);
					break;
					case MALE:
						this.lblFamilyFatherName.setIcon(mediumMaleIcon);
					break;
					case UNKNOWN:
						this.lblFamilyFatherName.setIcon(mediumUnknowIcon);
					break;
				}
			}
			//
			if (source.getMother() == null) {
				this.lblFamilyMotherId.setText("---");
				this.lblFamilyMotherName.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individual.unknown"));
				this.lblFamilyMotherName.setIcon(mediumUnknowIcon);
			} else {
				this.lblFamilyMotherId.setText(String.valueOf(source.getMother().getId()));
				this.lblFamilyMotherName.setText(source.getMother().getName());
				switch (source.getMother().getGender()) {
					case FEMALE:
						this.lblFamilyMotherName.setIcon(mediumFemaleIcon);
					break;
					case MALE:
						this.lblFamilyMotherName.setIcon(mediumMaleIcon);
					break;
					case UNKNOWN:
						this.lblFamilyMotherName.setIcon(mediumUnknowIcon);
					break;
				}
			}

			//
			((FamilyChildrenModel) tableFamilyChildren.getModel()).setSource(source);
			lblFamilyChildren.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblChildren.text") + " ("
					+ ((FamilyChildrenModel) tableFamilyChildren.getModel()).children().size() + ")");

			//
			cmbbxFamilyChildrenIds.setDataList(ComboBoxIds.instance().items());

			//
			attributesPanel.setSource(source.attributes());

			//
			int selectedIndex = familyList.getSelectedIndex();
			if (selectedIndex != -1) {
				Family selected = (Family) ((FamiliesModel) familyList.getModel()).getElementAt(selectedIndex);
				if (source != selected) {
					int sourceIndex = ((FamiliesModel) familyList.getModel()).indexOf(source);

					if (sourceIndex != -1) {
						familyList.setSelectedIndex(sourceIndex);
						familyList.ensureIndexIsVisible(sourceIndex);
					}
				}
			}

			//
			btnAddChild.setEnabled(true);
		}
	}

	private static void addPopup(final Component component, final JPopupMenu popup) {
		component.addMouseListener(new MouseAdapter() {
			@Override
			public void mousePressed(final MouseEvent e) {
				if (e.isPopupTrigger()) {
					showMenu(e);
				}
			}

			@Override
			public void mouseReleased(final MouseEvent e) {
				if (e.isPopupTrigger()) {
					showMenu(e);
				}
			}

			private void showMenu(final MouseEvent e) {
				popup.show(e.getComponent(), e.getX(), e.getY());
			}
		});
	}
}
