package org.tip.puckgui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.Attributes;
import org.tip.puckgui.NetGUI;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;

/**
 * 
 * @author TIP
 */
public class CorpusPanel extends JPanel {

	private static final long serialVersionUID = 1990081342527870857L;

	static private final Logger logger = LoggerFactory.getLogger(CorpusPanel.class);

	int reportCounter = 0;
	private JPanel thisJPanel;
	private NetGUI netGUI;
	JLabel lblFileNameValue;
	JLabel lblFileDateValue;
	JLabel lblFileSizeValue;
	JLabel lblIndividualCount;
	JLabel lblFamilyCount;
	private AttributesPanel attributesPanel;
	private JLabel lblRelationCount;
	private JLabel lblRelationModelCount;

	/**
	 * 
	 * @param guiManager
	 */
	public CorpusPanel(final NetGUI guiManager) {
		//
		this.thisJPanel = this;
		this.netGUI = guiManager;
		setVisible(true);
		setLayout(new BorderLayout(0, 0));

		JPanel generalPanel = new JPanel();
		add(generalPanel, BorderLayout.NORTH);
		generalPanel.setLayout(new BoxLayout(generalPanel, BoxLayout.Y_AXIS));

		JPanel corpusStaticDataPanel = new JPanel();
		corpusStaticDataPanel.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "General", TitledBorder.LEADING, TitledBorder.TOP, null,
				new Color(51, 51, 51)));
		corpusStaticDataPanel.setAlignmentX(Component.LEFT_ALIGNMENT);
		generalPanel.add(corpusStaticDataPanel);
		corpusStaticDataPanel.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode("default:grow"), FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, }));

		JLabel lblFileName = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("CorpusPanel.lblFileName.text")); //$NON-NLS-1$ //$NON-NLS-2$
		lblFileName.setFont(new Font("Dialog", Font.PLAIN, 12));
		corpusStaticDataPanel.add(lblFileName, "2, 2");

		lblFileNameValue = new JLabel("-");
		lblFileNameValue.setFont(new Font("Dialog", Font.PLAIN, 12));
		corpusStaticDataPanel.add(lblFileNameValue, "4, 2");

		JLabel lblFileDate = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("CorpusPanel.lblFileDate.text")); //$NON-NLS-1$ //$NON-NLS-2$
		lblFileDate.setFont(new Font("Dialog", Font.PLAIN, 12));
		corpusStaticDataPanel.add(lblFileDate, "2, 4");

		lblFileDateValue = new JLabel("-");
		lblFileDateValue.setFont(new Font("Dialog", Font.PLAIN, 12));
		corpusStaticDataPanel.add(lblFileDateValue, "4, 4");

		JLabel lblFileSize = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("CorpusPanel.lblFileSize.text")); //$NON-NLS-1$ //$NON-NLS-2$
		lblFileSize.setFont(new Font("Dialog", Font.PLAIN, 12));
		corpusStaticDataPanel.add(lblFileSize, "2, 6");

		lblFileSizeValue = new JLabel("-");
		lblFileSizeValue.setFont(new Font("Dialog", Font.PLAIN, 12));
		corpusStaticDataPanel.add(lblFileSizeValue, "4, 6");

		JLabel lblIndividuals = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("CorpusPanel.lblIndividuals.text")); //$NON-NLS-1$ //$NON-NLS-2$
		lblIndividuals.setFont(new Font("Dialog", Font.PLAIN, 12));
		corpusStaticDataPanel.add(lblIndividuals, "2, 8");

		lblIndividualCount = new JLabel("-");
		lblIndividualCount.setFont(new Font("Dialog", Font.PLAIN, 12));
		corpusStaticDataPanel.add(lblIndividualCount, "4, 8");

		JLabel lblFamilies = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("CorpusPanel.lblFamilies.text")); //$NON-NLS-1$ //$NON-NLS-2$
		lblFamilies.setFont(new Font("Dialog", Font.PLAIN, 12));
		corpusStaticDataPanel.add(lblFamilies, "2, 10");

		lblFamilyCount = new JLabel("-");
		lblFamilyCount.setFont(new Font("Dialog", Font.PLAIN, 12));
		corpusStaticDataPanel.add(lblFamilyCount, "4, 10");

		JLabel lblRelationModels = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("CorpusPanel.lblRelationModels.text")); //$NON-NLS-1$ //$NON-NLS-2$
		lblRelationModels.setFont(new Font("Dialog", Font.PLAIN, 12));
		corpusStaticDataPanel.add(lblRelationModels, "2, 12");

		lblRelationModelCount = new JLabel("-");
		lblRelationModelCount.setFont(new Font("Dialog", Font.PLAIN, 12));
		corpusStaticDataPanel.add(lblRelationModelCount, "4, 12");

		JLabel lblRelations = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("CorpusPanel.lblRelations.text")); //$NON-NLS-1$ //$NON-NLS-2$
		lblRelations.setFont(new Font("Dialog", Font.PLAIN, 12));
		corpusStaticDataPanel.add(lblRelations, "2, 14");

		lblRelationCount = new JLabel("-");
		lblRelationCount.setFont(new Font("Dialog", Font.PLAIN, 12));
		corpusStaticDataPanel.add(lblRelationCount, "4, 14");

		Component verticalStrut_10 = Box.createVerticalStrut(10);
		generalPanel.add(verticalStrut_10);

		JSeparator separator_5 = new JSeparator();
		generalPanel.add(separator_5);

		Component verticalStrut_9 = Box.createVerticalStrut(10);
		generalPanel.add(verticalStrut_9);

		attributesPanel = new AttributesPanel(this.netGUI, (Attributes) null);
		add(attributesPanel, BorderLayout.CENTER);
	}

	/**
	 * 
	 */
	public void update() {
		lblFileNameValue.setText(netGUI.getFile().getName());
		lblFileNameValue.setToolTipText(netGUI.getFile().getAbsolutePath());
		//
		long time = netGUI.getFile().lastModified();
		String timeText;
		if (time == 0) {
			timeText = "-";
		} else {
			timeText = (new SimpleDateFormat("dd/MM/yyyy HH':'mm")).format(new Date(time));
		}
		lblFileDateValue.setText(timeText);

		lblFileSizeValue.setText(netGUI.getFile().length() + " octets");
		lblIndividualCount.setText(String.valueOf(netGUI.getNet().individuals().size()));
		lblFamilyCount.setText(String.valueOf(netGUI.getNet().families().size()));
		lblRelationModelCount.setText(String.valueOf(netGUI.getNet().relationModels().size()));
		lblRelationCount.setText(String.valueOf(netGUI.getNet().relations().size()));

		//
		attributesPanel.setSource(netGUI.getNet().attributes());
	}

}
