package org.tip.puckgui.views;

import java.awt.BorderLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.workers.ControlReporter;
import org.tip.puck.net.workers.ControlReporter.ControlType;
import org.tip.puck.report.Report;
import org.tip.puckgui.NetGUI;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;

/**
 * 
 * @author TIP
 */
public class ControlInputWindow extends JFrame {
	private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.tip.puckgui.messages"); //$NON-NLS-1$

	static private final Logger logger = LoggerFactory.getLogger(ControlInputWindow.class);

	private static final long serialVersionUID = -6113524443785800524L;

	private JFrame thisJFrame;
	private NetGUI netGUI;
	private JPanel contentPane;
	private JCheckBox chckbxSameSexSpouses;
	private JCheckBox chckbxFemaleFathersOrMaleMothers;
	private JCheckBox chckbxCyclicDescentCases;
	private JCheckBox chckbxUnknownSexPersons;
	private JCheckBox chckbxNamelessPersons;
	private JCheckBox chckbxParentChildMarriages;
	private JCheckBox chckbxMultipleParents;
	private JCheckBox chckbxAutomarriages;

	/**
	 * Create the frame.
	 */
	public ControlInputWindow(final NetGUI netGUI) {
		setIconImage(Toolkit.getDefaultToolkit().getImage(FooReporterInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));

		this.thisJFrame = this;
		this.netGUI = netGUI;
		setTitle(BUNDLE.getString("ControlReporterInputWindow.this.title")); //$NON-NLS-1$
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 395, 303);
		setLocationRelativeTo(null);

		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(new BorderLayout(0, 0));

		JPanel inputPanel = new JPanel();
		contentPane.add(inputPanel, BorderLayout.CENTER);
		inputPanel.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("default:grow"), }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, }));

		chckbxSameSexSpouses = new JCheckBox(BUNDLE.getString("ControlReporterInputWindow.chckbxSameSexSpouses.text")); //$NON-NLS-1$
		chckbxSameSexSpouses.setSelected(true);
		inputPanel.add(chckbxSameSexSpouses, "4, 2");

		chckbxFemaleFathersOrMaleMothers = new JCheckBox(BUNDLE.getString("ControlReporterInputWndow.chckbxFemalFathersOrMaleMothers")); //$NON-NLS-1$
		chckbxFemaleFathersOrMaleMothers.setSelected(true);
		inputPanel.add(chckbxFemaleFathersOrMaleMothers, "4, 4");

		chckbxMultipleParents = new JCheckBox(BUNDLE.getString("ControlInputWindow.chckbxMultipleFathersOr.text")); //$NON-NLS-1$
		chckbxMultipleParents.setSelected(true);
		inputPanel.add(chckbxMultipleParents, "4, 6");

		chckbxCyclicDescentCases = new JCheckBox(BUNDLE.getString("ControlReporterInputWindow.chckbxCyclicDescentCases.text")); //$NON-NLS-1$
		chckbxCyclicDescentCases.setSelected(true);
		inputPanel.add(chckbxCyclicDescentCases, "4, 8");

		chckbxUnknownSexPersons = new JCheckBox(BUNDLE.getString("ControlReporterInputWindow.chckbxUnknownSexPersons.text")); //$NON-NLS-1$
		chckbxUnknownSexPersons.setSelected(true);
		inputPanel.add(chckbxUnknownSexPersons, "4, 10");

		chckbxNamelessPersons = new JCheckBox(BUNDLE.getString("ControlReporterInputWindow.chckbxNamelessPersons.text")); //$NON-NLS-1$
		chckbxNamelessPersons.setSelected(true);
		inputPanel.add(chckbxNamelessPersons, "4, 12");

		chckbxParentChildMarriages = new JCheckBox(BUNDLE.getString("ControlReporterInputWindow.chckbxParentChildMarriages.text")); //$NON-NLS-1$
		chckbxParentChildMarriages.setSelected(true);
		inputPanel.add(chckbxParentChildMarriages, "4, 14");

		chckbxAutomarriages = new JCheckBox(BUNDLE.getString("ControlInputWindow.chckbxAutomarriages.text")); //$NON-NLS-1$
		chckbxAutomarriages.setSelected(true);
		inputPanel.add(chckbxAutomarriages, "4, 16");

		JPanel buttonPanel = new JPanel();
		contentPane.add(buttonPanel, BorderLayout.SOUTH);

		JButton btnCancel = new JButton(BUNDLE.getString("ControlReporterInputWindow.btnCancel.text")); //$NON-NLS-1$
		btnCancel.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Close.
				dispose();
			}
		});
		buttonPanel.add(btnCancel);

		JButton btnLaunch = new JButton(BUNDLE.getString("ControlReporterInputWindow.btnLaunch.text")); //$NON-NLS-1$
		getRootPane().setDefaultButton(btnLaunch);
		btnLaunch.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Launch.
				try {
					List<ControlType> controlTypes = new ArrayList<ControlType>();
					if (chckbxCyclicDescentCases.isSelected()) {
						controlTypes.add(ControlType.CYCLIC_DESCENT_CASES);
					}

					if (chckbxFemaleFathersOrMaleMothers.isSelected()) {
						controlTypes.add(ControlType.FEMALE_FATHERS_OR_MALE_MOTHERS);
					}

					if (chckbxMultipleParents.isSelected()) {
						controlTypes.add(ControlType.MULTIPLE_FATHERS_OR_MOTHERS);
					}

					if (chckbxNamelessPersons.isSelected()) {
						controlTypes.add(ControlType.NAMELESS_PERSONS);
					}

					if (chckbxParentChildMarriages.isSelected()) {
						controlTypes.add(ControlType.PARENT_CHILD_MARRIAGES);
					}

					if (chckbxAutomarriages.isSelected()) {
						controlTypes.add(ControlType.AUTO_MARRIAGE);
					}

					if (chckbxSameSexSpouses.isSelected()) {
						controlTypes.add(ControlType.SAME_SEX_SPOUSES);
					}

					if (chckbxUnknownSexPersons.isSelected()) {
						controlTypes.add(ControlType.UNKNOWN_SEX_PERSONS);
					}

					ControlType[] controls = new ControlType[controlTypes.size()];
					controlTypes.toArray(controls);
					Report report = ControlReporter.reportControls(netGUI.getNet(), BUNDLE, controls);

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(thisJFrame, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						netGUI.addReportTab(report);
					}

					dispose();
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(thisJFrame, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		buttonPanel.add(btnLaunch);
	}
}
