package org.tip.puckgui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CensusReporter;
import org.tip.puck.census.workers.CensusUtils;
import org.tip.puck.census.workers.ChainValuator;
import org.tip.puck.census.workers.ChainValuator.ChainProperty;
import org.tip.puck.census.workers.CircuitFinder;
import org.tip.puck.census.workers.CircuitType;
import org.tip.puck.census.workers.RestrictionType;
import org.tip.puck.census.workers.SiblingMode;
import org.tip.puck.census.workers.SymmetryType;
import org.tip.puck.graphs.onemode.OMGraph.GraphMode;
import org.tip.puck.graphs.onemode.ShuffleCriteria;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.report.Report;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;

/**
 * 
 * @author TIP
 */
public class CensusInputWindow extends JFrame {

	static private final Logger logger = LoggerFactory.getLogger(CensusInputWindow.class);

	private static final long serialVersionUID = -6113524443785800524L;

	private JFrame thisJFrame;
	private NetGUI netGUI;
	private JPanel contentPane;
	private final ButtonGroup buttonGroupSymmetry = new ButtonGroup();
	private final ButtonGroup buttonGroupFiliation = new ButtonGroup();
	private final ButtonGroup buttonGroupSib = new ButtonGroup();
	private final ButtonGroup buttonGroupCircuit = new ButtonGroup();
	private JTextField txtfldPattern;
	private JTextField txtfldFilter;
	private JCheckBox chckbxCrossSex;
	private JCheckBox chckbxMarriedOnly;
	private final ButtonGroup buttonGroupRestriction = new ButtonGroup();
	private JRadioButton rdbtnCircuitTypeCircuit;
	private JRadioButton rdbtnCircuitTypeRing;
	private JRadioButton rdbtnCircuitTypeMinor;
	private JRadioButton rdbtnCircuitTypeMinimal;
	private JRadioButton rdbtnFiliationAgnatic;
	private JRadioButton rdbtnFiliationUterine;
	private JRadioButton rdbtnFiliationCognatic;
	private JRadioButton rdbtnFiliationBilateral;
	private JRadioButton rdbtnRestrictionNone;
	private JRadioButton rdbtnRestrictionSome;
	private JRadioButton rdbtnRestrictionAll;
	private JRadioButton rdbtnRestrictionLastMarried;
	private JRadioButton rdbtnRestrictionEgo;
	private JRadioButton rdbtnRestrictionEgoAlter;
	private JRadioButton rdbtnSibNone;
	private JRadioButton rdbtnSibFull;
	private JRadioButton rdbtnSibAll;
	private JRadioButton rdbtnSymmetryInvariable;
	private JRadioButton rdbtnSymmetryInvertible;
	private JRadioButton rdbtnSymmetryPermutable;
	private JLabel lblRelationType;
	private JButton btnRestoreDefaults;
	private JComboBox cmbbxClosingRelationType;
	private JLabel lblChainClassification;
	private JComboBox cmbbxClassification;
	private JComboBox cmbbxClassificatoryLinking;
	private JPanel panel;
	private JLabel lblLabel;
	private JLabel lblReport;
	private JLabel lblDiagram;
	private JComboBox cmbbxLabel1;
	private JCheckBox chckbxReport1;
	private JCheckBox chckbxDiagram1;
	private JComboBox cmbbxLabel2;
	private JComboBox cmbbxLabel3;
	private JComboBox cmbbxLabel4;
	private JComboBox cmbbxLabel5;
	private JCheckBox chckbxReport2;
	private JCheckBox chckbxDiagram2;
	private JCheckBox chckbxReport3;
	private JCheckBox chckbxReport4;
	private JCheckBox chckbxReport5;
	private JCheckBox chckbxDiagram3;
	private JCheckBox chckbxDiagram4;
	private JCheckBox chckbxDiagram5;
	private JComboBox cmbbxLabel6;
	private JComboBox cmbbxLabel7;
	private JComboBox cmbbxLabel8;
	private JComboBox cmbbxLabel9;
	private JComboBox cmbbxLabel10;
	private JCheckBox chckbxReport6;
	private JCheckBox chckbxReport7;
	private JCheckBox chckbxReport8;
	private JCheckBox chckbxReport9;
	private JCheckBox chckbxReport10;
	private JCheckBox chckbxDiagram6;
	private JCheckBox chckbxDiagram7;
	private JCheckBox chckbxDiagram8;
	private JCheckBox chckbxDiagram9;
	private JCheckBox chckbxDiagram10;
	private JLabel label_1;
	private JLabel label_2;
	private JLabel label_3;
	private JSeparator separator;
	private static String[] endogenousLabels;
	private JCheckBox chckbxMarkIndividuals;
	private JPanel panel_2;
	private JCheckBox chckbxCircuitIntersection;
	private JCheckBox chckbxCircuitInduced;
	private JCheckBox chckbxCircuitInducedFrame;
	private JCheckBox chckbxCircuitNetworks;
	private JCheckBox chckbxOpenChainFrequencies;
	private JPanel panel_3;
	private JLabel lblEgoRole;
	private JLabel lblAlterRole;
	private JComboBox cmbbxClosingRelationEgoRole;
	private JComboBox cmbbxClosingRelationAlterRole;
	private JButton btnLaunchWithReshuffling;
	private JCheckBox chckbxCircuitsAsRelations;

	/**
	 * Create the frame.
	 */
	public CensusInputWindow(final NetGUI netGUI) {
		setIconImage(Toolkit.getDefaultToolkit().getImage(FooReporterInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));

		// Compute the endogenous labels list.
		if (endogenousLabels == null) {
			endogenousLabels = ChainValuator.getEndogenousLabels();
		}

		this.thisJFrame = this;
		this.netGUI = netGUI;
		setTitle("Census Reporter Inputs");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 941, 568);
		setLocationRelativeTo(null);

		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(new BorderLayout(0, 0));

		JPanel panelInputs = new JPanel();
		contentPane.add(panelInputs, BorderLayout.CENTER);
		panelInputs.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), FormFactory.RELATED_GAP_COLSPEC, },
				new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
						FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode("default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
						FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
						FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
						FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
						FormFactory.RELATED_GAP_ROWSPEC, }));

		JLabel lblPattern = new JLabel("Pattern:");
		panelInputs.add(lblPattern, "4, 2, right, default");

		txtfldPattern = new JTextField();
		txtfldPattern.setColumns(10);
		panelInputs.add(txtfldPattern, "6, 2, fill, default");

		JLabel lblex = new JLabel("(ex. \"3 2 4\" ou \"HF(F)F\")");
		panelInputs.add(lblex, "6, 4");

		panel = new JPanel();
		panel.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "Details and Diagrams", TitledBorder.LEADING, TitledBorder.TOP, null,
				new Color(51, 51, 51)));
		panelInputs.add(panel, "10, 2, 1, 9, fill, fill");
		panel.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), FormFactory.RELATED_GAP_COLSPEC,
				FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), FormFactory.RELATED_GAP_COLSPEC,
				FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, }));

		lblLabel = new JLabel("Label");
		panel.add(lblLabel, "2, 2, left, default");

		lblReport = new JLabel("Report");
		panel.add(lblReport, "4, 2, left, default");

		lblDiagram = new JLabel("Diagram");
		panel.add(lblDiagram, "6, 2, left, default");

		separator = new JSeparator();
		separator.setOrientation(SwingConstants.VERTICAL);
		panel.add(separator, "8, 2, 1, 11");

		label_1 = new JLabel("Label");
		panel.add(label_1, "10, 2");

		label_2 = new JLabel("Report");
		panel.add(label_2, "12, 2");

		label_3 = new JLabel("Diagram");
		panel.add(label_3, "14, 2");

		cmbbxLabel1 = new JComboBox(endogenousLabels);
		panel.add(cmbbxLabel1, "2, 4, fill, default");

		chckbxReport1 = new JCheckBox("");
		panel.add(chckbxReport1, "4, 4, center, default");

		chckbxDiagram1 = new JCheckBox("");
		panel.add(chckbxDiagram1, "6, 4, center, default");

		cmbbxLabel6 = new JComboBox(endogenousLabels);
		panel.add(cmbbxLabel6, "10, 4, fill, default");

		chckbxReport6 = new JCheckBox("");
		panel.add(chckbxReport6, "12, 4, center, default");

		chckbxDiagram6 = new JCheckBox("");
		panel.add(chckbxDiagram6, "14, 4, center, default");

		cmbbxLabel2 = new JComboBox(endogenousLabels);
		panel.add(cmbbxLabel2, "2, 6, fill, default");

		chckbxReport2 = new JCheckBox("");
		panel.add(chckbxReport2, "4, 6, center, default");

		chckbxDiagram2 = new JCheckBox("");
		panel.add(chckbxDiagram2, "6, 6, center, default");

		cmbbxLabel7 = new JComboBox(endogenousLabels);
		panel.add(cmbbxLabel7, "10, 6, fill, default");

		chckbxReport7 = new JCheckBox("");
		panel.add(chckbxReport7, "12, 6, center, default");

		chckbxDiagram7 = new JCheckBox("");
		panel.add(chckbxDiagram7, "14, 6, center, default");

		cmbbxLabel3 = new JComboBox(endogenousLabels);
		panel.add(cmbbxLabel3, "2, 8, fill, default");

		chckbxReport3 = new JCheckBox("");
		panel.add(chckbxReport3, "4, 8, center, default");

		chckbxDiagram3 = new JCheckBox("");
		panel.add(chckbxDiagram3, "6, 8, center, default");

		cmbbxLabel8 = new JComboBox(endogenousLabels);
		panel.add(cmbbxLabel8, "10, 8, fill, default");

		chckbxReport8 = new JCheckBox("");
		panel.add(chckbxReport8, "12, 8, center, default");

		chckbxDiagram8 = new JCheckBox("");
		panel.add(chckbxDiagram8, "14, 8, center, default");

		cmbbxLabel4 = new JComboBox(endogenousLabels);
		panel.add(cmbbxLabel4, "2, 10, fill, default");

		chckbxReport4 = new JCheckBox("");
		panel.add(chckbxReport4, "4, 10, center, default");

		chckbxDiagram4 = new JCheckBox("");
		panel.add(chckbxDiagram4, "6, 10, center, default");

		cmbbxLabel9 = new JComboBox(endogenousLabels);
		panel.add(cmbbxLabel9, "10, 10, fill, default");

		chckbxReport9 = new JCheckBox("");
		panel.add(chckbxReport9, "12, 10, center, default");

		chckbxDiagram9 = new JCheckBox("");
		panel.add(chckbxDiagram9, "14, 10, center, default");

		cmbbxLabel5 = new JComboBox(endogenousLabels);
		panel.add(cmbbxLabel5, "2, 12, fill, default");

		chckbxReport5 = new JCheckBox("");
		panel.add(chckbxReport5, "4, 12, center, default");

		chckbxDiagram5 = new JCheckBox("");
		panel.add(chckbxDiagram5, "6, 12, center, default");

		cmbbxLabel10 = new JComboBox(endogenousLabels);
		panel.add(cmbbxLabel10, "10, 12, fill, default");

		chckbxReport10 = new JCheckBox("");
		panel.add(chckbxReport10, "12, 12, center, default");

		chckbxDiagram10 = new JCheckBox("");
		panel.add(chckbxDiagram10, "14, 12, center, default");

		panel_3 = new JPanel();
		panel_3.setBorder(new TitledBorder(null, "Closing Relation", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelInputs.add(panel_3, "4, 6, 3, 1, right, fill");
		panel_3.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("default:grow"), }, new RowSpec[] { FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, }));

		lblRelationType = new JLabel("Relation Type:");
		panel_3.add(lblRelationType, "2, 1");

		cmbbxClosingRelationType = new JComboBox();
		cmbbxClosingRelationType.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Select Closing Relation Type.
				String selectedType = (String) cmbbxClosingRelationType.getSelectedItem();
				if ((StringUtils.equals(selectedType, "SPOUSE")) || (StringUtils.equals(selectedType, "PARTN")) || (StringUtils.equals(selectedType, "OPEN"))
						|| (StringUtils.equals(selectedType, "LINEAR")) || (StringUtils.equals(selectedType, "COSPOUSE")) || (selectedType.startsWith("@"))) {
					//
					cmbbxClosingRelationEgoRole.setEnabled(false);
					cmbbxClosingRelationAlterRole.setEnabled(false);
				} else {
					//
					cmbbxClosingRelationEgoRole.setEnabled(true);
					cmbbxClosingRelationAlterRole.setEnabled(true);

					//
					List<String> roleNames = new ArrayList<String>();
					roleNames.add("");
					roleNames.addAll(netGUI.getNet().relationModels().getByName(selectedType).roles().nameList());
					Object[] roleNamesData = roleNames.toArray();
					cmbbxClosingRelationEgoRole.setModel(new DefaultComboBoxModel(roleNamesData));
					cmbbxClosingRelationAlterRole.setModel(new DefaultComboBoxModel(roleNamesData));
				}
			}
		});
		panel_3.add(cmbbxClosingRelationType, "4, 1");
		cmbbxClosingRelationType.setEditable(true);
		cmbbxClosingRelationType.setModel(new DefaultComboBoxModel(new String[] { "SPOUSE", "PARTN", "OPEN", "LINEAR", "COSPOUSE" }));

		lblEgoRole = new JLabel("Ego Role:");
		panel_3.add(lblEgoRole, "2, 3, right, default");

		cmbbxClosingRelationEgoRole = new JComboBox();
		panel_3.add(cmbbxClosingRelationEgoRole, "4, 3, fill, default");

		lblAlterRole = new JLabel("Alter Role:");
		panel_3.add(lblAlterRole, "2, 5, right, default");

		cmbbxClosingRelationAlterRole = new JComboBox();
		panel_3.add(cmbbxClosingRelationAlterRole, "4, 5, fill, default");

		JLabel lblFilter = new JLabel("Filter:");
		panelInputs.add(lblFilter, "4, 8, right, default");

		txtfldFilter = new JTextField();
		txtfldFilter.setColumns(10);
		panelInputs.add(txtfldFilter, "6, 8, fill, default");

		JLabel lblClassificatoryLinking = new JLabel("Classificatory linking:");
		panelInputs.add(lblClassificatoryLinking, "4, 10, right, default");

		cmbbxClassificatoryLinking = new JComboBox();
		cmbbxClassificatoryLinking.setModel(new DefaultComboBoxModel(new String[] { "" }));
		panelInputs.add(cmbbxClassificatoryLinking, "6, 10, fill, default");

		lblChainClassification = new JLabel("Chain classification:");
		panelInputs.add(lblChainClassification, "4, 12, right, default");

		cmbbxClassification = new JComboBox();
		cmbbxClassification.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				if ((StringUtils.equals((String) cmbbxClassification.getSelectedItem(), "SIMPLE"))
						|| (StringUtils.equals((String) cmbbxClassification.getSelectedItem(), "CLASSIC"))
						|| (StringUtils.equals((String) cmbbxClassification.getSelectedItem(), "CLASSIC_GENDERED"))
						|| (StringUtils.equals((String) cmbbxClassification.getSelectedItem(), "POSITIONAL"))) {
					cmbbxLabel1.setEnabled(true);
					cmbbxLabel2.setEnabled(true);
					cmbbxLabel3.setEnabled(true);
					cmbbxLabel4.setEnabled(true);
					cmbbxLabel5.setEnabled(true);
					cmbbxLabel6.setEnabled(true);
					cmbbxLabel7.setEnabled(true);
					cmbbxLabel8.setEnabled(true);
					cmbbxLabel9.setEnabled(true);
					cmbbxLabel10.setEnabled(true);

					chckbxReport1.setEnabled(true);
					chckbxReport2.setEnabled(true);
					chckbxReport3.setEnabled(true);
					chckbxReport4.setEnabled(true);
					chckbxReport5.setEnabled(true);
					chckbxReport6.setEnabled(true);
					chckbxReport7.setEnabled(true);
					chckbxReport8.setEnabled(true);
					chckbxReport9.setEnabled(true);
					chckbxReport10.setEnabled(true);

					chckbxDiagram1.setEnabled(true);
					chckbxDiagram2.setEnabled(true);
					chckbxDiagram3.setEnabled(true);
					chckbxDiagram4.setEnabled(true);
					chckbxDiagram5.setEnabled(true);
					chckbxDiagram6.setEnabled(true);
					chckbxDiagram7.setEnabled(true);
					chckbxDiagram8.setEnabled(true);
					chckbxDiagram9.setEnabled(true);
					chckbxDiagram10.setEnabled(true);
				} else {
					cmbbxLabel1.setEnabled(false);
					cmbbxLabel2.setEnabled(false);
					cmbbxLabel3.setEnabled(false);
					cmbbxLabel4.setEnabled(false);
					cmbbxLabel5.setEnabled(false);
					cmbbxLabel6.setEnabled(false);
					cmbbxLabel7.setEnabled(false);
					cmbbxLabel8.setEnabled(false);
					cmbbxLabel9.setEnabled(false);
					cmbbxLabel10.setEnabled(false);

					chckbxReport1.setEnabled(false);
					chckbxReport2.setEnabled(false);
					chckbxReport3.setEnabled(false);
					chckbxReport4.setEnabled(false);
					chckbxReport5.setEnabled(false);
					chckbxReport6.setEnabled(false);
					chckbxReport7.setEnabled(false);
					chckbxReport8.setEnabled(false);
					chckbxReport9.setEnabled(false);
					chckbxReport10.setEnabled(false);

					chckbxDiagram1.setEnabled(false);
					chckbxDiagram2.setEnabled(false);
					chckbxDiagram3.setEnabled(false);
					chckbxDiagram4.setEnabled(false);
					chckbxDiagram5.setEnabled(false);
					chckbxDiagram6.setEnabled(false);
					chckbxDiagram7.setEnabled(false);
					chckbxDiagram8.setEnabled(false);
					chckbxDiagram9.setEnabled(false);
					chckbxDiagram10.setEnabled(false);
				}
			}
		});
		cmbbxClassification.setModel(new DefaultComboBoxModel(ChainProperty.values()));
		panelInputs.add(cmbbxClassification, "6, 12, fill, default");

		chckbxMarriedOnly = new JCheckBox("Couples only");
		panelInputs.add(chckbxMarriedOnly, "4, 14");

		chckbxCrossSex = new JCheckBox("Cross-sex chains only");
		chckbxCrossSex.setSelected(true);
		panelInputs.add(chckbxCrossSex, "6, 14");

		chckbxMarkIndividuals = new JCheckBox("Mark Individuals");
		panelInputs.add(chckbxMarkIndividuals, "4, 16, default, top");

		chckbxOpenChainFrequencies = new JCheckBox("Open Chains Frequencies");
		panelInputs.add(chckbxOpenChainFrequencies, "6, 16");

		panel_2 = new JPanel();
		panel_2.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "Circuit to include in Pajek format", TitledBorder.LEADING,
				TitledBorder.TOP, null, new Color(51, 51, 51)));
		panelInputs.add(panel_2, "10, 12, 1, 5, fill, fill");
		panel_2.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				FormFactory.DEFAULT_COLSPEC, }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, }));

		chckbxCircuitInduced = new JCheckBox("Circuit induced network");
		panel_2.add(chckbxCircuitInduced, "4, 2");

		chckbxCircuitIntersection = new JCheckBox("Circuit intersection network");
		panel_2.add(chckbxCircuitIntersection, "2, 4");

		chckbxCircuitInducedFrame = new JCheckBox("Circuit induced frame network");
		panel_2.add(chckbxCircuitInducedFrame, "4, 4");

		chckbxCircuitNetworks = new JCheckBox("Circuit as networks");
		panel_2.add(chckbxCircuitNetworks, "2, 2");

		chckbxCircuitsAsRelations = new JCheckBox("Circuits as Relations");
		panelInputs.add(chckbxCircuitsAsRelations, "4, 18");

		JPanel panel_1 = new JPanel();
		panelInputs.add(panel_1, "4, 20, 7, 1, fill, fill");
		panel_1.setLayout(new GridLayout(0, 5, 0, 0));

		JPanel panelCircuitType = new JPanel();
		panel_1.add(panelCircuitType);
		panelCircuitType.setBorder(new TitledBorder(null, "Circuit Type", TitledBorder.LEADING, TitledBorder.TOP, null, new Color(51, 51, 51)));
		panelCircuitType.setLayout(new BoxLayout(panelCircuitType, BoxLayout.Y_AXIS));

		rdbtnCircuitTypeCircuit = new JRadioButton("Circuit");
		panelCircuitType.add(rdbtnCircuitTypeCircuit);
		rdbtnCircuitTypeCircuit.setSelected(true);
		buttonGroupCircuit.add(rdbtnCircuitTypeCircuit);

		rdbtnCircuitTypeRing = new JRadioButton("Ring");
		panelCircuitType.add(rdbtnCircuitTypeRing);
		buttonGroupCircuit.add(rdbtnCircuitTypeRing);

		rdbtnCircuitTypeMinor = new JRadioButton("Minor");
		panelCircuitType.add(rdbtnCircuitTypeMinor);
		buttonGroupCircuit.add(rdbtnCircuitTypeMinor);

		rdbtnCircuitTypeMinimal = new JRadioButton("Minimal");
		panelCircuitType.add(rdbtnCircuitTypeMinimal);
		buttonGroupCircuit.add(rdbtnCircuitTypeMinimal);

		JPanel panelFiliationType = new JPanel();
		panel_1.add(panelFiliationType);
		panelFiliationType.setBorder(new TitledBorder(null, "Filiation Type", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelFiliationType.setLayout(new BoxLayout(panelFiliationType, BoxLayout.Y_AXIS));

		rdbtnFiliationAgnatic = new JRadioButton("Agnatic");
		buttonGroupFiliation.add(rdbtnFiliationAgnatic);
		panelFiliationType.add(rdbtnFiliationAgnatic);

		rdbtnFiliationUterine = new JRadioButton("Uterine");
		buttonGroupFiliation.add(rdbtnFiliationUterine);
		panelFiliationType.add(rdbtnFiliationUterine);

		rdbtnFiliationCognatic = new JRadioButton("Cognatic");
		buttonGroupFiliation.add(rdbtnFiliationCognatic);
		rdbtnFiliationCognatic.setSelected(true);
		panelFiliationType.add(rdbtnFiliationCognatic);

		rdbtnFiliationBilateral = new JRadioButton("Bilateral");
		buttonGroupFiliation.add(rdbtnFiliationBilateral);
		panelFiliationType.add(rdbtnFiliationBilateral);

		JPanel panelRestrictionType = new JPanel();
		panel_1.add(panelRestrictionType);
		panelRestrictionType.setBorder(new TitledBorder(null, "Restriction Type", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelRestrictionType.setLayout(new BoxLayout(panelRestrictionType, BoxLayout.Y_AXIS));

		rdbtnRestrictionNone = new JRadioButton("None");
		buttonGroupRestriction.add(rdbtnRestrictionNone);
		rdbtnRestrictionNone.setSelected(true);
		panelRestrictionType.add(rdbtnRestrictionNone);

		rdbtnRestrictionSome = new JRadioButton("Some");
		buttonGroupRestriction.add(rdbtnRestrictionSome);
		panelRestrictionType.add(rdbtnRestrictionSome);

		rdbtnRestrictionAll = new JRadioButton("All");
		buttonGroupRestriction.add(rdbtnRestrictionAll);
		panelRestrictionType.add(rdbtnRestrictionAll);

		rdbtnRestrictionLastMarried = new JRadioButton("Last Married");
		buttonGroupRestriction.add(rdbtnRestrictionLastMarried);
		panelRestrictionType.add(rdbtnRestrictionLastMarried);

		rdbtnRestrictionEgo = new JRadioButton("Ego");
		buttonGroupRestriction.add(rdbtnRestrictionEgo);
		panelRestrictionType.add(rdbtnRestrictionEgo);

		rdbtnRestrictionEgoAlter = new JRadioButton("Ego Alter");
		buttonGroupRestriction.add(rdbtnRestrictionEgoAlter);
		panelRestrictionType.add(rdbtnRestrictionEgoAlter);

		JPanel panelSiblingMode = new JPanel();
		panel_1.add(panelSiblingMode);
		panelSiblingMode.setBorder(new TitledBorder(new EtchedBorder(EtchedBorder.LOWERED, null, null), "Sibling Types", TitledBorder.LEADING,
				TitledBorder.TOP, null, new Color(0, 0, 0)));
		panelSiblingMode.setLayout(new BoxLayout(panelSiblingMode, BoxLayout.Y_AXIS));

		rdbtnSibNone = new JRadioButton("2 (None)");
		rdbtnSibNone.setToolTipText("No siblings assimilated.");
		panelSiblingMode.add(rdbtnSibNone);
		buttonGroupSib.add(rdbtnSibNone);

		rdbtnSibFull = new JRadioButton("3 (Full)");
		rdbtnSibFull.setToolTipText("Full siblings assimilated.");
		panelSiblingMode.add(rdbtnSibFull);
		rdbtnSibFull.setSelected(true);
		buttonGroupSib.add(rdbtnSibFull);

		rdbtnSibAll = new JRadioButton("1 (All)");
		rdbtnSibAll.setToolTipText("All siblings assimilated.");
		panelSiblingMode.add(rdbtnSibAll);
		buttonGroupSib.add(rdbtnSibAll);

		JPanel panelSymmetryType = new JPanel();
		panel_1.add(panelSymmetryType);
		panelSymmetryType.setBorder(new TitledBorder(null, "Symmetry Type", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelSymmetryType.setLayout(new BoxLayout(panelSymmetryType, BoxLayout.Y_AXIS));

		rdbtnSymmetryInvariable = new JRadioButton("Invariable");
		rdbtnSymmetryInvariable.setToolTipText("Not permutable.");
		panelSymmetryType.add(rdbtnSymmetryInvariable);
		buttonGroupSymmetry.add(rdbtnSymmetryInvariable);

		rdbtnSymmetryInvertible = new JRadioButton("Invertible");
		rdbtnSymmetryInvertible.setToolTipText("Ego-alter reflection possible.");
		panelSymmetryType.add(rdbtnSymmetryInvertible);
		buttonGroupSymmetry.add(rdbtnSymmetryInvertible);

		rdbtnSymmetryPermutable = new JRadioButton("Fully Permutable");
		panelSymmetryType.add(rdbtnSymmetryPermutable);
		rdbtnSymmetryPermutable.setSelected(true);
		buttonGroupSymmetry.add(rdbtnSymmetryPermutable);

		JPanel buttonPanel = new JPanel();
		contentPane.add(buttonPanel, BorderLayout.SOUTH);

		JButton btnCancel = new JButton("Cancel");
		btnCancel.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Close.
				dispose();
			}
		});

		btnRestoreDefaults = new JButton("Restore Defaults");
		btnRestoreDefaults.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Restore Defaults.
				CensusCriteria criteria = new CensusCriteria();
				setCriteria(criteria);
			}
		});
		buttonPanel.add(btnRestoreDefaults);
		buttonPanel.add(btnCancel);

		JButton btnLaunch = new JButton("Launch");
		getRootPane().setDefaultButton(btnLaunch);
		btnLaunch.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Launch.
				try {
					//
					CensusCriteria criteria = getCriteria();

					//
					PuckGUI.instance().getPreferences().setCensusCriteria(criteria);

					//
					CircuitFinder finder = new CircuitFinder(netGUI.getSegmentation(), criteria);
					Report report = CensusReporter.reportFindCircuit(finder, netGUI.getSegmentation(), criteria, netGUI.getFile());

					if (criteria.isCircuitInducedNetwork()) {
						Net newNet = CensusUtils.createCircuitInducedNet(finder);
						NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), newNet);
						newNetGui.setChanged(true, "-circuits-" + finder.getPattern());
					}

					netGUI.addReportTab(report);

					if (criteria.isCircuitsAsRelations()) {

						//
						RelationModel model = netGUI.getNet().createRelationModel("Circuits_" + finder.getPattern());
						NetUtils.createRelationsFromCircuits(netGUI.getNet(), finder, model);

						//
						netGUI.setChanged(true);

						//
						netGUI.addRelationTab(model);

						// Refresh.
						netGUI.updateAll();

					}

					dispose();

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(thisJFrame, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		buttonPanel.add(btnLaunch);

		btnLaunchWithReshuffling = new JButton("Launch with Reshuffling");
		btnLaunchWithReshuffling.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Launch.
				try {
					//
					CensusCriteria criteria = getCriteria();
					ShuffleCriteria shuffleCriteria = new ShuffleCriteria();

					shuffleCriteria.setSwitchesPerIteration(2);
					shuffleCriteria.setMaxGenerationalDistance(2);
					shuffleCriteria.setMinShufflePercentage(50);
					shuffleCriteria.setMinStableIterations(100);
					shuffleCriteria.setMode(GraphMode.OREGRAPH);
					int runs = 10;

					//
					PuckGUI.instance().getPreferences().setCensusCriteria(criteria);

					Report report2 = CensusReporter.reportFindCircuitsReshuffled(netGUI.getNet(), shuffleCriteria, runs, criteria);
					netGUI.addReportTab(report2);

					dispose();

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(thisJFrame, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		buttonPanel.add(btnLaunchWithReshuffling);

		// /////////////////
		setCriteria(PuckGUI.instance().getPreferences().getCensusCriteria());
	}

	/**
	 * 
	 * @return
	 */
	public CensusCriteria getCriteria() {
		CensusCriteria result;

		//
		result = new CensusCriteria();

		//
		result.setPattern(txtfldPattern.getText());
		result.setFilter(txtfldFilter.getText());
		result.setClassificatoryLinking((String) cmbbxClassificatoryLinking.getSelectedItem());
		result.setClosingRelation((String) cmbbxClosingRelationType.getSelectedItem());
		result.setClosingRelationEgoRole((String) cmbbxClosingRelationEgoRole.getSelectedItem());
		result.setClosingRelationAlterRole((String) cmbbxClosingRelationAlterRole.getSelectedItem());
		result.setChainClassification((String) cmbbxClassification.getSelectedItem());
		result.setCrossSexChainsOnly(chckbxCrossSex.isSelected());
		result.setMarriedOnly(chckbxMarriedOnly.isSelected());
		result.setMarkIndividuals(chckbxMarkIndividuals.isSelected());
		result.setOpenChainFrequencies(chckbxOpenChainFrequencies.isSelected());
		result.setCircuitsAsRelations(chckbxCircuitsAsRelations.isSelected());

		//
		CircuitType circuitType;
		if (rdbtnCircuitTypeCircuit.isSelected()) {
			circuitType = CircuitType.CIRCUIT;
		} else if (rdbtnCircuitTypeMinimal.isSelected()) {
			circuitType = CircuitType.MINIMAL;
		} else if (rdbtnCircuitTypeMinor.isSelected()) {
			circuitType = CircuitType.MINOR;
		} else if (rdbtnCircuitTypeRing.isSelected()) {
			circuitType = CircuitType.RING;
		} else {
			circuitType = null;
		}
		result.setCircuitType(circuitType);

		//
		FiliationType filiationType;
		if (rdbtnFiliationAgnatic.isSelected()) {
			filiationType = FiliationType.AGNATIC;
		} else if (rdbtnFiliationBilateral.isSelected()) {
			filiationType = FiliationType.BILINEAR;
		} else if (rdbtnFiliationCognatic.isSelected()) {
			filiationType = FiliationType.COGNATIC;
		} else if (rdbtnFiliationUterine.isSelected()) {
			filiationType = FiliationType.UTERINE;
		} else {
			filiationType = null;
		}
		result.setFiliationType(filiationType);

		//
		RestrictionType restrictionType;
		if (rdbtnRestrictionAll.isSelected()) {
			restrictionType = RestrictionType.ALL;
		} else if (rdbtnRestrictionEgo.isSelected()) {
			restrictionType = RestrictionType.EGO;
		} else if (rdbtnRestrictionEgoAlter.isSelected()) {
			restrictionType = RestrictionType.EGOALTER;
		} else if (rdbtnRestrictionLastMarried.isSelected()) {
			restrictionType = RestrictionType.LASTMARRIED;
		} else if (rdbtnRestrictionNone.isSelected()) {
			restrictionType = RestrictionType.NONE;
		} else if (rdbtnRestrictionSome.isSelected()) {
			restrictionType = RestrictionType.SOME;
		} else {
			restrictionType = null;
		}
		result.setRestrictionType(restrictionType);

		//
		SiblingMode siblingMode;
		if (rdbtnSibAll.isSelected()) {
			siblingMode = SiblingMode.ALL;
		} else if (rdbtnSibFull.isSelected()) {
			siblingMode = SiblingMode.FULL;
		} else if (rdbtnSibNone.isSelected()) {
			siblingMode = SiblingMode.NONE;
		} else {
			siblingMode = null;
		}
		result.setSiblingMode(siblingMode);

		//
		SymmetryType symmetryType;
		if (rdbtnSymmetryInvariable.isSelected()) {
			symmetryType = SymmetryType.INVARIABLE;
		} else if (rdbtnSymmetryInvertible.isSelected()) {
			symmetryType = SymmetryType.INVERTIBLE;
		} else if (rdbtnSymmetryPermutable.isSelected()) {
			symmetryType = SymmetryType.PERMUTABLE;
		} else {
			symmetryType = null;
		}
		result.setSymmetryType(symmetryType);

		//
		result.getCensusDetails().clear();
		result.getCensusDetails().add((String) cmbbxLabel1.getSelectedItem(), chckbxReport1.isSelected(), chckbxDiagram1.isSelected());
		result.getCensusDetails().add((String) cmbbxLabel2.getSelectedItem(), chckbxReport2.isSelected(), chckbxDiagram2.isSelected());
		result.getCensusDetails().add((String) cmbbxLabel3.getSelectedItem(), chckbxReport3.isSelected(), chckbxDiagram3.isSelected());
		result.getCensusDetails().add((String) cmbbxLabel4.getSelectedItem(), chckbxReport4.isSelected(), chckbxDiagram4.isSelected());
		result.getCensusDetails().add((String) cmbbxLabel5.getSelectedItem(), chckbxReport5.isSelected(), chckbxDiagram5.isSelected());
		result.getCensusDetails().add((String) cmbbxLabel6.getSelectedItem(), chckbxReport6.isSelected(), chckbxDiagram6.isSelected());
		result.getCensusDetails().add((String) cmbbxLabel7.getSelectedItem(), chckbxReport7.isSelected(), chckbxDiagram7.isSelected());
		result.getCensusDetails().add((String) cmbbxLabel8.getSelectedItem(), chckbxReport8.isSelected(), chckbxDiagram8.isSelected());
		result.getCensusDetails().add((String) cmbbxLabel9.getSelectedItem(), chckbxReport9.isSelected(), chckbxDiagram9.isSelected());
		result.getCensusDetails().add((String) cmbbxLabel10.getSelectedItem(), chckbxReport10.isSelected(), chckbxDiagram10.isSelected());

		//
		result.setCircuitInducedNetwork(chckbxCircuitInduced.isSelected());
		result.setCircuitInduceFrameNetwork(chckbxCircuitInducedFrame.isSelected());
		result.setCircuitIntersectionNetwork(chckbxCircuitIntersection.isSelected());
		result.setCircuitNetworks(chckbxCircuitNetworks.isSelected());

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public void setCriteria(final CensusCriteria source) {
		//
		if (source != null) {
			//
			txtfldPattern.setText(source.getPattern());
			txtfldFilter.setText(source.getFilter());

			//
			List<String> classificatoryLinkingLabels = new ArrayList<String>(20);
			classificatoryLinkingLabels.add("");
			classificatoryLinkingLabels.addAll(IndividualValuator.getExogenousAttributeLabels(netGUI.getCurrentIndividuals()));

			cmbbxClassificatoryLinking.setModel(new DefaultComboBoxModel(classificatoryLinkingLabels.toArray()));

			if (StringUtils.isBlank(source.getClassificatoryLinking())) {
				cmbbxClassificatoryLinking.setSelectedIndex(0);
			} else {
				int classificatoryLinkingLabelIndex = classificatoryLinkingLabels.indexOf(source.getClassificatoryLinking());
				if (classificatoryLinkingLabelIndex == -1) {
					cmbbxClassificatoryLinking.setSelectedIndex(0);
				} else {
					cmbbxClassificatoryLinking.setSelectedIndex(classificatoryLinkingLabelIndex);
				}
			}

			//
			List<String> closingRelationLabels = new ArrayList<String>();
			closingRelationLabels.add("SPOUSE");
			closingRelationLabels.add("PARTN");
			closingRelationLabels.add("OPEN");
			closingRelationLabels.add("LINEAR");
			closingRelationLabels.add("COSPOUSE");
			closingRelationLabels.addAll(netGUI.getNet().relationModels().sortedNameList());
			for (String label : IndividualValuator.getExogenousAttributeLabels(netGUI.getCurrentIndividuals())) {
				closingRelationLabels.add("@" + label);
			}
			cmbbxClosingRelationType.setModel(new DefaultComboBoxModel(closingRelationLabels.toArray()));
			if (StringUtils.isBlank(source.getClosingRelation())) {
				cmbbxClosingRelationType.setSelectedIndex(0);
			} else if (closingRelationLabels.contains(source.getClosingRelation())) {
				cmbbxClosingRelationType.setSelectedIndex(closingRelationLabels.indexOf(source.getClosingRelation()));
			} else {
				cmbbxClosingRelationType.setSelectedIndex(0);
			}

			//
			cmbbxClassification.setModel(new DefaultComboBoxModel(endogenousLabels));

			int chainClassificationLabelIndex;
			if (StringUtils.isBlank(source.getChainClassification())) {
				chainClassificationLabelIndex = ArrayUtils.indexOf(endogenousLabels, "SIMPLE");
			} else {
				chainClassificationLabelIndex = ArrayUtils.indexOf(endogenousLabels, source.getChainClassification());
				if (chainClassificationLabelIndex == -1) {
					chainClassificationLabelIndex = ArrayUtils.indexOf(endogenousLabels, "SIMPLE");
				}
			}
			cmbbxClassification.setSelectedIndex(chainClassificationLabelIndex);

			//
			chckbxCrossSex.setSelected(source.isCrossSexChainsOnly());
			chckbxMarriedOnly.setSelected(source.isCouplesOnly());
			chckbxMarkIndividuals.setSelected(source.isMarkIndividuals());
			chckbxOpenChainFrequencies.setSelected(source.isOpenChainFrequencies());
			chckbxCircuitsAsRelations.setSelected(source.isCircuitsAsRelations());

			//
			rdbtnCircuitTypeCircuit.setSelected(false);
			rdbtnCircuitTypeMinimal.setSelected(false);
			rdbtnCircuitTypeMinor.setSelected(false);
			rdbtnCircuitTypeRing.setSelected(false);
			switch (source.getCircuitType()) {
				case CIRCUIT:
					rdbtnCircuitTypeCircuit.setSelected(true);
				break;
				case MINIMAL:
					rdbtnCircuitTypeMinimal.setSelected(true);
				break;
				case MINOR:
					rdbtnCircuitTypeMinor.setSelected(true);
				break;
				case RING:
					rdbtnCircuitTypeRing.setSelected(true);
				break;
			}

			//
			rdbtnFiliationAgnatic.setSelected(false);
			rdbtnFiliationBilateral.setSelected(false);
			rdbtnFiliationCognatic.setSelected(false);
			rdbtnFiliationUterine.setSelected(false);
			switch (source.getFiliationType()) {
				case AGNATIC:
					rdbtnFiliationAgnatic.setSelected(true);
				break;
				case BILINEAR:
					rdbtnFiliationBilateral.setSelected(true);
				break;
				case COGNATIC:
					rdbtnFiliationCognatic.setSelected(true);
				break;
				case UTERINE:
					rdbtnFiliationUterine.setSelected(true);
				break;
			}

			//
			rdbtnRestrictionAll.setSelected(false);
			rdbtnRestrictionEgo.setSelected(false);
			rdbtnRestrictionEgoAlter.setSelected(false);
			rdbtnRestrictionLastMarried.setSelected(false);
			rdbtnRestrictionNone.setSelected(false);
			rdbtnRestrictionSome.setSelected(false);
			switch (source.getRestrictionType()) {
				case ALL:
					rdbtnRestrictionAll.setSelected(true);
				break;
				case EGO:
					rdbtnRestrictionEgo.setSelected(true);
				break;
				case EGOALTER:
					rdbtnRestrictionEgoAlter.setSelected(true);
				break;
				case LASTMARRIED:
					rdbtnRestrictionLastMarried.setSelected(true);
				break;
				case NONE:
					rdbtnRestrictionNone.setSelected(true);
				break;
				case SOME:
					rdbtnRestrictionSome.setSelected(true);
				break;
			}

			//
			rdbtnSibAll.setSelected(false);
			rdbtnSibFull.setSelected(false);
			rdbtnSibNone.setSelected(false);
			switch (source.getSiblingMode()) {
				case ALL:
					rdbtnSibAll.setSelected(true);
				break;
				case FULL:
					rdbtnSibFull.setSelected(true);
				break;
				case NONE:
					rdbtnSibNone.setSelected(true);
				break;
			}

			//
			rdbtnSymmetryInvariable.setSelected(false);
			rdbtnSymmetryInvertible.setSelected(false);
			rdbtnSymmetryPermutable.setSelected(false);
			switch (source.getSymmetryType()) {
				case INVARIABLE:
					rdbtnSymmetryInvariable.setSelected(true);
				break;
				case INVERTIBLE:
					rdbtnSymmetryInvertible.setSelected(true);
				break;
				case PERMUTABLE:
					rdbtnSymmetryPermutable.setSelected(true);
				break;
			}

			//
			cmbbxLabel1.setSelectedIndex(ArrayUtils.indexOf(endogenousLabels, source.getCensusDetails().get(0).getLabel()));
			cmbbxLabel2.setSelectedIndex(ArrayUtils.indexOf(endogenousLabels, source.getCensusDetails().get(1).getLabel()));
			cmbbxLabel3.setSelectedIndex(ArrayUtils.indexOf(endogenousLabels, source.getCensusDetails().get(2).getLabel()));
			cmbbxLabel4.setSelectedIndex(ArrayUtils.indexOf(endogenousLabels, source.getCensusDetails().get(3).getLabel()));
			cmbbxLabel5.setSelectedIndex(ArrayUtils.indexOf(endogenousLabels, source.getCensusDetails().get(4).getLabel()));
			cmbbxLabel6.setSelectedIndex(ArrayUtils.indexOf(endogenousLabels, source.getCensusDetails().get(5).getLabel()));
			cmbbxLabel7.setSelectedIndex(ArrayUtils.indexOf(endogenousLabels, source.getCensusDetails().get(6).getLabel()));
			cmbbxLabel8.setSelectedIndex(ArrayUtils.indexOf(endogenousLabels, source.getCensusDetails().get(7).getLabel()));
			cmbbxLabel9.setSelectedIndex(ArrayUtils.indexOf(endogenousLabels, source.getCensusDetails().get(8).getLabel()));
			cmbbxLabel10.setSelectedIndex(ArrayUtils.indexOf(endogenousLabels, source.getCensusDetails().get(9).getLabel()));

			chckbxReport1.setSelected(source.getCensusDetails().get(0).isReport());
			chckbxReport2.setSelected(source.getCensusDetails().get(1).isReport());
			chckbxReport3.setSelected(source.getCensusDetails().get(2).isReport());
			chckbxReport4.setSelected(source.getCensusDetails().get(3).isReport());
			chckbxReport5.setSelected(source.getCensusDetails().get(4).isReport());
			chckbxReport6.setSelected(source.getCensusDetails().get(5).isReport());
			chckbxReport7.setSelected(source.getCensusDetails().get(6).isReport());
			chckbxReport8.setSelected(source.getCensusDetails().get(7).isReport());
			chckbxReport9.setSelected(source.getCensusDetails().get(8).isReport());
			chckbxReport10.setSelected(source.getCensusDetails().get(9).isReport());

			chckbxDiagram1.setSelected(source.getCensusDetails().get(0).isDiagram());
			chckbxDiagram2.setSelected(source.getCensusDetails().get(1).isDiagram());
			chckbxDiagram3.setSelected(source.getCensusDetails().get(2).isDiagram());
			chckbxDiagram4.setSelected(source.getCensusDetails().get(3).isDiagram());
			chckbxDiagram5.setSelected(source.getCensusDetails().get(4).isDiagram());
			chckbxDiagram6.setSelected(source.getCensusDetails().get(5).isDiagram());
			chckbxDiagram7.setSelected(source.getCensusDetails().get(6).isDiagram());
			chckbxDiagram8.setSelected(source.getCensusDetails().get(7).isDiagram());
			chckbxDiagram9.setSelected(source.getCensusDetails().get(8).isDiagram());
			chckbxDiagram10.setSelected(source.getCensusDetails().get(9).isDiagram());

			//
			chckbxCircuitInduced.setSelected(source.isCircuitInducedNetwork());
			chckbxCircuitInducedFrame.setSelected(source.isCircuitInducedFrameNetwork());
			chckbxCircuitIntersection.setSelected(source.isCircuitIntersectionNetwork());
			chckbxCircuitNetworks.setSelected(source.isCircuitNetworks());
		}
	}
}
