package org.tip.puckgui.views;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.Attributes;
import org.tip.puckgui.WindowGUI;
import org.tip.puckgui.models.AttributesModel;

/**
 * 
 * @author TIP
 */
public class AttributesPanel extends JPanel {
	static private final Logger logger = LoggerFactory.getLogger(AttributesPanel.class);

	private static final long serialVersionUID = -7349931177487894947L;
	private static final ResourceBundle bundle = ResourceBundle.getBundle("org.tip.puckgui.messages");
	private JTable table;
	private JLabel lblTitle;
	private JButton btnAdd;
	private WindowGUI guim;

	/**
	 * Create the panel.
	 */
	public AttributesPanel(final WindowGUI guiManager, final Attributes source) {
		this.guim = guiManager;
		setLayout(new BoxLayout(this, BoxLayout.X_AXIS));

		JPanel panel_1 = new JPanel();
		add(panel_1);
		panel_1.setLayout(new BoxLayout(panel_1, BoxLayout.Y_AXIS));

		Component verticalStrut_1 = Box.createVerticalStrut(5);
		panel_1.add(verticalStrut_1);

		JPanel panel = new JPanel();
		panel_1.add(panel);
		panel.setMaximumSize(new Dimension(32767, 25));
		panel.setAlignmentX(Component.LEFT_ALIGNMENT);
		panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));

		lblTitle = new JLabel("Additional Data");
		panel.add(lblTitle);

		Component horizontalStrut = Box.createHorizontalStrut(20);
		panel.add(horizontalStrut);

		btnAdd = new JButton(" + ");
		btnAdd.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				if (((AttributesModel) table.getModel()).getSource() != null) {
					// Add attribute.
					if (table.getModel().getRowCount() == ((AttributesModel) table.getModel()).getSource().size()) {
						((AttributesModel) table.getModel()).setNewItem();
					}
					table.scrollRectToVisible(table.getCellRect(table.getModel().getRowCount() - 1, 0, true));
					table.setRowSelectionInterval(table.getModel().getRowCount() - 1, table.getModel().getRowCount() - 1);
					table.setColumnSelectionInterval(0, 0);
					table.editCellAt(table.getModel().getRowCount() - 1, 0);
					table.getEditorComponent().requestFocus();
				}
			}
		});
		btnAdd.setBorder(new EmptyBorder(0, 0, 0, 0));
		panel.add(btnAdd);

		Component verticalStrut = Box.createVerticalStrut(5);
		panel_1.add(verticalStrut);

		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
		panel_1.add(scrollPane);

		table = new JTable();
		table.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		table.setCellSelectionEnabled(true);
		scrollPane.setViewportView(table);
		table.setModel(new AttributesModel(this.guim, null));

		JPopupMenu popupMenu = new JPopupMenu();

		JMenuItem mntmDelete = new JMenuItem("Delete");
		mntmDelete.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Delete.
				logger.debug("Delete " + ArrayUtils.toString(table.getSelectedRows()));
				int[] selectedRowIds = table.getSelectedRows();
				ArrayUtils.reverse(selectedRowIds);
				for (int rowIndex : selectedRowIds) {
					String label = (String) table.getModel().getValueAt(rowIndex, 0);
					((AttributesModel) table.getModel()).getSource().remove(label);
				}
				setSource(((AttributesModel) table.getModel()).getSource());
			}
		});
		popupMenu.add(mntmDelete);

		table.getModel().addTableModelListener(new TableModelListener() {
			@Override
			public void tableChanged(final TableModelEvent event) {
				lblTitle.setText(bundle.getString("MainWindow.lblAdditionalData.text") + " (" + table.getModel().getRowCount() + ")");
			}
		});

		addPopup(table, popupMenu);
	}

	/**
	 * 
	 * @param source
	 */
	public void setSource(final Attributes source) {
		if (source == null) {
			//
			lblTitle.setText(bundle.getString("MainWindow.lblAdditionalData.text"));
			((AttributesModel) table.getModel()).setSource(null);
			btnAdd.setEnabled(false);
		} else {
			//
			if ((table.isEditing()) && (table.getCellEditor() != null)) {
				table.getCellEditor().stopCellEditing();
			}
			((AttributesModel) table.getModel()).setSource(source);
			lblTitle.setText(bundle.getString("MainWindow.lblAdditionalData.text") + " (" + source.size() + ")");
			btnAdd.setEnabled(true);
		}
	}

	private static void addPopup(final Component component, final JPopupMenu popup) {
		component.addMouseListener(new MouseAdapter() {
			@Override
			public void mousePressed(final MouseEvent e) {
				if (e.isPopupTrigger()) {
					showMenu(e);
				}
			}

			@Override
			public void mouseReleased(final MouseEvent e) {
				if (e.isPopupTrigger()) {
					showMenu(e);
				}
			}

			private void showMenu(final MouseEvent e) {
				popup.show(e.getComponent(), e.getX(), e.getY());
			}
		});
	}
}
