package org.tip.puck.util;

import java.util.Comparator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.workers.GraphUtils;
import org.tip.puck.graphs.workers.NodeValuator;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.workers.NodeReferentValuator;

import fr.devinsy.util.StringList;

/**
 * 
 * @author TIP
 * 
 */
public class PuckUtils {

	static private final Logger logger = LoggerFactory.getLogger(PuckUtils.class);

	/**
	 * 
	 * @return
	 * @throws PuckException
	 */
	public static <E> StringList writePajekNetwork(final Graph<E> source) throws PuckException {
		StringList result;

		result = writePajekNetwork(source, null);

		//
		return result;
	}

	/**
	 * 
	 * @return
	 * @throws PuckException
	 */
	public static <E> StringList writePajekNetwork(final Graph<E> source, final List<String> partitionLabels) throws PuckException {
		StringList result;

		// Generate core Pajek writing.
		result = GraphUtils.writePajekNetwork(source, NodeValuator.getMatchingLabels(partitionLabels));

		// Partitions
		for (String label : NodeValuator.getNotMatchingLabels(partitionLabels)) {
			//
			result.appendln();

			// Build value list sorting exactly as source nodes.
			Values values = new NodeReferentValuator<E>().get(source.getNodes().toListSortedById(), label);

			//
			if (values.isNumeric()) {
				result.appendln("*Vector " + label);
				result.appendln("*vertices " + source.nodeCount());
				for (Value value : values) {
					result.appendln(value.intValue());
				}
			} else {
				//
				Partition<Value> partition = PartitionMaker.create(label, values);
				partition = PartitionMaker.createNumerized(partition);

				//
				result.appendln("*Partition " + partition.getLabel());
				result.appendln("*vertices " + source.nodeCount());
				for (int valueIndex = 1; valueIndex <= values.size(); valueIndex++) {
					Value value = values.get(valueIndex - 1);
					result.appendln(partition.getValue(value).intValue());
				}
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 * @throws PuckException
	 */
	public static <E> StringList writePajekPartition(Partition<E> partition, final Comparator<E> comparator) throws PuckException {
		StringList result;

		result = new StringList();

		String label = partition.getLabel();

		//
		if (partition.isNumeric()) {
			result.appendln("*Vector " + label);
			result.appendln("*vertices " + partition.itemsCount());
			for (E item : partition.getItemsAsSortedList(comparator)) {
				result.appendln(partition.getValue(item).intValue());
			}
		} else {
			//
			partition = PartitionMaker.createNumerized(partition);

			//
			result.appendln("*Partition " + label);
			result.appendln("*vertices " + partition.itemsCount());
			for (E item : partition.getItemsAsSortedList(comparator)) {
				result.appendln(partition.getValue(item).intValue());
			}
		}

		//
		return result;
	}

}
