package org.tip.puck.util;

import java.util.Map;

/**
 * 
 * @author TIP
 * 
 */
public class MathUtils {

	/**
	 * 
	 * @param value1
	 * @param value2
	 * @return
	 */
	public static double compare(final Double value1, final Double value2) {
		double result;

		if ((value1 == null) && (value2 == null)) {
			result = 0;
		} else if (value1 == null) {
			result = -1;
		} else if (value2 == null) {
			result = +1;
		} else {
			result = value1 - value2;
		}

		//
		return result;
	}

	/**
	 * 
	 * @param value1
	 * @param value2
	 * @return
	 */
	public static int compare(final Integer value1, final Integer value2) {
		int result;

		if ((value1 == null) && (value2 == null)) {
			result = 0;
		} else if (value1 == null) {
			result = -1;
		} else if (value2 == null) {
			result = +1;
		} else {
			result = value1 - value2;
		}

		//
		return result;
	}

	/**
	 * 
	 * @param value
	 * @return
	 */
	public static boolean isDecimalInteger(final double value) {
		boolean result;

		if (((int) value) == value) {
			result = true;
		} else {
			result = false;
		}

		//
		return result;
	}

	/**
	 * 
	 * @param value
	 * @return
	 */
	public static boolean isDecimalInteger(final Double value) {
		boolean result;

		if (value == null) {
			result = false;
		} else {
			result = isDecimalInteger(value.doubleValue());
		}

		//
		return result;
	}

	public static double meanValue(final Map<Integer, Integer> map) {
		double result;

		result = 0.;

		double totalNumber = 0.;
		double totalValue = 0.;

		for (int value : map.keySet()) {
			totalValue += value;
			totalNumber += map.get(value);
		}

		result = totalValue / totalNumber;
		//
		return result;
	}

	public static double medianValue(final Map<Integer, Integer> map) {
		double result;

		result = 0.;
		double totalNumber = 0.;

		for (int value : map.keySet()) {
			totalNumber += map.get(value);
		}

		double half = totalNumber / 2;
		double count = 0.;

		for (int value : map.keySet()) {
			count += map.get(value);
			if (count >= half) {
				result = value;
				break;
			}
		}
		//
		return result;
	}

	/**
	 * Calculates percentage.
	 * 
	 * @param a
	 *            The first double.
	 * @param b
	 *            The second double.
	 * @return Percentage.
	 */
	public static double percent(final double a, final double b) {
		double result;

		if (b == 0.) {
			result = 0.;
		} else {
			result = Math.round(10000. * (a / b)) / 100.;
		}

		//
		return result;
	}

	/**
	 * Calculates a percentage with a given number of decimal positions.
	 * 
	 * @param a
	 *            The first double.
	 * @param b
	 *            The second double.
	 * @param dec
	 *            The number of decimal positions.
	 * 
	 * @return percentage.
	 */
	public static double percent(final double a, final double b, final int dec) {
		double result;

		double k = Math.pow(10, dec);
		if (b == 0.) {
			result = 0.;
		} else {
			result = Math.round(100 * k * (a / b)) / k;
		}

		//
		return result;
	}

	/**
	 * Calculates percentage.
	 * 
	 * @param a
	 *            the first integer
	 * @param b
	 *            the second integer
	 * 
	 * @return percentage.
	 */
	public static double percent(final int a, final int b) {
		double result;

		if (b == 0) {
			result = 0.;
		} else {
			result = percent(new Double(a).doubleValue(), new Double(b).doubleValue());
		}

		//
		return result;
	}

	/**
	 * Calculates the square of an integer.
	 * 
	 * @param value
	 *            The integer.
	 * @return The square of the integer.
	 */
	public static int pow2(final int value) {
		int result;

		// TODO Simplify?
		result = new Double(Math.pow(2, value)).intValue();

		//
		return result;
	}

	/**
	 * 
	 * @param value
	 * @param decimalNumber
	 * @return
	 */
	public static double round(final double value, final int decimalNumber) {
		double result;

		double shifter = Math.pow(10, decimalNumber);
		result = ((int) (value * shifter)) / shifter;

		//
		return result;
	}

	/**
	 * 
	 * @param value
	 * @param decimalNumber
	 * @return
	 */
	public static double roundHundredth(final double value) {
		double result;

		result = Math.round(100. * value) / 100.;

		//
		return result;
	}

	/**
	 * 
	 * @param value
	 * @param factor
	 * @return
	 */
	public static int toIntAmplified(final double value, final int factor) {
		int result;

		result = new Double(factor * value).intValue();

		return result;
	}

	/**
	 * 
	 * @param value
	 * @return
	 */
	public static String toString(final double value) {
		String result;

		if (MathUtils.isDecimalInteger(value)) {
			result = String.valueOf((int) value);
		} else {
			result = String.valueOf(value);
		}

		//
		return result;
	}

	/**
	 * 
	 * @param value
	 * @return
	 */
	public static String toString(final Double value) {
		String result;

		if (value == null) {
			result = "";
		} else {
			result = toString(value.doubleValue());
		}

		//
		return result;
	}

}