package org.tip.puck.net.relations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.tip.puck.util.NumberablesHashMap;

/**
 * The <code>Families</code> class represents a family collection.
 * 
 * @author TIP
 */
public class Relations extends NumberablesHashMap<Relation> {

	/**
	 * 
	 */
	public Relations() {
		super();
	}

	/**
	 * 
	 */
	public Relations(final int capacity) {
		super(capacity);
	}

	/**
	 * 
	 * @param source
	 */
	public Relations(final List<Relation> source) {
		super();

		add(source);
	}

	/**
	 * 
	 * @param source
	 */
	public Relations(final Relations source) {
		super();

		add(source);
	}

	/**
	 * 
	 * @param source
	 * @return
	 */
	public Relations add(final List<Relation> source) {
		Relations result;

		result = put(source);

		//
		return result;
	}

	/**
	 * 
	 * @param source
	 * @return
	 */
	public Relations add(final Relations source) {
		Relations result;

		result = put(source);

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public List<String> getAttributeLabels() {
		List<String> result;

		//
		result = new ArrayList<String>();

		//
		for (Relation relation : this) {
			for (String label : relation.attributes().labels()) {
				if (!result.contains(label)) {
					result.add(label);
				}
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @param model
	 * @return
	 */
	public Relations getByModel(final RelationModel model) {
		Relations result;

		result = new Relations();
		for (Relation relation : this) {
			if (relation.getModel() == model) {
				result.add(relation);
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @param model
	 * @return
	 */
	public Relations getByModelName(final String name) {
		Relations result;

		//
		result = new Relations();

		//
		if (StringUtils.isNotBlank(name)) {
			for (Relation relation : this) {
				if (relation.getModel().getName().equals(name)) {
					result.add(relation);
				}
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public int getFirstFreeTypedId() {
		int result;

		int[] ids = new int[this.size()];
		int relationIndex = 0;
		for (Relation relation : this) {
			ids[relationIndex] = relation.getTypedId();
			relationIndex += 1;
		}

		if (ids.length == 0) {
			result = 1;
		} else {
			Arrays.sort(ids);

			boolean ended = false;
			int index = 0;
			result = -1;
			while (!ended) {
				if (index < ids.length - 1) {
					if (ids[index] + 1 == ids[index + 1]) {
						index += 1;
					} else {
						ended = true;
						result = ids[index] + 1;
					}
				} else {
					ended = true;
					result = ids[index] + 1;
				}
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public int getLastTypedId() {
		int result;

		result = 0;
		for (Relation relation : data.values()) {
			if (relation.getTypedId() > result) {
				result = relation.getTypedId();
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @param strategy
	 * @return
	 */
	public int nextFreeTypedId(final IdStrategy strategy) {
		int result;

		if (strategy == null) {
			result = 0;
		} else {
			switch (strategy) {
				case FILL:
					result = getFirstFreeTypedId();
				break;

				case APPEND:
					result = getLastTypedId() + 1;
				break;

				case SIZE:
					result = this.size() + 1;
				break;

				default:
					result = 0;
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @param source
	 * @return
	 */
	public Relations put(final List<Relation> source) {
		Relations result;

		//
		if (source != null) {
			for (Relation relation : source) {
				this.add(relation);
			}
		}

		//
		result = this;

		//
		return result;
	}

	/**
	 * 
	 * @param source
	 * @return
	 */
	public Relations put(final Relations source) {
		Relations result;

		//
		if (source != null) {
			for (Relation relation : source) {
				this.add(relation);
			}
		}

		//
		result = this;

		//
		return result;
	}

	/**
	 * 
	 * @param relation
	 */
	public void remove(final Relation relation) {
		if (relation != null) {
			this.removeById(relation.getId());
		}
	}

	/**
	 * 
	 * @param relationModel
	 * @param sourceRole
	 */
	public void removeRelationRole(final RelationModel model, final Role role) {
		if ((model != null) && (role != null)) {
			//
			Relations relations = this.getByModel(model);
			for (Relation relation : relations) {
				Actors actors = relation.actors().getByRole(role);
				for (Actor actor : actors) {
					relation.actors().remove(actor);
					if (relation.actors().getById(actor.getId()) == null) {
						actor.getIndividual().relations().removeById(relation.getId());
					}
				}
			}

			//
			model.roles().remove(role);
		}
	}

	/**
	 * 
	 * @param pattern
	 * @return
	 */
	public List<Relation> searchByName(final String pattern) {
		List<Relation> result;

		Relations relations = new Relations();
		if (StringUtils.isNotBlank(pattern)) {
			//
			for (Relation relation : this) {
				if (relation.matches(pattern)) {
					relations.add(relation);
				}
			}
		}

		result = relations.toSortedList();

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public List<Relation> toListSortedByTypeId() {
		List<Relation> result;

		result = toList();
		Collections.sort(result, new Comparator<Relation>() {
			@Override
			public int compare(final Relation relation1, final Relation relation2) {
				int result;

				result = relation1.getTypedId() - relation2.getTypedId();

				//
				return result;
			}
		});

		//
		return result;
	}
}
