package org.tip.puck.net.relations;

import java.util.Iterator;

import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.Individual;
import org.tip.puck.util.Numberable;

/**
 * 
 * @author TIP
 */
public class Relation implements Numberable {

	private int id;
	private int typedId;
	private RelationModel model;
	private String name;
	private Actors actors;
	private Attributes attributes;

	/**
	 * 
	 * @param id
	 * @param model
	 * @param name
	 * @param actors
	 */
	public Relation(final int id, final int typedId, final RelationModel model, final String name, final Actor... actors) {
		this.id = id;
		this.typedId = typedId;
		this.model = model;
		this.name = name;
		this.actors = new Actors();
		for (Actor actor : actors) {
			this.actors.add(actor);
		}
		this.attributes = new Attributes();
	}

	/**
	 * 
	 * @return
	 */
	public Actors actors() {
		return actors;
	}

	/**
	 * 
	 * @return
	 */
	public Attributes attributes() {
		Attributes result;

		result = this.attributes;

		//
		return result;
	}

	/**
	 * 
	 */
	public String getAttributeValue(final String label) {
		String result;

		Attribute attribute = this.attributes().get(label);
		if (attribute == null) {
			result = null;
		} else {
			result = attribute.getValue();
		}

		//
		return result;
	}

	/**
	 * 
	 */
	@Override
	public int getId() {
		return id;
	}

	public RelationModel getModel() {
		return model;
	}

	public String getName() {
		return name;
	}

	public int getTypedId() {
		return typedId;
	}

	/**
	 * 
	 * @param id
	 * @return
	 */
	public boolean hasActor(final Actor actor) {
		boolean result;

		if (actor == null) {
			result = false;
		} else {
			result = this.actors.hasActor(actor.getId(), actor.getRole().getName());
		}

		//
		return result;
	}

	/**
	 * 
	 * @param id
	 * @return
	 */
	public boolean hasActor(final Individual individual) {
		boolean result;

		if (individual == null) {
			result = false;
		} else {
			result = this.actors.hasActor(individual.getId());
		}

		//
		return result;
	}

	/**
	 * 
	 * @param id
	 * @return
	 */
	public boolean hasActor(final Individual individual, final String role) {
		boolean result;

		if (individual == null) {
			result = false;
		} else {
			result = this.actors.hasActor(individual.getId(), role);
		}

		//
		return result;
	}

	/**
	 * 
	 * @param id
	 * @return
	 */
	public boolean hasActor(final int id) {
		boolean result;

		result = this.actors.hasActor(id);

		//
		return result;
	}

	/**
	 * 
	 * @param id
	 * @param role
	 * @return
	 */
	public boolean hasActor(final int id, final String role) {
		boolean result;

		result = this.actors.hasActor(id, role);

		//
		return result;
	}

	/**
	 * 
	 */
	@Override
	public String hashKey() {
		String result;

		result = "" + this.id;

		//
		return result;
	}

	public boolean hasRole(final Individual individual, final String roleName) {
		boolean result = false;

		for (Actor actor : actors) {
			if (actor.getIndividual() == individual && actor.getRole().getName().equals(roleName)) {
				result = true;
				break;
			}
		}
		//
		return result;
	}

	/**
	 * 
	 * @param pattern
	 * @return
	 */
	public boolean matches(final String pattern) {
		boolean result;

		if (StringUtils.isBlank(pattern)) {
			result = false;
		} else {
			String targetPattern = pattern.toLowerCase();

			if (this.name.toLowerCase().contains(targetPattern)) {
				result = true;
			} else {
				boolean ended = false;
				result = false;
				Iterator<Actor> iterator = this.actors.iterator();
				while (!ended) {
					if (iterator.hasNext()) {
						Actor actor = iterator.next();
						if (actor.getIndividual().getName().toLowerCase().contains(targetPattern)) {
							ended = true;
							result = true;
						}
					} else {
						ended = true;
						result = false;
					}
				}
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @param target
	 */
	public void removeActor(final Actor actor) {
		this.actors.remove(actor);
	}

	/**
	 * 
	 * @param id
	 */
	public void removeActor(final int id) {
		for (Actor actor : this.actors.toList()) {
			if (actor.getId() == id) {
				this.actors.remove(actor);
			}
		}
	}

	/**
	 * 
	 */
	@Override
	public void setId(final int id) {
		this.id = id;
	}

	public void setModel(final RelationModel model) {
		this.model = model;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public void setTypedId(final int typedId) {
		this.typedId = typedId;
	}
}
