package org.tip.puck.net;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.IndividualComparator.Sorting;
import org.tip.puck.util.NumberablesHashMap;

/**
 * The <code>Individuals</code> class represents an individual collection.
 * 
 * 
 * @author TIP
 */
public class Individuals extends NumberablesHashMap<Individual> {
	/**
	 * 
	 */
	public Individuals() {
		super();
	}

	/**
	 * 
	 */
	public Individuals(final Individuals source) {
		super();
		add(source);
	}

	/**
	 * 
	 */
	public Individuals(final int initialCapacity) {
		super(initialCapacity);
	}

	/**
	 * 
	 * @param source
	 */
	public Individuals(final List<Individual> source) {
		super();
		add(source);
	}

	/**
	 * 
	 * @param source
	 * @return
	 */
	public Individuals add(final Individuals source) {
		Individuals result;

		result = put(source);

		//
		return result;
	}

	/**
	 * 
	 * @param source
	 * @return
	 */
	public Individuals add(final List<Individual> source) {
		Individuals result;

		result = put(source);

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public List<String> firstNames() {
		List<String> result;

		//
		HashMap<String, String> buffer = new HashMap<String, String>();
		for (Individual individual : this) {
			String firstName = individual.getFirstName();
			if (StringUtils.isNotBlank(firstName)) {
				buffer.put(firstName, null);
			}
		}

		//
		Set<String> firstNames = buffer.keySet();
		result = new ArrayList<String>(firstNames.size());
		for (String firstName : buffer.keySet()) {
			result.add(firstName);
		}

		//
		Collections.sort(result);

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public List<String> getAttributeLabels() {
		List<String> result;

		//
		result = new ArrayList<String>();

		//
		for (Individual individual : this) {
			for (String label : individual.attributes().labels()) {
				if (!result.contains(label)) {
					result.add(label);
				}
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @param pattern
	 * @return
	 */
	public Individuals getByGender(final Gender pattern) {
		Individuals result;

		if (pattern == null) {
			result = new Individuals(this);
		} else {
			result = new Individuals();
			for (Individual individual : this) {
				if (individual.getGender() == pattern) {
					result.add(individual);
				}
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @param pattern
	 * @return
	 */
	public Individuals getByGenderNear(final Gender pattern) {
		Individuals result;

		if (pattern == null) {
			result = new Individuals(this);
		} else {
			result = new Individuals();

			for (Individual individual : this) {
				if (individual.getGender().matchs(pattern)) {
					result.add(individual);
				}
			}
		}

		//
		return result;
	}

	/***
	 * 
	 * @param ids
	 * @return
	 */
	public Individuals getByIds(final Integer[] ids) {
		Individuals result;

		if (ids == null) {
			result = new Individuals();
		} else {
			result = new Individuals(ids.length);
			for (Integer id : ids) {
				Individual individual = getById(id);
				if (individual != null) {
					result.add(individual);
				}
			}
		}

		//
		return result;
	}

	/***
	 * 
	 * @param ids
	 * @return
	 */
	public Individuals getByIds(final List<Integer> ids) {
		Individuals result;

		if (ids == null) {
			result = new Individuals();
		} else {
			result = new Individuals(ids.size());
			for (Integer id : ids) {
				Individual individual = getById(id);
				if (individual != null) {
					result.add(individual);
				}
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @param pattern
	 * @return
	 */
	public Individuals getFertiles() {
		Individuals result;

		result = new Individuals();
		for (Individual individual : this) {
			if (individual.isFertile()) {
				result.add(individual);
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @param pattern
	 * @return
	 */
	public Individuals getSteriles() {
		Individuals result;

		//
		result = new Individuals();
		for (Individual individual : this) {
			if (individual.isSterile()) {
				result.add(individual);
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public List<String> lastNames() {
		List<String> result;

		//
		HashMap<String, String> buffer = new HashMap<String, String>();
		for (Individual individual : this) {
			String lastName = individual.getLastName();
			if (StringUtils.isNotBlank(lastName)) {
				buffer.put(lastName, null);
			}
		}

		//
		Set<String> lastNames = buffer.keySet();
		result = new ArrayList<String>(lastNames.size());
		for (String lastName : buffer.keySet()) {
			result.add(lastName);
		}

		//
		Collections.sort(result);

		//
		return result;
	}

	/**
	 * 
	 * @param source
	 * @return
	 */
	public Individuals put(final Individuals source) {
		Individuals result;

		//
		if (source != null) {
			for (Individual individual : source) {
				this.add(individual);
			}
		}

		//
		result = this;

		//
		return result;
	}

	/**
	 * 
	 * @param source
	 * @return
	 */
	public Individuals put(final List<Individual> source) {
		Individuals result;

		//
		if (source != null) {
			for (Individual individual : source) {
				this.add(individual);
			}
		}

		//
		result = this;

		//
		return result;
	}

	/**
	 * 
	 * @param pattern
	 * @return individuals matching pattern, sorted by their number.
	 */
	public List<Individual> searchByName(final String pattern) {
		List<Individual> result;

		Individuals individuals = new Individuals();
		if (StringUtils.isNotBlank(pattern)) {

			String targetPattern = pattern.toLowerCase();
			for (Individual individual : this) {
				if (individual.getName() != null && individual.getName().toLowerCase().contains(targetPattern)) {
					individuals.add(individual);
				}
			}
		}

		result = individuals.toSortedList();

		//
		return result;
	}

	/**
	 * 
	 * @param id
	 * @param label
	 * @param value
	 */
	public void setAttribute(final int id, final String label, final String value) {

		if ((label != null) && (value != null)) {
			//
			Individual individual = getById(id);
			if (individual == null) {
				individual = new Individual(id);
				this.put(individual);
			}

			//
			if ((label.equals("NAME")) && (StringUtils.isNotBlank(value)) && (!StringUtils.equals(value, "null"))) {
				individual.setName(value);
			}

			//
			individual.attributes().put(label, value);
		}
	}

	/**
	 * 
	 * @param source
	 * @return
	 */
	public int size(final Gender pattern) {
		int result;

		if (pattern == null) {
			result = this.size();
		} else {
			result = 0;
			for (Individual individual : this) {
				if (individual.getGender() == pattern) {
					result += 1;
				}
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public Individual[] toArray() {
		Individual[] result;

		result = new Individual[this.size()];

		int individualCount = 0;
		for (Individual individual : this) {
			result[individualCount] = individual;
			individualCount += 1;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public List<Individual> toSortedList(final Sorting sorting) {
		List<Individual> result;

		result = toList();
		Collections.sort(result, new IndividualComparator(sorting));

		//
		return result;
	}
}
