package org.tip.puck.net;

import java.util.Comparator;

import org.tip.puck.net.workers.IndividualValuator;

/**
 * 
 * @author TIP
 */
public class IndividualComparator implements Comparator<Individual> {

	public enum Sorting {
		ID,
		FIRSTN,
		LASTN,
		GENDER,
		BIRT_YEAR;

	}

	Sorting sorting;

	public IndividualComparator(final Sorting sorting) {
		this.sorting = sorting;
	}

	/**
	 * 
	 */
	@Override
	public int compare(final Individual alpha, final Individual bravo) {
		int result;

		if ((alpha == null) && (bravo == null)) {
			result = 0;
		} else if (alpha == null) {
			result = -1;
		} else if (bravo == null) {
			result = +1;
		} else {
			switch (sorting) {
				case ID:
					result = new Integer(alpha.getId()).compareTo(bravo.getId());
				break;
				case FIRSTN:
					if ((alpha.getFirstName() == null) && (bravo.getFirstName() == null)) {
						result = 0;
					} else if (alpha.getFirstName() == null) {
						result = -1;
					} else if (bravo.getFirstName() == null) {
						result = +1;
					} else {
						result = alpha.getFirstName().compareTo(bravo.getFirstName());
						if (result == 0) {
							result = new IndividualComparator(Sorting.LASTN).compare(alpha, bravo);
						}
					}
				break;
				case LASTN:
					if ((alpha.getLastName() == null) && (bravo.getLastName() == null)) {
						result = 0;
					} else if (alpha.getLastName() == null) {
						result = -1;
					} else if (bravo.getLastName() == null) {
						result = +1;
					} else {
						result = alpha.getLastName().compareTo(bravo.getLastName());
					}
				break;
				case GENDER:
					result = alpha.getGender().compareTo(bravo.getGender());
				break;
				case BIRT_YEAR:
					Integer firstBirtYear = IndividualValuator.getBirthYear(alpha);
					Integer secondBirtYear = IndividualValuator.getBirthYear(bravo);
					if (firstBirtYear == null || secondBirtYear == null){
						result = 0;
					} else {
						result = firstBirtYear.compareTo(secondBirtYear);
					}
					break;
				default:
					result = new Integer(alpha.getId()).compareTo(bravo.getId());
			}
		}

		//
		return result;
	}
}
