package org.tip.puck.net;

/**
 * Note: to avoid bad comparison, a hard parameter is setted for each enum
 * entry.
 * 
 * @author TIP
 */
public enum Gender {

	MALE(0),
	FEMALE(1),
	UNKNOWN(2);

	private static final char MALE_CHAR = 0x2642;
	private static final char FEMALE_CHAR = 0x2640;
	private static final char NEUTRAL_CHAR = 0x26B2;
	private int code;

	/**
	 * 
	 * @param code
	 * @param message
	 */
	private Gender(final int code) {
		this.code = code;
	}

	/**
	 * 
	 * @param gender
	 * @return
	 */
	public boolean canMarry(final Gender gender) {
		boolean result;

		result = (!(this == gender) || (this == UNKNOWN));

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public Gender invert() {
		Gender result;

		if (this == MALE) {
			result = FEMALE;
		} else if (this == FEMALE) {
			result = MALE;
		} else {
			result = this;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isFemale() {
		boolean result;

		result = this == FEMALE;

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isMale() {
		boolean result;

		result = this == MALE;

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isUnknown() {
		boolean result;

		result = this == UNKNOWN;

		//
		return result;
	}

	/**
	 * 
	 * @param gender
	 * @return
	 */
	public boolean matchs(final Gender gender) {
		boolean result;

		if ((gender == null) || (this == UNKNOWN) || (gender == UNKNOWN) || (this == gender)) {
			result = true;
		} else {
			result = false;
		}

		//
		return result;
	}

	public char toAscendantChar() {
		char result;

		switch (this) {
			case FEMALE:
				result = 'M';
			break;
			case MALE:
				result = 'F';
			break;
			default:
				result = 'P';
		}
		//
		return result;
	}

	public char toDescendantChar() {
		char result;

		switch (this) {
			case FEMALE:
				result = 'D';
			break;
			case MALE:
				result = 'S';
			break;
			default:
				result = 'C';
		}
		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public char toChar() {
		char result;

		switch (this) {
			case FEMALE:
				result = 'F';
			break;
			case MALE:
				result = 'H';
			break;
			default:
				result = 'X';
		}

		//
		return result;
	}

	/**
	 * TIP format compatibility.
	 * 
	 * @return
	 */
	public int toInt() {
		int result;

		result = this.code;

		//
		return result;
	}

	public String toShapeString() {
		String result;
		switch (this) {
			case FEMALE:
				result = "ellipse";
			break;
			case MALE:
				result = "triangle";
			break;
			default:
				result = "diamond";
		}

		//
		return result;
	}
	
	public static boolean isGenderSymbol(char c){
		boolean result;
		
		result = (c == FEMALE_CHAR || c == MALE_CHAR || c == NEUTRAL_CHAR);
		//
		return result;
	}
	
	/**
	 * 
	 * @return
	 */
	public char toSymbol() {
		char result;

		switch (this) {
			case FEMALE:
				result = FEMALE_CHAR;
			break;
			case MALE:
				result = MALE_CHAR;
			break;
			default:
				result = NEUTRAL_CHAR;
		}

		//
		return result;

	}

	/**
	 * 
	 * TIP format compatible (0->M, 1->F). - Deactivated for in some txt
	 * datasets 0 = unknown.
	 * 
	 * 
	 * @param value
	 *            .
	 * 
	 * 
	 * @return
	 */
	static public Gender valueOf(final char value) {
		Gender result;

		switch (value) {
			case '0':
			case 'm':
			case 'M':
			case 'h':
			case 'H':
				result = MALE;
			break;

			case '1':
			case 'f':
			case 'F':
				result = FEMALE;
			break;
			default:
				result = UNKNOWN;
		}

		//
		return result;
	}

	/**
	 * K
	 * 
	 * @param value
	 * 
	 * @return
	 */
	static public Gender valueOf(final int value) {
		Gender result;

		switch (value) {
			case 0:
				result = Gender.MALE;
			break;
			case 1:
				result = Gender.FEMALE;
			break;
			default:
				result = Gender.UNKNOWN;
		}

		//
		return result;
	}

}
