package org.tip.puck.net;

import java.util.Comparator;


/**
 * 
 * @author TIP
 * 
 */
public class FamilyComparator implements Comparator<Family> {
	
	public enum Sorting {
		ID,
		HUSBAND,
		WIFE,

	}

	Sorting sorting;

	public FamilyComparator(final Sorting sorting) {
		this.sorting = sorting;
	}

	/**
	 * 
	 */
	@Override
	public int compare(final Family alpha, final Family bravo) {
		int result;

		if ((alpha == null) && (bravo == null)) {
			result = 0;
		} else if (alpha == null) {
			result = -1;
		} else if (bravo == null) {
			result = +1;
		} else {
			switch (sorting) {
				case ID:
					result = new Integer(alpha.getId()).compareTo(bravo.getId());
				break;
				case HUSBAND:
					if ((alpha.getHusband() == null) && (bravo.getHusband() == null)) {
						result = 0;
					} else if (alpha.getHusband() == null) {
						result = -1;
					} else if (bravo.getHusband() == null) {
						result = +1;
					} else {
						result = new Integer(alpha.getHusband().getId()).compareTo(bravo.getHusband().getId());
						if (result == 0) {
							result = new FamilyComparator(Sorting.WIFE).compare(alpha, bravo);
						}
					}
				break;
				case WIFE:
					if ((alpha.getWife() == null) && (bravo.getWife() == null)) {
						result = 0;
					} else if (alpha.getWife() == null) {
						result = -1;
					} else if (bravo.getWife() == null) {
						result = +1;
					} else {
						result = new Integer(alpha.getWife().getId()).compareTo(bravo.getWife().getId());
						if (result == 0) {
							result = new FamilyComparator(Sorting.HUSBAND).compare(alpha, bravo);
						}
					}
				break;
				default:
					result = new Integer(alpha.getId()).compareTo(bravo.getId());
			}
		}

		//
		return result;
	}

	

}
