package org.tip.puck.net;

import org.tip.puck.util.Numberable;

/**
 * 
 * 
 * @author TIP
 */
public class Family implements Numberable {

	private int id;
	private Individual husband;
	private Individual wife;
	private UnionStatus unionStatus;
	private Individuals children;
	private Attributes attributes;

	/**
	 * 
	 * @param husband
	 * @param wife
	 */
	public Family(final Individual husband, final Individual wife) {
		this.unionStatus = UnionStatus.UNMARRIED;
		this.husband = husband;
		this.wife = wife;
		this.children = new Individuals();
		this.attributes = new Attributes();
	}

	/**
	 * 
	 */
	public Family(final int id) {
		this.id = id;
		this.unionStatus = UnionStatus.UNMARRIED;
		this.children = new Individuals();
		this.attributes = new Attributes();
	}

	/**
	 * 
	 * @param id
	 * @param husband
	 * @param wife
	 */
	public Family(final int id, final Individual husband, final Individual wife) {
		this.id = id;
		this.unionStatus = UnionStatus.UNMARRIED;
		this.husband = husband;
		this.wife = wife;
		this.children = new Individuals();
		this.attributes = new Attributes();
	}

	/**
	 * 
	 * @param id
	 * @param husband
	 * @param wife
	 */
	public Family(final int id, final Individual husband, final Individual wife, final UnionStatus status) {
		this.id = id;
		if (status == null) {
			this.unionStatus = UnionStatus.UNMARRIED;
		} else {
			this.unionStatus = status;
		}
		this.husband = husband;
		this.wife = wife;
		this.children = new Individuals();
		this.attributes = new Attributes();
	}

	/**
	 * 
	 * @return
	 */
	public Attributes attributes() {
		return attributes;
	}

	/**
	 * 
	 */
	@Override
	public Family clone() {
		Family result;

		//
		Individual husbandClone = null;
		if (husband != null) {
			husbandClone = husband.clone();
		}

		//
		Individual wifeClone = null;
		if (wife != null) {
			wifeClone = wife.clone();
		}

		//
		result = new Family(id, husbandClone, wifeClone);

		//
		return result;
	}

	/**
	 * 
	 */
	public String getAttributeValue(final String label) {
		String result;

		Attribute attribute = this.attributes().get(label);
		if (attribute == null) {
			result = null;
		} else {
			result = attribute.getValue();
		}

		//
		return result;
	}

	/**
	 * 
	 */
	public Individuals getChildren() {
		Individuals result;

		result = this.children;

		//
		return result;
	}

	public Individuals getChildren(final Gender gender) {
		Individuals result;

		result = new Individuals();
		for (Individual child : children) {
			if (child.getGender() == gender) {
				result.add(child);
			}
		}
		//
		return result;
	}

	/**
	 * Returns the parent playing the paternel role.
	 */
	public Individual getFather() {
		Individual result;

		result = this.husband;
		//
		return result;
	}

	/**
	 * Returns the parent playing the paternel role.
	 */
	public Individual getHusband() {
		Individual result;

		result = this.husband;

		//
		return result;
	}

	public Family getHusbandsOriginFamily() {
		Family result;

		if (husband == null) {
			result = null;
		} else {
			result = husband.getOriginFamily();
		}
		//
		return result;
	}

	/**
	 * 
	 */
	@Override
	public int getId() {
		int result;

		result = this.id;

		//
		return result;
	}

	/**
	 * Returns the parent playing the paternel role.
	 */
	public Individual getMother() {
		Individual result;

		result = this.wife;

		//
		return result;
	}

	/**
	 * 
	 * @param parent
	 * @return
	 */
	public Individual getOtherParent(final Individual parent) {
		Individual result;

		if (parent == husband) {
			result = wife;
		} else if (parent == wife) {
			result = husband;
		} else {
			result = null;
		}

		//
		return result;
	}

	public Individual getParent(final Gender gender) {
		Individual result;

		switch (gender) {
			case MALE:
				result = this.husband;
			break;
			case FEMALE:
				result = this.wife;
			break;
			default:
				result = null;
		}
		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public Individuals getParents() {
		Individuals result;

		result = new Individuals();
		if (this.husband != null) {
			result.add(this.husband);
		}
		if (this.wife != null) {
			result.add(this.wife);
		}

		//
		return result;
	}

	public UnionStatus getUnionStatus() {
		return unionStatus;
	}

	/**
	 * Returns the parent playing the paternel role.
	 */
	public Individual getWife() {
		Individual result;

		result = this.wife;

		//
		return result;
	}

	public Family getWifesOriginFamily() {
		Family result;

		if (wife == null) {
			result = null;
		} else {
			result = wife.getOriginFamily();
		}
		//
		return result;
	}

	@Override
	public String hashKey() {
		String wifeStr = "?";
		String husbandStr = "?";
		if (wife != null) {
			wifeStr = "" + wife.getId();
		}
		if (husband != null) {
			husbandStr = "" + husband.getId();
		}
		return wifeStr + " [+] " + husbandStr;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isDivorced() {
		boolean result;

		result = this.unionStatus.isDivorced();

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isEmpty() {
		boolean result;

		if ((isOrphan()) && (isSterile()) && (this.attributes.isEmpty())) {
			result = true;
		} else {
			result = false;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isEmptyAndSingleParent() {
		boolean result;

		if ((isSingleParent()) && (isSterile()) && (this.attributes.isEmpty())) {
			result = true;
		} else {
			result = false;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isFertile() {
		boolean result;

		result = this.children.size() != 0;

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isMarried() {
		boolean result;

		result = this.unionStatus.isMarried();

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isNotSingleParent() {
		boolean result;

		result = !isSingleParent();

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isOrphan() {
		boolean result;

		if ((this.husband == null) && (this.wife == null)) {
			result = true;
		} else {
			result = false;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isParent(final Individual parent) {
		boolean result;

		if ((this.husband == parent) || (this.wife == parent)) {
			result = true;
		} else {
			result = false;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isSingleParent() {
		boolean result;

		if (((this.husband == null) && (this.wife != null)) || ((this.husband != null) && (this.wife == null))) {
			result = true;
		} else {
			result = false;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isSterile() {
		boolean result;

		result = this.children.size() == 0;

		//
		return result;
	}

	public int numberOfParents() {
		int result;

		if (husband != null && wife != null) {
			result = 2;
		} else if (husband == null && wife == null) {
			result = 0;
		} else {
			result = 1;
		}
		//
		return result;
	}

	/**
	 * 
	 * @param label
	 * @param value
	 */
	public void setAttribute(final String label, final String value) {
		this.attributes().put(label, value);
	}

	/**
	 * 
	 * @param married
	 */
	public void setDivorced() {
		this.unionStatus = UnionStatus.DIVORCED;
	}

	public void setFather(final Individual father) {
		this.husband = father;
	}

	public void setHusband(final Individual husband) {
		this.husband = husband;
	}

	/**
	 * 
	 */
	@Override
	public void setId(final int id) {
		this.id = id;
	}

	/**
	 * 
	 * @param married
	 */
	public void setMarried() {
		this.unionStatus = UnionStatus.MARRIED;
	}

	/**
	 * 
	 * @param married
	 */
	public void setMarried(final boolean married) {
		if (married == true) {
			this.unionStatus = UnionStatus.MARRIED;
		} else {
			this.unionStatus = UnionStatus.UNMARRIED;
		}
	}

	public void setMother(final Individual mother) {
		this.wife = mother;
	}

	/**
	 * 
	 * @param parent
	 */
	public void setSpouses(final Individual husband, final Individual wife) {
		this.husband = husband;
		this.wife = wife;
	}

	/**
	 * 
	 * @param value
	 */
	public void setUnionStatus(final UnionStatus value) {
		if (value == null) {
			this.unionStatus = UnionStatus.UNMARRIED;
		} else {
			this.unionStatus = value;
		}
	}

	/**
	 * 
	 * @param married
	 */
	public void setUnmarried() {
		this.unionStatus = UnionStatus.UNMARRIED;
	}

	public void setWife(final Individual wife) {
		this.wife = wife;
	}

	@Override
	public String toString() {
		String husbandString = "";
		if (husband != null) {
			husbandString = husband.toString();
		}
		String wifeString = "";
		if (wife != null) {
			wifeString = wife.toString();
		}
		String sep = "";
		if (husband != null && wife != null) {
			sep = " & ";
		}

		return (id + " " + husbandString + sep + wifeString);
	}

}
