package org.tip.puck.io.txt1;

import java.util.ArrayList;
import java.util.List;

import org.tip.puck.io.txt1.TXT1File.Format;

/**
 * This class represents a line of individual from a TXT file.
 * 
 * @author Klaus Hamberger
 * @author TIP
 */
public class TXTIndividualLine {
	public static final int NOID = 0;

	protected int id;
	protected String name;
	protected char gender;
	protected int fatherId;
	protected int motherId;
	protected List<Integer> spouseIds;
	
	protected Format format;
	
	protected int originFamilyId;
	protected List<Integer> personalFamilyIds;
	
	

	/**
	 * 
	 */
	public TXTIndividualLine(Format format) {
		this.format = format;
		this.gender = 'X';
		if (format == format.ONEMODE){
			this.spouseIds = new ArrayList<Integer>();
		} else if (format == format.TWOMODE){
			this.personalFamilyIds = new ArrayList<Integer>();
		}
	}

	public int fatherId() {
		return fatherId;
	}

	public char gender() {
		return gender;
	}

	public int id() {
		return id;
	}

	public int motherId() {
		return motherId;
	}

	public String name() {
		return name;
	}

	public void setFatherId(final int fatherId) {
		this.fatherId = fatherId;
	}

	public void setGender(final char gender) {
		this.gender = gender;
	}

	public void setId(final int id) {
		this.id = id;
	}

	public void setMotherId(final int motherId) {
		this.motherId = motherId;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public List<Integer> spouseIds() {
		return spouseIds;
	}

	public int originFamilyId() {
		return originFamilyId;
	}

	public void setOriginFamilyId(int originFamilyId) {
		this.originFamilyId = originFamilyId;
	}

	public List<Integer> personalFamilyIds() {
		return personalFamilyIds;
	}

}
