/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.random;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.tip.puck.mas.MAS;
import org.tip.puck.mas.MASConfig;
import org.tip.puck.net.Families;
import org.tip.puck.net.Family;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.util.Distributions;
import org.tip.puck.util.RandomUtils;
import org.tip.puckgui.views.RandomCorpusCriteria;

public class RandomNetMaker {
    private MAS mas;
    Random randGen;
    int initSize;
    int years;
    int maxAge;
    int minAge;
    double meanAgeDifference;
    double stdevAgeDifference;
    double marriageRate;
    double fertilityRate;
    double divorceRate;
    private int samples;
    private Individual[] wives;
    private Individual[] husbands;
    private double[] weights;
    FiliationType cousinPreferenceType;
    double cousinPreferenceWeight;
    Map<Integer, List<Integer>> weightIndexMap;
    double totalWeight;
    Families fertileFamilies;
    List<Individual> disposibleMen;
    List<Individual> disposibleWomen;
    Individuals children;
    Individuals adults;
    Map<Integer, Individuals> preferences;
    Map<Integer, Individuals> avoidances;

    public RandomNetMaker(RandomCorpusCriteria criteria) {
        if (criteria.isMas()) {
            MASConfig config = new MASConfig();
            config.fromString(criteria.toMASConfig());
            this.mas = config.getMas();
        } else {
            this.initSize = criteria.getInitialPopulation();
            this.years = criteria.getYear();
            this.maxAge = criteria.getMaxAge();
            this.minAge = criteria.getMinAge();
            this.meanAgeDifference = criteria.getMeanAgeDifference();
            this.stdevAgeDifference = criteria.getStdevAgeDifference();
            this.marriageRate = criteria.getMarriageRate();
            this.fertilityRate = criteria.getFertilityRate();
            this.divorceRate = criteria.getDivorceRate();
            this.cousinPreferenceType = criteria.getCousinPreferenceType();
            this.cousinPreferenceWeight = criteria.getCousinPreferenceWeight();
            this.randGen = new Random();
            this.fertileFamilies = new Families();
            this.disposibleMen = new ArrayList<Individual>();
            this.disposibleWomen = new ArrayList<Individual>();
            this.children = new Individuals();
            this.adults = new Individuals();
            this.preferences = new HashMap<Integer, Individuals>();
            this.avoidances = new HashMap<Integer, Individuals>();
        }
    }

    public Net createRandomMASNet() {
        this.getMas().run();
        Net result = this.getMas().toNet();
        return result;
    }

    public static int getAge(Individual individual, int year) {
        return year - Integer.parseInt(individual.getAttributeValue("BIRT"));
    }

    public void getWeights(int n, int year) {
        this.weightIndexMap = new HashMap<Integer, List<Integer>>();
        this.totalWeight = 0.0;
        this.husbands = new Individual[n];
        this.wives = new Individual[n];
        this.weights = new double[n];
        int i = 0;
        for (Individual husband : this.disposibleMen) {
            ArrayList<Integer> husbandIndexList = new ArrayList<Integer>();
            this.weightIndexMap.put(husband.getId(), husbandIndexList);
            for (Individual wife : this.disposibleWomen) {
                List<Integer> wifeIndexList = this.weightIndexMap.get(wife.getId());
                if (wifeIndexList == null) {
                    wifeIndexList = new ArrayList<Integer>();
                    this.weightIndexMap.put(wife.getId(), wifeIndexList);
                }
                husbandIndexList.add(i);
                wifeIndexList.add(i);
                double weight = this.avoidances.get(husband.getId()) != null && this.avoidances.get(husband.getId()).contains(wife) ? 0.0 : (this.preferences.get(husband.getId()) != null && this.preferences.get(husband.getId()).contains(wife) && husband.isSingle() && wife.isSingle() ? this.cousinPreferenceWeight : 1.0);
                int ageDiff = RandomNetMaker.getAge(husband, year) - RandomNetMaker.getAge(wife, year);
                double ageDiffFactor = Distributions.normal(ageDiff, this.meanAgeDifference, this.stdevAgeDifference);
                this.totalWeight += (weight *= ageDiffFactor);
                this.wives[i] = wife;
                this.husbands[i] = husband;
                this.weights[i] = weight;
                ++i;
            }
        }
    }

    public void marriage(Families families, int year, int n) {
        if (this.totalWeight <= 0.0) {
            return;
        }
        double pos = 0.0;
        while (pos == 0.0) {
            pos = this.randGen.nextDouble() * this.totalWeight;
        }
        double sum = 0.0;
        int i = 0;
        while (i < n) {
            if ((sum += this.weights[i]) > pos) {
                Individual husband = this.husbands[i];
                Individual wife = this.wives[i];
                if (husband != null && wife != null) {
                    Family family = new Family(families.size() + 1, husband, wife);
                    if (this.preferences.get(husband.getId()).contains(wife)) {
                        family.setAttribute("PREFERENCE", "true");
                    }
                    husband.addPersonalFamily(family);
                    wife.addPersonalFamily(family);
                    family.setMarried(true);
                    families.put(family);
                    if (RandomNetMaker.getAge(husband, year) <= this.maxAge && RandomNetMaker.getAge(wife, year) <= this.maxAge) {
                        this.fertileFamilies.add(family);
                    }
                    this.disposibleMen.remove(husband);
                    this.disposibleWomen.remove(wife);
                    double indexSum = 0.0;
                    for (int husbandIndex : this.weightIndexMap.get(husband.getId())) {
                        indexSum += this.weights[husbandIndex];
                        this.weights[husbandIndex] = 0.0;
                    }
                    for (int wifeIndex : this.weightIndexMap.get(wife.getId())) {
                        indexSum += this.weights[wifeIndex];
                        this.weights[wifeIndex] = 0.0;
                    }
                    this.totalWeight -= indexSum;
                    break;
                }
            }
            ++i;
        }
    }

    public void marriageBySamples(Families families, int year) {
        this.husbands = new Individual[this.samples];
        this.wives = new Individual[this.samples];
        this.weights = new double[this.samples];
        double totalWeight = 0.0;
        int i = 0;
        while (i < this.samples) {
            Individual husband = RandomUtils.draw(this.disposibleMen);
            Individual wife = RandomUtils.draw(this.disposibleWomen);
            if (husband != null && wife != null) {
                double weight = this.avoidances.get(husband.getId()) != null && this.avoidances.get(husband.getId()).contains(wife) ? 0.0 : (this.preferences.get(husband.getId()) != null && this.preferences.get(husband.getId()).contains(wife) ? this.cousinPreferenceWeight : 1.0);
                totalWeight += weight;
                this.wives[i] = wife;
                this.husbands[i] = husband;
                this.weights[i] = weight;
            }
            ++i;
        }
        double pos = this.randGen.nextDouble() * totalWeight;
        totalWeight = 0.0;
        int i2 = 0;
        while (i2 < this.samples) {
            if ((totalWeight += this.weights[i2]) > pos) {
                Individual husband = this.husbands[i2];
                Individual wife = this.wives[i2];
                if (husband != null && wife != null) {
                    Family family = new Family(families.size() + 1, husband, wife);
                    if (this.preferences.get(husband.getId()).contains(wife)) {
                        family.setAttribute("PREFERENCE", "true");
                    }
                    husband.addPersonalFamily(family);
                    wife.addPersonalFamily(family);
                    family.setMarried(true);
                    families.put(family);
                    if (RandomNetMaker.getAge(husband, year) <= this.maxAge && RandomNetMaker.getAge(wife, year) <= this.maxAge) {
                        this.fertileFamilies.add(family);
                    }
                    this.disposibleMen.remove(husband);
                    this.disposibleWomen.remove(wife);
                    break;
                }
            }
            ++i2;
        }
    }

    public Net createRandomNet() {
        Net result = new Net();
        int id = 1;
        while (id < this.initSize + 1) {
            int age = this.randGen.nextInt(this.maxAge + 1);
            Gender gender = Gender.valueOf(this.randGen.nextInt(2));
            Individual indi = new Individual(id, String.valueOf(gender.toChar()) + " " + id, gender);
            indi.setAttribute("BIRT", String.valueOf(-age));
            result.individuals().put(indi);
            if (indi.getGender() == Gender.MALE) {
                this.preferences.put(indi.getId(), new Individuals());
                this.avoidances.put(indi.getId(), new Individuals());
            }
            if (age >= this.minAge && age <= this.maxAge) {
                this.adults.put(indi);
                if (indi.isMale()) {
                    this.disposibleMen.add(indi);
                } else if (indi.isFemale()) {
                    this.disposibleWomen.add(indi);
                }
            } else {
                this.children.put(indi);
            }
            ++id;
        }
        int year = 0;
        while (year < this.years) {
            int marriages = RandomUtils.randomRound((double)((this.disposibleMen.size() + this.disposibleWomen.size()) / 2) * this.marriageRate, this.randGen);
            int n = this.disposibleMen.size() * this.disposibleWomen.size();
            this.getWeights(n, year);
            int i = 0;
            while (i < marriages) {
                this.marriage(result.families(), year, n);
                ++i;
            }
            List disposibleFamilies = this.fertileFamilies.toList();
            int births = RandomUtils.randomRound(this.fertilityRate * (double)this.adults.size() / (double)(2 * (this.maxAge - this.minAge)), this.randGen);
            int i2 = 0;
            while (i2 < births) {
                Family family = (Family)RandomUtils.draw(disposibleFamilies);
                if (family != null) {
                    Gender gender = Gender.valueOf(this.randGen.nextInt(2));
                    int id2 = result.individuals().size() + 1;
                    Individual indi = new Individual(id2, String.valueOf(gender.toChar()) + " " + id2, gender);
                    indi.setAttribute("BIRT", String.valueOf(year));
                    result.individuals().put(indi);
                    this.children.put(indi);
                    family.getChildren().put(indi);
                    indi.setOriginFamily(family);
                    disposibleFamilies.remove(family);
                    if (indi.isMale()) {
                        this.preferences.put(indi.getId(), new Individuals());
                        this.avoidances.put(indi.getId(), new Individuals());
                    }
                    Individuals preferred = this.preferences.get(indi.getId());
                    for (Individual cousin : indi.crossSexCousins(this.cousinPreferenceType)) {
                        if (this.preferences.get(cousin.getId()) == null) continue;
                        if (indi.isMale()) {
                            preferred.put(cousin);
                            continue;
                        }
                        this.preferences.get(cousin.getId()).put(indi);
                    }
                    Individuals avoided = this.avoidances.get(indi.getId());
                    for (Individual parent : indi.getParents()) {
                        if (indi.isMale() && parent.isFemale()) {
                            avoided.put(parent);
                        } else if (indi.isFemale() && parent.isMale()) {
                            this.avoidances.get(parent.getId()).put(indi);
                        }
                        for (Individual sibling : parent.getChildren()) {
                            if (indi.isMale() && sibling.isFemale()) {
                                avoided.put(sibling);
                                continue;
                            }
                            if (!indi.isFemale() || !sibling.isMale()) continue;
                            this.avoidances.get(sibling.getId()).put(indi);
                        }
                    }
                }
                ++i2;
            }
            for (Individual indi : this.children.toList()) {
                if (RandomNetMaker.getAge(indi, year) < this.minAge) continue;
                this.children.removeById(indi.getId());
                this.adults.put(indi);
                if (indi.isMale()) {
                    this.disposibleMen.add(indi);
                    continue;
                }
                if (!indi.isFemale()) continue;
                this.disposibleWomen.add(indi);
            }
            for (Individual indi : this.adults.toList()) {
                if (RandomNetMaker.getAge(indi, year) <= this.maxAge) continue;
                this.adults.removeById(indi.getId());
                this.preferences.remove(indi.getId());
                this.avoidances.remove(indi.getId());
                if (indi.isMale()) {
                    this.disposibleMen.remove(indi);
                } else if (indi.isFemale()) {
                    this.disposibleWomen.remove(indi);
                }
                for (Family family : indi.getPersonalFamilies()) {
                    this.fertileFamilies.removeById(family.getId());
                }
            }
            for (Family family : this.fertileFamilies.toList()) {
                if (!RandomUtils.event(this.divorceRate, this.randGen)) continue;
                this.fertileFamilies.removeById(family.getId());
                this.disposibleMen.add(family.getHusband());
                this.disposibleWomen.add(family.getWife());
            }
            System.out.println(String.valueOf(year) + "\t" + marriages + "\t" + births + "\t" + this.fertileFamilies.size() + "\t" + this.adults.size() + "\t" + this.children.size() + "\t" + result.individuals().size());
            ++year;
        }
        return result;
    }

    public MAS getMas() {
        return this.mas;
    }
}

