/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net;

import org.apache.commons.lang3.StringUtils;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.Families;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.UnionStatus;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.RelationModels;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.Role;
import org.tip.puck.statistics.StatisticsWorker;
import org.tip.puck.util.NumberablesHashMap;
import org.tip.puck.util.NumberedIntegers;

public class Net {
    private String label;
    private Attributes attributes;
    private Individuals individuals;
    private Families families;
    private NumberablesHashMap.IdStrategy defaultIdStrategy;
    private RelationModels relationModels;
    private Relations relations;

    public Net() {
        this.label = "";
        this.individuals = new Individuals();
        this.families = new Families();
        this.attributes = new Attributes();
        this.relationModels = new RelationModels();
        this.relations = new Relations();
        this.defaultIdStrategy = NumberablesHashMap.IdStrategy.APPEND;
    }

    public Net(Net source) {
        this.label = source.getLabel();
        this.attributes = new Attributes(source.attributes());
        this.individuals = new Individuals(source.individuals().size());
        for (Individual sourceIndividual : source.individuals()) {
            Individual targetIndividual = new Individual(sourceIndividual.getId());
            targetIndividual.setGender(sourceIndividual.getGender());
            targetIndividual.setName(sourceIndividual.getName());
            targetIndividual.setOriginFamily(sourceIndividual.getOriginFamily());
            targetIndividual.getPersonalFamilies().add(sourceIndividual.getPersonalFamilies());
            targetIndividual.relations().add(sourceIndividual.relations());
            targetIndividual.attributes().addAll(sourceIndividual.attributes());
            this.individuals.add(targetIndividual);
        }
        this.families = new Families(source.families().size());
        for (Family sourceFamily : source.families()) {
            Family targetFamily = new Family(sourceFamily.getId());
            targetFamily.setHusband(sourceFamily.getHusband());
            targetFamily.setWife(sourceFamily.getWife());
            targetFamily.setUnionStatus(sourceFamily.getUnionStatus());
            targetFamily.getChildren().add(sourceFamily.getChildren());
            targetFamily.attributes().addAll(sourceFamily.attributes());
            this.families.add(targetFamily);
        }
        this.relationModels = new RelationModels(source.relationModels());
        this.relations = new Relations();
        for (Relation sourceRelation : source.relations()) {
            Relation targetRelation = new Relation(sourceRelation.getId(), sourceRelation.getTypedId(), this.relationModels().getByName(sourceRelation.getModel().getName()), sourceRelation.getName(), new Actor[0]);
            this.relations().add(targetRelation);
            for (Actor sourceActor : sourceRelation.actors()) {
                Actor targetActor = new Actor((Individual)this.individuals().getById(sourceActor.getId()), targetRelation.getModel().roles().getByName(sourceActor.getRole().getName()));
                targetRelation.actors().add(targetActor);
            }
            targetRelation.attributes().addAll(sourceRelation.attributes());
        }
        for (Individual individual : this.individuals) {
            if (individual.getOriginFamily() != null) {
                individual.setOriginFamily((Family)this.families.getById(individual.getOriginFamily().getId()));
            }
            for (Family family : individual.getPersonalFamilies()) {
                individual.getPersonalFamilies().put((Family)this.families.getById(family.getId()));
            }
            for (Relation relation : individual.relations()) {
                individual.relations().put((Relation)this.relations().getById(relation.getId()));
            }
        }
        for (Family family : this.families) {
            if (family.getHusband() != null) {
                family.setHusband((Individual)this.individuals.getById(family.getHusband().getId()));
            }
            if (family.getWife() != null) {
                family.setWife((Individual)this.individuals.getById(family.getWife().getId()));
            }
            for (Individual child : family.getChildren()) {
                family.getChildren().put((Individual)this.individuals.getById(child.getId()));
            }
        }
    }

    public void addChild(Family family, Individual child) {
        if (family != null && child != null && child.getOriginFamily() == null) {
            family.getChildren().add(child);
            child.setOriginFamily(family);
        }
    }

    public void adjustIndividuals(Individuals source) {
        for (Individual individual : this.individuals()) {
            individual.adjust((Individual)source.getById(individual.getId()));
        }
    }

    public Attributes attributes() {
        return this.attributes;
    }

    public void changeId(Family target, int targetId) {
        if (target != null && targetId >= 0) {
            this.families.removeById(target.getId());
            target.setId(targetId);
            this.families.add(target);
        }
    }

    public void changeId(Individual target, int targetId) {
        if (target != null && targetId >= 0) {
            this.individuals.removeById(target.getId());
            target.setId(targetId);
            this.individuals.add(target);
        }
    }

    public boolean contains(int id) {
        boolean result = this.get(id) != null;
        return result;
    }

    public boolean containsSpouse(Individual v) {
        boolean result = false;
        if (!v.isSingle()) {
            for (Individual w : v.getSpouses()) {
                if (!this.contains(w.getId())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public Net copy() {
        Net result = this.copy(null);
        return result;
    }

    public Net copy(String suffix) {
        Net result = new Net(this);
        if (suffix != null) {
            result.setLabel(String.valueOf(result.getLabel()) + suffix);
        }
        return result;
    }

    public Family createFamily(NumberablesHashMap.IdStrategy idStrategy, Individual husband, Individual wife, Individual ... children) {
        Family result = new Family(this.families.nextFreeId(idStrategy), husband, wife);
        this.families.add(result);
        if (husband != null) {
            husband.getPersonalFamilies().add(result);
        }
        if (wife != null) {
            wife.getPersonalFamilies().add(result);
        }
        Individual[] individualArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Individual child = individualArray[n2];
            result.getChildren().put(child);
            child.setOriginFamily(result);
            ++n2;
        }
        return result;
    }

    public Family createFamily(Individual husband, Individual wife, Individual ... children) {
        Family result = this.createFamily(this.defaultIdStrategy, husband, wife, children);
        return result;
    }

    public Family createFamily(int id) throws PuckException {
        Family result = this.createFamily(id, null, null, UnionStatus.UNMARRIED);
        return result;
    }

    public Family createFamily(int id, Individual husband, Individual wife, UnionStatus unionStatus) throws PuckException {
        Family result = (Family)this.families.getById(id);
        if (result == null) {
            result = new Family(id, husband, wife);
            result.setUnionStatus(unionStatus);
            this.families.add(result);
            if (husband != null) {
                husband.addPersonalFamily(result);
            }
            if (wife != null) {
                wife.addPersonalFamily(result);
            }
        } else {
            throw PuckExceptions.INVALID_PARAMETER.create("Family with id [" + id + "] is already existing.", new Object[0]);
        }
        return result;
    }

    public Individual createIndividual() {
        Individual result = this.createIndividual("", Gender.UNKNOWN);
        return result;
    }

    public Individual createIndividual(NumberablesHashMap.IdStrategy idStrategy, String name, Gender gender) {
        Individual result = new Individual(this.individuals().nextFreeId(idStrategy), name, gender);
        this.individuals.add(result);
        return result;
    }

    public Individual createIndividual(int id) throws PuckException {
        Individual result = this.createIndividual(id, "", Gender.UNKNOWN);
        return result;
    }

    public Individual createIndividual(int id, String name, Gender gender) throws PuckException {
        Individual result = (Individual)this.individuals.getById(id);
        if (result != null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Individual with id [" + id + "] is already existing.", new Object[0]);
        }
        result = new Individual(id, name, gender);
        this.individuals.add(result);
        return result;
    }

    public Individual createIndividual(String name, Gender gender) {
        Individual result = this.createIndividual(this.defaultIdStrategy, name, gender);
        return result;
    }

    public Relation createRelation(int typedId, String name, RelationModel model) {
        Relation result = new Relation(this.relations().nextFreeId(NumberablesHashMap.IdStrategy.FILL), typedId, model, name, new Actor[0]);
        this.relations.add(result);
        return result;
    }

    public Relation createRelation(String name, RelationModel model) {
        Relation result = new Relation(this.relations().nextFreeId(NumberablesHashMap.IdStrategy.FILL), this.relations.getByModel(model).nextFreeTypedId(NumberablesHashMap.IdStrategy.FILL), model, name, new Actor[0]);
        this.relations.add(result);
        return result;
    }

    public Actor createRelationActor(Relation relation, int individualId, String roleName) throws PuckException {
        if (relation == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Invalid null relation.", new Object[0]);
        }
        if (individualId < 1) {
            throw PuckExceptions.INVALID_PARAMETER.create("Invalid individual id.", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)roleName)) {
            throw PuckExceptions.INVALID_PARAMETER.create("Invalid null role name.", new Object[0]);
        }
        Role role = relation.getModel().roles().getByName(roleName);
        if (role == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Unknown role [" + roleName + "].", new Object[0]);
        }
        Individual individual = (Individual)this.individuals().getById(individualId);
        if (individual == null) {
            individual = new Individual(individualId);
            this.individuals.put(individual);
        }
        Actor result = new Actor(individual, role);
        relation.actors().add(result);
        individual.relations().add(relation);
        return result;
    }

    public RelationModel createRelationModel(RelationModel source) throws PuckException {
        if (source == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter.", new Object[0]);
        }
        if (this.relationModels.getByName(source.getName()) != null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Relation model name already in use.", new Object[0]);
        }
        RelationModel result = new RelationModel(source);
        this.relationModels.add(result);
        return result;
    }

    public RelationModel createRelationModel(String name) throws PuckException {
        if (this.relationModels.getByName(name) != null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Relation model name already in use.", new Object[0]);
        }
        RelationModel result = new RelationModel(name);
        this.relationModels.add(result);
        return result;
    }

    public Role createRelationRole(RelationModel model, String roleName) {
        Role result;
        if (model == null || StringUtils.isBlank((CharSequence)roleName)) {
            result = null;
        } else {
            result = model.roles().getByName(roleName);
            if (result == null) {
                result = new Role(roleName);
                model.roles().add(result);
            }
        }
        return result;
    }

    public int depth() {
        int result = StatisticsWorker.depth(this);
        return result;
    }

    public Families families() {
        Families result = this.families;
        return result;
    }

    public Individual get(int id) {
        Individual result = (Individual)this.individuals.getById(id);
        return result;
    }

    public Individual getCloneWithAttributes(Individual individual) {
        Individual result = this.get(individual.getId());
        if (result == null) {
            result = individual.cloneWithAttributes();
            this.individuals.put(result);
        }
        return result;
    }

    public NumberablesHashMap.IdStrategy getDefaultIdStrategy() {
        return this.defaultIdStrategy;
    }

    public String getLabel() {
        String result = this.label;
        return result;
    }

    public NumberedIntegers heightData() {
        NumberedIntegers result = new NumberedIntegers(this.individuals.size());
        for (Individual individual : this.individuals) {
            if (result.get(individual.getId()) != null) continue;
            result.put(individual.getId(), individual.height(result));
        }
        return result;
    }

    public Individuals individuals() {
        Individuals result = this.individuals;
        return result;
    }

    public RelationModels relationModels() {
        RelationModels result = this.relationModels;
        return result;
    }

    public Relations relations() {
        Relations result = this.relations;
        return result;
    }

    public void remove(Family source) {
        if (source != null) {
            Individual wife;
            Individual husband = source.getHusband();
            if (husband != null) {
                husband.getPersonalFamilies().removeById(source.getId());
                source.setHusband(null);
            }
            if ((wife = source.getWife()) != null) {
                wife.getPersonalFamilies().removeById(source.getId());
                source.setWife(null);
            }
            for (Individual child : source.getChildren()) {
                child.setOriginFamily(null);
            }
            source.getChildren().clear();
            this.families().removeById(source.getId());
        }
    }

    public void remove(Individual source) {
        if (source != null) {
            Family originFamily = source.getOriginFamily();
            if (originFamily != null) {
                originFamily.getChildren().removeById(source.getId());
                source.setOriginFamily(null);
            }
            for (Family family : source.getPersonalFamilies()) {
                if (family.getHusband() == source) {
                    family.setHusband(null);
                } else if (family.getWife() == source) {
                    family.setWife(null);
                }
                if (!family.isEmpty()) continue;
                this.remove(family);
            }
            source.getPersonalFamilies().clear();
            for (Relation relation : source.relations()) {
                relation.removeActor(source.getId());
            }
            source.relations().clear();
            this.individuals().removeById(source.getId());
        }
    }

    public void remove(Relation source) {
        if (source != null) {
            for (Actor actor : source.actors().toList()) {
                actor.getIndividual().relations().remove(source);
            }
            this.relations.removeById(source.getId());
        }
    }

    public void remove(RelationModel source) {
        Relations relations;
        if (source != null && (relations = this.relations.getByModel(source)).isEmpty()) {
            this.relationModels.remove(source);
        }
    }

    public void removeChild(Individual child) {
        if (child != null && child.getOriginFamily() != null) {
            child.getOriginFamily().getChildren().removeById(child.getId());
            child.setOriginFamily(null);
        }
    }

    public void removeRelationActor(Relation relation, Actor actor) {
        relation.actors().remove(actor);
        actor.getIndividual().relations().remove(relation);
    }

    public void removeRelationRole(RelationModel model, Role role) {
        this.relations.removeRelationRole(model, role);
    }

    public void replaceIndividualInActor(Relation relation, Actor actor, Individual newIndividual) {
        if (relation != null && actor != null && newIndividual != null) {
            Individual oldIndividual = actor.getIndividual();
            actor.setIndividual(newIndividual);
            if (!relation.hasActor(oldIndividual)) {
                oldIndividual.relations().remove(relation);
            }
            if (!newIndividual.relations().contains(relation)) {
                newIndividual.relations().add(relation);
            }
        }
    }

    public void setDefaultIdStrategy(NumberablesHashMap.IdStrategy idStrategy) {
        this.defaultIdStrategy = idStrategy;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int size() {
        int result = this.individuals().size();
        return result;
    }
}

