/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.matrix;

import fr.devinsy.util.StringList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.tip.puck.PuckException;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.random.RandomCriteria;
import org.tip.puck.graphs.random.RandomGraphMaker;
import org.tip.puck.matrix.Matrix;
import org.tip.puck.util.Value;
import umontreal.iro.lecuyer.probdist.StudentDist;
import umontreal.iro.lecuyer.stat.Tally;

public class MatrixStatistics {
    private Tally tally;
    private double sum = 0.0;
    private double arcCount = 0.0;
    private double nodeCount = 0.0;
    private double maxNumberOfCircuits = 0.0;
    private int runs;
    private double endogamyIndex = 0.0;
    private double concentrationIndex = 0.0;
    private double minimumConcentration;
    private double symmetryIndex = 0.0;
    private double endogamicConcentrationIndex = 0.0;
    private double strengthConcentrationIndex = 0.0;
    private double endogamicStrengthConcentrationIndex = 0.0;
    private double strengthSymmetryIndex = 0.0;
    private double strengthProductSum = 0.0;
    private double endogamousClosureRate = 0.0;
    private double numberOfLoops = 0.0;
    private double numberOfCircuits = 0.0;
    private double numberOfParallelCircuits = 0.0;
    private double numberOfCrossCircuits = 0.0;
    private double balanceOfParallelVsCrossCircuits = 0.0;
    private double numberOfTriangles = 0.0;
    private double numberOfCyclicTriangles = 0.0;
    private double numberOfTransitiveTriangles = 0.0;
    private double maxWeight = 0.0;
    private double maxStrength = 0.0;
    private double normalizedNumberOfCircuits = 0.0;
    private double normalizedNumberOfParallelCircuits = 0.0;
    private double normalizedNumberOfCrossCircuits = 0.0;
    private double normalizedBalanceOfParallelVsCrossCircuits = 0.0;
    private double normalizedNumberOfTriangles = 0.0;
    private double normalizedNumberOfCyclicTriangles = 0.0;
    private double normalizedNumberOfTransitiveTriangles = 0.0;
    private double expectedConcentrationIndex = 0.0;
    private double expectedEndogamicConcentrationIndex = 0.0;
    private double expectedSymmetryIndex = 0.0;
    private double expectedEndogamyIndex = 0.0;
    private double expectedNumberOfLoops = 0.0;
    private double expectedNumberOfCircuits = 0.0;
    private double expectedNumberOfParallelCircuits = 0.0;
    private double expectedNumberOfCrossCircuits = 0.0;
    private double expectedBalanceOfParallelVsCrossCircuits = 0.0;
    private double expectedNumberOfTriangles = 0.0;
    private double expectedNumberOfCyclicTriangles = 0.0;
    private double expectedNumberOfTransitiveTriangles = 0.0;
    private double expectedNormalizedNumberOfCircuits = 0.0;
    private double expectedNormalizedNumberOfParallelCircuits = 0.0;
    private double expectedNormalizedNumberOfCrossCircuits = 0.0;
    private double expectedNormalizedBalanceOfParallelVsCrossCircuits = 0.0;
    private double expectedNormalizedNumberOfTriangles = 0.0;
    private double expectedNormalizedNumberOfCyclicTriangles = 0.0;
    private double expectedNormalizedNumberOfTransitiveTriangles = 0.0;
    private double divergenceOfConcentration = 0.0;
    private double divergenceOfEndogamicConcentration = 0.0;
    private double divergenceOfSymmetry = 0.0;
    private double divergenceOfLoops = 0.0;
    private double divergenceOfCircuits = 0.0;
    private double divergenceOfParallelCircuits = 0.0;
    private double divergenceOfCrossCircuits = 0.0;
    private double divergenceOfBalanceOfParallelVsCrossCircuits = 0.0;
    private double divergenceOfTriangles = 0.0;
    private double divergenceOfCyclicTriangles = 0.0;
    private double divergenceOfTransitiveTriangles = 0.0;
    private double divergenceOfNormalizedLoops = 0.0;
    private double divergenceOfNormalizedCircuits = 0.0;
    private double divergenceOfNormalizedParallelCircuits = 0.0;
    private double divergenceOfNormalizedCrossCircuits = 0.0;
    private double divergenceOfNormalizedBalanceOfParallelVsCrossCircuits = 0.0;
    private double divergenceOfNormalizedTriangles = 0.0;
    private double divergenceOfNormalizedCyclicTriangles = 0.0;
    private double divergenceOfNormalizedTransitiveTriangles = 0.0;
    private double overestimationOfLoops = 0.0;
    private double overestimationOfCircuits = 0.0;
    private double overestimationOfParallelCircuits = 0.0;
    private double overestimationOfCrossCircuits = 0.0;
    private double overestimationOfBalanceOfParallelVsCrossCircuits = 0.0;
    private double overestimationOfTriangles = 0.0;
    private double overestimationOfCyclicTriangles = 0.0;
    private double overestimationOfTransitiveTriangles = 0.0;
    private double overestimationOfConcentration = 0.0;
    private double overestimationOfEndogamicConcentration = 0.0;
    private double overestimationOfSymmetry = 0.0;
    private double overestimationOfStrengthConcentration = 0.0;
    private double overestimationOfEndogamicStrengthConcentration = 0.0;
    private double overestimationOfStrengthSymmetry = 0.0;
    private double overestimationOfExpectedLoops = 0.0;
    private double overestimationOfExpectedCircuits = 0.0;
    private double overestimationOfExpectedParallelCircuits = 0.0;
    private double overestimationOfExpectedCrossCircuits = 0.0;
    private double overestimationOfExpectedBalanceOfParallelVsCrossCircuits = 0.0;
    private double overestimationOfExpectedTriangles = 0.0;
    private double overestimationOfExpectedCyclicTriangles = 0.0;
    private double overestimationOfExpectedTransitiveTriangles = 0.0;
    private double overestimationOfExpectedConcentration = 0.0;
    private double overestimationOfExpectedEndogamicConcentration = 0.0;
    private double overestimationOfExpectedSymmetry = 0.0;
    private double overestimationOfExpectedStrengthConcentration = 0.0;
    private double overestimationOfExpectedEndogamicStrengthConcentration = 0.0;
    private double overestimationOfExpectedStrengthSymmetry = 0.0;
    private double overestimationOfDivergenceOfLoops = 0.0;
    private double overestimationOfDivergenceOfCircuits = 0.0;
    private double overestimationOfDivergenceOfParallelCircuits = 0.0;
    private double overestimationOfDivergenceOfCrossCircuits = 0.0;
    private double overestimationOfDivergenceOfBalanceOfParallelVsCrossCircuits = 0.0;
    private double overestimationOfDivergenceOfTriangles = 0.0;
    private double overestimationOfDivergenceOfCyclicTriangles = 0.0;
    private double overestimationOfDivergenceOfTransitiveTriangles = 0.0;
    private double overestimationOfDivergenceOfConcentration = 0.0;
    private double overestimationOfDivergenceOfEndogamicConcentration = 0.0;
    private double overestimationOfDivergenceOfSymmetry = 0.0;
    private double overestimationOfDivergenceOfStrengthConcentration = 0.0;
    private double overestimationOfDivergenceOfEndogamicStrengthConcentration = 0.0;
    private double overestimationOfDivergenceOfStrengthSymmetry = 0.0;
    private double squareDivergenceOfConcentration = 0.0;
    private double squareDivergenceOfEndogamicConcentration = 0.0;
    private double squareDivergenceOfSymmetry = 0.0;
    private double squareDivergenceOfLoops = 0.0;
    private double squareDivergenceOfCircuits = 0.0;
    private double squareDivergenceOfParallelCircuits = 0.0;
    private double squareDivergenceOfCrossCircuits = 0.0;
    private double squareDivergenceOfBalanceOfParallelVsCrossCircuits = 0.0;
    private double squareDivergenceOfTriangles = 0.0;
    private double squareDivergenceOfCyclicTriangles = 0.0;
    private double squareDivergenceOfTransitiveTriangles = 0.0;
    private double squareDivergenceOfNormalizedLoops = 0.0;
    private double squareDivergenceOfNormalizedCircuits = 0.0;
    private double squareDivergenceOfNormalizedParallelCircuits = 0.0;
    private double squareDivergenceOfNormalizedCrossCircuits = 0.0;
    private double squareDivergenceOfNormalizedBalanceOfParallelVsCrossCircuits = 0.0;
    private double squareDivergenceOfNormalizedTriangles = 0.0;
    private double squareDivergenceOfNormalizedCyclicTriangles = 0.0;
    private double squareDivergenceOfNormalizedTransitiveTriangles = 0.0;
    private Graph graph;

    public static String getValueString(Graph graph) throws PuckException {
        String result = graph.getLabel();
        MatrixStatistics worker = new MatrixStatistics(graph);
        Indicator[] indicatorArray = Indicator.values();
        int n = indicatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Indicator indicator = indicatorArray[n2];
            result = String.valueOf(result) + "\t";
            Value value = new Value(worker.getNumber(indicator));
            if (value != null) {
                result = String.valueOf(result) + value.toString();
            }
            ++n2;
        }
        return result;
    }

    public static Map<Double, Double> getDistribution(DistributionObject dist, Matrix source) {
        Map<Double, Double> result = null;
        switch (dist) {
            case WEIGHTS: {
                result = MatrixStatistics.getDistributionOfWeights(source);
                break;
            }
            case STRENGTHS: {
                result = MatrixStatistics.getDistributionOfStrengths(source);
            }
        }
        return result;
    }

    public static Map<Double, Double> getDistribution(DistributionObject dist, Graph source) {
        Map<Double, Double> result = null;
        switch (dist) {
            case WEIGHTS: {
                result = MatrixStatistics.getDistributionOfWeights(source);
                break;
            }
            case STRENGTHS: {
                result = MatrixStatistics.getDistributionOfStrengths(source);
            }
        }
        return result;
    }

    public static Map<Double, Double> getDistributionOfStrengths(Graph source) {
        Matrix matrix = source.getSquareMatrix().getMatrix();
        Map<Double, Double> result = MatrixStatistics.getDistributionOfStrengths(matrix);
        return result;
    }

    public static Map<Double, Double> getDistributionOfStrengths(Matrix matrix) {
        HashMap<Double, Double> result = new HashMap<Double, Double>();
        double inc = new Double(1.0 / (double)matrix.getRowDim());
        int i = 0;
        while (i < matrix.getRowDim()) {
            double value = matrix.getRowSum(i) + matrix.getColSum(i);
            Double frequency = (Double)result.get(value);
            frequency = frequency == null ? Double.valueOf(inc) : Double.valueOf(frequency + inc);
            result.put(value, frequency);
            ++i;
        }
        return result;
    }

    public static Map<Double, Double> getDistributionOfWeights(Graph source) {
        Matrix matrix = source.getSquareMatrix().getMatrix();
        Map<Double, Double> result = MatrixStatistics.getDistributionOfWeights(matrix);
        return result;
    }

    public static Map<Double, Double> getDistributionOfWeights(Matrix matrix) {
        HashMap<Double, Double> result = new HashMap<Double, Double>();
        double inc = new Double(1.0 / (double)(matrix.getRowDim() * matrix.getColDim()));
        int i = 0;
        while (i < matrix.getRowDim()) {
            int j = 0;
            while (j < matrix.getColDim()) {
                double value = matrix.get(i, j);
                Double frequency = (Double)result.get(value);
                frequency = frequency == null ? Double.valueOf(inc) : Double.valueOf(frequency + inc);
                result.put(value, frequency);
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static <E> Map<Double, Double> getRandomDistribution(DistributionObject dist, Graph source, RandomCriteria criteria, int interval, int runs) {
        HashMap<Double, Double> result = new HashMap<Double, Double>();
        int run = 0;
        while (run < runs) {
            RandomGraphMaker randomGraphMaker = new RandomGraphMaker(criteria);
            Graph randomGraph = source != null ? randomGraphMaker.createRandomGraphByObserverSimulation(source) : randomGraphMaker.createRandomGraphByAgentSimulation();
            Map<Double, Double> distribution = MatrixStatistics.getDistribution(dist, randomGraph);
            for (Double key : distribution.keySet()) {
                Double value = (Double)result.get(key);
                if (value == null) {
                    value = 0.0;
                }
                value = value + distribution.get(key);
                result.put(key, value);
            }
            ++run;
        }
        for (Double key : result.keySet()) {
            Double value = (Double)result.get(key);
            if (value == null) continue;
            value = value / (double)runs;
        }
        return result;
    }

    public static <E> Map<Double, Double[]> getRandomDistributions(DistributionObject dist, Graph source, RandomCriteria criteria, int runs, int nrSeries, int variableIndex, int variableIntervalFactor) {
        Double[] value;
        HashMap<Double, Double[]> result = new HashMap<Double, Double[]>();
        int start = 0;
        if (source != null) {
            start = 1;
            Map<Double, Double> distribution = MatrixStatistics.getDistribution(dist, source);
            for (Double key : distribution.keySet()) {
                value = new Double[nrSeries];
                value[0] = distribution.get(key);
                result.put(key, value);
            }
        }
        int series = start;
        while (series < nrSeries) {
            int run = 0;
            while (run < runs) {
                RandomGraphMaker randomGraphMaker = new RandomGraphMaker(criteria);
                Graph randomGraph = source != null ? randomGraphMaker.createRandomGraphByObserverSimulation(source) : randomGraphMaker.createRandomGraphByAgentSimulation();
                Map<Double, Double> distribution = MatrixStatistics.getDistribution(dist, randomGraph);
                for (Double key : distribution.keySet()) {
                    Double[] value2 = (Double[])result.get(key);
                    if (value2 == null) {
                        value2 = new Double[nrSeries];
                        value2[series] = 0.0;
                        result.put(key, value2);
                    } else if (value2[series] == null) {
                        value2[series] = 0.0;
                    }
                    int n = series;
                    value2[n] = value2[n] + distribution.get(key);
                }
                ++run;
            }
            for (Double key : result.keySet()) {
                value = (Double[])result.get(key);
                if (value == null || value[series] == null) continue;
                value[series] = value[series] / (double)runs;
            }
            criteria.getInertia()[variableIndex] = criteria.getInertia()[variableIndex] * (double)variableIntervalFactor;
            ++series;
        }
        return result;
    }

    public MatrixStatistics() {
    }

    public MatrixStatistics(Graph source) {
        this.graph = source;
        Matrix matrix = source.getSquareMatrix().getMatrix();
        this.analyze(matrix);
    }

    private void analyze(Matrix matrix) {
        this.sum = matrix.getSum();
        this.nodeCount = matrix.getRowDim();
        this.maxNumberOfCircuits = new Double(Math.pow(this.sum, 2.0)) / 2.0;
        double squareSum = 0.0;
        double crossSum = 0.0;
        double loopSum = 0.0;
        double squareLoopSum = 0.0;
        double sumSquare = Math.pow(this.sum, 2.0);
        double sumDoubleSquare = Math.pow(this.sum, 4.0);
        double squareOutStrengthSum = 0.0;
        double squareInStrengthSum = 0.0;
        double squareStrengthProductSum = 0.0;
        this.strengthProductSum = 0.0;
        this.numberOfCyclicTriangles = 0.0;
        this.numberOfTransitiveTriangles = 0.0;
        int i = 0;
        while (i < matrix.getRowDim()) {
            int colSum;
            loopSum += (double)matrix.get(i, i);
            squareLoopSum += Math.pow(matrix.get(i, i), 2.0);
            int rowSum = matrix.getRowSum(i);
            double strength = rowSum + (colSum = matrix.getColSum(i));
            if (strength > this.maxStrength) {
                this.maxStrength = strength;
            }
            squareOutStrengthSum += Math.pow(rowSum, 2.0);
            squareInStrengthSum += Math.pow(colSum, 2.0);
            this.strengthProductSum += (double)(rowSum * colSum);
            squareStrengthProductSum += Math.pow(rowSum * colSum, 2.0);
            int j = 0;
            while (j < matrix.getColDim()) {
                squareSum += Math.pow(matrix.get(i, j), 2.0);
                crossSum += (double)(matrix.get(i, j) * matrix.get(j, i));
                if ((double)matrix.get(i, j) > this.maxWeight) {
                    this.maxWeight = matrix.get(i, j);
                }
                if (matrix.get(i, j) > 0) {
                    int k = 0;
                    while (k < matrix.getRowDim()) {
                        int indirectPaths = matrix.get(i, j) * matrix.get(j, k);
                        if (i < j && j < k) {
                            this.numberOfCyclicTriangles += (double)(indirectPaths * matrix.get(k, i));
                        }
                        if (i != j && j != k && k != i) {
                            this.numberOfTransitiveTriangles += (double)(indirectPaths * matrix.get(i, k));
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        this.concentrationIndex = squareSum / sumSquare;
        this.minimumConcentration = 1.0 / Math.pow(matrix.getRowDim(), 2.0);
        this.endogamousClosureRate = loopSum / this.strengthProductSum;
        this.symmetryIndex = crossSum / squareSum;
        this.endogamicConcentrationIndex = loopSum > 0.0 ? squareLoopSum / Math.pow(loopSum, 2.0) : 0.0;
        this.endogamyIndex = loopSum / this.sum;
        this.numberOfLoops = new Double(loopSum).intValue();
        this.numberOfParallelCircuits = new Double(squareSum - this.sum - squareLoopSum + loopSum).intValue() / 2;
        this.normalizedNumberOfParallelCircuits = (squareSum - this.sum - squareLoopSum + loopSum) / sumSquare;
        this.numberOfCrossCircuits = new Double(crossSum - squareLoopSum).intValue() / 2;
        this.normalizedNumberOfCrossCircuits = (crossSum - squareLoopSum) / sumSquare;
        this.balanceOfParallelVsCrossCircuits = this.numberOfParallelCircuits - this.numberOfCrossCircuits;
        this.numberOfCircuits = this.numberOfParallelCircuits + this.numberOfCrossCircuits;
        this.numberOfTriangles = this.numberOfCyclicTriangles + this.numberOfTransitiveTriangles;
        this.normalizedNumberOfCircuits = this.normalizedNumberOfParallelCircuits + this.normalizedNumberOfCrossCircuits;
        this.normalizedNumberOfTriangles = this.numberOfTriangles / Math.pow(this.sum, 3.0);
        this.strengthConcentrationIndex = squareInStrengthSum * squareOutStrengthSum / sumDoubleSquare;
        this.endogamicStrengthConcentrationIndex = squareStrengthProductSum / Math.pow(this.strengthProductSum, 2.0);
        this.strengthSymmetryIndex = Math.pow(squareStrengthProductSum, 0.5) / this.strengthProductSum;
        double factor0 = new Double(1.0 / this.sum);
        double factor1 = this.sum * (this.sum - 1.0) / 2.0;
        double factor2 = 1.0 - factor0;
        double factor3 = factor2 * Math.pow(this.strengthProductSum, 2.0) / sumDoubleSquare + factor0 * this.strengthProductSum / sumSquare;
        double factor4 = factor2 * squareStrengthProductSum / sumDoubleSquare + factor0 * this.strengthProductSum / sumSquare;
        this.expectedEndogamyIndex = this.strengthProductSum / sumSquare;
        this.expectedNumberOfLoops = this.expectedEndogamyIndex * this.sum;
        this.expectedConcentrationIndex = factor2 * this.strengthConcentrationIndex + factor0;
        this.expectedSymmetryIndex = factor3 / this.expectedConcentrationIndex;
        this.expectedEndogamicConcentrationIndex = factor4 / factor3;
        double expectedRelativeNumberOfParallelCircuits = this.strengthConcentrationIndex - squareStrengthProductSum / sumDoubleSquare;
        double expectedRelativeNumberOfCrossCircuits = Math.pow(this.strengthProductSum, 2.0) / sumDoubleSquare - squareStrengthProductSum / sumDoubleSquare;
        this.expectedNumberOfParallelCircuits = factor1 * expectedRelativeNumberOfParallelCircuits;
        this.expectedNumberOfCrossCircuits = factor1 * expectedRelativeNumberOfCrossCircuits;
        this.expectedNumberOfCircuits = this.expectedNumberOfParallelCircuits + this.expectedNumberOfCrossCircuits;
        this.expectedBalanceOfParallelVsCrossCircuits = this.expectedNumberOfParallelCircuits - this.expectedNumberOfCrossCircuits;
        this.expectedNormalizedNumberOfParallelCircuits = factor2 * expectedRelativeNumberOfParallelCircuits;
        this.expectedNormalizedNumberOfCrossCircuits = factor2 * expectedRelativeNumberOfCrossCircuits;
        this.expectedNormalizedNumberOfCircuits = this.expectedNormalizedNumberOfParallelCircuits + this.expectedNormalizedNumberOfCrossCircuits;
        this.setDivergences();
    }

    public void setOverestimation(Indicator indicator, MatrixStatistics sourceStats) {
        switch (indicator) {
            case CONCENTRATION: {
                this.overestimationOfConcentration = this.concentrationIndex / sourceStats.concentrationIndex;
                break;
            }
            case SYMMETRY: {
                this.overestimationOfSymmetry = this.symmetryIndex / sourceStats.symmetryIndex;
                break;
            }
            case ENDOGAMIC_CONCENTRATION: {
                this.overestimationOfEndogamicConcentration = this.endogamicConcentrationIndex / sourceStats.endogamicConcentrationIndex;
                break;
            }
            case STRENGTH_CONCENTRATION: {
                this.overestimationOfStrengthConcentration = this.strengthConcentrationIndex / sourceStats.strengthConcentrationIndex;
                break;
            }
            case STRENGTH_SYMMETRY: {
                this.overestimationOfStrengthSymmetry = this.strengthSymmetryIndex / sourceStats.strengthSymmetryIndex;
                break;
            }
            case ENDOGAMIC_STRENGTH_CONCENTRATION: {
                this.overestimationOfEndogamicStrengthConcentration = this.endogamicStrengthConcentrationIndex / sourceStats.endogamicStrengthConcentrationIndex;
                break;
            }
            case LOOPS: {
                this.overestimationOfLoops = this.endogamyIndex / sourceStats.endogamyIndex;
                break;
            }
            case DUAL_CIRCUITS: {
                this.overestimationOfCircuits = this.normalizedNumberOfCircuits / sourceStats.normalizedNumberOfCircuits;
                break;
            }
            case PARALLEL_CIRCUITS: {
                this.overestimationOfParallelCircuits = this.normalizedNumberOfParallelCircuits / sourceStats.normalizedNumberOfParallelCircuits;
                break;
            }
            case CROSS_CIRCUITS: {
                this.overestimationOfCrossCircuits = this.normalizedNumberOfCrossCircuits / sourceStats.normalizedNumberOfCrossCircuits;
                break;
            }
            case BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS: {
                this.overestimationOfBalanceOfParallelVsCrossCircuits = this.normalizedBalanceOfParallelVsCrossCircuits / sourceStats.normalizedBalanceOfParallelVsCrossCircuits;
                break;
            }
            case TRIANGLES: {
                this.overestimationOfTriangles = this.normalizedNumberOfTriangles / sourceStats.normalizedNumberOfTriangles;
                break;
            }
            case TRANSITIVE_TRIANGLES: {
                this.overestimationOfTransitiveTriangles = this.normalizedNumberOfTransitiveTriangles / sourceStats.normalizedNumberOfTransitiveTriangles;
                break;
            }
            case CYCLIC_TRIANGLES: {
                this.overestimationOfCyclicTriangles = this.normalizedNumberOfCyclicTriangles / sourceStats.normalizedNumberOfCyclicTriangles;
            }
        }
    }

    public void setOverestimationOfExpectation(Indicator indicator, MatrixStatistics sourceStats) {
        switch (indicator) {
            case CONCENTRATION: {
                this.overestimationOfExpectedConcentration = this.expectedConcentrationIndex / sourceStats.expectedConcentrationIndex;
                break;
            }
            case SYMMETRY: {
                this.overestimationOfExpectedSymmetry = this.expectedSymmetryIndex / sourceStats.expectedSymmetryIndex;
                break;
            }
            case ENDOGAMIC_CONCENTRATION: {
                this.overestimationOfExpectedEndogamicConcentration = this.expectedEndogamicConcentrationIndex / sourceStats.expectedEndogamicConcentrationIndex;
                break;
            }
            case LOOPS: {
                this.overestimationOfExpectedLoops = this.expectedEndogamyIndex / sourceStats.expectedEndogamyIndex;
                break;
            }
            case DUAL_CIRCUITS: {
                this.overestimationOfExpectedCircuits = this.expectedNormalizedNumberOfCircuits / sourceStats.expectedNormalizedNumberOfCircuits;
                break;
            }
            case PARALLEL_CIRCUITS: {
                this.overestimationOfExpectedParallelCircuits = this.expectedNormalizedNumberOfParallelCircuits / sourceStats.expectedNormalizedNumberOfParallelCircuits;
                break;
            }
            case CROSS_CIRCUITS: {
                this.overestimationOfExpectedCrossCircuits = this.expectedNormalizedNumberOfCrossCircuits / sourceStats.expectedNormalizedNumberOfCrossCircuits;
                break;
            }
            case BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS: {
                this.overestimationOfExpectedBalanceOfParallelVsCrossCircuits = this.expectedNormalizedBalanceOfParallelVsCrossCircuits / sourceStats.expectedNormalizedBalanceOfParallelVsCrossCircuits;
                break;
            }
            case TRIANGLES: {
                this.overestimationOfExpectedTriangles = this.expectedNormalizedNumberOfTriangles / sourceStats.expectedNormalizedNumberOfTriangles;
                break;
            }
            case TRANSITIVE_TRIANGLES: {
                this.overestimationOfExpectedTransitiveTriangles = this.expectedNormalizedNumberOfTransitiveTriangles / sourceStats.expectedNormalizedNumberOfTransitiveTriangles;
                break;
            }
            case CYCLIC_TRIANGLES: {
                this.overestimationOfExpectedCyclicTriangles = this.expectedNormalizedNumberOfCyclicTriangles / sourceStats.expectedNormalizedNumberOfCyclicTriangles;
            }
        }
    }

    public void compareValues(MatrixStatistics sourceStats) {
        if (sourceStats != null) {
            Indicator[] indicatorArray = Indicator.values();
            int n = indicatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Indicator indicator = indicatorArray[n2];
                this.setOverestimation(indicator, sourceStats);
                this.setOverestimationOfExpectation(indicator, sourceStats);
                this.setOverestimationOfDivergence(indicator);
                ++n2;
            }
        }
    }

    public double getArcCount() {
        return this.arcCount;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public double getMaximalNumberOfCircuits() {
        return this.maxNumberOfCircuits;
    }

    public double getMinimumConcentration() {
        return this.minimumConcentration;
    }

    public double getSum() {
        return this.sum;
    }

    private void incrementSquareDivergences(MatrixStatistics stats) {
        this.squareDivergenceOfConcentration += Math.pow(stats.divergenceOfConcentration, 2.0);
        this.squareDivergenceOfEndogamicConcentration += Math.pow(stats.divergenceOfEndogamicConcentration, 2.0);
        this.squareDivergenceOfSymmetry += Math.pow(stats.divergenceOfSymmetry, 2.0);
        this.squareDivergenceOfLoops += Math.pow(stats.divergenceOfLoops, 2.0);
        this.squareDivergenceOfCircuits += Math.pow(stats.divergenceOfCircuits, 2.0);
        this.squareDivergenceOfParallelCircuits += Math.pow(stats.divergenceOfParallelCircuits, 2.0);
        this.squareDivergenceOfCrossCircuits += Math.pow(stats.divergenceOfCrossCircuits, 2.0);
        this.squareDivergenceOfBalanceOfParallelVsCrossCircuits += Math.pow(stats.divergenceOfBalanceOfParallelVsCrossCircuits, 2.0);
        this.squareDivergenceOfTriangles += Math.pow(stats.divergenceOfTriangles, 2.0);
        this.squareDivergenceOfCyclicTriangles += Math.pow(stats.divergenceOfCyclicTriangles, 2.0);
        this.squareDivergenceOfTransitiveTriangles += Math.pow(stats.divergenceOfTransitiveTriangles, 2.0);
        this.squareDivergenceOfNormalizedLoops += Math.pow(stats.divergenceOfNormalizedLoops, 2.0);
        this.squareDivergenceOfNormalizedCircuits += Math.pow(stats.divergenceOfNormalizedCircuits, 2.0);
        this.squareDivergenceOfNormalizedParallelCircuits += Math.pow(stats.divergenceOfNormalizedParallelCircuits, 2.0);
        this.squareDivergenceOfNormalizedCrossCircuits += Math.pow(stats.divergenceOfNormalizedCrossCircuits, 2.0);
        this.squareDivergenceOfNormalizedBalanceOfParallelVsCrossCircuits += Math.pow(stats.divergenceOfNormalizedBalanceOfParallelVsCrossCircuits, 2.0);
        this.squareDivergenceOfNormalizedTriangles += Math.pow(stats.divergenceOfNormalizedTriangles, 2.0);
        this.squareDivergenceOfNormalizedCyclicTriangles += Math.pow(stats.divergenceOfNormalizedCyclicTriangles, 2.0);
        this.squareDivergenceOfNormalizedTransitiveTriangles += Math.pow(stats.divergenceOfNormalizedTransitiveTriangles, 2.0);
    }

    public void incrementValues(MatrixStatistics stats) {
        this.sum += stats.getSum();
        this.nodeCount += stats.getNodeCount();
        this.arcCount += stats.getArcCount();
        this.maxNumberOfCircuits += stats.getMaximalNumberOfCircuits();
        Indicator[] indicatorArray = Indicator.values();
        int n = indicatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Indicator indicator = indicatorArray[n2];
            Mode[] modeArray = Mode.values();
            int n3 = modeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Mode mode = modeArray[n4];
                this.set(indicator, mode, this.get(indicator, mode) + stats.get(indicator, mode));
                ++n4;
            }
            ++n2;
        }
        this.incrementSquareDivergences(stats);
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public void normalizeValues(int runs) {
        double n = new Double(runs);
        this.runs = runs;
        this.sum /= n;
        this.nodeCount /= n;
        this.arcCount /= n;
        this.maxNumberOfCircuits /= n;
        Indicator[] indicatorArray = Indicator.values();
        int n2 = indicatorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Indicator indicator = indicatorArray[n3];
            Mode[] modeArray = Mode.values();
            int n4 = modeArray.length;
            int n5 = 0;
            while (n5 < n4) {
                Mode mode = modeArray[n5];
                if (mode == Mode.DIVERGENCE) {
                    double squareSum = this.getSquareDivergence(indicator);
                    double sumSquare = Math.pow(this.getDivergence(indicator), 2.0);
                    double sigma = Math.pow((squareSum - sumSquare / n) / (n - 1.0), 0.5);
                    this.setSquareDivergence(indicator, sigma);
                }
                this.set(indicator, mode, this.get(indicator, mode) / n);
                ++n5;
            }
            ++n3;
        }
    }

    public double getOverestimationOfSymmetry() {
        return this.overestimationOfSymmetry;
    }

    public double get(Indicator indicator, Mode mode) {
        double result = 0.0;
        switch (mode) {
            case SIMPLE: {
                result = this.getNumber(indicator);
                break;
            }
            case EXPECTED: {
                result = this.getExpectedNumber(indicator);
                break;
            }
            case NORMALIZED: {
                result = this.getNormalizedNumber(indicator);
                break;
            }
            case EXPECTED_NORMALIZED: {
                result = this.getExpectedNormalizedNumber(indicator);
                break;
            }
            case DIVERGENCE: {
                result = this.getDivergence(indicator);
                break;
            }
            case DIVERGENCE_NORMALIZED: {
                result = this.getDivergenceNormalized(indicator);
                break;
            }
            case OVERESTIMATION: {
                result = this.getOverestimation(indicator);
                break;
            }
            case OVERESTIMATION_EXPECTED: {
                result = this.getOverestimationOfExpectation(indicator);
                break;
            }
            case OVERESTIMATION_DIVERGENCE: {
                result = this.getOverestimationOfDivergence(indicator);
            }
        }
        return result;
    }

    public double set(Indicator indicator, Mode mode, double value) {
        double result = 0.0;
        switch (mode) {
            case SIMPLE: {
                this.setNumber(indicator, value);
                break;
            }
            case EXPECTED: {
                this.setExpectedNumber(indicator, value);
                break;
            }
            case NORMALIZED: {
                this.setNormalizedNumber(indicator, value);
                break;
            }
            case EXPECTED_NORMALIZED: {
                this.setExpectedNormalizedNumber(indicator, value);
                break;
            }
            case DIVERGENCE: {
                this.setDivergence(indicator, value);
                break;
            }
            case DIVERGENCE_NORMALIZED: {
                this.setDivergenceNormalized(indicator, value);
            }
        }
        return result;
    }

    public double getNumber(Indicator indicator) {
        double result = 0.0;
        switch (indicator) {
            case CONCENTRATION: {
                result = this.concentrationIndex;
                break;
            }
            case SYMMETRY: {
                result = this.symmetryIndex;
                break;
            }
            case ENDOGAMIC_CONCENTRATION: {
                result = this.endogamicConcentrationIndex;
                break;
            }
            case STRENGTH_CONCENTRATION: {
                result = this.strengthConcentrationIndex;
                break;
            }
            case STRENGTH_SYMMETRY: {
                result = this.strengthSymmetryIndex;
                break;
            }
            case ENDOGAMIC_STRENGTH_CONCENTRATION: {
                result = this.endogamicStrengthConcentrationIndex;
                break;
            }
            case LOOPS: {
                result = this.numberOfLoops;
                break;
            }
            case DUAL_CIRCUITS: {
                result = this.numberOfCircuits;
                break;
            }
            case PARALLEL_CIRCUITS: {
                result = this.numberOfParallelCircuits;
                break;
            }
            case CROSS_CIRCUITS: {
                result = this.numberOfCrossCircuits;
                break;
            }
            case BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS: {
                result = this.balanceOfParallelVsCrossCircuits;
                break;
            }
            case TRIANGLES: {
                result = this.numberOfTriangles;
                break;
            }
            case TRANSITIVE_TRIANGLES: {
                result = this.numberOfTransitiveTriangles;
                break;
            }
            case CYCLIC_TRIANGLES: {
                result = this.numberOfCyclicTriangles;
                break;
            }
            case MAX_WEIGHT: {
                result = this.maxWeight;
                break;
            }
            case MAX_STRENGTH: {
                result = this.maxStrength;
            }
        }
        return result;
    }

    public double getOverestimation(Indicator indicator) {
        double result = 0.0;
        switch (indicator) {
            case CONCENTRATION: {
                result = this.overestimationOfConcentration;
                break;
            }
            case SYMMETRY: {
                result = this.overestimationOfSymmetry;
                break;
            }
            case ENDOGAMIC_CONCENTRATION: {
                result = this.overestimationOfEndogamicConcentration;
                break;
            }
            case STRENGTH_CONCENTRATION: {
                result = this.overestimationOfStrengthConcentration;
                break;
            }
            case STRENGTH_SYMMETRY: {
                result = this.overestimationOfStrengthSymmetry;
                break;
            }
            case ENDOGAMIC_STRENGTH_CONCENTRATION: {
                result = this.overestimationOfEndogamicStrengthConcentration;
                break;
            }
            case LOOPS: {
                result = this.overestimationOfLoops;
                break;
            }
            case DUAL_CIRCUITS: {
                result = this.overestimationOfCircuits;
                break;
            }
            case PARALLEL_CIRCUITS: {
                result = this.overestimationOfParallelCircuits;
                break;
            }
            case CROSS_CIRCUITS: {
                result = this.overestimationOfCrossCircuits;
                break;
            }
            case BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS: {
                result = this.overestimationOfBalanceOfParallelVsCrossCircuits;
                break;
            }
            case TRIANGLES: {
                result = this.overestimationOfTriangles;
                break;
            }
            case TRANSITIVE_TRIANGLES: {
                result = this.overestimationOfTransitiveTriangles;
                break;
            }
            case CYCLIC_TRIANGLES: {
                result = this.overestimationOfCyclicTriangles;
            }
        }
        return result;
    }

    public double getOverestimationOfExpectation(Indicator indicator) {
        double result = 0.0;
        switch (indicator) {
            case CONCENTRATION: {
                result = this.overestimationOfExpectedConcentration;
                break;
            }
            case SYMMETRY: {
                result = this.overestimationOfExpectedSymmetry;
                break;
            }
            case ENDOGAMIC_CONCENTRATION: {
                result = this.overestimationOfExpectedEndogamicConcentration;
                break;
            }
            case STRENGTH_CONCENTRATION: {
                result = this.overestimationOfExpectedStrengthConcentration;
                break;
            }
            case STRENGTH_SYMMETRY: {
                result = this.overestimationOfExpectedStrengthSymmetry;
                break;
            }
            case ENDOGAMIC_STRENGTH_CONCENTRATION: {
                result = this.overestimationOfExpectedEndogamicStrengthConcentration;
                break;
            }
            case LOOPS: {
                result = this.overestimationOfExpectedLoops;
                break;
            }
            case DUAL_CIRCUITS: {
                result = this.overestimationOfExpectedCircuits;
                break;
            }
            case PARALLEL_CIRCUITS: {
                result = this.overestimationOfExpectedParallelCircuits;
                break;
            }
            case CROSS_CIRCUITS: {
                result = this.overestimationOfExpectedCrossCircuits;
                break;
            }
            case BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS: {
                result = this.overestimationOfExpectedBalanceOfParallelVsCrossCircuits;
                break;
            }
            case TRIANGLES: {
                result = this.overestimationOfExpectedTriangles;
                break;
            }
            case TRANSITIVE_TRIANGLES: {
                result = this.overestimationOfExpectedTransitiveTriangles;
                break;
            }
            case CYCLIC_TRIANGLES: {
                result = this.overestimationOfExpectedCyclicTriangles;
            }
        }
        return result;
    }

    public double getOverestimationOfDivergence(Indicator indicator) {
        double result = 0.0;
        switch (indicator) {
            case CONCENTRATION: {
                result = this.overestimationOfDivergenceOfConcentration;
                break;
            }
            case SYMMETRY: {
                result = this.overestimationOfDivergenceOfSymmetry;
                break;
            }
            case ENDOGAMIC_CONCENTRATION: {
                result = this.overestimationOfDivergenceOfEndogamicConcentration;
                break;
            }
            case STRENGTH_CONCENTRATION: {
                result = this.overestimationOfDivergenceOfStrengthConcentration;
                break;
            }
            case STRENGTH_SYMMETRY: {
                result = this.overestimationOfDivergenceOfStrengthSymmetry;
                break;
            }
            case ENDOGAMIC_STRENGTH_CONCENTRATION: {
                result = this.overestimationOfDivergenceOfEndogamicStrengthConcentration;
                break;
            }
            case LOOPS: {
                result = this.overestimationOfDivergenceOfLoops;
                break;
            }
            case DUAL_CIRCUITS: {
                result = this.overestimationOfDivergenceOfCircuits;
                break;
            }
            case PARALLEL_CIRCUITS: {
                result = this.overestimationOfDivergenceOfParallelCircuits;
                break;
            }
            case CROSS_CIRCUITS: {
                result = this.overestimationOfDivergenceOfCrossCircuits;
                break;
            }
            case BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS: {
                result = this.overestimationOfDivergenceOfBalanceOfParallelVsCrossCircuits;
                break;
            }
            case TRIANGLES: {
                result = this.overestimationOfDivergenceOfTriangles;
                break;
            }
            case TRANSITIVE_TRIANGLES: {
                result = this.overestimationOfDivergenceOfTransitiveTriangles;
                break;
            }
            case CYCLIC_TRIANGLES: {
                result = this.overestimationOfDivergenceOfCyclicTriangles;
            }
        }
        return result;
    }

    public double getDivergence(Indicator indicator) {
        double result = 0.0;
        switch (indicator) {
            case CONCENTRATION: {
                result = this.divergenceOfConcentration;
                break;
            }
            case SYMMETRY: {
                result = this.divergenceOfSymmetry;
                break;
            }
            case ENDOGAMIC_CONCENTRATION: {
                result = this.divergenceOfEndogamicConcentration;
                break;
            }
            case LOOPS: {
                result = this.divergenceOfLoops;
                break;
            }
            case DUAL_CIRCUITS: {
                result = this.divergenceOfCircuits;
                break;
            }
            case PARALLEL_CIRCUITS: {
                result = this.divergenceOfParallelCircuits;
                break;
            }
            case CROSS_CIRCUITS: {
                result = this.divergenceOfCrossCircuits;
                break;
            }
            case BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS: {
                result = this.divergenceOfBalanceOfParallelVsCrossCircuits;
                break;
            }
            case TRIANGLES: {
                result = this.divergenceOfTriangles;
                break;
            }
            case TRANSITIVE_TRIANGLES: {
                result = this.divergenceOfTransitiveTriangles;
                break;
            }
            case CYCLIC_TRIANGLES: {
                result = this.divergenceOfCyclicTriangles;
            }
        }
        return result;
    }

    public double getSquareDivergence(Indicator indicator) {
        double result = 0.0;
        switch (indicator) {
            case CONCENTRATION: {
                result = this.squareDivergenceOfConcentration;
                break;
            }
            case SYMMETRY: {
                result = this.squareDivergenceOfSymmetry;
                break;
            }
            case ENDOGAMIC_CONCENTRATION: {
                result = this.squareDivergenceOfEndogamicConcentration;
                break;
            }
            case LOOPS: {
                result = this.squareDivergenceOfLoops;
                break;
            }
            case DUAL_CIRCUITS: {
                result = this.squareDivergenceOfCircuits;
                break;
            }
            case PARALLEL_CIRCUITS: {
                result = this.squareDivergenceOfParallelCircuits;
                break;
            }
            case CROSS_CIRCUITS: {
                result = this.squareDivergenceOfCrossCircuits;
                break;
            }
            case BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS: {
                result = this.squareDivergenceOfBalanceOfParallelVsCrossCircuits;
                break;
            }
            case TRIANGLES: {
                result = this.squareDivergenceOfTriangles;
                break;
            }
            case TRANSITIVE_TRIANGLES: {
                result = this.squareDivergenceOfTransitiveTriangles;
                break;
            }
            case CYCLIC_TRIANGLES: {
                result = this.squareDivergenceOfCyclicTriangles;
            }
        }
        return result;
    }

    public double getDivergenceNormalized(Indicator indicator) {
        double result = 0.0;
        switch (indicator) {
            case LOOPS: {
                result = this.divergenceOfNormalizedLoops;
                break;
            }
            case DUAL_CIRCUITS: {
                result = this.divergenceOfNormalizedCircuits;
                break;
            }
            case PARALLEL_CIRCUITS: {
                result = this.divergenceOfNormalizedParallelCircuits;
                break;
            }
            case CROSS_CIRCUITS: {
                result = this.divergenceOfNormalizedCrossCircuits;
                break;
            }
            case BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS: {
                result = this.divergenceOfNormalizedBalanceOfParallelVsCrossCircuits;
                break;
            }
            case TRIANGLES: {
                result = this.divergenceOfNormalizedTriangles;
                break;
            }
            case TRANSITIVE_TRIANGLES: {
                result = this.divergenceOfNormalizedTransitiveTriangles;
                break;
            }
            case CYCLIC_TRIANGLES: {
                result = this.divergenceOfNormalizedCyclicTriangles;
            }
        }
        return result;
    }

    public void setNumber(Indicator indicator, double value) {
        switch (indicator) {
            case CONCENTRATION: {
                this.concentrationIndex = value;
                break;
            }
            case SYMMETRY: {
                this.symmetryIndex = value;
                break;
            }
            case ENDOGAMIC_CONCENTRATION: {
                this.endogamicConcentrationIndex = value;
                break;
            }
            case STRENGTH_CONCENTRATION: {
                this.strengthConcentrationIndex = value;
                break;
            }
            case STRENGTH_SYMMETRY: {
                this.strengthSymmetryIndex = value;
                break;
            }
            case ENDOGAMIC_STRENGTH_CONCENTRATION: {
                this.endogamicStrengthConcentrationIndex = value;
                break;
            }
            case LOOPS: {
                this.numberOfLoops = value;
                break;
            }
            case DUAL_CIRCUITS: {
                this.numberOfCircuits = value;
                break;
            }
            case PARALLEL_CIRCUITS: {
                this.numberOfParallelCircuits = value;
                break;
            }
            case CROSS_CIRCUITS: {
                this.numberOfCrossCircuits = value;
                break;
            }
            case BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS: {
                this.balanceOfParallelVsCrossCircuits = value;
                break;
            }
            case TRIANGLES: {
                this.numberOfTriangles = value;
                break;
            }
            case TRANSITIVE_TRIANGLES: {
                this.numberOfTransitiveTriangles = value;
                break;
            }
            case CYCLIC_TRIANGLES: {
                this.numberOfCyclicTriangles = value;
                break;
            }
            case MAX_WEIGHT: {
                this.maxWeight = value;
                break;
            }
            case MAX_STRENGTH: {
                this.maxStrength = value;
            }
        }
    }

    public void setNormalizedNumber(Indicator indicator, double value) {
        switch (indicator) {
            case LOOPS: {
                this.endogamyIndex = value;
                break;
            }
            case DUAL_CIRCUITS: {
                this.normalizedNumberOfCircuits = value;
                break;
            }
            case PARALLEL_CIRCUITS: {
                this.normalizedNumberOfParallelCircuits = value;
                break;
            }
            case CROSS_CIRCUITS: {
                this.normalizedNumberOfCrossCircuits = value;
                break;
            }
            case BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS: {
                this.normalizedBalanceOfParallelVsCrossCircuits = value;
                break;
            }
            case TRIANGLES: {
                this.normalizedNumberOfTriangles = value;
                break;
            }
            case TRANSITIVE_TRIANGLES: {
                this.normalizedNumberOfTransitiveTriangles = value;
                break;
            }
            case CYCLIC_TRIANGLES: {
                this.normalizedNumberOfCyclicTriangles = value;
            }
        }
    }

    public void setExpectedNormalizedNumber(Indicator indicator, double value) {
        switch (indicator) {
            case LOOPS: {
                this.expectedEndogamyIndex = value;
                break;
            }
            case DUAL_CIRCUITS: {
                this.expectedNormalizedNumberOfCircuits = value;
                break;
            }
            case PARALLEL_CIRCUITS: {
                this.expectedNormalizedNumberOfParallelCircuits = value;
                break;
            }
            case CROSS_CIRCUITS: {
                this.expectedNormalizedNumberOfCrossCircuits = value;
                break;
            }
            case BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS: {
                this.expectedNormalizedBalanceOfParallelVsCrossCircuits = value;
                break;
            }
            case TRIANGLES: {
                this.expectedNormalizedNumberOfTriangles = value;
                break;
            }
            case TRANSITIVE_TRIANGLES: {
                this.expectedNormalizedNumberOfTransitiveTriangles = value;
                break;
            }
            case CYCLIC_TRIANGLES: {
                this.expectedNormalizedNumberOfCyclicTriangles = value;
            }
        }
    }

    public void setExpectedNumber(Indicator indicator, double value) {
        switch (indicator) {
            case CONCENTRATION: {
                this.expectedConcentrationIndex = value;
                break;
            }
            case SYMMETRY: {
                this.expectedSymmetryIndex = value;
                break;
            }
            case ENDOGAMIC_CONCENTRATION: {
                this.expectedEndogamicConcentrationIndex = value;
                break;
            }
            case LOOPS: {
                this.expectedNumberOfLoops = value;
                break;
            }
            case DUAL_CIRCUITS: {
                this.expectedNumberOfCircuits = value;
                break;
            }
            case PARALLEL_CIRCUITS: {
                this.expectedNumberOfParallelCircuits = value;
                break;
            }
            case CROSS_CIRCUITS: {
                this.expectedNumberOfCrossCircuits = value;
                break;
            }
            case BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS: {
                this.expectedBalanceOfParallelVsCrossCircuits = value;
                break;
            }
            case TRIANGLES: {
                this.expectedNumberOfTriangles = value;
                break;
            }
            case TRANSITIVE_TRIANGLES: {
                this.expectedNumberOfTransitiveTriangles = value;
                break;
            }
            case CYCLIC_TRIANGLES: {
                this.expectedNumberOfCyclicTriangles = value;
            }
        }
    }

    public void setDivergences() {
        Indicator[] indicatorArray = Indicator.values();
        int n = indicatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Indicator indicator = indicatorArray[n2];
            this.setDivergence(indicator, this.getNumber(indicator) / this.getExpectedNumber(indicator));
            this.setDivergenceNormalized(indicator, this.getNormalizedNumber(indicator) / this.getExpectedNormalizedNumber(indicator));
            ++n2;
        }
    }

    public void setDivergence(Indicator indicator, double value) {
        switch (indicator) {
            case CONCENTRATION: {
                this.divergenceOfConcentration = value;
                break;
            }
            case SYMMETRY: {
                this.divergenceOfSymmetry = value;
                break;
            }
            case ENDOGAMIC_CONCENTRATION: {
                this.divergenceOfEndogamicConcentration = value;
                break;
            }
            case LOOPS: {
                this.divergenceOfLoops = value;
                break;
            }
            case DUAL_CIRCUITS: {
                this.divergenceOfCircuits = value;
                break;
            }
            case PARALLEL_CIRCUITS: {
                this.divergenceOfParallelCircuits = value;
                break;
            }
            case CROSS_CIRCUITS: {
                this.divergenceOfCrossCircuits = value;
                break;
            }
            case BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS: {
                this.divergenceOfBalanceOfParallelVsCrossCircuits = value;
                break;
            }
            case TRIANGLES: {
                this.divergenceOfTriangles = value;
                break;
            }
            case TRANSITIVE_TRIANGLES: {
                this.divergenceOfTransitiveTriangles = value;
                break;
            }
            case CYCLIC_TRIANGLES: {
                this.divergenceOfCyclicTriangles = value;
            }
        }
    }

    public void setOverestimationOfDivergence(Indicator indicator) {
        double value = this.getOverestimation(indicator) / this.getOverestimationOfExpectation(indicator);
        switch (indicator) {
            case CONCENTRATION: {
                this.overestimationOfDivergenceOfConcentration = value;
                break;
            }
            case SYMMETRY: {
                this.overestimationOfDivergenceOfSymmetry = value;
                break;
            }
            case ENDOGAMIC_CONCENTRATION: {
                this.overestimationOfDivergenceOfEndogamicConcentration = value;
                break;
            }
            case LOOPS: {
                this.overestimationOfDivergenceOfLoops = value;
                break;
            }
            case DUAL_CIRCUITS: {
                this.overestimationOfDivergenceOfCircuits = value;
                break;
            }
            case PARALLEL_CIRCUITS: {
                this.overestimationOfDivergenceOfParallelCircuits = value;
                break;
            }
            case CROSS_CIRCUITS: {
                this.overestimationOfDivergenceOfCrossCircuits = value;
                break;
            }
            case BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS: {
                this.overestimationOfDivergenceOfBalanceOfParallelVsCrossCircuits = value;
                break;
            }
            case TRIANGLES: {
                this.overestimationOfDivergenceOfTriangles = value;
                break;
            }
            case TRANSITIVE_TRIANGLES: {
                this.overestimationOfDivergenceOfTransitiveTriangles = value;
                break;
            }
            case CYCLIC_TRIANGLES: {
                this.overestimationOfDivergenceOfCyclicTriangles = value;
            }
        }
    }

    public void setSquareDivergence(Indicator indicator, double value) {
        switch (indicator) {
            case CONCENTRATION: {
                this.squareDivergenceOfConcentration = value;
                break;
            }
            case SYMMETRY: {
                this.squareDivergenceOfSymmetry = value;
                break;
            }
            case ENDOGAMIC_CONCENTRATION: {
                this.squareDivergenceOfEndogamicConcentration = value;
                break;
            }
            case LOOPS: {
                this.squareDivergenceOfLoops = value;
                break;
            }
            case DUAL_CIRCUITS: {
                this.squareDivergenceOfCircuits = value;
                break;
            }
            case PARALLEL_CIRCUITS: {
                this.squareDivergenceOfParallelCircuits = value;
                break;
            }
            case CROSS_CIRCUITS: {
                this.squareDivergenceOfCrossCircuits = value;
                break;
            }
            case BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS: {
                this.squareDivergenceOfBalanceOfParallelVsCrossCircuits = value;
                break;
            }
            case TRIANGLES: {
                this.squareDivergenceOfTriangles = value;
                break;
            }
            case TRANSITIVE_TRIANGLES: {
                this.squareDivergenceOfTransitiveTriangles = value;
                break;
            }
            case CYCLIC_TRIANGLES: {
                this.squareDivergenceOfCyclicTriangles = value;
            }
        }
    }

    public void setDivergenceNormalized(Indicator indicator, double value) {
        switch (indicator) {
            case LOOPS: {
                this.divergenceOfNormalizedLoops = value;
                break;
            }
            case DUAL_CIRCUITS: {
                this.divergenceOfNormalizedCircuits = value;
                break;
            }
            case PARALLEL_CIRCUITS: {
                this.divergenceOfNormalizedParallelCircuits = value;
                break;
            }
            case CROSS_CIRCUITS: {
                this.divergenceOfNormalizedCrossCircuits = value;
                break;
            }
            case BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS: {
                this.divergenceOfNormalizedBalanceOfParallelVsCrossCircuits = value;
                break;
            }
            case TRIANGLES: {
                this.divergenceOfNormalizedTriangles = value;
                break;
            }
            case TRANSITIVE_TRIANGLES: {
                this.divergenceOfNormalizedTransitiveTriangles = value;
                break;
            }
            case CYCLIC_TRIANGLES: {
                this.divergenceOfNormalizedCyclicTriangles = value;
            }
        }
    }

    public double getNormalizedNumber(Indicator indicator) {
        double result = 0.0;
        switch (indicator) {
            case LOOPS: {
                result = this.endogamyIndex;
                break;
            }
            case DUAL_CIRCUITS: {
                result = this.normalizedNumberOfCircuits;
                break;
            }
            case PARALLEL_CIRCUITS: {
                result = this.normalizedNumberOfParallelCircuits;
                break;
            }
            case CROSS_CIRCUITS: {
                result = this.normalizedNumberOfCrossCircuits;
                break;
            }
            case BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS: {
                result = this.normalizedBalanceOfParallelVsCrossCircuits;
                break;
            }
            case TRIANGLES: {
                result = this.normalizedNumberOfTriangles;
                break;
            }
            case TRANSITIVE_TRIANGLES: {
                result = this.normalizedNumberOfTransitiveTriangles;
                break;
            }
            case CYCLIC_TRIANGLES: {
                result = this.normalizedNumberOfCyclicTriangles;
            }
        }
        return result;
    }

    public double getExpectedNumber(Indicator indicator) {
        double result = 0.0;
        switch (indicator) {
            case CONCENTRATION: {
                result = this.expectedConcentrationIndex;
                break;
            }
            case SYMMETRY: {
                result = this.expectedSymmetryIndex;
                break;
            }
            case ENDOGAMIC_CONCENTRATION: {
                result = this.expectedEndogamicConcentrationIndex;
                break;
            }
            case LOOPS: {
                result = this.expectedNumberOfLoops;
                break;
            }
            case DUAL_CIRCUITS: {
                result = this.expectedNumberOfCircuits;
                break;
            }
            case PARALLEL_CIRCUITS: {
                result = this.expectedNumberOfParallelCircuits;
                break;
            }
            case CROSS_CIRCUITS: {
                result = this.expectedNumberOfCrossCircuits;
                break;
            }
            case BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS: {
                result = this.expectedBalanceOfParallelVsCrossCircuits;
                break;
            }
            case TRIANGLES: {
                result = this.expectedNumberOfTriangles;
                break;
            }
            case TRANSITIVE_TRIANGLES: {
                result = this.expectedNumberOfTransitiveTriangles;
                break;
            }
            case CYCLIC_TRIANGLES: {
                result = this.expectedNumberOfCyclicTriangles;
            }
        }
        return result;
    }

    public double getExpectedNormalizedNumber(Indicator indicator) {
        double result = 0.0;
        switch (indicator) {
            case LOOPS: {
                result = this.expectedEndogamyIndex;
                break;
            }
            case DUAL_CIRCUITS: {
                result = this.expectedNormalizedNumberOfCircuits;
                break;
            }
            case PARALLEL_CIRCUITS: {
                result = this.expectedNormalizedNumberOfParallelCircuits;
                break;
            }
            case CROSS_CIRCUITS: {
                result = this.expectedNormalizedNumberOfCrossCircuits;
                break;
            }
            case BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS: {
                result = this.expectedNormalizedBalanceOfParallelVsCrossCircuits;
                break;
            }
            case TRIANGLES: {
                result = this.expectedNormalizedNumberOfTriangles;
                break;
            }
            case TRANSITIVE_TRIANGLES: {
                result = this.expectedNormalizedNumberOfTransitiveTriangles;
                break;
            }
            case CYCLIC_TRIANGLES: {
                result = this.expectedNormalizedNumberOfCyclicTriangles;
            }
        }
        return result;
    }

    private static String lineTitle(Indicator indicator) {
        String result = "";
        switch (indicator) {
            case CONCENTRATION: {
                result = "concentration";
                break;
            }
            case ENDOGAMIC_CONCENTRATION: {
                result = "endogamic concentration";
                break;
            }
            case SYMMETRY: {
                result = "symmetry";
                break;
            }
            case STRENGTH_CONCENTRATION: {
                result = "strength concentration";
                break;
            }
            case ENDOGAMIC_STRENGTH_CONCENTRATION: {
                result = "endogamic strength concentration";
                break;
            }
            case STRENGTH_SYMMETRY: {
                result = "strength symmetry";
                break;
            }
            case LOOPS: {
                result = "loops";
                break;
            }
            case DUAL_CIRCUITS: {
                result = "dual circuits";
                break;
            }
            case PARALLEL_CIRCUITS: {
                result = "parallel circuits";
                break;
            }
            case CROSS_CIRCUITS: {
                result = "cross circuits";
                break;
            }
            case BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS: {
                result = "balance parallel-cross circuits";
                break;
            }
            case TRIANGLES: {
                result = "triangles";
                break;
            }
            case TRANSITIVE_TRIANGLES: {
                result = "transitive triangles";
                break;
            }
            case CYCLIC_TRIANGLES: {
                result = "cyclic triangles";
            }
        }
        return result;
    }

    public double getStrengthProductSum() {
        return this.strengthProductSum;
    }

    public double getEndogamousClosureRate() {
        return this.endogamousClosureRate;
    }

    public static String statisticsLineRandom(Indicator indicator, Mode mode, MatrixStatistics randStats, MatrixStatistics sourceStats) {
        String result;
        if (mode == Mode.SIMPLE) {
            result = String.valueOf(MatrixStatistics.lineTitle(indicator)) + "\t" + randStats.getNumber(indicator) + "\t" + randStats.getNormalizedNumber(indicator) + "\t";
            if (sourceStats != null) {
                result = String.valueOf(result) + sourceStats.getNumber(indicator) + "\t" + sourceStats.getNormalizedNumber(indicator) + "\t" + randStats.getOverestimation(indicator) + "\t";
            }
        } else if (mode == Mode.EXPECTED) {
            result = String.valueOf(MatrixStatistics.lineTitle(indicator)) + "\t" + randStats.getExpectedNumber(indicator) + "\t" + randStats.getExpectedNormalizedNumber(indicator) + "\t";
            if (sourceStats != null) {
                result = String.valueOf(result) + sourceStats.getExpectedNumber(indicator) + "\t" + sourceStats.getExpectedNormalizedNumber(indicator) + "\t";
            }
        } else {
            result = "";
        }
        return result;
    }

    public static String statisticsLine(Indicator indicator, Mode mode, MatrixStatistics sourceStats, MatrixStatistics randStats) {
        String result;
        double alpha = 0.1;
        if (mode == Mode.SIMPLE) {
            result = String.valueOf(MatrixStatistics.lineTitle(indicator)) + "\t" + sourceStats.getNumber(indicator) + "\t" + sourceStats.getExpectedNumber(indicator) + "\t" + sourceStats.getDivergence(indicator) + "\t";
            if (randStats != null) {
                result = String.valueOf(result) + randStats.getNumber(indicator) + "\t" + randStats.getExpectedNumber(indicator) + "\t" + randStats.getDivergence(indicator) + "\t" + Arrays.toString(randStats.getConfidenceInterval(indicator, alpha)) + "\t";
                result = MatrixStatistics.isInConfidenceInterval(sourceStats, randStats, indicator, alpha) ? String.valueOf(result) + "GREEN\t" : String.valueOf(result) + "RED\t";
            }
        } else if (mode == Mode.NORMALIZED) {
            result = String.valueOf(MatrixStatistics.lineTitle(indicator)) + "\t" + sourceStats.getNormalizedNumber(indicator) + "\t" + sourceStats.getExpectedNormalizedNumber(indicator) + "\t" + sourceStats.getDivergenceNormalized(indicator) + "\t";
            if (randStats != null) {
                result = String.valueOf(result) + randStats.getNormalizedNumber(indicator) + "\t" + randStats.getExpectedNormalizedNumber(indicator) + "\t" + randStats.getDivergenceNormalized(indicator) + "\t";
            }
        } else {
            result = "";
        }
        return result;
    }

    private static boolean isInConfidenceInterval(MatrixStatistics sourceStats, MatrixStatistics randStats, Indicator indicator, double alpha) {
        double value;
        double[] interval = randStats.getConfidenceInterval(indicator, alpha);
        boolean result = interval[0] <= (value = sourceStats.getDivergence(indicator)) && value <= interval[1];
        return result;
    }

    private double[] getConfidenceInterval(Indicator indicator, double alpha) {
        double c = StudentDist.inverseF((int)(this.runs - 1), (double)(1.0 - alpha / 2.0));
        double s = this.getSquareDivergence(indicator) / Math.pow(this.runs, 0.5);
        double m = this.getDivergence(indicator);
        double[] result = new double[]{m - c * s, m + c * s};
        return result;
    }

    public static StringList statistics(MatrixStatistics sourceStats, MatrixStatistics randStats) {
        StringList result = new StringList(100);
        result.appendln("number of nodes:\t" + sourceStats.getNodeCount());
        result.appendln("number of arcs:\t" + sourceStats.getSum());
        result.appendln("maximal number of circuits:\t" + sourceStats.getMaximalNumberOfCircuits());
        result.appendln("maximal weight (marriages per arc):\t" + sourceStats.getNumber(Indicator.MAX_WEIGHT));
        result.appendln("maximal strength (marriages per node):\t" + sourceStats.getNumber(Indicator.MAX_STRENGTH));
        result.appendln("potential endogamic pairs:\t" + sourceStats.getStrengthProductSum() + "\tEndogamic closure rate:\t" + sourceStats.getEndogamousClosureRate());
        result.appendln();
        result.appendln("Strength distribution (marriages by clusters)");
        result.appendln("\tobserved\t\t\trd mean observed\t\t");
        result.appendln();
        result.appendln(MatrixStatistics.statisticsLine(Indicator.STRENGTH_CONCENTRATION, Mode.SIMPLE, sourceStats, randStats));
        result.appendln(MatrixStatistics.statisticsLine(Indicator.ENDOGAMIC_STRENGTH_CONCENTRATION, Mode.SIMPLE, sourceStats, randStats));
        result.appendln(MatrixStatistics.statisticsLine(Indicator.STRENGTH_SYMMETRY, Mode.SIMPLE, sourceStats, randStats));
        result.appendln();
        result.appendln("Weight distribution (marriages by cluster pairs)");
        result.appendln("\tobserved\texpected\tdivergence\trd mean observed\trd mean expected\trd divergence mean\trd divergence ci (0.1)");
        result.appendln();
        result.appendln(MatrixStatistics.statisticsLine(Indicator.CONCENTRATION, Mode.SIMPLE, sourceStats, randStats));
        result.appendln(MatrixStatistics.statisticsLine(Indicator.ENDOGAMIC_CONCENTRATION, Mode.SIMPLE, sourceStats, randStats));
        result.appendln(MatrixStatistics.statisticsLine(Indicator.SYMMETRY, Mode.SIMPLE, sourceStats, randStats));
        result.appendln();
        result.appendln("Circuit census");
        result.appendln("\tobserved\texpected\tdivergence\trd mean observed\trd mean expected\trd divergence mean\trd divergence ci (0.1)");
        result.appendln();
        result.appendln(MatrixStatistics.statisticsLine(Indicator.LOOPS, Mode.SIMPLE, sourceStats, randStats));
        result.appendln(MatrixStatistics.statisticsLine(Indicator.DUAL_CIRCUITS, Mode.SIMPLE, sourceStats, randStats));
        result.appendln(MatrixStatistics.statisticsLine(Indicator.PARALLEL_CIRCUITS, Mode.SIMPLE, sourceStats, randStats));
        result.appendln(MatrixStatistics.statisticsLine(Indicator.CROSS_CIRCUITS, Mode.SIMPLE, sourceStats, randStats));
        result.appendln(MatrixStatistics.statisticsLine(Indicator.BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS, Mode.SIMPLE, sourceStats, randStats));
        result.appendln(MatrixStatistics.statisticsLine(Indicator.TRIANGLES, Mode.SIMPLE, sourceStats, randStats));
        result.appendln(MatrixStatistics.statisticsLine(Indicator.TRANSITIVE_TRIANGLES, Mode.SIMPLE, sourceStats, randStats));
        result.appendln(MatrixStatistics.statisticsLine(Indicator.CYCLIC_TRIANGLES, Mode.SIMPLE, sourceStats, randStats));
        result.appendln();
        result.appendln("Circuit census (normalized)");
        result.appendln("\tobserved\texpected\tdivergence\trd mean observed\trd mean expected\trd mean divergence");
        result.appendln();
        result.appendln(MatrixStatistics.statisticsLine(Indicator.LOOPS, Mode.NORMALIZED, sourceStats, randStats));
        result.appendln(MatrixStatistics.statisticsLine(Indicator.DUAL_CIRCUITS, Mode.NORMALIZED, sourceStats, randStats));
        result.appendln(MatrixStatistics.statisticsLine(Indicator.PARALLEL_CIRCUITS, Mode.NORMALIZED, sourceStats, randStats));
        result.appendln(MatrixStatistics.statisticsLine(Indicator.CROSS_CIRCUITS, Mode.NORMALIZED, sourceStats, randStats));
        result.appendln(MatrixStatistics.statisticsLine(Indicator.BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS, Mode.NORMALIZED, sourceStats, randStats));
        result.appendln(MatrixStatistics.statisticsLine(Indicator.TRIANGLES, Mode.NORMALIZED, sourceStats, randStats));
        result.appendln(MatrixStatistics.statisticsLine(Indicator.TRANSITIVE_TRIANGLES, Mode.NORMALIZED, sourceStats, randStats));
        result.appendln(MatrixStatistics.statisticsLine(Indicator.CYCLIC_TRIANGLES, Mode.NORMALIZED, sourceStats, randStats));
        result.appendln();
        return result;
    }

    public static StringList statisticsRandom(MatrixStatistics randStats, MatrixStatistics sourceStats) {
        StringList result = new StringList(100);
        randStats.compareValues(sourceStats);
        result.appendln("mean number of nodes:\t" + randStats.getNodeCount());
        result.appendln("mean number of arcs:\t" + randStats.getSum());
        result.appendln("mean maximal number of circuits:\t" + randStats.getMaximalNumberOfCircuits());
        result.appendln("maximal weight (marriages per arc):\t" + randStats.getNumber(Indicator.MAX_WEIGHT));
        result.appendln("maximal strength (marriages per node):\t" + randStats.getNumber(Indicator.MAX_STRENGTH));
        result.appendln();
        result.appendln("Strength distribution (marriages by clusters)");
        result.appendln("\tmean\t\torig\t\toverestimation");
        result.appendln();
        result.appendln(MatrixStatistics.statisticsLineRandom(Indicator.STRENGTH_CONCENTRATION, Mode.SIMPLE, randStats, sourceStats));
        result.appendln(MatrixStatistics.statisticsLineRandom(Indicator.ENDOGAMIC_STRENGTH_CONCENTRATION, Mode.SIMPLE, randStats, sourceStats));
        result.appendln(MatrixStatistics.statisticsLineRandom(Indicator.STRENGTH_SYMMETRY, Mode.SIMPLE, randStats, sourceStats));
        result.appendln();
        result.appendln("Weight distribution (marriages by cluster pairs)");
        result.appendln("\tmean\t\torig\t\toverestimation");
        result.appendln();
        result.appendln(MatrixStatistics.statisticsLineRandom(Indicator.CONCENTRATION, Mode.SIMPLE, randStats, sourceStats));
        result.appendln(MatrixStatistics.statisticsLineRandom(Indicator.ENDOGAMIC_CONCENTRATION, Mode.SIMPLE, randStats, sourceStats));
        result.appendln(MatrixStatistics.statisticsLineRandom(Indicator.SYMMETRY, Mode.SIMPLE, randStats, sourceStats));
        result.appendln();
        result.appendln("Circuit census");
        result.appendln("\tmean\tnormalized mean\torig\torig normalized\toverestimation");
        result.appendln();
        result.appendln(MatrixStatistics.statisticsLineRandom(Indicator.LOOPS, Mode.SIMPLE, randStats, sourceStats));
        result.appendln(MatrixStatistics.statisticsLineRandom(Indicator.DUAL_CIRCUITS, Mode.SIMPLE, randStats, sourceStats));
        result.appendln(MatrixStatistics.statisticsLineRandom(Indicator.PARALLEL_CIRCUITS, Mode.SIMPLE, randStats, sourceStats));
        result.appendln(MatrixStatistics.statisticsLineRandom(Indicator.CROSS_CIRCUITS, Mode.SIMPLE, randStats, sourceStats));
        result.appendln(MatrixStatistics.statisticsLineRandom(Indicator.BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS, Mode.SIMPLE, randStats, sourceStats));
        result.appendln(MatrixStatistics.statisticsLineRandom(Indicator.TRIANGLES, Mode.SIMPLE, randStats, sourceStats));
        result.appendln(MatrixStatistics.statisticsLineRandom(Indicator.TRANSITIVE_TRIANGLES, Mode.SIMPLE, randStats, sourceStats));
        result.appendln(MatrixStatistics.statisticsLineRandom(Indicator.CYCLIC_TRIANGLES, Mode.SIMPLE, randStats, sourceStats));
        result.appendln();
        return result;
    }

    public double getNodeCount() {
        return this.nodeCount;
    }

    public static enum DistributionObject {
        WEIGHTS,
        STRENGTHS;

    }

    public static enum Indicator {
        CONCENTRATION,
        SYMMETRY,
        ENDOGAMIC_CONCENTRATION,
        STRENGTH_CONCENTRATION,
        STRENGTH_SYMMETRY,
        ENDOGAMIC_STRENGTH_CONCENTRATION,
        LOOPS,
        DUAL_CIRCUITS,
        PARALLEL_CIRCUITS,
        CROSS_CIRCUITS,
        BALANCE_OF_PARALLEL_VS_CROSS_CIRCUITS,
        TRIANGLES,
        TRANSITIVE_TRIANGLES,
        CYCLIC_TRIANGLES,
        MAX_WEIGHT,
        MAX_STRENGTH;

    }

    public static enum Mode {
        SIMPLE,
        NORMALIZED,
        EXPECTED,
        EXPECTED_NORMALIZED,
        DIVERGENCE,
        DIVERGENCE_NORMALIZED,
        OVERESTIMATION,
        OVERESTIMATION_EXPECTED,
        OVERESTIMATION_DIVERGENCE;

    }
}

