/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.xls;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLSWriter
extends Writer {
    private static final Logger logger = LoggerFactory.getLogger(XLSWriter.class);
    protected WritableWorkbook workbook;
    protected int currentSheet;
    protected int currentRow;
    protected int currentColumn;

    public XLSWriter(File file, String ... tabNames) throws IOException {
        WorkbookSettings settings = new WorkbookSettings();
        settings.setLocale(new Locale("fr", "FR"));
        this.workbook = Workbook.createWorkbook((File)file, (WorkbookSettings)settings);
        if (tabNames != null) {
            int sheetCounter = 0;
            String[] stringArray = tabNames;
            int n = tabNames.length;
            int n2 = 0;
            while (n2 < n) {
                String tabName = stringArray[n2];
                this.workbook.createSheet(tabName, sheetCounter);
                ++sheetCounter;
                ++n2;
            }
        }
        this.currentSheet = 0;
        this.currentRow = 0;
        this.currentColumn = 0;
    }

    @Override
    public void close() throws IOException {
        try {
            this.workbook.write();
            this.workbook.close();
        }
        catch (WriteException exception) {
            throw new IOException(exception.getMessage());
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.write(new String(cbuf, off, len));
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        try {
            String[] tokens;
            String[] stringArray = tokens = str.split("\t");
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                if (token.contains("\n")) {
                    if (this.currentColumn == 0) {
                        ++this.currentSheet;
                        this.currentRow = 0;
                        this.currentColumn = 0;
                    } else {
                        ++this.currentRow;
                        this.currentColumn = 0;
                    }
                } else {
                    if (NumberUtils.isNumber((String)token)) {
                        this.workbook.getSheet(this.currentSheet).addCell((WritableCell)new Number(this.currentColumn, this.currentRow, new Double(token).doubleValue()));
                    } else {
                        if (this.currentSheet >= this.workbook.getNumberOfSheets() && this.currentRow == 0 && this.currentColumn == 0) {
                            this.workbook.createSheet(token, this.currentSheet);
                        }
                        this.workbook.getSheet(this.currentSheet).addCell((WritableCell)new Label(this.currentColumn, this.currentRow, token));
                    }
                    ++this.currentColumn;
                }
                ++n2;
            }
        }
        catch (RowsExceededException exception) {
            throw new IOException("JXL RowsExceededException: " + exception.getMessage());
        }
        catch (WriteException exception) {
            throw new IOException("JXL WriteException: " + exception.getMessage());
        }
        catch (IndexOutOfBoundsException exception) {
            throw new IOException("JXL IndexOutOfBoundsException: " + exception.getMessage());
        }
    }
}

