/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.xls;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.io.txt1.TXT1File;
import org.tip.puck.io.xls.XLSBufferedReader;
import org.tip.puck.io.xls.XLSWriter;
import org.tip.puck.net.Net;

public class XLS1File {
    public static final int MAX_LINE_SIZE = 1024;
    private static final Logger logger = LoggerFactory.getLogger(XLS1File.class);

    public static Net load(File file) throws PuckException {
        Net result;
        XLSBufferedReader in = null;
        try {
            try {
                in = new XLSBufferedReader(file);
                result = TXT1File.read(in);
                result.setLabel(file.getName());
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create(exception, "Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create(exception, "Opening file [" + file + "]", new Object[0]);
            }
            catch (IOException exception) {
                throw PuckExceptions.IO_ERROR.create(exception, "Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            try {
                if (in != null) {
                    ((BufferedReader)in).close();
                }
            }
            catch (IOException exception) {
                logger.warn("Not managed error.");
                exception.printStackTrace();
            }
        }
        return result;
    }

    public static void save(File file, Net source) throws PuckException {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new XLSWriter(file, "Kinship Relations", "Attributs"));
                TXT1File.write(out, source);
            }
            catch (IOException exception) {
                throw PuckExceptions.IO_ERROR.create(exception, "Opening file [" + file + "].", new Object[0]);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void save(File file, Net source, ResourceBundle bundle) throws PuckException {
    }

    protected static enum Status {
        MANDATORY,
        OPTIONAL;

    }
}

