/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.txt3;

import fr.devinsy.util.StringList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.io.txt3.TXTFamilyLine;
import org.tip.puck.io.txt3.TXTIndividualLine;
import org.tip.puck.io.txt3.TXTLabelsLine;
import org.tip.puck.io.txt3.TXTRelationLine;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.Families;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.UnionStatus;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.RelationModels;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.Role;
import org.tip.puck.util.LogHelper;

public class TXT3File {
    private static final Logger logger = LoggerFactory.getLogger(TXT3File.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final int MAX_LINE_SIZE = 2048;

    public static Net load(File file) throws PuckException {
        Net result = TXT3File.load(file, DEFAULT_CHARSET_NAME);
        return result;
    }

    public static Net load(File file, String charsetName) throws PuckException {
        Net result;
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
                result = TXT3File.read(in);
                result.setLabel(file.getName());
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException exception) {
                logger.warn("Not managed error.");
                exception.printStackTrace();
            }
        }
        return result;
    }

    public static Net read(BufferedReader in) throws PuckException {
        Net result = new Net();
        TXT3File.readCorpusAttributes(result.attributes(), in);
        TXT3File.readIndividuals(result, in);
        TXT3File.readFamilies(result, in);
        boolean ended = false;
        while (!ended) {
            if (TXT3File.readRelations(result, in)) continue;
            ended = true;
        }
        return result;
    }

    public static TXTLabelsLine readCorpusAttributeLabelsLine(BufferedReader in) throws PuckException {
        TXTLabelsLine result;
        try {
            in.mark(2048);
            String line = TXT3File.readNotEmptyLine(in);
            if (line == null) {
                result = null;
            } else if (line.matches("^[Ii][Dd]\\t.*$") || line.matches("^\\d.*$")) {
                in.reset();
                result = null;
            } else {
                String[] tokens = line.split("\\t");
                result = new TXTLabelsLine();
                String[] stringArray = tokens;
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    result.add(token);
                    ++n2;
                }
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading labels line.", new Object[0]);
        }
        return result;
    }

    public static void readCorpusAttributes(Attributes target, BufferedReader in) throws PuckException {
        TXTLabelsLine valuesLine;
        logger.debug("Read corpus attributes.");
        TXTLabelsLine labelsLine = TXT3File.readCorpusAttributeLabelsLine(in);
        if (labelsLine != null && (valuesLine = TXT3File.readLabelsLine(in)) != null) {
            int valueCount = 0;
            while (valueCount < valuesLine.size()) {
                String label = (String)labelsLine.get(valueCount);
                String value = (String)valuesLine.get(valueCount);
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    target.put(label, value);
                }
                ++valueCount;
            }
        }
    }

    public static void readFamilies(Net target, BufferedReader in) throws PuckException {
        logger.debug("Read families.");
        TXTLabelsLine labelsLine = TXT3File.readLabelsLine(in);
        boolean ended = false;
        while (!ended) {
            UnionStatus status;
            Individual mother;
            Individual father;
            TXTFamilyLine source = TXT3File.readFamilyLine(in);
            if (source == null) {
                ended = true;
                continue;
            }
            if (source.getId() == 0) continue;
            if (source.getFatherId() == 0) {
                father = null;
            } else {
                father = (Individual)target.individuals().getById(source.getFatherId());
                if (father == null) {
                    father = target.createIndividual(source.getFatherId());
                }
            }
            if (source.getMotherId() == 0) {
                mother = null;
            } else {
                mother = (Individual)target.individuals().getById(source.getMotherId());
                if (mother == null) {
                    mother = target.createIndividual(source.getMotherId());
                }
            }
            switch (source.getStatus()) {
                case 'U': {
                    status = UnionStatus.UNMARRIED;
                    break;
                }
                case 'M': {
                    status = UnionStatus.MARRIED;
                    break;
                }
                case 'D': {
                    status = UnionStatus.DIVORCED;
                    break;
                }
                default: {
                    throw PuckExceptions.BAD_FILE_FORMAT.create("Unknown union status [" + source.getStatus() + "]", new Object[0]);
                }
            }
            Family family = target.createFamily(source.getId(), father, mother, status);
            if (StringUtils.isNotBlank((CharSequence)source.getChildIds())) {
                String[] ids;
                String[] stringArray = ids = source.getChildIds().split("[ .,;]+");
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String childId = stringArray[n2];
                    if (NumberUtils.isNumber((String)childId)) {
                        Individual child = (Individual)target.individuals().getById(Integer.parseInt(childId));
                        if (child == null) {
                            target.createIndividual(Integer.parseInt(childId));
                        }
                        if (child.getOriginFamily() == null) {
                            child.setOriginFamily(family);
                            family.getChildren().add(child);
                        } else {
                            throw PuckExceptions.BAD_FILE_FORMAT.create("Child [" + child.getId() + "] defined in two different families [" + child.getOriginFamily().getId() + "][" + family.getId() + "]", new Object[0]);
                        }
                    }
                    ++n2;
                }
            }
            int valueCount = 0;
            while (valueCount < source.attributeValues().size()) {
                logger.debug("valueCount=" + valueCount + " " + source.attributeValues().size() + " " + source.attributeValues().get(valueCount));
                String label = (String)labelsLine.get(valueCount + 5);
                String value = source.attributeValues().get(valueCount);
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    family.attributes().put(label, value);
                }
                ++valueCount;
            }
        }
    }

    public static TXTFamilyLine readFamilyLine(BufferedReader in) throws PuckException {
        TXTFamilyLine result;
        try {
            in.mark(2048);
            String line = TXT3File.readNotEmptyLine(in);
            if (line == null) {
                result = null;
            } else if (line.matches("^\\d.*$")) {
                String[] tokens = line.split("\\t");
                result = new TXTFamilyLine();
                result.setId(Double.valueOf(tokens[0]).intValue());
                if (tokens.length > 1) {
                    String statusToken = tokens[1].trim().toUpperCase();
                    if (statusToken.length() == 0) {
                        result.setStatus('U');
                    } else if (statusToken.length() == 1) {
                        result.setStatus(statusToken.charAt(0));
                    } else {
                        throw PuckExceptions.BAD_FILE_FORMAT.create("Bad union status [" + tokens[1] + "].", new Object[0]);
                    }
                }
                if (tokens.length > 2) {
                    result.setFatherId(Double.valueOf(tokens[2]).intValue());
                }
                if (tokens.length > 3) {
                    result.setMotherId(Double.valueOf(tokens[3]).intValue());
                }
                if (tokens.length > 4 && StringUtils.isNotBlank((CharSequence)tokens[4])) {
                    result.setChildIds(tokens[4]);
                }
                int tokenCount = 5;
                while (tokenCount < tokens.length) {
                    result.attributeValues().add(tokens[tokenCount]);
                    ++tokenCount;
                }
            } else {
                in.reset();
                result = null;
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading family line.", new Object[0]);
        }
        return result;
    }

    public static TXTIndividualLine readIndividualLine(BufferedReader in) throws PuckException {
        TXTIndividualLine result;
        try {
            in.mark(2048);
            String line = TXT3File.readNotEmptyLine(in);
            if (line == null) {
                result = null;
            } else if (line.matches("^\\d.*$")) {
                String[] tokens = line.split("\\t");
                result = new TXTIndividualLine();
                result.setId(Double.valueOf(tokens[0]).intValue());
                if (tokens.length > 1) {
                    result.setName(tokens[1]);
                }
                if (tokens.length > 2 && tokens[2].length() > 0) {
                    result.setGender(tokens[2].charAt(0));
                } else {
                    result.setGender('X');
                }
                int tokenCount = 3;
                while (tokenCount < tokens.length) {
                    result.attributeValues().add(tokens[tokenCount]);
                    ++tokenCount;
                }
            } else {
                in.reset();
                result = null;
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading individual line.", new Object[0]);
        }
        return result;
    }

    public static void readIndividuals(Net target, BufferedReader in) throws PuckException {
        logger.debug("Read individuals.");
        TXTLabelsLine labelsLine = TXT3File.readLabelsLine(in);
        boolean ended = false;
        while (!ended) {
            Individual individual;
            TXTIndividualLine source = TXT3File.readIndividualLine(in);
            if (source == null) {
                ended = true;
                continue;
            }
            if (source.getId() == 0) continue;
            try {
                individual = target.createIndividual(source.getId());
            }
            catch (PuckException exception) {
                throw PuckExceptions.BAD_FILE_FORMAT.create("Individual [" + source.getId() + "] define twice.", new Object[0]);
            }
            if (!StringUtils.isBlank((CharSequence)source.getName())) {
                individual.setName(source.getName());
            }
            if (Gender.valueOf(source.getGender()) != Gender.UNKNOWN) {
                individual.setGender(Gender.valueOf(source.getGender()));
            }
            int valueCount = 0;
            while (valueCount < source.attributeValues().size()) {
                String label = (String)labelsLine.get(valueCount + 3);
                String value = source.attributeValues().get(valueCount);
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    individual.attributes().put(label, value);
                }
                ++valueCount;
            }
        }
    }

    public static TXTLabelsLine readLabelsLine(BufferedReader in) throws PuckException {
        TXTLabelsLine result;
        try {
            in.mark(2048);
            String line = TXT3File.readNotEmptyLine(in);
            if (line == null) {
                result = null;
            } else if (line.matches("^\\d.*$")) {
                in.reset();
                result = null;
            } else {
                String[] tokens = line.split("\\t");
                result = new TXTLabelsLine();
                String[] stringArray = tokens;
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    result.add(token);
                    ++n2;
                }
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading labels line.", new Object[0]);
        }
        return result;
    }

    public static String readNotEmptyLine(BufferedReader in) throws PuckException {
        String result;
        try {
            boolean ended = false;
            result = null;
            while (!ended) {
                String line = in.readLine();
                if (line == null) {
                    ended = true;
                    result = null;
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)line)) continue;
                ended = true;
                result = line;
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading line.", new Object[0]);
        }
        return result;
    }

    public static TXTRelationLine readRelationLine(BufferedReader in) throws PuckException {
        TXTRelationLine result;
        try {
            in.mark(2048);
            String line = TXT3File.readNotEmptyLine(in);
            if (line == null) {
                result = null;
            } else if (line.matches("^\\d.*$")) {
                String[] tokens = line.split("\\t");
                result = new TXTRelationLine();
                result.setId(Double.valueOf(tokens[0]).intValue());
                result.setName(tokens[1]);
                int tokenCount = 2;
                while (tokenCount < tokens.length) {
                    result.values().add(tokens[tokenCount]);
                    ++tokenCount;
                }
            } else {
                in.reset();
                result = null;
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading individual line.", new Object[0]);
        }
        return result;
    }

    public static boolean readRelations(Net target, BufferedReader in) throws PuckException {
        boolean result;
        TXTLabelsLine labelsLine = TXT3File.readLabelsLine(in);
        if (labelsLine == null || labelsLine.size() != 1) {
            result = false;
        } else {
            String name = ((String)labelsLine.get(0)).length() > 5 ? WordUtils.capitalizeFully((String)((String)labelsLine.get(0))) : (String)labelsLine.get(0);
            RelationModel model = target.relationModels().getByName(name);
            if (model != null) {
                throw PuckExceptions.BAD_FILE_FORMAT.create("Relation model [" + name + "] is defined twice.", new Object[0]);
            }
            model = new RelationModel(name);
            target.relationModels().add(model);
            logger.debug("Relation model=" + model.getName());
            labelsLine = TXT3File.readLabelsLine(in);
            int labelIndex = 2;
            while (labelIndex < labelsLine.size()) {
                String label = (String)labelsLine.get(labelIndex);
                if (!label.startsWith("#")) {
                    model.roles().add(new Role(label, 0));
                }
                ++labelIndex;
            }
            if (labelsLine != null && labelsLine.size() > 2) {
                boolean ended = false;
                while (!ended) {
                    TXTRelationLine source = TXT3File.readRelationLine(in);
                    if (source == null) {
                        ended = true;
                        continue;
                    }
                    if (source.getId() == 0 || !StringUtils.isNotBlank((CharSequence)source.getName())) continue;
                    Relation relation = target.createRelation(source.getId(), source.getName(), model);
                    int valueCount = 0;
                    while (valueCount < source.values().size()) {
                        String label = (String)labelsLine.get(valueCount + 2);
                        String value = source.values().get(valueCount);
                        if (StringUtils.isNotBlank((CharSequence)value)) {
                            if (label.startsWith("#")) {
                                relation.attributes().add(new Attribute(label.substring(1), value));
                            } else {
                                String[] ids;
                                String[] stringArray = ids = value.split("[ .,;]+");
                                int n = ids.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String id = stringArray[n2];
                                    target.createRelationActor(relation, Integer.parseInt(id), label);
                                    ++n2;
                                }
                            }
                        }
                        ++valueCount;
                    }
                }
            }
            result = true;
        }
        logger.debug("Done.");
        return result;
    }

    public static void save(File file, Net source) throws PuckException {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), DEFAULT_CHARSET_NAME));
                TXT3File.write(out, source);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static String toString(TXTFamilyLine source) {
        String result = source == null ? "[null]" : String.format("[id=%d][status=%d][fatherId=%d][motherId=%d][childIds=%s][attributeValues=%s]", source.getId(), Character.valueOf(source.getStatus()), source.getFatherId(), source.getMotherId(), source.getChildIds(), LogHelper.toString(source.attributeValues()));
        return result;
    }

    public static String toString(TXTIndividualLine source) {
        String result = source == null ? "[null]" : String.format("[id=%d][name=%s][gender=%c][attributeValues=%s]", source.getId(), source.getName(), Character.valueOf(source.getGender()), LogHelper.toString(source.attributeValues()));
        return result;
    }

    public static String toString(TXTLabelsLine source) {
        String result;
        if (source == null) {
            result = "[null]";
        } else {
            StringList buffer = new StringList();
            buffer.append("[");
            for (String label : source) {
                buffer.append(label);
                buffer.append(",");
            }
            buffer.removeLast();
            buffer.append("]");
            result = buffer.toString();
        }
        return result;
    }

    public static void write(PrintWriter out, Net source) throws PuckException {
        TXT3File.writeCorpusAttributes(out, source.attributes());
        TXT3File.writeIndividuals(out, source.individuals());
        TXT3File.writeFamilies(out, source.families());
        TXT3File.writeRelations(out, source.relationModels(), source.relations());
    }

    public static void write(PrintWriter out, TXTFamilyLine source) {
        StringBuffer buffer = new StringBuffer(512);
        buffer.append(String.format("%d\t%c\t%d\t%d", source.getId(), Character.valueOf(source.getStatus()), source.getFatherId(), source.getMotherId()));
        buffer.append("\t");
        if (source.getChildIds() != null) {
            buffer.append(source.getChildIds());
        }
        for (String value : source.attributeValues()) {
            buffer.append("\t");
            buffer.append(value);
        }
        out.println(buffer.toString());
    }

    public static void write(PrintWriter out, TXTIndividualLine source) {
        StringBuffer buffer = new StringBuffer(512);
        buffer.append(String.format("%d\t%s\t%c", source.getId(), source.getName(), Character.valueOf(source.getGender())));
        for (String value : source.attributeValues()) {
            buffer.append("\t");
            buffer.append(value);
        }
        out.println(buffer.toString());
    }

    public static void write(PrintWriter out, TXTLabelsLine source) {
        StringBuffer buffer = new StringBuffer(192);
        for (String value : source) {
            buffer.append(value);
            buffer.append("\t");
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        out.println(buffer.toString());
    }

    public static void write(PrintWriter out, TXTRelationLine source) {
        StringBuffer buffer = new StringBuffer(512);
        buffer.append(String.format("%d\t%s", source.getId(), source.getName()));
        for (String value : source.values()) {
            buffer.append("\t");
            buffer.append(value);
        }
        out.println(buffer.toString());
    }

    public static void writeCorpusAttributes(PrintWriter out, Attributes source) {
        if (!source.isEmpty()) {
            logger.debug("Write corpus attributes block.");
            TXTLabelsLine labelsLine = new TXTLabelsLine();
            labelsLine.addAll(source.labels());
            TXT3File.write(out, labelsLine);
            TXTLabelsLine valuesLine = new TXTLabelsLine();
            logger.debug("Write corpus attributes data.");
            for (String label : labelsLine) {
                String value = source.getValue(label);
                if (value == null) {
                    valuesLine.add("");
                    continue;
                }
                valuesLine.add(value);
            }
            TXT3File.write(out, valuesLine);
        }
        out.println();
    }

    public static void writeFamilies(PrintWriter out, Families source) throws PuckException {
        logger.debug("Write families block.");
        TXTLabelsLine labelsLine = new TXTLabelsLine();
        labelsLine.add("Id");
        labelsLine.add("Status");
        labelsLine.add("FatherId");
        labelsLine.add("MotherId");
        labelsLine.add("Children");
        labelsLine.addAll(source.getAttributeLabels());
        TXT3File.write(out, labelsLine);
        logger.debug("Write families data.");
        for (Family family : source.toSortedList()) {
            char status;
            TXTFamilyLine target = new TXTFamilyLine();
            target.setId(family.getId());
            switch (family.getUnionStatus()) {
                case UNMARRIED: {
                    status = 'U';
                    break;
                }
                case MARRIED: {
                    status = 'M';
                    break;
                }
                case DIVORCED: {
                    status = 'D';
                    break;
                }
                default: {
                    throw PuckExceptions.INVALID_PARAMETER.create("Unknown union status code  [" + family.getUnionStatus().toString() + "]", new Object[0]);
                }
            }
            target.setStatus(status);
            if (family.getFather() == null) {
                target.setFatherId(0);
            } else {
                target.setFatherId(family.getFather().getId());
            }
            if (family.getMother() == null) {
                target.setMotherId(0);
            } else {
                target.setMotherId(family.getMother().getId());
            }
            StringList buffer = new StringList();
            for (Individual individual : family.getChildren()) {
                buffer.append(individual.getId());
                buffer.append(';');
            }
            buffer.removeLast();
            target.setChildIds(buffer.toString());
            if (!family.attributes().isEmpty()) {
                int labelCount = 5;
                while (labelCount < labelsLine.size()) {
                    String label = (String)labelsLine.get(labelCount);
                    String value = family.getAttributeValue(label);
                    if (value == null) {
                        target.attributeValues().add("");
                    } else {
                        target.attributeValues().add(value);
                    }
                    ++labelCount;
                }
            }
            TXT3File.write(out, target);
        }
        out.println();
    }

    public static void writeIndividuals(PrintWriter out, Individuals source) {
        logger.debug("Write individuals block.");
        TXTLabelsLine labelsLine = new TXTLabelsLine();
        labelsLine.add("Id");
        labelsLine.add("Name");
        labelsLine.add("Gender");
        labelsLine.addAll(source.getAttributeLabels());
        TXT3File.write(out, labelsLine);
        logger.debug("Write individuals data.");
        for (Individual individual : source.toSortedList()) {
            TXTIndividualLine target = new TXTIndividualLine();
            target.setId(individual.getId());
            target.setName(individual.getName());
            target.setGender(individual.getGender().toChar());
            if (!individual.attributes().isEmpty()) {
                int labelCount = 3;
                while (labelCount < labelsLine.size()) {
                    String label = (String)labelsLine.get(labelCount);
                    String value = individual.getAttributeValue(label);
                    if (value == null) {
                        target.attributeValues().add("");
                    } else {
                        target.attributeValues().add(value);
                    }
                    ++labelCount;
                }
            }
            TXT3File.write(out, target);
        }
        out.println();
    }

    public static void writeRelations(PrintWriter out, RelationModels models, Relations source) {
        for (RelationModel relationModel : models) {
            Relations relations = source.getByModel(relationModel);
            out.println(relationModel.getName());
            logger.debug("Find labels.");
            TXTLabelsLine labelsLine = new TXTLabelsLine();
            labelsLine.add("Id");
            labelsLine.add("Name");
            labelsLine.addAll(relationModel.roles().nameList());
            for (String attributeLabel : relations.getAttributeLabels()) {
                labelsLine.add("#" + attributeLabel);
            }
            TXT3File.write(out, labelsLine);
            if (!relations.isEmpty()) {
                for (Relation relation : relations.toSortedList()) {
                    TXTRelationLine target = new TXTRelationLine();
                    target.setId(relation.getTypedId());
                    target.setName(relation.getName());
                    for (Role role : relationModel.roles()) {
                        Actors actors = relation.actors().getByRole(role);
                        StringList buffer = new StringList();
                        for (Actor actor : actors) {
                            buffer.append(actor.getId());
                            buffer.append(';');
                        }
                        buffer.removeLast();
                        target.values().add(buffer.toString());
                    }
                    if (!relation.attributes().isEmpty()) {
                        int labelCount = 2 + relationModel.roles().size();
                        while (labelCount < labelsLine.size()) {
                            String label = (String)labelsLine.get(labelCount);
                            String value = relation.getAttributeValue(label.substring(1));
                            if (value == null) {
                                target.values().add("");
                            } else {
                                target.values().add(value);
                            }
                            ++labelCount;
                        }
                    }
                    TXT3File.write(out, target);
                }
            }
            out.println();
        }
    }
}

