/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.ods;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.math.NumberUtils;
import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SpreadSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODSWriter
extends Writer {
    private static final Logger logger = LoggerFactory.getLogger(ODSWriter.class);
    protected File file;
    protected SpreadSheet workbook;
    protected Sheet currentSheet;
    protected int currentSheetIndex;
    protected int currentRow;
    protected int currentColumn;

    public ODSWriter(File file) throws Exception {
        this.file = file;
        this.workbook = SpreadSheet.createEmpty((TableModel)new DefaultTableModel());
        this.workbook.getSheet(0).setName("Kinship Relations");
        this.workbook.addSheet("Attributs");
        this.currentSheetIndex = 0;
        this.currentSheet = this.workbook.getSheet(this.currentSheetIndex);
        this.currentRow = 0;
        this.currentColumn = 0;
    }

    @Override
    public void close() throws IOException {
        this.workbook.saveAs(this.file);
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.write(new String(cbuf, off, len));
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        String[] tokens;
        String[] stringArray = tokens = str.split("\t");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.contains("\n")) {
                if (this.currentColumn == 0) {
                    ++this.currentSheetIndex;
                    this.currentSheet = this.currentSheetIndex < this.workbook.getSheetCount() ? this.workbook.getSheet(this.currentSheetIndex) : null;
                    this.currentRow = 0;
                    this.currentColumn = 0;
                } else {
                    ++this.currentRow;
                    this.currentColumn = 0;
                }
            } else {
                if (this.currentSheet == null) {
                    this.currentSheet = this.workbook.addSheet(token);
                }
                this.currentSheet.ensureColumnCount(this.currentColumn + 1);
                this.currentSheet.ensureRowCount(this.currentRow + 1);
                if (NumberUtils.isNumber((String)token)) {
                    this.currentSheet.getCellAt(this.currentColumn, this.currentRow).setValue((Object)Integer.valueOf(token));
                } else {
                    this.currentSheet.getCellAt(this.currentColumn, this.currentRow).setValue((Object)token);
                }
                ++this.currentColumn;
            }
            ++n2;
        }
    }
}

