/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs.onemode;

import java.util.HashMap;
import java.util.Map;
import org.tip.puck.net.Family;
import org.tip.puck.net.Individual;
import org.tip.puck.util.Numberable;

public class OMNode {
    private OMNode femaleLink;
    private OMNode maleLink;
    private Numberable referent;
    private boolean virtual;
    private boolean marriedParents;
    private Map<OMNode, Integer> descendants;
    private Map<OMNode, Integer> originalDescendants;
    private int outDegree;
    private int outDegreeF;
    private int outDegreeM;

    public boolean hasMarriedParents() {
        return this.marriedParents;
    }

    public void setMarriedParents(boolean marriedParents) {
        this.marriedParents = marriedParents;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public OMNode(Numberable referent, OMNode wifeLink, OMNode husbandLink) {
        this.referent = referent;
        this.femaleLink = wifeLink;
        this.maleLink = husbandLink;
        this.descendants = new HashMap<OMNode, Integer>();
        this.outDegree = 0;
    }

    public Family getFamily() {
        Family result = null;
        if (this.referent instanceof Family) {
            result = (Family)this.referent;
        }
        return result;
    }

    public Individual getIndividual() {
        Individual result = null;
        if (this.referent instanceof Individual) {
            result = (Individual)this.referent;
        }
        return result;
    }

    public OMNode(Numberable referent) {
        this(referent, null, null);
    }

    public OMNode cloneWithLinks() {
        return new OMNode(this.referent, this.femaleLink, this.maleLink);
    }

    public void addDescendant(OMNode origin, int distance) {
        if (this.femaleLink != null) {
            this.femaleLink.addDescendant(origin, distance + 1);
        }
        if (this.maleLink != null) {
            this.maleLink.addDescendant(origin, distance + 1);
        }
        if (this == origin) {
            return;
        }
        if (this.descendants.containsKey(origin)) {
            Integer curDistance = this.descendants.get(origin);
            if (curDistance > distance) {
                this.descendants.put(origin, distance);
            }
        } else {
            this.descendants.put(origin, distance);
        }
    }

    public void clearDescendants() {
        this.descendants.clear();
    }

    public void storeOriginalDescendants() {
        this.originalDescendants = new HashMap<OMNode, Integer>(this.descendants);
    }

    public int generationalDistance(OMNode m) {
        if (this == m) {
            return 0;
        }
        if (this.descendants.containsKey(m)) {
            return this.descendants.get(m);
        }
        return -1;
    }

    public int originalGenerationalDistance(OMNode m) {
        if (this == m) {
            return 0;
        }
        if (this.originalDescendants.containsKey(m)) {
            return this.originalDescendants.get(m);
        }
        return -1;
    }

    public boolean hasDescendant(OMNode m) {
        return this.descendants.containsKey(m);
    }

    public double distance(OMNode m) {
        double dist = 0.0;
        if (this.femaleLink != m.femaleLink) {
            dist += 0.5;
        }
        if (this.maleLink != m.maleLink) {
            dist += 0.5;
        }
        return dist;
    }

    public void incOutDegree() {
        ++this.outDegree;
    }

    public int numberOfDescendants() {
        return this.descendants.size();
    }

    public String hashKey() {
        return this.referent.hashKey();
    }

    public String toString() {
        return this.hashKey();
    }

    public Individual getWife() {
        Individual result = null;
        if (this.referent != null && this.referent instanceof Family) {
            result = ((Family)this.referent).getWife();
        }
        return result;
    }

    public void setWife(Individual wife) {
        if (this.referent instanceof Family) {
            ((Family)this.referent).setWife(wife);
        } else {
            this.referent = wife;
        }
    }

    public Individual getHusband() {
        Individual result = null;
        if (this.referent != null && this.referent instanceof Family) {
            result = ((Family)this.referent).getHusband();
        }
        return result;
    }

    public void setHusband(Individual husband) {
        if (this.referent instanceof Family) {
            ((Family)this.referent).setHusband(husband);
        } else {
            this.referent = husband;
        }
    }

    public void setReferent(Numberable referent) {
        this.referent = referent;
    }

    public OMNode getFemaleLink() {
        return this.femaleLink;
    }

    public void setFemaleLink(OMNode wifeLink) {
        this.femaleLink = wifeLink;
    }

    public OMNode getMaleLink() {
        return this.maleLink;
    }

    public void setMaleLink(OMNode husbandLink) {
        this.maleLink = husbandLink;
    }

    public Map<OMNode, Integer> getDescendants() {
        return this.descendants;
    }

    public int getOutDegree() {
        return this.outDegree;
    }

    public int getOutDegreeF() {
        return this.outDegreeF;
    }

    public void incOutDegreeF() {
        ++this.outDegreeF;
    }

    public int getOutDegreeM() {
        return this.outDegreeM;
    }

    public void incOutDegreeM() {
        ++this.outDegreeM;
    }
}

