/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.clusternetworks;

import org.tip.puck.matrix.Mat;

public class VirtualFieldworkVariationsCriteria {
    private boolean numberOfLoopsChecked = false;
    private boolean numberOfCircuitsChecked = false;
    private boolean numberOfTrianglesChecked = false;
    private boolean concentrationChecked = false;
    private boolean strengthConcentrationChecked;
    private boolean weightDistributionChecked = false;
    private boolean strengthDistributionChecked = false;
    private boolean symmetryChecked = false;
    private int numberOfNodes;
    private int arcWeightSum;
    private double fractionOfNodes = 1.0;
    private double arcWeightFraction = 0.1;
    private double outPreference = 0.5;
    private int numberOfRuns = 100;
    private int firstVariableIndex = 0;
    private double firstVariableInitialValue = 1.0E-5;
    private int firstVariableIntervalFactor = 10;
    private int firstVariableNumberOfIntervals = 5;
    private int secondVariableIndex = 1;
    private double secondVariableInitialValue = 1.0E-5;
    private int secondVariableIntervalFactor = 10;
    private int secondVariableNumberOfIntervals = 5;

    public int getFirstVariableIndex() {
        return this.firstVariableIndex;
    }

    public double getFirstVariableInitialValue() {
        return this.firstVariableInitialValue;
    }

    public int getFirstVariableIntervalFactor() {
        return this.firstVariableIntervalFactor;
    }

    public int getFirstVariableNumberOfIntervals() {
        return this.firstVariableNumberOfIntervals;
    }

    public double getArcWeightFraction() {
        return this.arcWeightFraction;
    }

    public double getFractionOfNodes() {
        return this.fractionOfNodes;
    }

    public int getArcWeightSum() {
        return this.arcWeightSum;
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public int getNumberOfRuns() {
        return this.numberOfRuns;
    }

    public double getOutPreference() {
        return this.outPreference;
    }

    public int getSecondVariableIndex() {
        return this.secondVariableIndex;
    }

    public double getSecondVariableInitialValue() {
        return this.secondVariableInitialValue;
    }

    public int getSecondVariableIntervalFactor() {
        return this.secondVariableIntervalFactor;
    }

    public int getSecondVariableNumberOfIntervals() {
        return this.secondVariableNumberOfIntervals;
    }

    public boolean isConcentrationChecked() {
        return this.concentrationChecked;
    }

    public boolean isNumberOfCircuitsChecked() {
        return this.numberOfCircuitsChecked;
    }

    public boolean isNumberOfLoopsChecked() {
        return this.numberOfLoopsChecked;
    }

    public boolean isNumberOfTrianglesChecked() {
        return this.numberOfTrianglesChecked;
    }

    public boolean isStrengthDistributionChecked() {
        return this.strengthDistributionChecked;
    }

    public boolean isSymmetryChecked() {
        return this.symmetryChecked;
    }

    public boolean isWeightDistributionChecked() {
        return this.weightDistributionChecked;
    }

    public void nominalizeValues(int sourceNodeCount, double sourceArcWeightSum) {
        this.numberOfNodes = (int)Mat.round(this.fractionOfNodes * (double)sourceNodeCount, 0);
        this.arcWeightSum = (int)Mat.round(this.arcWeightFraction * sourceArcWeightSum, 0);
        this.firstVariableInitialValue = 1.0 / Math.pow(this.firstVariableIntervalFactor, this.firstVariableNumberOfIntervals);
        this.secondVariableInitialValue = 1.0 / Math.pow(this.secondVariableIntervalFactor, this.secondVariableNumberOfIntervals);
    }

    public void setConcentrationChecked(boolean concentrationChecked) {
        this.concentrationChecked = concentrationChecked;
    }

    public void setFirstVariableIndex(int firstVariableIndex) {
        this.firstVariableIndex = firstVariableIndex;
    }

    public void setFirstVariableInitialValue(double firstVariableInitialValue) {
        this.firstVariableInitialValue = firstVariableInitialValue;
    }

    public void setFirstVariableIntervalFactor(int firstVariableIntervalFactor) {
        this.firstVariableIntervalFactor = firstVariableIntervalFactor;
    }

    public void setFirstVariableNumberOfIntervals(int firstVariableNumberOfIntervals) {
        this.firstVariableNumberOfIntervals = firstVariableNumberOfIntervals;
    }

    public void setFractionOfArcs(double fractionOfArcs) {
        this.arcWeightFraction = fractionOfArcs;
    }

    public void setFractionOfNodes(double fractionOfNodes) {
        this.fractionOfNodes = fractionOfNodes;
    }

    public void setNumberOfCircuitsChecked(boolean numberOfCircuitsChecked) {
        this.numberOfCircuitsChecked = numberOfCircuitsChecked;
    }

    public void setNumberOfLoopsChecked(boolean numberOfLoopsChecked) {
        this.numberOfLoopsChecked = numberOfLoopsChecked;
    }

    public void setNumberOfRuns(int numberOfRuns) {
        this.numberOfRuns = numberOfRuns;
    }

    public void setNumberOfTrianglesChecked(boolean numberOfTrianglesChecked) {
        this.numberOfTrianglesChecked = numberOfTrianglesChecked;
    }

    public void setOutPreference(double outs) {
        this.outPreference = outs;
    }

    public void setSecondVariableIndex(int secondVariableIndex) {
        this.secondVariableIndex = secondVariableIndex;
    }

    public void setSecondVariableInitialValue(double secondVariableInitialValue) {
        this.secondVariableInitialValue = secondVariableInitialValue;
    }

    public void setSecondVariableIntervalFactor(int secondVariableIntervalFactor) {
        this.secondVariableIntervalFactor = secondVariableIntervalFactor;
    }

    public void setSecondVariableNumberOfIntervals(int secondVariableNumberOfIntervals) {
        this.secondVariableNumberOfIntervals = secondVariableNumberOfIntervals;
    }

    public void setStrengthDistributionChecked(boolean strengthDistributionChecked) {
        this.strengthDistributionChecked = strengthDistributionChecked;
    }

    public void setSymmetryChecked(boolean symmetryChecked) {
        this.symmetryChecked = symmetryChecked;
    }

    public void setWeightDistributionChecked(boolean weightDistributionChecked) {
        this.weightDistributionChecked = weightDistributionChecked;
    }

    public boolean isStrengthConcentrationChecked() {
        return this.strengthConcentrationChecked;
    }

    public void setStrengthConcentrationChecked(boolean strengthConcentrationChecked) {
        this.strengthConcentrationChecked = strengthConcentrationChecked;
    }
}

