/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.tip.puck.PuckException;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.util.Labels;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.views.PartitionCriteriaDialog;

public class SegmentationPanel
extends JPanel {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.tip.puckgui.messages");
    private static final long serialVersionUID = -1123800488357812371L;
    private NetGUI netGUI;
    private JComboBox comboBoxPartition;
    private JComboBox comboBoxCluster;
    private boolean isComboboxNeutralized;

    public SegmentationPanel(final NetGUI netGUI) {
        this.netGUI = netGUI;
        this.isComboboxNeutralized = false;
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(140dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(125dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel label = new JLabel("Partition:");
        this.add((Component)label, "2, 2, right, default");
        this.comboBoxPartition = new JComboBox();
        this.comboBoxPartition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    if (!SegmentationPanel.this.isComboboxNeutralized) {
                        netGUI.changeSegmentationToPartition(SegmentationPanel.this.comboBoxPartition.getSelectedIndex());
                    }
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.comboBoxPartition.setMaximumRowCount(15);
        this.comboBoxPartition.setModel(new DefaultComboBoxModel<String>(new String[]{"ALL"}));
        this.add((Component)this.comboBoxPartition, "4, 2, fill, default");
        JLabel lblCluster = new JLabel("Cluster:");
        this.add((Component)lblCluster, "6, 2, right, default");
        this.comboBoxCluster = new JComboBox();
        this.comboBoxCluster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (!SegmentationPanel.this.isComboboxNeutralized) {
                        netGUI.changeSegmentationToCluster(SegmentationPanel.this.comboBoxCluster.getSelectedIndex());
                    }
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.comboBoxCluster.setMaximumRowCount(15);
        this.comboBoxCluster.setModel(new DefaultComboBoxModel<String>(new String[]{"ALL"}));
        this.add((Component)this.comboBoxCluster, "8, 2, fill, default");
        JButton btnClear = new JButton("");
        btnClear.setToolTipText(BUNDLE.getString("SegmentationPanel.btnClear.toolTipText"));
        btnClear.setIcon(new ImageIcon(SegmentationPanel.class.getResource("/org/tip/puckgui/images/edit-clear-16x16.png")));
        btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    netGUI.changeSegmentationToClear();
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.add((Component)btnClear, "10, 2");
        JButton btnAdd = new JButton("");
        btnAdd.setToolTipText(BUNDLE.getString("SegmentationPanel.btnAdd.toolTipText"));
        btnAdd.setIcon(new ImageIcon(SegmentationPanel.class.getResource("/org/tip/puckgui/images/add-16x16.png")));
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    List<Labels> modelsLabels = Segmentation.buildModelLabels(netGUI.getCurrentIndividuals(), netGUI.getCurrentFamilies(), netGUI.getNet().relationModels(), netGUI.getNet().relations());
                    PartitionCriteria criteria = PartitionCriteriaDialog.showDialog(modelsLabels);
                    if (criteria != null) {
                        netGUI.changeSegmentationToNew(criteria);
                    }
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        JButton btnDown = new JButton("");
        btnDown.setToolTipText(BUNDLE.getString("SegmentationPanel.btnDown.toolTipText"));
        btnDown.setIcon(new ImageIcon(SegmentationPanel.class.getResource("/org/tip/puckgui/images/down-16x16.png")));
        btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    netGUI.changeSegmentationToDown();
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        JButton btnUp = new JButton("");
        btnUp.setToolTipText(BUNDLE.getString("SegmentationPanel.btnUp.toolTipText"));
        btnUp.setIcon(new ImageIcon(SegmentationPanel.class.getResource("/org/tip/puckgui/images/up-16x16.png")));
        btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    netGUI.changeSegmentationToUp();
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        JButton btnRemove = new JButton("");
        btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    netGUI.changeSegmentationToPop();
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        btnRemove.setIcon(new ImageIcon(SegmentationPanel.class.getResource("/org/tip/puckgui/images/remove-16x16.png")));
        btnRemove.setToolTipText(BUNDLE.getString("SegmentationPanel.btnRemove.toolTipText"));
        this.add((Component)btnRemove, "12, 2");
        this.add((Component)btnUp, "14, 2");
        this.add((Component)btnDown, "16, 2");
        this.add((Component)btnAdd, "18, 2");
        this.update();
    }

    public void update() {
        if (this.netGUI != null) {
            Segmentation segmentation = this.netGUI.getSegmentation();
            this.comboBoxPartition.setModel(new DefaultComboBoxModel<Object>(segmentation.getSegmentLabels().toArray()));
            this.isComboboxNeutralized = true;
            this.comboBoxPartition.setSelectedIndex(segmentation.getCurrentSegmentIndex());
            this.isComboboxNeutralized = false;
            this.comboBoxCluster.setModel(new DefaultComboBoxModel<Object>(segmentation.getClusterLabels().toArray()));
            this.isComboboxNeutralized = true;
            this.comboBoxCluster.setSelectedIndex(segmentation.getCurrentClusterIndex());
            this.isComboboxNeutralized = false;
        }
    }
}

