/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;

public class OpenRecentMenuItem
extends JMenuItem {
    private static final long serialVersionUID = -6988304006803940278L;
    private NetGUI netGUI;
    private File file;

    public OpenRecentMenuItem(final JFrame window, final NetGUI netGUI, final File file) {
        this.netGUI = netGUI;
        this.file = file;
        this.setText(file.getName());
        if (!file.exists()) {
            this.setEnabled(false);
        }
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (netGUI.isBlank()) {
                        netGUI.updateFile(file);
                    } else {
                        PuckGUI.instance().createNetGUI(file);
                    }
                }
                catch (PuckException exception) {
                    String message;
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
                    switch (PuckExceptions.valueOf(exception.getCode())) {
                        case FILE_NOT_FOUND: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
                            break;
                        }
                        case BAD_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
                            break;
                        }
                        case UNSUPPORTED_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
                            break;
                        }
                        case NOT_A_FILE: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
                            break;
                        }
                        case UNSUPPORTED_ENCODING: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
                            break;
                        }
                        default: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
                        }
                    }
                    JOptionPane.showMessageDialog(window, message, title, 0);
                }
                catch (Exception exception) {
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
                    String message = "Error";
                    JOptionPane.showMessageDialog(window, message, title, 0);
                }
            }
        });
    }
}

